/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.converters.AbstractPutval;
import com.sap.db.jdbc.converters.InputStreamFilter;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

@NotThreadSafe
class PutvalBlob
extends AbstractPutval {
    private InputStream _stream;
    private byte[] _sourceBytes;

    protected PutvalBlob(InputStream stream, long length, int inputFieldPos) {
        super(inputFieldPos);
        this._stream = length >= 0L ? new InputStreamFilter(stream, length) : stream;
    }

    protected PutvalBlob(byte[] sourceBytes, int inputFieldPos, HDataPart dataPart, int descriptorOffset) {
        super(inputFieldPos, dataPart, descriptorOffset);
        this._stream = new ByteArrayInputStream(sourceBytes);
        this._sourceBytes = sourceBytes;
    }

    @Override
    public DataType getDataType() {
        return DataType.BLOB;
    }

    @Override
    public AbstractPutval cloneForBatch() {
        return this._sourceBytes == null ? this : new PutvalBlob(this._sourceBytes, this._inputFieldPos, this._dataPart, this._descriptorOffset);
    }

    @Override
    public boolean atEnd() {
        return this._stream == null;
    }

    @Override
    public void transferStream(boolean isExecuteRequest, HDataPart dataPart) throws SQLException {
        boolean isStreamExhaused = dataPart.fillWithStream(isExecuteRequest, this._stream, this._descriptorOffset);
        if (isStreamExhaused) {
            this._closeStream();
        }
    }

    @Override
    public void closeStream() {
        this._closeStream();
    }

    public String toString() {
        return super.toString() + ":" + this._stream;
    }

    private void _closeStream() {
        try {
            this._stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._stream = null;
    }
}

