/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.AesCbc;
import com.sap.db.util.ByteUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

@ThreadSafe
class SmallIntConverter
extends AbstractNumericConverter {
    private static final Short MIN_VALUE = Short.MIN_VALUE;
    private static final Short MAX_VALUE = Short.MAX_VALUE;
    private static final BigDecimal MIN_VALUE_BIG_DECIMAL = BigDecimal.valueOf(MIN_VALUE.shortValue());
    private static final BigDecimal MAX_VALUE_BIG_DECIMAL = BigDecimal.valueOf(MAX_VALUE.shortValue());

    protected SmallIntConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        if (this._isEncrypted) {
            return AesCbc.getEncryptedLength(this._isDeterministic ? 2 : 3) + 1;
        }
        return 3;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Short)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (this._isEncrypted) {
            return AesCbc.getEncryptedLength(this._isDeterministic ? 2 : 3) + 2;
        }
        return 3;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Short)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        Short value = (Short)data;
        if (this._isEncrypted) {
            int off;
            byte[] bytes;
            if (this._isDeterministic) {
                bytes = new byte[2];
                off = 0;
            } else {
                bytes = new byte[3];
                ByteUtils.putByte(1, bytes, 0);
                off = 1;
            }
            ByteUtils.putShort(value.shortValue(), bytes, off);
            byte[] encrypted = this._getEncryptedBuffer(bytes);
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putShortAsSmallInt(value);
    }

    @Override
    public int getColumnDisplaySize() {
        return String.valueOf(Short.MAX_VALUE).length() + 1;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : Short.valueOf(this._getValueAsShort(controller, dataPart, false, decrypted));
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true, null) != 0;
    }

    @Override
    public Short setBoolean(boolean value) throws SQLException {
        return (short)(value ? 1 : 0);
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (byte)this._getValueAsShort(controller, dataPart, true, null);
    }

    @Override
    public Short setByte(byte value) throws SQLException {
        return value;
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true, null);
    }

    @Override
    public Short setShort(short value) throws SQLException {
        return value;
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true, null);
    }

    @Override
    public Short setInt(int value) throws SQLException {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw this._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return (short)value;
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true, null);
    }

    @Override
    public Short setLong(long value) throws SQLException {
        if (value < (long)MIN_VALUE.shortValue() || value > (long)MAX_VALUE.shortValue()) {
            throw this._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return (short)value;
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true, null);
    }

    @Override
    public Short setFloat(float value) throws SQLException {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw this._newSetNumericValueInvalidException(String.valueOf(value));
        }
        if (value < (float)MIN_VALUE.shortValue() || value > (float)MAX_VALUE.shortValue()) {
            throw this._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return (short)value;
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true, null);
    }

    @Override
    public Short setDouble(double value) throws SQLException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw this._newSetNumericValueInvalidException(String.valueOf(value));
        }
        if (value < (double)MIN_VALUE.shortValue() || value > (double)MAX_VALUE.shortValue()) {
            throw this._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return (short)value;
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : BigDecimal.valueOf(this._getValueAsShort(controller, dataPart, false, decrypted));
    }

    @Override
    public Short setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.compareTo(MIN_VALUE_BIG_DECIMAL) < 0 || value.compareTo(MAX_VALUE_BIG_DECIMAL) > 0) {
            throw this._newSetNumericValueOutOfRangeException(value.toPlainString(), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return value.shortValue();
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : String.valueOf(this._getValueAsShort(controller, dataPart, false, decrypted));
    }

    @Override
    public Short setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            return Short.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw this._newSetConversionException(value, "short");
        }
    }

    @Override
    public Short setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length != 1) {
            throw this._newSetNumericInvalidByteArrayLengthConversionException(Arrays.toString(value));
        }
        return (short)(value[0] & 0xFF);
    }

    private short _getValueAsShort(SQLParamController controller, HDataPart dataPart, boolean doNullCheck, byte[] decrypted) throws SQLException {
        if (doNullCheck) {
            byte[] byArray = decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
            if (dataPart.isNull(this, controller, decrypted)) {
                return 0;
            }
        }
        if (this._isEncrypted) {
            if (decrypted == null) {
                decrypted = this._getDecryptedBuffer(dataPart);
            }
            return ByteUtils.getShort(decrypted, this._isDeterministic ? 0 : 1);
        }
        return dataPart.getSmallIntAsShort();
    }
}

