/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.trace;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.PacketAnalyzer;
import com.sap.db.jdbc.trace.TraceConfiguration;
import com.sap.db.jdbc.trace.TraceControl;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.util.CharsetUtils;
import com.sap.db.util.FileUtils;
import com.sap.db.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
public class Tracer {
    private static final String CURRENT_WRITE_POSITION = "<CURRENT WRITE POSITION>";
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        public DecimalFormat initialValue() {
            DecimalFormat decimalFormat = new DecimalFormat("0.000");
            return decimalFormat;
        }
    };
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            return dateFormat;
        }
    };
    private final boolean _isForOneConnection;
    private final TraceControl _traceControl;
    private final AtomicBoolean _isTraceOn;
    private final AtomicBoolean _isPerformanceTraceOn;
    @GuardedBy(value="this")
    private final PacketAnalyzer _packetAnalyzer;
    @GuardedBy(value="this")
    private final TraceConfiguration _traceConfiguration;
    @GuardedBy(value="this")
    private ConnectionSapDB _connection;
    @GuardedBy(value="this")
    private String _traceFileName;
    @GuardedBy(value="this")
    private File _traceFile;
    @GuardedBy(value="this")
    private long _traceSize;
    @GuardedBy(value="this")
    private RandomAccessFile _log;
    @GuardedBy(value="this")
    private boolean _isWritingHeader;
    @GuardedBy(value="this")
    private int _wrapCount;
    @GuardedBy(value="this")
    private Thread _lastThread;

    public static Tracer getDummyTracer() {
        return DummyTracer.INSTANCE;
    }

    public Tracer(boolean isForOneConnection) {
        this._isForOneConnection = isForOneConnection;
        this._traceControl = new TraceControl(this);
        this._isTraceOn = new AtomicBoolean(false);
        this._isPerformanceTraceOn = new AtomicBoolean(false);
        this._packetAnalyzer = new PacketAnalyzer();
        this._traceConfiguration = new TraceConfiguration();
        this.setTraceFileName(this._traceConfiguration.getTraceFileName());
        this._setTraceSize(this._traceConfiguration.getTraceSize());
    }

    public boolean isForOneConnection() {
        return this._isForOneConnection;
    }

    public TraceControl getTraceControl() {
        return this._traceControl;
    }

    public boolean on() {
        return this._isTraceOn.get();
    }

    public boolean pon() {
        return this._isPerformanceTraceOn.get();
    }

    public TraceConfiguration getTraceConfiguration() {
        return this._traceConfiguration;
    }

    public synchronized ConnectionSapDB getConnection() {
        return this._connection;
    }

    public synchronized void setConnection(ConnectionSapDB connection) {
        this._connection = connection;
    }

    public synchronized File getTraceFile() {
        if (this._traceFile != null) {
            return this._traceFile;
        }
        if (this._traceFileName == null || this._traceFileName.isEmpty()) {
            this._traceFileName = "jdbctrace.prt";
        }
        try {
            String fileName = FileUtils.getFileName(this._traceFileName);
            String fileExtension = FileUtils.getFileExtension(this._traceFileName);
            String directoryName = FileUtils.getDirectoryName(this._traceFileName);
            File directory = FileUtils.createDirectoryIfNecessary(directoryName);
            this._traceFile = File.createTempFile(fileName, fileExtension, directory);
            FileUtils.limitAccessToReadWriteByOwner(this._traceFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._traceFile;
    }

    public synchronized boolean setTraceFileName(String traceFileName) {
        boolean wasNameChanged;
        boolean bl = wasNameChanged = !traceFileName.equals(this._traceFileName);
        if (!wasNameChanged) {
            return false;
        }
        this._traceFileName = traceFileName;
        this._traceFile = null;
        return true;
    }

    public synchronized boolean setTraceSize(String traceSize) {
        try {
            return this._setTraceSize(Long.parseLong(traceSize));
        }
        catch (NumberFormatException e) {
            return this._setTraceSize(Long.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchTraceOn() {
        if (this._isTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isTraceOn.set(true);
            this._traceConfiguration.setTraceEnabled(true);
            this._open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchTraceOff() {
        if (!this._isTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isTraceOn.set(false);
            this._traceConfiguration.setTraceEnabled(false);
            this._close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchPerformanceTraceOn() {
        if (this._isPerformanceTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isPerformanceTraceOn.set(true);
            this._traceConfiguration.setPerformanceTraceEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchPerformanceTraceOff() {
        if (!this._isPerformanceTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isPerformanceTraceOn.set(false);
            this._traceConfiguration.setPerformanceTraceEnabled(false);
            TraceRecordPublisher.getInstance().close();
        }
    }

    public synchronized void checkTraceSettings() {
        if (!this._traceConfiguration.hasTraceSettingsChanged()) {
            return;
        }
        this._traceConfiguration.loadTraceSettings();
        boolean wasTraceFileNameChanged = this.setTraceFileName(this._traceConfiguration.getTraceFileName());
        boolean wasTraceSizeChanged = this._setTraceSize(this._traceConfiguration.getTraceSize());
        if (this._traceConfiguration.isTraceEnabled()) {
            if (wasTraceFileNameChanged || wasTraceSizeChanged) {
                this.switchTraceOff();
            }
            this.switchTraceOn();
        } else {
            this.switchTraceOff();
        }
        if (this._traceConfiguration.isPerformanceTraceEnabled()) {
            this.switchPerformanceTraceOn();
        } else {
            this.switchPerformanceTraceOff();
        }
    }

    public synchronized void refreshTraceSettings() {
        if (this._traceConfiguration.isTraceEnabled()) {
            this.switchTraceOn();
        } else {
            this.switchTraceOff();
        }
        if (this._traceConfiguration.isPerformanceTraceEnabled()) {
            this.switchPerformanceTraceOn();
        } else {
            this.switchPerformanceTraceOff();
        }
    }

    public synchronized void printCurrentStackTrace(String message) {
        if (this._log == null) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(message);
        this._writelnWithIndent(this._getStackTraceString(new Throwable()));
    }

    public synchronized void printConnectionOpening(ConnectionSapDB connection, String ... indentedMessages) {
        this._printConnectionTrace(connection, false, connection.isReconnecting() ? "reconnecting" : "opening", null, indentedMessages);
    }

    public synchronized void printConnectionOpened(ConnectionSapDB connection) {
        this._printConnectionTrace(connection, true, connection.isReconnecting() ? "reconnected" : "opened", null, new String[0]);
    }

    public synchronized void printConnectionMessage(ConnectionSapDB connection, String message, String ... indentedMessages) {
        this._printConnectionTrace(connection, false, "message", message, indentedMessages);
    }

    public synchronized void printConnectionClosing(ConnectionSapDB connection) {
        this._printConnectionTrace(connection, true, "closing", null, new String[0]);
    }

    public synchronized void printConnectionClosed(ConnectionSapDB connection) {
        this._printConnectionTrace(connection, false, "closed", null, new String[0]);
    }

    public synchronized void printSessionOpening(Session session) {
        this._printSessionTrace(session, false, "opening", null, new String[0]);
    }

    public synchronized void printSessionOpened(Session session) {
        this._printSessionTrace(session, true, "opened", null, new String[0]);
    }

    public synchronized void printSessionMessage(Session session, String message, String ... indentedMessages) {
        this._printSessionTrace(session, false, "message", message, indentedMessages);
    }

    public synchronized void printSessionClosing(Session session) {
        this._printSessionTrace(session, true, "closing", null, new String[0]);
    }

    public synchronized void printSessionClosed(Session session) {
        this._printSessionTrace(session, false, "closed", null, new String[0]);
    }

    private void _printConnectionTrace(ConnectionSapDB connection, boolean isFullTraceString, String messageType, String message, String ... indentedMessages) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(4)) {
            return;
        }
        String text = "Connection " + messageType + ": " + connection.getTraceString(isFullTraceString) + (message != null ? " " + message : "");
        this._checkThreadChange();
        this._writelnWithTimestamp(text);
        if (indentedMessages != null) {
            for (String s : indentedMessages) {
                this._writelnWithIndent(s);
            }
        }
    }

    private void _printSessionTrace(Session session, boolean isFullTraceString, String messageType, String message, String ... indentedMessages) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(4)) {
            return;
        }
        String text = "Session " + messageType + ": " + session.getTraceString(isFullTraceString, true) + (message != null ? " " + message : "");
        this._checkThreadChange();
        this._writelnWithTimestamp(text);
        if (indentedMessages != null) {
            for (String s : indentedMessages) {
                this._writelnWithIndent(s);
            }
        }
    }

    public synchronized void printCall(Object caller, String name, Object ... arguments) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(0)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(caller + "." + name + "(" + this._getArgumentsString(arguments) + ")");
    }

    public synchronized void printResult(Object result) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(0)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("=> " + this._getValueAsString(result));
    }

    public synchronized void printException(SQLException e) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(0)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(this._getStackTraceString(e));
        this._checkStopOnError(e);
    }

    public synchronized void printStatementCached(ParseInfo parseInfo) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(0)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement cached: " + parseInfo.toString());
    }

    public synchronized void printStatementReused(ParseInfo parseInfo) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(0)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement reused: " + parseInfo.toString());
    }

    public synchronized void printStatementEvicted(ParseInfo parseInfo, String reason) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(0)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement evicted (" + reason + "): " + parseInfo.toString());
    }

    public synchronized void printPacket(byte[] packet, EngineFeatures engineFeatures) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(1)) {
            return;
        }
        this._checkThreadChange();
        this._packetAnalyzer.parse(packet);
        this._writelnWithTimestamp("<Packet " + this._packetAnalyzer.getDisplayPacketHeader() + ">");
        while (this._packetAnalyzer.nextSegment()) {
            this._writeln("  <Segment " + this._packetAnalyzer.getDisplaySegmentHeader() + ">");
            while (this._packetAnalyzer.nextPart()) {
                this._writeln("    <Part " + this._packetAnalyzer.getDisplayPartHeader() + ">");
                this._writeln("      <PartBuffer>");
                this._writeln("        " + this._packetAnalyzer.getDisplayPartDataAsBinaryString());
                this._writeln("        " + this._packetAnalyzer.getDisplayPartData(engineFeatures));
                this._writeln("      </PartBuffer>");
                this._writeln("    </Part>");
            }
            this._writeln("  </Segment>");
        }
        this._writeln("</Packet>");
    }

    public synchronized void printDistribution(ConnectionSapDB connection, String message) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(2)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Distribution: " + (connection != null ? connection.getTraceString(true) + " " : "") + message);
    }

    public synchronized void printDistributionState(ConnectionSapDB connection, String message) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(2)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Distribution: " + (connection != null ? connection.getTraceString(true) + " " : "") + message);
        for (Session session : connection.getSessionPool().getSessions().values()) {
            this._writelnWithIndent(session.getTraceString(true, false));
        }
    }

    public synchronized void printConnectionStatistics(ConnectionSapDB connection) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(3)) {
            return;
        }
        if (!connection.isPreparedStatementCacheEnabled()) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Connection statistics: " + connection.getTraceString(true));
        this._writelnWithIndent("PreparedStatementCurrentCacheSize:         " + connection.getPreparedStatementCurrentCacheSize());
        this._writelnWithIndent("PreparedStatementCurrentTrackSize:         " + connection.getPreparedStatementCurrentTrackSize());
        this._writelnWithIndent("PreparedStatementCount:                    " + connection.getPreparedStatementCount());
        this._writelnWithIndent("PreparedStatementCacheHitCount:            " + connection.getPreparedStatementCacheHitCount());
        this._writelnWithIndent("PreparedStatementExecuteCount:             " + connection.getPreparedStatementExecuteCount());
        this._writelnWithIndent("PreparedStatementDropCount:                " + connection.getPreparedStatementDropCount());
        this._writelnWithIndent("PreparedStatementApproxUniqueSQLTextCount: " + connection.getPreparedStatementApproxUniqueSQLTextCount());
        this._writelnWithIndent("PreparedStatementCacheRejectedFullCount:   " + connection.getPreparedStatementCacheRejectedFullCount());
        this._writelnWithIndent("PreparedStatementCacheEvictedFullCount:    " + connection.getPreparedStatementCacheEvictedFullCount());
        this._writelnWithIndent("PreparedStatementCacheEvictedColdCount:    " + connection.getPreparedStatementCacheEvictedColdCount());
        this._writelnWithIndent("PreparedStatementTrackEvictedFullCount:    " + connection.getPreparedStatementTrackEvictedFullCount());
        this._writelnWithIndent("PreparedStatementTrackEvictedColdCount:    " + connection.getPreparedStatementTrackEvictedColdCount());
    }

    public synchronized void printSessionStatistics(Session session) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(3)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Session statistics: " + session.getTraceString(true, true));
        this._writelnWithIndent("Duration:            " + this._getDisplayDuration(System.currentTimeMillis() - session.getInstantiationTime()));
        this._writelnWithIndent("SentPacketCount:     " + session.getSentPacketCount() + " TotalTime: " + this._getDisplayMicroseconds(session.getTotalSendTime()));
        this._writelnWithIndent("ReceivedPacketCount: " + session.getReceivedPacketCount() + " TotalTime: " + this._getDisplayMicroseconds(session.getTotalReceiveTime()));
        this._writelnWithIndent("SentByteCount:       " + this._getDisplayByteCount(session.getSentByteCount()) + " Uncompressed: " + this._getDisplayByteCount(session.getUncompressedSentByteCount()) + " CompressionRatio: " + this._getDisplayCompressionRatio(session.getSentCompressionRatio()));
        this._writelnWithIndent("ReceivedByteCount:   " + this._getDisplayByteCount(session.getReceivedByteCount()) + " Uncompressed: " + this._getDisplayByteCount(session.getUncompressedReceivedByteCount()) + " CompressionRatio: " + this._getDisplayCompressionRatio(session.getReceivedCompressionRatio()));
    }

    public synchronized void printDebugMessage(String message) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(5)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(message);
    }

    public synchronized void printDebugThrowable(Throwable t, String message) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(5)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(message);
        this._writelnWithIndent(this._getStackTraceString(t));
        this._checkStopOnError(t);
    }

    private void _open() {
        File traceFile = this.getTraceFile();
        if (traceFile == null) {
            return;
        }
        this._close();
        try {
            this._log = new RandomAccessFile(traceFile, "rw");
            this._wrapCount = 0;
            this._writeHeader();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void _close() {
        if (this._log == null) {
            return;
        }
        try {
            this._log.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this._log = null;
        }
    }

    private boolean _setTraceSize(long traceSize) {
        if (traceSize < 8192L) {
            traceSize = 8192L;
        }
        if (traceSize == this._traceSize) {
            return false;
        }
        this._traceSize = traceSize;
        return true;
    }

    private void _writeln() {
        this._writeln(null);
    }

    private void _writeln(String text) {
        try {
            if (text != null) {
                this._log.write(text.getBytes(CharsetUtils.UTF_8));
            }
            this._log.write(10);
            this._checkFileSize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void _writelnWithTimestamp(String text) {
        this._writeln(this._traceConfiguration.isShowTimestampsEnabled() ? DATE_FORMAT.get().format(new Timestamp(System.currentTimeMillis())) + ": " + (text != null ? text : "") : text);
    }

    private void _writelnWithIndent(String text) {
        this._writeln("  " + (text != null ? text : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeHeader() {
        try {
            Set<ConnectionSapDB> connections;
            this._isWritingHeader = true;
            this._writeln("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body><PRE><PLAINTEXT>");
            this._writeln("Java version: " + Driver.getJavaVersion());
            this._writeln("ClassLoader: " + Tracer.class.getClassLoader());
            this._writeln("Process ID: " + Driver.getProcessID());
            this._writeln("Driver version: " + Driver.getVersionInfo().toString());
            this._writeln();
            if (this._wrapCount > 0) {
                this._writeln("Warning: Trace wrapped around " + this._wrapCount + " times.");
                this._writeln();
            }
            Set<ConnectionSapDB> set = connections = this._isForOneConnection && this._connection != null ? Collections.singleton(this._connection) : Driver.getConnections();
            if (!connections.isEmpty()) {
                this._writeln("Object tree begin:");
                for (ConnectionSapDB connection : connections) {
                    this._writeln(connection.toString());
                    for (StatementSapDB statement : connection.getStatements()) {
                        this._writelnWithIndent(statement.toString());
                    }
                }
                this._writeln("Object tree end:");
            }
        }
        finally {
            this._isWritingHeader = false;
        }
    }

    private void _checkFileSize() throws IOException {
        if (this._isWritingHeader || this._traceSize == Long.MAX_VALUE) {
            return;
        }
        long offset = this._log.getFilePointer();
        if (offset + (long)CURRENT_WRITE_POSITION.length() > this._traceSize) {
            while (offset < this._traceSize) {
                this._log.write(32);
                ++offset;
            }
            this._log.seek(0L);
            ++this._wrapCount;
            this._writeHeader();
            offset = this._log.getFilePointer();
        }
        this._log.writeBytes(CURRENT_WRITE_POSITION);
        this._log.seek(offset);
    }

    private void _checkThreadChange() {
        Thread thread = Thread.currentThread();
        if (thread == this._lastThread) {
            return;
        }
        this._lastThread = thread;
        this._writelnWithTimestamp("---- Thread " + Integer.toHexString(thread.hashCode()) + " " + thread.getName());
    }

    private void _checkStopOnError(Throwable t) {
        int stopOnError = this._traceConfiguration.getStopOnError();
        if (stopOnError != 0 && t instanceof SQLException && ((SQLException)t).getErrorCode() == stopOnError) {
            this._close();
        }
    }

    private String _getStackTraceString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private String _getArgumentsString(Object[] arguments) {
        switch (arguments.length) {
            case 0: {
                return "";
            }
            case 1: {
                return this._getValueAsString(arguments[0]);
            }
        }
        StringBuilder builder = new StringBuilder(64);
        for (Object arg : arguments) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(this._getValueAsString(arg));
        }
        return builder.toString();
    }

    private String _getValueAsString(Object object) {
        return object instanceof String ? StringUtils.quote(object.toString(), '\"', '\u0000', true, true) : String.valueOf(object);
    }

    private String _getDisplayDuration(long milliseconds) {
        long s = milliseconds / 1000L;
        return String.format("%d hours %d minutes %d seconds", s / 3600L, s % 3600L / 60L, s % 60L);
    }

    private String _getDisplayMicroseconds(long microseconds) {
        return String.valueOf(microseconds / 1000L) + " ms";
    }

    private String _getDisplayByteCount(long byteCount) {
        return DECIMAL_FORMAT.get().format((double)byteCount / 1048576.0) + " MB";
    }

    private String _getDisplayCompressionRatio(double ratio) {
        return DECIMAL_FORMAT.get().format(ratio);
    }

    private static class DummyTracer
    extends Tracer {
        private static final DummyTracer INSTANCE = new DummyTracer();

        private DummyTracer() {
            super(false);
        }

        @Override
        public boolean on() {
            return false;
        }

        @Override
        public boolean pon() {
            return false;
        }
    }
}

