/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.OutputBuffer;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.sql.SQLException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

@Immutable
public final class AesCbc {
    public static final String JAVA_ALGORITHM_NAME = "AES";
    public static final String HANA_ALGORITHM_NAME = "AES-256-CBC";
    public static final String TRANSFORMATION_NAME = "AES/CBC/PKCS5Padding";
    private static final ThreadLocal<Cipher> CIPHER_AES_CBC_PKCS5 = new ThreadLocal<Cipher>(){

        @Override
        public Cipher initialValue() {
            try {
                return Cipher.getInstance(AesCbc.TRANSFORMATION_NAME);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("error.crypto.extension.not_installed", e);
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException("error.crypto.extension.not_installed", e);
            }
        }
    };
    private static final String PASSWD_TRANSFORMATION_NAME = "PBKDF2WithHmacSHA256";
    private static final String SALT = "JDBC_CSE_SALT";
    private static final int BLOCK_SIZE = 16;
    private static final int IV_LENGTH = 16;
    private static final int PASSWD_ITERATIONS = 100000;

    private AesCbc() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static Key generateKey(int size, String algorithmName) throws SQLException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(AesCbc._getJavaAlgorithmName(algorithmName));
            keyGenerator.init(size);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.keygeneration.failed", e.getMessage());
        }
    }

    public static Key getAesKeyFromPasswd(String passwd) throws SQLException {
        SecretKeySpec aesKey;
        char[] passwdArray = passwd == null ? new char[]{} : passwd.toCharArray();
        PBEKeySpec spec = new PBEKeySpec(passwdArray, SALT.getBytes(), 100000, 256);
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(PASSWD_TRANSFORMATION_NAME);
            SecretKey passwdKey = secretKeyFactory.generateSecret(spec);
            aesKey = new SecretKeySpec(passwdKey.getEncoded(), JAVA_ALGORITHM_NAME);
        }
        catch (NoSuchAlgorithmException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.keygeneration.failed", e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.keygeneration.failed", e.getMessage());
        }
        return aesKey;
    }

    public static Key getKey(byte[] aesKeyBytes, String algorithmName) {
        return new SecretKeySpec(aesKeyBytes, 0, aesKeyBytes.length, AesCbc._getJavaAlgorithmName(algorithmName));
    }

    public static int getEncryptedLength(int unencryptedLength) {
        return 16 + (unencryptedLength / 16 + 1) * 16;
    }

    public static byte[] encrypt(Key publicKey, byte[] input, IvParameterSpec ivParameterSpec) throws SQLException {
        byte[] output;
        try {
            Cipher cipher = AesCbc._getCipher(TRANSFORMATION_NAME);
            cipher.init(1, publicKey, ivParameterSpec);
            output = cipher.doFinal(input);
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        catch (BadPaddingException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        return output;
    }

    public static byte[] encrypt(ColumnEncryptionKey cek, boolean isDeterministic, byte[] input) throws SQLException {
        byte[] output;
        try {
            IvParameterSpec ivParameterSpec = isDeterministic ? AesCbc._getDeterministicIv(cek.getKey(), input) : AesCbc._getRandomIv();
            Cipher cipher = AesCbc._getCipher(AesCbc._getTransformationName(cek.getAlgorithmName()));
            cipher.init(1, cek.getKey(), ivParameterSpec);
            byte[] iv = ivParameterSpec.getIV();
            OutputBuffer outputBuffer = new OutputBuffer(iv.length + input.length);
            outputBuffer.write(iv);
            outputBuffer.write(input);
            output = cipher.doFinal(outputBuffer.getArray());
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        catch (InvalidParameterSpecException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        catch (IOException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        catch (BadPaddingException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        return output;
    }

    public static byte[] decrypt(ColumnEncryptionKey cek, byte[] packet, int offset, int length) throws SQLException {
        byte[] output;
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(packet, offset, 16);
            Cipher cipher = AesCbc._getCipher(AesCbc._getTransformationName(cek.getAlgorithmName()));
            cipher.init(2, cek.getKey(), ivParameterSpec);
            output = cipher.doFinal(packet, offset + 16, length - 16);
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.decrypt.failed", e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.decrypt.failed", e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.decrypt.failed", e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.decrypt.failed", e.getMessage());
        }
        catch (BadPaddingException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.decrypt.failed", e.getMessage());
        }
        return output;
    }

    private static Cipher _getCipher(String transformationName) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (transformationName.equals(TRANSFORMATION_NAME)) {
            return CIPHER_AES_CBC_PKCS5.get();
        }
        return Cipher.getInstance(transformationName);
    }

    private static String _getJavaAlgorithmName(String algorithmName) {
        if (algorithmName.equalsIgnoreCase(HANA_ALGORITHM_NAME)) {
            return JAVA_ALGORITHM_NAME;
        }
        return "UNKNOWN";
    }

    private static String _getTransformationName(String algorithmName) {
        if (algorithmName.equalsIgnoreCase(HANA_ALGORITHM_NAME)) {
            return TRANSFORMATION_NAME;
        }
        return "UNKNOWN";
    }

    private static IvParameterSpec _getDeterministicIv(Key aesKey, byte[] input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(aesKey.getEncoded());
        md.update(input);
        return new IvParameterSpec(md.digest(), 0, 16);
    }

    private static IvParameterSpec _getRandomIv() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidParameterSpecException {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION_NAME);
        IvParameterSpec ivParameterSpec = cipher.getParameters().getParameterSpec(IvParameterSpec.class);
        return ivParameterSpec;
    }
}

