/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HanaWebSocket;
import com.sap.db.jdbc.LatencySession;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.Topologies;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.util.Base64Utils;
import com.sap.db.util.CharsetUtils;
import com.sap.db.util.MessageTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;

@NotThreadSafe
public class BasicSession
extends Session {
    static final SessionFactory SESSION_FACTORY = new SessionFactory(){

        @Override
        public Session newInstance(ConnectionSapDB connection, Address address, boolean doConnectExchange) throws RTEException {
            ConnectionProperties connectionProperties = connection.getConnectionProperties();
            try {
                BasicSession initialSession = connectionProperties.hasProperty(ConnectionProperty.LATENCY) ? new LatencySession(connection, address) : new BasicSession(connection, address);
                initialSession._doInfoExchange();
                Session returnedSession = doConnectExchange ? initialSession._doConnectExchange(SESSION_FACTORY, connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME)) : initialSession;
                Topologies.setUnreachable(address, false);
                return returnedSession;
            }
            catch (RTEException e) {
                Topologies.setUnreachable(address, true);
                throw e;
            }
        }
    };
    @GuardedBy(value="_connection (implicit)")
    private final Socket _socket;
    @GuardedBy(value="_connection (implicit)")
    private final HanaWebSocket _webSocket;
    @GuardedBy(value="_connection (implicit)")
    private final InputStream _inputStream;
    @GuardedBy(value="_connection (implicit)")
    private final OutputStream _outputStream;

    BasicSession(ConnectionSapDB connection, Address address) throws RTEException {
        super(connection, address);
        HanaWebSocket[] webSocketOutputParm = new HanaWebSocket[1];
        try {
            this._socket = this._openSocket(webSocketOutputParm);
            this._webSocket = webSocketOutputParm[0];
            this._inputStream = this._socket.getInputStream();
            this._outputStream = this._socket.getOutputStream();
        }
        catch (IOException e) {
            this.destroy();
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", address.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
    }

    @Override
    protected Socket _getSocket() {
        return this._socket;
    }

    @Override
    protected HanaWebSocket _getWebSocket() {
        return this._webSocket;
    }

    @Override
    protected InputStream _getInputStream() {
        return this._inputStream;
    }

    @Override
    protected OutputStream _getOutputStream() {
        return this._outputStream;
    }

    private Socket _openSocket(HanaWebSocket[] webSocketOutputParm) throws RTEException {
        Socket socket = null;
        HanaWebSocket webSocket = null;
        Address address = (Address)this._address.get();
        String host = address.getHost();
        int port = address.getPort();
        String webSocketUrl = this._connectionProperties.getProperty(ConnectionProperty.WEB_SOCKET_URL);
        boolean isWebSocket = !webSocketUrl.isEmpty();
        String proxyHostName = this._connectionProperties.getProperty(ConnectionProperty.PROXY_HOST_NAME);
        try {
            if (!proxyHostName.isEmpty()) {
                String proxyUserName;
                int proxyPort = this._connectionProperties.getIntProperty(ConnectionProperty.PROXY_PORT);
                char[] proxyPassword = this._connectionProperties.getProperty(ConnectionProperty.PROXY_PASSWD).toCharArray();
                String proxyScpAccount = this._connectionProperties.getProperty(ConnectionProperty.PROXY_SCP_ACCOUNT);
                if (!proxyScpAccount.isEmpty()) {
                    int idx = proxyScpAccount.indexOf(46);
                    if (idx != -1) {
                        byte[] leftPart = proxyScpAccount.substring(0, idx - 1).getBytes(CharsetUtils.US_ASCII);
                        byte[] rightPart = proxyScpAccount.substring(idx + 1).getBytes(CharsetUtils.US_ASCII);
                        proxyUserName = "1." + Base64Utils.encodeToString(leftPart) + '.' + Base64Utils.encodeToString(rightPart);
                    } else {
                        proxyUserName = "1." + Base64Utils.encodeToString(proxyScpAccount.getBytes(CharsetUtils.UTF_8));
                    }
                } else {
                    proxyUserName = this._connectionProperties.getProperty(ConnectionProperty.PROXY_USER_NAME);
                }
                final String f_proxyUserName = proxyUserName;
                final char[] f_proxyPassword = proxyPassword;
                Authenticator authenticator = new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(f_proxyUserName, f_proxyPassword);
                    }
                };
                if (isWebSocket) {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHostName, proxyPort));
                    webSocket = new HanaWebSocket(this._tracer, this._getWebSocketUri(address, webSocketUrl), proxy, authenticator, this._getConnectTimeout(), false, null, this._connectionProperties.getIntProperty(ConnectionProperty.WEB_SOCKET_PING_TIMEOUT));
                    socket = webSocket.getSocket();
                } else {
                    Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyHostName, proxyPort));
                    socket = new Socket(proxy);
                    Authenticator.setDefault(authenticator);
                    socket.connect(new InetSocketAddress(host, port), this._getConnectTimeout());
                }
            } else if (isWebSocket) {
                webSocket = new HanaWebSocket(this._tracer, this._getWebSocketUri(address, webSocketUrl), null, null, this._getConnectTimeout(), false, null, this._connectionProperties.getIntProperty(ConnectionProperty.WEB_SOCKET_PING_TIMEOUT));
                socket = webSocket.getSocket();
            } else {
                socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), this._getConnectTimeout());
            }
            this._setSocketOptions(socket);
            if (isWebSocket) {
                this._setWebSocketDefaults(this._connectionProperties);
            }
        }
        catch (UnknownHostException e) {
            this._throwRTEException(MessageTranslator.translate("error.unknown.host", address.toString(), e.getMessage(), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
        }
        catch (IOException e) {
            this._throwRTEException(MessageTranslator.translate("error.host.connect", address.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
        catch (RTEException e) {
            this._throwRTEException(e);
        }
        webSocketOutputParm[0] = webSocket;
        return socket;
    }
}

