/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.ClientInfo;
import com.sap.db.jdbc.ClientKeyPair;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.CursorID;
import com.sap.db.jdbc.DatabaseMetaDataSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.HanaCallableStatement;
import com.sap.db.jdbc.HanaCallableStatementFinalize;
import com.sap.db.jdbc.HanaCallableStatementPhantom;
import com.sap.db.jdbc.HanaDatabaseMetaData;
import com.sap.db.jdbc.HanaPreparedStatement;
import com.sap.db.jdbc.HanaPreparedStatementFinalize;
import com.sap.db.jdbc.HanaPreparedStatementPhantom;
import com.sap.db.jdbc.HanaStatement;
import com.sap.db.jdbc.InternalCallableStatementSapDB;
import com.sap.db.jdbc.InternalResultSetSapDB;
import com.sap.db.jdbc.InternalStatementSapDB;
import com.sap.db.jdbc.KeyCache;
import com.sap.db.jdbc.ParseID;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.PreferredAddress;
import com.sap.db.jdbc.PreparedStatementSapDB;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.SessionVariables;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteTypeVolumeID;
import com.sap.db.jdbc.StatementCache;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.SystemInfo;
import com.sap.db.jdbc.Topologies;
import com.sap.db.jdbc.Transaction;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.exceptions.ConnectionException;
import com.sap.db.jdbc.exceptions.InternalConnectException;
import com.sap.db.jdbc.exceptions.InternalFallbackHintRoutedException;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.ClientSideEncryptionVersion;
import com.sap.db.jdbc.packet.DistributionMode;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.HOptionsPart;
import com.sap.db.jdbc.packet.HPartInfo;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.StatementContextFlag;
import com.sap.db.jdbc.packet.StatementContextOption;
import com.sap.db.jdbc.packet.TransactionFlag;
import com.sap.db.jdbc.packet.TransactionState;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbcext.XAExceptionSAP;
import com.sap.db.jdbcext.wrapper.Connection;
import com.sap.db.util.AesCbc;
import com.sap.db.util.BackOffTimer;
import com.sap.db.util.Base64Utils;
import com.sap.db.util.Dbg;
import com.sap.db.util.DbgInstanceCount;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.RsaOaep;
import com.sap.db.util.StringUtils;
import com.sap.db.util.UUIDUtils;
import com.sap.db.util.UniqueID;
import com.sap.db.util.security.AbstractAuthenticationManager;
import com.sap.db.util.security.AuthenticationManager;
import com.sap.db.util.security.NativeAuthenticationManagerImpl;
import java.security.Key;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

@ThreadSafe
public abstract class ConnectionSapDB
extends WrapperDummy
implements java.sql.Connection {
    protected final Tracer _tracer;
    protected final Properties _info;
    protected final ConnectionProperties _connectionProperties;
    protected final List<PreferredAddress> _preferredAddresses;
    protected final AtomicBoolean _isClosed;
    private final SessionPool _sessionPool;
    private final UniqueID _uniqueID;
    private final boolean _emptyTimestampIsNull;
    private final boolean _inexactDoubleToDecimalConversion;
    private final AtomicInteger _sentBytes;
    private final AtomicInteger _receivedBytes;
    private final AtomicReference<StatementSapDB> _executingStatement;
    private final AtomicReference<StatementSapDB> _alterTableStatement;
    private final AtomicBoolean _isInReconnect;
    @GuardedBy(value="itself")
    private final Set<StatementSapDB> _statements = Collections.newSetFromMap(new WeakHashMap());
    @GuardedBy(value="itself")
    private final Set<PreparedStatementSapDB> _preparedStatementsClosePending = Collections.newSetFromMap(new WeakHashMap());
    @GuardedBy(value="itself")
    private final Set<ResultSetSapDB> _resultSetsClosePending = Collections.newSetFromMap(new WeakHashMap());
    @GuardedBy(value="this")
    private final Deque<HRequestPacket> _packetPool;
    @GuardedBy(value="this")
    private final SessionVariables _sessionVariables;
    @GuardedBy(value="this")
    private final ClientInfo _clientInfo;
    @GuardedBy(value="this")
    private final Transaction _transaction;
    @GuardedBy(value="this")
    private final StatementCache _statementCache;
    @GuardedBy(value="this")
    private Map<String, Class<?>> _typeMap;
    @GuardedBy(value="this")
    private int _resultSetHoldability;
    @GuardedBy(value="this")
    private boolean _isDDLCommitted;
    @GuardedBy(value="this")
    private boolean _isReadOnly;
    @GuardedBy(value="this")
    private int _isolationLevel;
    @GuardedBy(value="this")
    private String _currentSchema;
    @GuardedBy(value="this")
    private boolean _isIgnoringTopology;
    @GuardedBy(value="this")
    private DistributionMode _distributionMode;
    @GuardedBy(value="this")
    private byte[] _cookie;
    @GuardedBy(value="this")
    private Subject _authenticatedSubject;
    @GuardedBy(value="this")
    private EngineFeatures _engineFeatures;
    @GuardedBy(value="this")
    private SQLWarning _warnings;
    @GuardedBy(value="this")
    private DatabaseMetaDataSapDB _databaseMetaData;
    @GuardedBy(value="this")
    private String _defaultSchema;
    @GuardedBy(value="this")
    private int _rollbackCount;
    @GuardedBy(value="this")
    private boolean _savedAutoCommitForGlobalTransaction;
    @GuardedBy(value="this")
    private BackOffTimer _backOffTimer;
    @GuardedBy(value="this")
    private byte[] _statementContext;
    @GuardedBy(value="this")
    private ResultSetSapDB _outstandingPrefetchResultSet;
    @GuardedBy(value="this")
    private Session _outstandingPrefetchSession;
    @GuardedBy(value="this")
    private Map<ResultSetSapDB, Object> _prefetchedCachedReplyMap;

    public static ConnectionSapDB getConnectionSapDB(java.sql.Connection connection) {
        java.sql.Connection c = connection;
        while (!(c instanceof ConnectionSapDB)) {
            if (c instanceof Connection) {
                c = ((Connection)c).getPhysicalConnection();
                continue;
            }
            return null;
        }
        return (ConnectionSapDB)c;
    }

    public static int getJdbcIsolationLevelForHanaIsolationLevel(int hanaIsolationLevel) throws SQLException {
        switch (hanaIsolationLevel) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
        }
        throw SQLExceptionSapDB.newInstance("error.invalid.transactionisolation", String.valueOf(hanaIsolationLevel));
    }

    public static String getSQLForJdbcIsolationLevel(int jdbcIsolationLevel) throws SQLException {
        switch (jdbcIsolationLevel) {
            case 0: 
            case 1: {
                return "READ UNCOMMITTED";
            }
            case 2: {
                return "READ COMMITTED";
            }
            case 4: {
                return "REPEATABLE READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        throw SQLExceptionSapDB.newInstance("error.invalid.transactionisolation", String.valueOf(jdbcIsolationLevel));
    }

    protected ConnectionSapDB(Tracer tracer, Properties info, ConnectionProperties connectionProperties, List<PreferredAddress> preferredAddresses) {
        this._tracer = tracer;
        this._info = info;
        this._connectionProperties = new ConnectionProperties(connectionProperties);
        this._preferredAddresses = Collections.unmodifiableList(preferredAddresses);
        this._isClosed = new AtomicBoolean();
        this._sessionPool = new SessionPool(this);
        this._uniqueID = new UniqueID();
        this._emptyTimestampIsNull = this._connectionProperties.getBooleanProperty(ConnectionProperty.EMPTY_TIMESTAMP_IS_NULL);
        this._inexactDoubleToDecimalConversion = this._connectionProperties.getBooleanProperty(ConnectionProperty.INEXACT_DOUBLE_TO_DECIMAL_CONVERSION);
        this._sentBytes = new AtomicInteger();
        this._receivedBytes = new AtomicInteger();
        this._executingStatement = new AtomicReference();
        this._alterTableStatement = new AtomicReference();
        this._isInReconnect = new AtomicBoolean();
        this._packetPool = new ArrayDeque<HRequestPacket>();
        this._sessionVariables = new SessionVariables();
        this._clientInfo = new ClientInfo();
        this._transaction = new Transaction(this);
        this._statementCache = StatementCache.getInstance(this);
        this._typeMap = new TreeMap();
        this._resultSetHoldability = 1;
        this._isDDLCommitted = true;
        this._transaction.setAutoCommit(this._connectionProperties.getBooleanProperty(ConnectionProperty.AUTO_COMMIT));
        this._isReadOnly = this._connectionProperties.getBooleanProperty(ConnectionProperty.READ_ONLY);
        this._isolationLevel = ConnectionSapDB._getJdbcIsolationLevelForConnectionPropertyValue(this._connectionProperties.getProperty(ConnectionProperty.ISOLATION));
        this._currentSchema = this._connectionProperties.getProperty(ConnectionProperty.CURRENT_SCHEMA);
        this._isIgnoringTopology = this._connectionProperties.getBooleanProperty(ConnectionProperty.IGNORE_TOPOLOGY);
        this._distributionMode = this._isIgnoringTopology ? DistributionMode.Off : DistributionMode.decode(this._connectionProperties.getProperty(ConnectionProperty.DISTRIBUTION));
        this._prefetchedCachedReplyMap = new HashMap<ResultSetSapDB, Object>();
        if (this._connectionProperties.hasProperty(ConnectionProperty.CSE_KEY_STORE_PASSWD)) {
            KeyCache.setKeyStoreFilename(this._connectionProperties.getProperty(ConnectionProperty.CSE_KEY_STORE_FILENAME));
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "createStatement", new Object[0]);
            }
            Statement result = this._createStatement(1003, 1007, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            Statement statement = result;
            return statement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareStatement", sql);
            }
            PreparedStatement result = this._prepareStatement(sql, 1003, 1007, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            PreparedStatement preparedStatement = result;
            return preparedStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareCall") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareCall", sql);
            }
            CallableStatement result = this._prepareCall(sql, 1003, 1007, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            CallableStatement callableStatement = result;
            return callableStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String nativeSQL(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("nativeSQL") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "nativeSQL", sql);
            }
            String result = sql;
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getAutoCommit") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getAutoCommit", new Object[0]);
            }
            boolean result = this.isAutoCommit();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setAutoCommit") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAutoCommit", autoCommit);
            }
            this._setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("commit") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "commit", new Object[0]);
            }
            this._commit();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("rollback") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "rollback", new Object[0]);
            }
            this._rollback();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isClosed() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("isClosed") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isClosed", new Object[0]);
            }
            boolean result = this._isClosed();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("close") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "close", new Object[0]);
            }
            this._close();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMetaData") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMetaData", new Object[0]);
            }
            DatabaseMetaData result = this._getMetaData();
            if (on) {
                this._tracer.printResult(result);
            }
            DatabaseMetaData databaseMetaData = result;
            return databaseMetaData;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("isReadOnly") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isReadOnly", new Object[0]);
            }
            boolean result = this._isReadOnly;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setReadOnly(boolean isReadOnly) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setReadOnly") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setReadOnly", isReadOnly);
            }
            this._setReadOnly(isReadOnly);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getCatalog() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getCatalog") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getCatalog", new Object[0]);
            }
            String result = null;
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setCatalog(String catalog) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setCatalog") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCatalog", catalog);
            }
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTransactionIsolation") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTransactionIsolation", new Object[0]);
            }
            int result = this._isolationLevel;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setTransactionIsolation") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTransactionIsolation", level);
            }
            this._setTransactionIsolation(level, true);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getWarnings") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getWarnings", new Object[0]);
            }
            SQLWarning result = this._warnings;
            if (on) {
                this._tracer.printResult(result);
            }
            SQLWarning sQLWarning = result;
            return sQLWarning;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("clearWarnings") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearWarnings", new Object[0]);
            }
            this._warnings = null;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "createStatement", resultSetType, resultSetConcurrency);
            }
            Statement result = this._createStatement(resultSetType, resultSetConcurrency, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            Statement statement = result;
            return statement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareStatement", sql, resultSetType, resultSetConcurrency);
            }
            PreparedStatement result = this._prepareStatement(sql, resultSetType, resultSetConcurrency, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            PreparedStatement preparedStatement = result;
            return preparedStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareCall") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareCall", sql, resultSetType, resultSetConcurrency);
            }
            CallableStatement result = this._prepareCall(sql, resultSetType, resultSetConcurrency, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            CallableStatement callableStatement = result;
            return callableStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTypeMap") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTypeMap", new Object[0]);
            }
            Map<String, Class<?>> result = Collections.unmodifiableMap(this._typeMap);
            if (on) {
                this._tracer.printResult(result);
            }
            Map<String, Class<?>> map = result;
            return map;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setTypeMap(Map<String, Class<?>> typeMap) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setTypeMap") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTypeMap", typeMap);
            }
            this._typeMap = typeMap != null ? new TreeMap(typeMap) : new TreeMap();
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "createStatement", resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            Statement result = this._createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            if (on) {
                this._tracer.printResult(result);
            }
            Statement statement = result;
            return statement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareStatement", sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            PreparedStatement result = this._prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            if (on) {
                this._tracer.printResult(result);
            }
            PreparedStatement preparedStatement = result;
            return preparedStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareCall") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareCall", sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            CallableStatement result = this._prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            if (on) {
                this._tracer.printResult(result);
            }
            CallableStatement callableStatement = result;
            return callableStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareStatement", sql, autoGeneratedKeys);
            }
            if (autoGeneratedKeys != 2) {
                throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "autoGeneratedKeys", "NO_GENERATED_KEYS");
            }
            PreparedStatement result = this._prepareStatement(sql, 1003, 1007, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            PreparedStatement preparedStatement = result;
            return preparedStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "prepareStatement", sql, columnIndexes);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("prepareStatement( String, int[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "prepareStatement", sql, columnNames);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("prepareStatement( String, String[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getHoldability() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getHoldability") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getHoldability", new Object[0]);
            }
            int result = this._resultSetHoldability;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setHoldability(int holdability) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setHoldability") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setHoldability", holdability);
            }
            this._resultSetHoldability = holdability;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setSavepoint") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setSavepoint", new Object[0]);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("setSavepoint()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setSavepoint") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setSavepoint", name);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("setSavepoint( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("rollback") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "rollback", savepoint);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("rollback( Savepoint )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("releaseSavepoint") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "releaseSavepoint", savepoint);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("releaseSavepoint( Savepoint )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Clob createClob() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createClob", new Object[0]);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("createClob()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Blob createBlob() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createBlob", new Object[0]);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("createBlob()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized NClob createNClob() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createNClob", new Object[0]);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("createNClob()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized SQLXML createSQLXML() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createSQLXML", new Object[0]);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("createSQLXML()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean isValid(int timeout) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("isValid") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isValid", timeout);
            }
            boolean result = this._isValid(timeout);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Properties getClientInfo() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getClientInfo") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getClientInfo", new Object[0]);
            }
            Properties result = this._getClientInfo();
            if (on) {
                this._tracer.printResult(result);
            }
            Properties properties = result;
            return properties;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getClientInfo(String key) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getClientInfo") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getClientInfo", key);
            }
            String result = this._getClientInfo(key);
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setClientInfo(Properties properties) throws SQLClientInfoException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setClientInfo") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClientInfo", properties);
            }
            this._setClientInfo(properties);
        }
        catch (SQLClientInfoException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setClientInfo(String key, String value) throws SQLClientInfoException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setClientInfo") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClientInfo", key, value);
            }
            this._setClientInfo(key, value);
        }
        catch (SQLClientInfoException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createArrayOf") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createArrayOf", typeName, elements);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("createArrayOf( String, Object[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createStruct") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createStruct", typeName, attributes);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("createStruct( String, Object[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getSchema() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSchema") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getSchema", new Object[0]);
            }
            String result = this._currentSchema;
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setSchema(String schema) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setSchema") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setSchema", schema);
            }
            this._setCurrentSchema(schema);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void abort(Executor executor) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("abort") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "abort", executor);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("abort( Executor )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized int getNetworkTimeout() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getNetworkTimeout") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getNetworkTimeout", new Object[0]);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("getNetworkTimeout()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setNetworkTimeout") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setNetworkTimeout", executor, milliseconds);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("setNetworkTimeout( Executor, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    public String toString() {
        return this.getTraceString(true);
    }

    public static String getTraceString(String className, int hashCode, boolean isFullString, boolean isClosed, int anchorConnectionID) {
        String s = className + "@" + Integer.toHexString(hashCode);
        if (!isFullString) {
            return s;
        }
        if (isClosed) {
            return s + "[closed]";
        }
        return s + "[ID:" + anchorConnectionID + "]";
    }

    public String getTraceString(boolean isFullString) {
        return ConnectionSapDB.getTraceString(this.getClass().getName(), this.hashCode(), isFullString, this._isClosed(), this.getAnchorConnectionID());
    }

    public Tracer getTracer() {
        return this._tracer;
    }

    public SessionPool getSessionPool() {
        return this._sessionPool;
    }

    public int getAnchorConnectionID() {
        return Driver.getAnchorConnectionID(this);
    }

    public int getPrimaryConnectionID() {
        return Driver.getPrimaryConnectionID(this);
    }

    public ConnectionProperties getConnectionProperties() {
        return this._connectionProperties;
    }

    public String getConnectionProperty(ConnectionProperty connectionProperty) {
        return this._connectionProperties.getProperty(connectionProperty);
    }

    public boolean getBooleanConnectionProperty(ConnectionProperty connectionProperty) {
        return this._connectionProperties.getBooleanProperty(connectionProperty);
    }

    public int getIntConnectionProperty(ConnectionProperty connectionProperty) {
        return this._connectionProperties.getIntProperty(connectionProperty);
    }

    public void setConnectionProperty(ConnectionProperty connectionProperty, String value) {
        this._connectionProperties.setProperty(connectionProperty, value);
    }

    public boolean emptyTimestampIsNull() {
        return this._emptyTimestampIsNull;
    }

    public boolean inexactDoubleToDecimalConversion() {
        return this._inexactDoubleToDecimalConversion;
    }

    public int getSentBytes() {
        return this._sentBytes.get();
    }

    public int getReceivedBytes() {
        return this._receivedBytes.get();
    }

    public boolean isReconnecting() {
        return this._isInReconnect.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<StatementSapDB> getStatements() {
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            return new HashSet<StatementSapDB>(this._statements);
        }
    }

    public synchronized boolean isAutoCommit() {
        return this._transaction.getAutoCommit();
    }

    public synchronized TransactionState getTransactionState() {
        return this._transaction.getTransactionState();
    }

    public synchronized void handleTransaction(Session session, boolean allowChangePrimaryAndXAJoin) throws SQLException {
        this._transaction.handleTransaction(this, session, allowChangePrimaryAndXAJoin);
    }

    public synchronized void clearTransaction(boolean forCloseOrReconnect) {
        this._transaction.clearTransaction(this, forCloseOrReconnect);
    }

    public synchronized boolean isIgnoringTopology() {
        return this._isIgnoringTopology;
    }

    public synchronized DistributionMode getDistributionMode() {
        return this._distributionMode;
    }

    public synchronized byte[] getCookie() {
        return this._cookie;
    }

    public synchronized void setCookie(byte[] cookie) {
        this._cookie = cookie;
    }

    public synchronized Subject getAuthenticatedSubject() {
        return this._authenticatedSubject;
    }

    public synchronized void setAuthenticatedSubject(Subject authenticatedSubject) {
        this._authenticatedSubject = authenticatedSubject;
    }

    public synchronized String getTermID() {
        int processID = Driver.getProcessID();
        return processID == 0 ? "java@" + Integer.toHexString(this.hashCode()) : processID + "@" + Driver.getFullComputerName();
    }

    public synchronized EngineFeatures getEngineFeatures() {
        return this._engineFeatures;
    }

    public synchronized byte[] getStatementContext() {
        return this._statementContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HReplyPacket exchange(Session session, HRequestPacket requestPacket, StatementSapDB statement, ExchangeFlag ... exchangeFlags) throws SQLException {
        this._assertOpen();
        try {
            this._executingStatement.set(statement);
            this._send(session, requestPacket, exchangeFlags);
            HReplyPacket hReplyPacket = this._receive(session, exchangeFlags);
            return hReplyPacket;
        }
        finally {
            this._executingStatement.set(null);
        }
    }

    public synchronized void send(Session session, HRequestPacket requestPacket, StatementSapDB statement, ExchangeFlag ... exchangeFlags) throws SQLException {
        this._assertOpen();
        try {
            this._executingStatement.set(statement);
            this._send(session, requestPacket, exchangeFlags);
        }
        catch (SQLException e) {
            this._executingStatement.set(null);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HReplyPacket receive(Session session, StatementSapDB statement, ExchangeFlag ... exchangeFlags) throws SQLException {
        this._assertOpen();
        try {
            this._executingStatement.set(statement);
            HReplyPacket hReplyPacket = this._receive(session, exchangeFlags);
            return hReplyPacket;
        }
        finally {
            this._executingStatement.set(null);
        }
    }

    public synchronized void start(Xid xid, int flags) throws XAException {
        try {
            this._assertOpen();
            this._saveAndAlterAutoCommitForGlobalTransaction();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXAStart(this, session, xid, flags);
            this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized void end(Xid xid, int flags) throws XAException {
        try {
            this._assertOpen();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXAEnd(this, session, xid, flags);
            this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
        finally {
            this._restoreAutoCommitForGlobalTransaction();
        }
    }

    public synchronized int prepare(Xid xid) throws XAException {
        try {
            this._assertOpen();
            this._closeCursorsAtCommit();
            this._closePendingPreparedStatementsAndResultSets();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXAPrepare(this, session, xid);
            HReplyPacket replyPacket = this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
            int returnCode = replyPacket.findXAReturnCode(0);
            this.clearTransaction(false);
            return returnCode;
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this._assertOpen();
            if (onePhase) {
                this._closeCursorsAtCommit();
                this._closePendingPreparedStatementsAndResultSets();
            }
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXACommit(this, session, xid, onePhase);
            this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
            if (onePhase) {
                this.clearTransaction(false);
            }
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized void rollback(Xid xid) throws XAException {
        try {
            this._assertOpen();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXARollback(this, session, xid);
            this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
            this.clearTransaction(false);
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized Xid[] recover(int flag) throws XAException {
        try {
            this._assertOpen();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXARecover(this, session, flag);
            HReplyPacket replyPacket = this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
            Xid[] xids = replyPacket.findXids(0);
            return xids;
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized void forget(Xid xid) throws XAException {
        try {
            this._assertOpen();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXAForget(this, session, xid);
            this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized HRequestPacket initAuthenticate(Session session) {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initAuthenticate(this);
        return requestPacket;
    }

    public synchronized HRequestPacket initConnect(Session session, AbstractAuthenticationManager authenticationManager, String userName, String passwd, String userNameFromServer) throws SQLException {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initConnect(this, session, authenticationManager, userName, passwd, userNameFromServer);
        return requestPacket;
    }

    public synchronized HRequestPacket initDisconnect(Session session) {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initDisconnect();
        return requestPacket;
    }

    public synchronized HRequestPacket initExecuteDirect(Session session, int resultSetHoldability, int queryTimeout, String sql, String sourceModule, int lineNumber, boolean isBatch) {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initExecuteDirect(this, session, resultSetHoldability, queryTimeout, sql, sourceModule, lineNumber, isBatch);
        return requestPacket;
    }

    public synchronized HRequestPacket initPrepare(Session session, int resultSetHoldability, String sql) {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initPrepare(this, session, resultSetHoldability, sql);
        return requestPacket;
    }

    public synchronized HRequestPacket initExecute(Session session, int resultSetHoldability, int queryTimeout, ParseID parseID) {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initExecute(this, session, resultSetHoldability, queryTimeout, parseID);
        return requestPacket;
    }

    public synchronized HRequestPacket initReadLOB(Session session, byte[] locatorID, long position) {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initReadLOB(this, session, locatorID, position);
        return requestPacket;
    }

    public synchronized HRequestPacket initWriteLOB(Session session) {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initWriteLOB(this, session);
        return requestPacket;
    }

    public synchronized HRequestPacket initFetchNext(Session session, CursorID cursorID, int fetchSize) {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initFetchNext(this, session, cursorID, fetchSize);
        return requestPacket;
    }

    public synchronized HRequestPacket initStartDistributedTransaction(Session session) {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initStartDistributedTransaction(this, session);
        return requestPacket;
    }

    public synchronized HRequestPacket initJoinDistributedTransaction(Session session, byte[] transactionID) {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initJoinDistributedTransaction(this, session, transactionID);
        return requestPacket;
    }

    public synchronized Map<String, String> generateClientInfoTransform(Session session) {
        String key;
        HashMap<String, String> map = new HashMap<String, String>();
        Properties connectionProperties = new Properties();
        if (session.isHintRouted() || this._isInReconnect.get()) {
            connectionProperties.putAll((Map<?, ?>)this._sessionVariables._getProperties());
        }
        connectionProperties.putAll((Map<?, ?>)this._clientInfo._getProperties());
        Properties sessionProperties = session.getCurrentSessionVariablesAndClientInfoProperties();
        for (Map.Entry<Object, Object> entry : connectionProperties.entrySet()) {
            key = (String)entry.getKey();
            String desiredValue = (String)entry.getValue();
            String currentValue = sessionProperties.getProperty(key);
            if (currentValue != null && currentValue.equals(desiredValue)) continue;
            map.put(key, desiredValue);
        }
        for (Object object : sessionProperties.keySet()) {
            key = (String)object;
            if (connectionProperties.containsKey(key)) continue;
            map.put(key, null);
        }
        return map;
    }

    public synchronized void reinitialize(boolean toFactorySettings, boolean factoryAutoCommitSetting) throws SQLException {
        if (!toFactorySettings) {
            this._cacheOnInternalReconnect();
            return;
        }
        if (this._tracer.on()) {
            this._tracer.printConnectionMessage(this, "Returned to pool", new String[0]);
            this._tracer.printConnectionStatistics(this);
        }
        this._closeStatements(true);
        this._transaction.setAutoCommit(factoryAutoCommitSetting);
        this._setReadOnly(false);
        this._setTransactionIsolation(2, true);
        this._setCurrentSchema(this._defaultSchema);
        this._typeMap.clear();
        this._resultSetHoldability = 1;
        this._setClientInfo(null);
    }

    public boolean isPreparedStatementCacheEnabled() {
        return this._statementCache != null;
    }

    public int getPreparedStatementCurrentCacheSize() {
        return this._statementCache != null ? this._statementCache.getCurrentCacheSize() : -1;
    }

    public int getPreparedStatementCurrentTrackSize() {
        return this._statementCache != null ? this._statementCache.getCurrentTrackSize() : -1;
    }

    public int getPreparedStatementCount() {
        return this._statementCache != null ? this._statementCache.getPrepareCount() : -1;
    }

    public int getPreparedStatementCacheHitCount() {
        return this._statementCache != null ? this._statementCache.getCacheHitCount() : -1;
    }

    public int getPreparedStatementExecuteCount() {
        return this._statementCache != null ? this._statementCache.getExecuteCount() : -1;
    }

    public int getPreparedStatementDropCount() {
        return this._statementCache != null ? this._statementCache.getDropCount() : -1;
    }

    public int getPreparedStatementApproxUniqueSQLTextCount() {
        return this._statementCache != null ? this._statementCache.getApproxUniqueSQLTextCount() : -1;
    }

    public int getPreparedStatementCacheRejectedFullCount() {
        return this._statementCache != null ? this._statementCache.getCacheRejectedFullCount() : -1;
    }

    public int getPreparedStatementCacheEvictedFullCount() {
        return this._statementCache != null ? this._statementCache.getCacheEvictedFullCount() : -1;
    }

    public int getPreparedStatementCacheEvictedColdCount() {
        return this._statementCache != null ? this._statementCache.getCacheEvictedColdCount() : -1;
    }

    public int getPreparedStatementTrackEvictedFullCount() {
        return this._statementCache != null ? this._statementCache.getTrackEvictedFullCount() : -1;
    }

    public int getPreparedStatementTrackEvictedColdCount() {
        return this._statementCache != null ? this._statementCache.getTrackEvictedColdCount() : -1;
    }

    public synchronized ColumnEncryptionKey retrieveColumnEncryptionKey(String cekId) throws SQLException {
        ColumnEncryptionKey cek = KeyCache.getCachedColumnEncryptionKey(cekId, this._connectionProperties.getProperty(ConnectionProperty.CSE_KEY_STORE_PASSWD));
        if (cek != null) {
            return cek;
        }
        String password = this._connectionProperties.getProperty(ConnectionProperty.CSE_KEY_STORE_PASSWD);
        KeyCache.loadAllClientKeyPairs(null, password);
        Set<String> clientKeyPairIds = KeyCache.getClientKeyPairIds();
        for (String ckpId : clientKeyPairIds) {
            try {
                cek = this._retrieveColumnEncryptionKey(cekId, ckpId);
                if (cek == null) continue;
                break;
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -11488) continue;
                throw e;
            }
        }
        if (cek == null) {
            throw SQLExceptionSapDB.newInstance("error.couldnotretrievecek", cekId);
        }
        return cek;
    }

    protected synchronized Session _connectAnchor(boolean isReconnect, SiteType reconnectSiteType) throws RTEException, SQLException {
        SiteType siteType;
        boolean isConnectionDistribution;
        boolean isIgnoringTopology;
        SessionFactory factory = Driver.getSessionFactory(this._tracer, this._connectionProperties);
        boolean isWrongSiteType = false;
        int failedAddressesCount = 0;
        RTEException firstRTEException = null;
        StringBuilder errorMessage = null;
        if (isReconnect) {
            isIgnoringTopology = this._isIgnoringTopology;
            isConnectionDistribution = isIgnoringTopology ? false : this._distributionMode.isConnectionDistribution();
            siteType = reconnectSiteType;
        } else {
            isIgnoringTopology = this._connectionProperties.getBooleanProperty(ConnectionProperty.IGNORE_TOPOLOGY);
            isConnectionDistribution = isIgnoringTopology ? false : DistributionMode.decode(this._connectionProperties.getProperty(ConnectionProperty.DISTRIBUTION)).isConnectionDistribution();
            String siteTypeString = this._connectionProperties.getProperty(ConnectionProperty.SITE_TYPE);
            siteType = siteTypeString.equalsIgnoreCase("PRIMARY") ? SiteType.PRIMARY : (siteTypeString.equalsIgnoreCase("SECONDARY") ? SiteType.SECONDARY : SiteType.NONE);
        }
        List<? extends Address> addressesList = ConnectionSapDB._buildAddressesList(this._preferredAddresses, isConnectionDistribution, siteType);
        if (this._tracer.on()) {
            this._tracer.printConnectionOpening(this, "Properties:         " + Driver.getDisplayProperties(this._connectionProperties), "PreferredAddresses: " + Arrays.toString(this._preferredAddresses.toArray()), "ResolvedAddresses:  " + Arrays.toString(addressesList.toArray()));
        }
        for (Address address : addressesList) {
            try {
                Session session = factory.newInstance(this, address, true);
                if (isIgnoringTopology && !session.getAddress().equals(address)) {
                    session.destroy();
                    throw SQLExceptionSapDB.newInstance("error.connection.invalidproperties", "databaseName", "ignoreTopology=true");
                }
                this._authenticateAndConnectSession(session, true);
                if (siteType != SiteType.NONE && !session.getSiteType().equals(siteType)) {
                    this._sessionPool.releaseAll(this);
                    isWrongSiteType = true;
                    continue;
                }
                if (isReconnect) {
                    this._refreshMetaData();
                } else {
                    this._databaseMetaData = new HanaDatabaseMetaData(this._tracer, this);
                    this._defaultSchema = this._databaseMetaData._getUserName();
                    if (this._currentSchema == null) {
                        this._currentSchema = this._defaultSchema;
                    }
                }
                this._initClientInfoFromProperties();
                if (this._tracer.on()) {
                    this._tracer.printConnectionOpened(this);
                }
                return session;
            }
            catch (RTEException e) {
                switch (++failedAddressesCount) {
                    case 1: {
                        firstRTEException = e;
                        break;
                    }
                    case 2: {
                        errorMessage = new StringBuilder();
                        errorMessage.append(firstRTEException.getMessage());
                    }
                    default: {
                        errorMessage.append("; host = ");
                        errorMessage.append(address.toString());
                        errorMessage.append(" error = ");
                        errorMessage.append(e.getMessage());
                        break;
                    }
                }
            }
            catch (InternalConnectException e) {
                return this._connectAnchor(false, null);
            }
        }
        if (isWrongSiteType) {
            throw SQLExceptionSapDB.newInstance("error.wrong.site", this._connectionProperties.getProperty(ConnectionProperty.SITE_TYPE));
        }
        if (failedAddressesCount > 1) {
            throw new RTEException(this._tracer, MessageTranslator.translate("error.connect.rteexceptionMultipleHosts", errorMessage), RteReturnCode.SQLNOTOK, -708, firstRTEException);
        }
        throw firstRTEException;
    }

    protected Session _connectSecondary(SiteTypeVolumeID siteTypeVolumeID) throws RTEException, SQLException {
        SystemInfo systemInfo = this._sessionPool.getSystemInfo();
        if (systemInfo == null) {
            if (this._tracer.on()) {
                this._tracer.printConnectionMessage(this, "No SystemInfo available", new String[0]);
            }
            return null;
        }
        PublicAddress publicAddress = this._sessionPool.getSystemInfo().getAddress(siteTypeVolumeID);
        if (publicAddress == null) {
            if (this._tracer.on()) {
                this._tracer.printConnectionMessage(this, "No public address for SiteTypeVolumeID " + siteTypeVolumeID, new String[0]);
            }
            return null;
        }
        SessionFactory factory = Driver.getSessionFactory(this._tracer, this._connectionProperties);
        Session session = factory.newInstance(this, publicAddress, false);
        try {
            this._authenticateAndConnectSession(session, false);
        }
        catch (InternalConnectException e) {
            return null;
        }
        return session;
    }

    protected static SQLException _getUnsupportedMethodException(String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.unsupported", methodSignature, "Connection");
    }

    protected static String _getSessionVariableFromProperties(String name, Properties info) {
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            String sessionVariableValue;
            String sessionVariableName = ConnectionSapDB._getSessionVariableName(entry.getKey());
            if (sessionVariableName == null || !sessionVariableName.equalsIgnoreCase(name) || (sessionVariableValue = ConnectionSapDB._getSessionVariableValue(entry.getValue())) == null) continue;
            return sessionVariableValue;
        }
        return null;
    }

    protected TraceRecord _newTraceRecord(String methodName) {
        return new TraceRecord(this, null, null, "Connection", methodName);
    }

    protected void _publish(TraceRecord r) {
        r.update(this);
        TraceRecordPublisher.getInstance().publish(r);
    }

    protected PreparedStatement _prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this._assertOpen();
        if (Driver._createPhantomClass(this._connectionProperties)) {
            return HanaPreparedStatementPhantom.newInstance(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false, false);
        }
        if (Driver._createFinalizerClass(this._connectionProperties)) {
            return HanaPreparedStatementFinalize.newInstance(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false, false);
        }
        return HanaPreparedStatement.newInstance(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false, false);
    }

    protected CallableStatement _prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this._assertOpen();
        if (Driver._createPhantomClass(this._connectionProperties)) {
            return HanaCallableStatementPhantom.newInstance(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false, false);
        }
        if (Driver._createFinalizerClass(this._connectionProperties)) {
            return HanaCallableStatementFinalize.newInstance(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false, false);
        }
        return HanaCallableStatement.newInstance(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false, false);
    }

    protected void _assertOpen() throws SQLException {
        if (this._isClosed()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
    }

    protected UniqueID _getUniqueID() {
        return this._uniqueID;
    }

    protected synchronized Properties _getSessionVariables() {
        return (Properties)this._sessionVariables._getProperties().clone();
    }

    protected synchronized Properties _getClientInfo() {
        return (Properties)this._clientInfo._getProperties().clone();
    }

    protected synchronized String _getClientInfo(String key) {
        return this._clientInfo._getProperty(key);
    }

    protected synchronized void _setClientInfo(Properties properties) throws SQLClientInfoException {
        this._clientInfo._setProperties(properties);
        this._sessionPool.setSendClientInfoFlag();
    }

    protected synchronized void _setClientInfo(String key, String value) throws SQLClientInfoException {
        this._clientInfo._setProperty(key, value);
        this._sessionPool.setSendClientInfoFlag();
    }

    protected synchronized int _getHoldability() {
        return this._resultSetHoldability;
    }

    protected synchronized int _getTransactionIsolation() {
        return this._isolationLevel;
    }

    protected synchronized int _getRollbackCount() {
        return this._rollbackCount;
    }

    protected synchronized void _commitInternal() throws SQLException {
        block2: {
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initCommit(this, session);
            try {
                this.exchange(session, requestPacket, null, ExchangeFlag.IS_STATEMENT);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 700) break block2;
                throw e;
            }
        }
    }

    protected synchronized void _rollbackInternal() throws SQLException {
        block2: {
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initRollback(this, session);
            try {
                this.exchange(session, requestPacket, null, ExchangeFlag.IS_STATEMENT);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 700) break block2;
                throw e;
            }
        }
    }

    protected synchronized Session _getSecondarySession(SiteTypeVolumeID siteTypeVolumeID) throws SQLException {
        if (this._isIgnoringTopology) {
            return null;
        }
        Session session = this._sessionPool.getSession(siteTypeVolumeID);
        if (session == null) {
            try {
                session = this._connectSecondary(siteTypeVolumeID);
            }
            catch (RTEException e) {
                throw SQLExceptionSapDB.newInstance(e.getCause(), "error.connect.rteexception", "", e.getDetailErrorCode(), 0, e.getRTEReturnCode(), SQLExceptionSapDB.NO_UPDATE_COUNTS, "SiteTypeVolumeID=" + siteTypeVolumeID, e.getMessage());
            }
        }
        return session;
    }

    protected synchronized void _handleFailedHintRouted() {
        if (this._backOffTimer == null) {
            this._backOffTimer = new BackOffTimer(this._connectionProperties);
        }
        this._backOffTimer.backOff();
    }

    protected synchronized void _handleSuccessHintRouted() {
        if (this._backOffTimer == null) {
            return;
        }
        this._backOffTimer.reset();
    }

    protected synchronized boolean _isSecondaryReady() {
        if (this._backOffTimer == null) {
            return true;
        }
        return this._backOffTimer.isRetryOk();
    }

    protected synchronized void _dropParseIDs(ParseInfo parseInfo) throws SQLException {
        for (Map.Entry<Session, ParseID> entry : new HashMap<Session, ParseID>(parseInfo.getParseIDs()).entrySet()) {
            Session session = entry.getKey();
            ParseID parseID = entry.getValue();
            this._dropParseID(session, parseID);
            parseInfo.removeParseID(session);
        }
    }

    protected synchronized void _dropParseID(Session session, ParseID parseID) {
        if (session == null || !session.isConnected() || parseID == null) {
            return;
        }
        try {
            this.handleTransaction(session, false);
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initDropStatementID(this, session, parseID);
            this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected synchronized void _dropCursorID(Session session, CursorID cursorID) throws SQLException {
        if (session == null || !session.isConnected() || cursorID == null) {
            return;
        }
        try {
            this.handleTransaction(session, false);
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initCloseResultSet(this, session, cursorID);
            this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean _isClosed() {
        return this._isClosed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _close() throws SQLException {
        if (this._isClosed()) {
            return;
        }
        if (this._tracer.on()) {
            this._tracer.printConnectionClosing(this);
            this._tracer.printConnectionStatistics(this);
        }
        this._closeStatements(false);
        try {
            ConnectionSapDB connectionSapDB = this;
            synchronized (connectionSapDB) {
                block11: {
                    if (!this._isClosed()) break block11;
                    return;
                }
                this._clean();
                this._databaseMetaData = null;
                this._packetPool.clear();
                this.clearTransaction(true);
                this._isClosed.set(true);
            }
        }
        finally {
            Driver._removeConnection(this);
            if (this._tracer.on()) {
                this._tracer.printConnectionClosed(this);
            }
        }
    }

    protected void _clean() throws SQLException {
        ConnectionSapDB._clean(this.getInstanceClassName(), this, this._sessionPool, this._isClosed);
    }

    protected static void _clean(String instanceClassName, ConnectionSapDB connection, SessionPool sessionPool, AtomicBoolean isClosed) throws SQLException {
        if (isClosed.get()) {
            return;
        }
        sessionPool.releaseAll(connection);
        if (Dbg.runtimeEnabled) {
            DbgInstanceCount.incrementCleanedCount(instanceClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _cancel(Statement statement) throws SQLException {
        if (this._executingStatement.get() != statement && this._alterTableStatement.get() != statement) {
            return;
        }
        ConnectionSapDB conn = null;
        StatementSapDB is = null;
        try {
            conn = ConnectionSapDB.getConnectionSapDB(Driver.getInstance().getConnection(this._connectionProperties.getProperty(ConnectionProperty.DBURL), this._connectionProperties.toProperties()));
            int connectionID = this.getAnchorConnectionID();
            is = InternalStatementSapDB.newInstance(conn, false, true);
            is._executeUpdate("ALTER SYSTEM CANCEL SESSION '" + connectionID + "'");
        }
        finally {
            if (is != null) {
                try {
                    is._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addStatement(StatementSapDB statement) {
        if (statement instanceof InternalStatementSapDB) {
            return;
        }
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            this._statements.add(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removeStatement(StatementSapDB statement) {
        if (statement instanceof InternalStatementSapDB) {
            return;
        }
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            this._statements.remove(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _closeStatements(boolean sendRequests) throws SQLException {
        HashSet<StatementSapDB> statements;
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            statements = new HashSet<StatementSapDB>(this._statements);
        }
        for (StatementSapDB statement : statements) {
            statement._close(sendRequests, false);
        }
        this._cacheOnCloseStatements(sendRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _closeCursorsAtCommit() throws SQLException {
        HashSet<StatementSapDB> statements;
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            statements = new HashSet<StatementSapDB>(this._statements);
        }
        for (StatementSapDB statement : statements) {
            if (statement._getResultSetHoldability() != 2) continue;
            statement._closeResultSets(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addPreparedStatementClosePending(PreparedStatementSapDB statement) {
        Set<PreparedStatementSapDB> set = this._preparedStatementsClosePending;
        synchronized (set) {
            this._preparedStatementsClosePending.add(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removePreparedStatementClosePending(PreparedStatementSapDB statement) {
        Set<PreparedStatementSapDB> set = this._preparedStatementsClosePending;
        synchronized (set) {
            this._preparedStatementsClosePending.remove(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addResultSetClosePending(ResultSetSapDB resultSet) {
        Set<ResultSetSapDB> set = this._resultSetsClosePending;
        synchronized (set) {
            this._resultSetsClosePending.add(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removeResultSetClosePending(ResultSetSapDB resultSet) {
        Set<ResultSetSapDB> set = this._resultSetsClosePending;
        synchronized (set) {
            this._resultSetsClosePending.remove(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _closePendingPreparedStatementsAndResultSets() throws SQLException {
        HashSet<ResultSetSapDB> resultSets;
        HashSet<PreparedStatementSapDB> preparedStatements;
        Object object = this._preparedStatementsClosePending;
        synchronized (object) {
            preparedStatements = new HashSet<PreparedStatementSapDB>(this._preparedStatementsClosePending);
        }
        for (PreparedStatementSapDB preparedStatement : preparedStatements) {
            preparedStatement._close(true, false);
        }
        object = this._resultSetsClosePending;
        synchronized (object) {
            resultSets = new HashSet<ResultSetSapDB>(this._resultSetsClosePending);
        }
        for (ResultSetSapDB resultSet : resultSets) {
            resultSet._close(true, false);
        }
    }

    protected synchronized void _prefetchSend(Session session, ResultSetSapDB resultSet, CursorID cursorID, int fetchSize) throws SQLException {
        HRequestPacket requestPacket = this.initFetchNext(session, cursorID, fetchSize);
        this.send(session, requestPacket, resultSet.getStatementSapDB(), new ExchangeFlag[0]);
        this._outstandingPrefetchResultSet = resultSet;
        this._outstandingPrefetchSession = session;
    }

    protected synchronized HReplyPacket _prefetchReceive(ResultSetSapDB resultSet) throws SQLException {
        HReplyPacket replyPacket;
        Object cachedPrefetchObject = this._prefetchedCachedReplyMap.remove(resultSet);
        if (cachedPrefetchObject == null) {
            replyPacket = this._receiveOutstandingPrefetch(this._outstandingPrefetchSession, resultSet);
        } else if (cachedPrefetchObject instanceof HReplyPacket) {
            replyPacket = (HReplyPacket)cachedPrefetchObject;
        } else {
            if (cachedPrefetchObject instanceof SQLException) {
                throw (SQLException)cachedPrefetchObject;
            }
            throw new AssertionError((Object)("Unexpected cached prefetch object type:" + cachedPrefetchObject.getClass().getName()));
        }
        return replyPacket;
    }

    protected synchronized void _prefetchDiscard(ResultSetSapDB resultSet) throws SQLException {
        Object cachedPrefetchObject = this._prefetchedCachedReplyMap.remove(resultSet);
        if (cachedPrefetchObject == null && this._outstandingPrefetchResultSet == resultSet) {
            this._receiveOutstandingPrefetch(this._outstandingPrefetchSession, resultSet);
        }
    }

    protected synchronized ParseInfo _cacheOnPrepareGetCached(String sql) {
        if (this._statementCache == null) {
            return null;
        }
        return this._statementCache.onPrepareGetCached(sql);
    }

    protected synchronized void _cacheOnPrepareSetTracked(ParseInfo parseInfo) throws SQLException {
        if (this._statementCache == null) {
            return;
        }
        this._statementCache.onPrepareSetTracked(parseInfo);
    }

    protected synchronized void _cacheOnSetPoolable(ParseInfo parseInfo, boolean oldValue, boolean newValue) throws SQLException {
        if (this._statementCache == null) {
            return;
        }
        this._statementCache.onSetPoolable(parseInfo, oldValue, newValue);
    }

    protected synchronized void _cacheOnExecute() throws SQLException {
        if (this._statementCache == null) {
            return;
        }
        this._statementCache.onExecute();
    }

    protected synchronized boolean _cacheOnDrop(ParseInfo parseInfo, boolean isPoolable) throws SQLException {
        if (this._statementCache == null) {
            return false;
        }
        return this._statementCache.onDrop(parseInfo, isPoolable);
    }

    protected synchronized void _cacheOnSchemaChange() throws SQLException {
        if (this._statementCache == null) {
            return;
        }
        this._statementCache.onSchemaChange();
    }

    protected synchronized void _cacheOnInternalReconnect() throws SQLException {
        if (this._statementCache == null) {
            return;
        }
        this._statementCache.onInternalReconnect();
    }

    protected synchronized void _cacheOnCloseStatements(boolean sendRequests) throws SQLException {
        if (this._statementCache == null) {
            return;
        }
        this._statementCache.onCloseStatements(sendRequests);
    }

    protected synchronized void _createColumnEncryptionKey(String ckpId, String ckpName, String cekId, String cekName, String schemaName, String algorithmName, boolean isEmptyKeyCase) throws SQLException {
        String sql;
        this._assertOpen();
        Key cek = AesCbc.generateKey(256, algorithmName);
        Key publicKey = this._retrieveClientPublicKey(ckpId);
        byte[] encryptedKey = RsaOaep.encrypt(publicKey, cek.getEncoded());
        String encodedEncryptedKey = Base64Utils.encodeToString(encryptedKey);
        if (isEmptyKeyCase) {
            KeyCache.addColumnEncryptionKey(cekId, new ColumnEncryptionKey(cek, this._engineFeatures.getDatabaseName(), cekName, cekId, algorithmName));
            sql = "ALTER CLIENTSIDE ENCRYPTION COLUMN KEY \"" + schemaName + "\".\"" + cekName + "\" ENCRYPTED WITH KEYPAIR \"" + ckpName + "\" ENCRYPTED COLUMN KEYVALUE '" + encodedEncryptedKey + "'";
        } else {
            UUID uuid = UUID.randomUUID();
            KeyCache.addColumnEncryptionKey(uuid.toString(), new ColumnEncryptionKey(cek, this._engineFeatures.getDatabaseName(), cekName, uuid.toString(), algorithmName));
            sql = "CREATE CLIENTSIDE ENCRYPTION COLUMN KEY \"" + schemaName + "\".\"" + cekName + "\" ALGORITHM '" + algorithmName + "' ENCRYPTED WITH KEYPAIR \"" + ckpName + "\" ENCRYPTED COLUMN KEYVALUE '" + encodedEncryptedKey + "' COLUMN KEY ID '" + UUIDUtils.toHexString(uuid) + "'";
        }
        this._executeInternalStatement(sql);
    }

    protected synchronized void _dropColumnEncryptionKey(String cekId) {
        KeyCache.deleteCachedColumnEncryptionKey(cekId, this._connectionProperties.getProperty(ConnectionProperty.CSE_KEY_STORE_PASSWD));
    }

    protected synchronized void _grantAccessColumnEncryptionKey(String ckpName, String cekId, String cekName, String schemaName, Key publicKey) throws SQLException {
        this._assertOpen();
        ColumnEncryptionKey cek = this.retrieveColumnEncryptionKey(cekId);
        byte[] encryptedKey = RsaOaep.encrypt(publicKey, cek.getKey().getEncoded());
        String encodedEncryptedKey = Base64Utils.encodeToString(encryptedKey);
        this._executeInternalStatement("ALTER CLIENTSIDE ENCRYPTION COLUMN KEY \"" + schemaName + "\".\"" + cekName + "\" ADD KEYCOPY ENCRYPTED WITH KEYPAIR \"" + ckpName + "\" ENCRYPTED COLUMN KEYVALUE '" + encodedEncryptedKey + "'");
    }

    protected synchronized void _createClientKeyPair(String ckpName, String algorithmName) throws SQLException {
        UUID uuid = UUID.randomUUID();
        RsaOaep rsaKeys = new RsaOaep(2048, algorithmName);
        this._storeClientKeyPair(ckpName, algorithmName, uuid, rsaKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _transformColumn(String schemaName, String tableName, String columnName, String hiddenColumnName, String secondHiddenColumn, List<String> primaryKey, ColumnEncryptionKey cek, boolean deterministic, boolean encrypt, StatementSapDB stmtObject) throws SQLException {
        boolean preAutoCommit = this._transaction.getAutoCommit();
        boolean preDDLAutoCommit = this._isDDLCommitted;
        int preIsolationLevel = this._isolationLevel;
        StatementSapDB selectPs = null;
        StatementSapDB updatePs = null;
        StatementSapDB is = null;
        ResultSetSapDB irs = null;
        try {
            this._alterTableStatement.set(stmtObject);
            if (preAutoCommit) {
                this._setAutoCommit(false);
            } else {
                this._commit();
            }
            this._setTransactionIsolation(4, true);
            if (preDDLAutoCommit) {
                this._setDDLAutoCommit(false);
            }
            StringBuilder selectSql = new StringBuilder();
            selectSql.append("SELECT TOP ");
            selectSql.append(this._connectionProperties.getIntProperty(ConnectionProperty.COLUMN_TRANSFORMATION_BATCH_SIZE));
            selectSql.append(" \"");
            selectSql.append(columnName);
            selectSql.append("\" ");
            for (String aPrimaryKey : primaryKey) {
                selectSql.append(" , ");
                selectSql.append("\"");
                selectSql.append(aPrimaryKey);
                selectSql.append("\"");
            }
            selectSql.append(" FROM \"");
            selectSql.append(schemaName);
            selectSql.append("\".\"");
            selectSql.append(tableName);
            selectSql.append("\" WHERE \"");
            selectSql.append(secondHiddenColumn);
            selectSql.append("\" IS NULL OR \"");
            selectSql.append(secondHiddenColumn);
            selectSql.append("\" = FALSE ");
            StringBuilder updateSql = new StringBuilder();
            updateSql.append("UPDATE \"");
            updateSql.append(schemaName);
            updateSql.append("\".\"");
            updateSql.append(tableName);
            updateSql.append("\" SET \"");
            updateSql.append(hiddenColumnName);
            updateSql.append("\" = ? ");
            updateSql.append(" , \"");
            updateSql.append(secondHiddenColumn);
            updateSql.append("\" = TRUE ");
            updateSql.append(" WHERE ");
            for (int i = 0; i < primaryKey.size(); ++i) {
                updateSql.append(" \"");
                updateSql.append(primaryKey.get(i));
                updateSql.append("\" ");
                updateSql.append(" = ? ");
                if (i == primaryKey.size() - 1) continue;
                updateSql.append(" AND ");
            }
            if (stmtObject._wasCancelled.get()) {
                throw SQLExceptionSapDB.newInstance("error.statement.cancelled", new String[0]);
            }
            selectPs = InternalCallableStatementSapDB.newInstance(this, selectSql.toString(), false, true);
            updatePs = InternalCallableStatementSapDB.newInstance(this, updateSql.toString(), false, true);
            is = InternalStatementSapDB.newInstance(this, false, true);
            int MAX_RETRY_COUNT = 10;
            int INITIAL_WAIT_TIME = 10;
            int failCount = 0;
            int waitTime = 10;
            boolean failed = false;
            boolean lockAcquired = false;
            while (true) {
                if (failed) {
                    ++failCount;
                    waitTime *= 2;
                } else {
                    failCount = 0;
                    waitTime = 10;
                }
                if (failCount == 10) {
                    throw SQLExceptionSapDB.newInstance("error.column.transformation.failed", " too many serialization errors from the server");
                }
                irs = (InternalResultSetSapDB)((PreparedStatementSapDB)selectPs)._executeQuery();
                if (stmtObject._wasCancelled.get()) {
                    throw SQLExceptionSapDB.newInstance("error.statement.cancelled", new String[0]);
                }
                if (irs == null || !irs._isBeforeFirst()) {
                    if (!lockAcquired) {
                        this._setTransactionIsolation(2, true);
                        is._executeUpdate("LOCK TABLE \"" + schemaName + "\".\"" + tableName + "\" IN EXCLUSIVE MODE");
                        lockAcquired = true;
                    }
                    if ((irs = (InternalResultSetSapDB)((PreparedStatementSapDB)selectPs)._executeQuery()) == null || !irs._isBeforeFirst()) {
                        is._executeUpdate("ALTER TABLE \"" + schemaName + "\".\"" + tableName + "\" FINISH CLIENTSIDE ENCRYPTION ");
                        break;
                    }
                }
                while (irs.next()) {
                    ((PreparedStatementSapDB)updatePs)._setObject(1, irs.getObject(1));
                    for (int i = 0; i < primaryKey.size(); ++i) {
                        ((PreparedStatementSapDB)updatePs)._setObject(i + 2, irs.getObject(i + 2));
                    }
                    ((PreparedStatementSapDB)updatePs)._addBatch();
                }
                if (stmtObject._wasCancelled.get()) {
                    throw SQLExceptionSapDB.newInstance("error.statement.cancelled", new String[0]);
                }
                try {
                    ((PreparedStatementSapDB)updatePs)._executeBatch();
                    failed = false;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 138) {
                        failed = true;
                        try {
                            Thread.sleep(waitTime);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    throw e;
                }
                if (lockAcquired) continue;
                this._commit();
            }
        }
        finally {
            this._alterTableStatement.set(null);
            this._commit();
            if (preAutoCommit) {
                this._setAutoCommit(preAutoCommit);
            }
            this._setTransactionIsolation(preIsolationLevel, true);
            if (preDDLAutoCommit) {
                this._setDDLAutoCommit(true);
            }
            if (irs != null) {
                try {
                    irs._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
            if (is != null) {
                try {
                    is._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
            if (selectPs != null) {
                try {
                    selectPs._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
            if (updatePs != null) {
                try {
                    updatePs._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected void _dropClientKeyPair(String ckpId) throws SQLException {
        KeyCache.deleteClientKeyPair(ckpId, this._connectionProperties.getProperty(ConnectionProperty.CSE_KEY_STORE_PASSWD));
    }

    private void _init() {
        this._sessionPool.releaseAll(this);
        this._statementContext = null;
        this._outstandingPrefetchResultSet = null;
        this._outstandingPrefetchSession = null;
        this._prefetchedCachedReplyMap.clear();
    }

    private static List<? extends Address> _buildAddressesList(List<PreferredAddress> preferredAddresses, boolean isConnectionDistributionEnabled, SiteType requestedSiteType) {
        ArrayList mergedAddresses = new ArrayList();
        ArrayList<PublicAddress> bestPublic = null;
        ArrayList<PreferredAddress> bestPreferred = null;
        ArrayList<PublicAddress> standbyPublic = null;
        ArrayList<PreferredAddress> unreachablePreferred = null;
        ArrayList<PublicAddress> unreachablePublic = null;
        ArrayList<PublicAddress> wrongSiteTypePublic = null;
        ArrayList<PublicAddress> tempList = null;
        Topologies.TopologyInfo foundTopologyInfo = null;
        for (PreferredAddress preferredAddress : preferredAddresses) {
            Topologies.TopologyInfo topologyInfo;
            if (Topologies.isUnreachable(preferredAddress)) {
                if (unreachablePreferred == null) {
                    unreachablePreferred = new ArrayList<PreferredAddress>();
                }
                unreachablePreferred.add(preferredAddress);
            } else {
                if (bestPreferred == null) {
                    bestPreferred = new ArrayList<PreferredAddress>();
                }
                bestPreferred.add(preferredAddress);
            }
            if (!isConnectionDistributionEnabled || (topologyInfo = Topologies.getTopologyInfo(preferredAddress)) == null) continue;
            if (foundTopologyInfo == null) {
                foundTopologyInfo = topologyInfo;
                continue;
            }
            if (!SystemInfo.areDifferentSystems(topologyInfo.getSystemInfo(), foundTopologyInfo.getSystemInfo())) continue;
            Topologies.clear();
            return preferredAddresses;
        }
        if (isConnectionDistributionEnabled && foundTopologyInfo != null) {
            int size;
            SiteType siteType = requestedSiteType != SiteType.NONE ? requestedSiteType : foundTopologyInfo.getSiteType();
            for (PublicAddress publicAddress : foundTopologyInfo.getSystemInfo().getAddresses()) {
                if (!publicAddress.isIndexServer() && !publicAddress.isNameServer()) continue;
                if (siteType != SiteType.NONE && !publicAddress.getSiteType().equals(siteType)) {
                    if (wrongSiteTypePublic == null) {
                        wrongSiteTypePublic = new ArrayList<PublicAddress>();
                    }
                    wrongSiteTypePublic.add(publicAddress);
                    continue;
                }
                if (Topologies.isUnreachable(publicAddress)) {
                    if (unreachablePublic == null) {
                        unreachablePublic = new ArrayList<PublicAddress>();
                    }
                    unreachablePublic.add(publicAddress);
                    continue;
                }
                if (publicAddress.isStandby()) {
                    if (standbyPublic == null) {
                        standbyPublic = new ArrayList<PublicAddress>();
                    }
                    standbyPublic.add(publicAddress);
                    continue;
                }
                if (tempList == null) {
                    tempList = new ArrayList<PublicAddress>();
                }
                tempList.add(publicAddress);
            }
            if (tempList != null && (size = tempList.size()) > 0) {
                if (size > 1) {
                    Collections.rotate(tempList, -foundTopologyInfo.getNextAddressCounter() % size);
                }
                if (bestPublic == null) {
                    bestPublic = new ArrayList<PublicAddress>();
                }
                bestPublic.addAll(tempList);
            }
        }
        if (bestPublic != null) {
            mergedAddresses.addAll(bestPublic);
        }
        if (bestPreferred != null) {
            mergedAddresses.addAll(bestPreferred);
        }
        if (standbyPublic != null) {
            mergedAddresses.addAll(standbyPublic);
        }
        if (unreachablePreferred != null) {
            mergedAddresses.addAll(unreachablePreferred);
        }
        if (unreachablePublic != null) {
            mergedAddresses.addAll(unreachablePublic);
        }
        if (wrongSiteTypePublic != null) {
            mergedAddresses.addAll(wrongSiteTypePublic);
        }
        return mergedAddresses;
    }

    private static String _getSessionVariableName(Object key) {
        String keyString;
        String string = keyString = key instanceof String ? (String)key : key.toString();
        if (!keyString.regionMatches(true, 0, "sessionVariable:", 0, ConnectionProperty.SESSION_VARIABLE_PREFIX_LEN)) {
            return null;
        }
        String sessionVariableName = keyString.substring(ConnectionProperty.SESSION_VARIABLE_PREFIX_LEN);
        if (sessionVariableName.isEmpty()) {
            return null;
        }
        return sessionVariableName;
    }

    private static String _getSessionVariableValue(Object value) {
        String sessionVariableValue;
        String string = sessionVariableValue = value instanceof String ? (String)value : value.toString();
        if (sessionVariableValue.isEmpty()) {
            return null;
        }
        return sessionVariableValue;
    }

    private void _setLastExecutedSession(Session session) {
        this._sessionPool.setLastExecutedSession(session);
    }

    private void _refreshMetaData() {
        this._databaseMetaData._getDBInfo();
    }

    private HReplyPacket _receiveOutstandingPrefetch(Session session, ResultSetSapDB resultSet) throws SQLException {
        this._outstandingPrefetchResultSet = null;
        this._outstandingPrefetchSession = null;
        HReplyPacket replyPacket = this.receive(session, resultSet.getStatementSapDB(), new ExchangeFlag[0]);
        return replyPacket;
    }

    private static int _getJdbcIsolationLevelForConnectionPropertyValue(String value) {
        int jdbcIsolationLevel;
        block7: {
            if (value == null || value.isEmpty()) {
                return 2;
            }
            jdbcIsolationLevel = -1;
            try {
                jdbcIsolationLevel = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                if (value.equalsIgnoreCase("TRANSACTION_READ_UNCOMMITTED")) {
                    jdbcIsolationLevel = 1;
                }
                if (value.equalsIgnoreCase("TRANSACTION_READ_COMMITTED")) {
                    jdbcIsolationLevel = 2;
                }
                if (value.equalsIgnoreCase("TRANSACTION_REPEATABLE_READ")) {
                    jdbcIsolationLevel = 4;
                }
                if (!value.equalsIgnoreCase("TRANSACTION_SERIALIZABLE")) break block7;
                jdbcIsolationLevel = 8;
            }
        }
        if (jdbcIsolationLevel >= 1 && jdbcIsolationLevel <= 8) {
            return jdbcIsolationLevel;
        }
        return 1;
    }

    private HRequestPacket _getRequestPacket(Session session) {
        HRequestPacket requestPacket = this._packetPool.isEmpty() ? session.newRequestPacket() : this._packetPool.pop();
        return requestPacket;
    }

    private void _freeRequestPacket(HRequestPacket requestPacket) {
        this._packetPool.push(requestPacket);
    }

    private void _setAutoCommit(boolean autoCommit) throws SQLException {
        this._assertOpen();
        if (autoCommit && !this._transaction.getAutoCommit()) {
            this._commitInternal();
        }
        this._transaction.setAutoCommit(autoCommit);
    }

    private void _setReadOnly(boolean isReadOnly) throws SQLException {
        this._assertOpen();
        this._executeInternalStatement("SET TRANSACTION " + (isReadOnly ? "READ ONLY" : "READ WRITE"));
        this._isReadOnly = isReadOnly;
    }

    private void _setTransactionIsolation(int isolationLevel, boolean onAllSessions) throws SQLException {
        this._assertOpen();
        this._executeInternalStatement("SET TRANSACTION ISOLATION LEVEL " + ConnectionSapDB.getSQLForJdbcIsolationLevel(isolationLevel), onAllSessions);
    }

    private void _setCurrentSchema(String schema) throws SQLException {
        this._assertOpen();
        boolean isDoubleQuoted = schema != null && schema.startsWith("\"") && schema.endsWith("\"");
        String schemaArgument = this.getBooleanConnectionProperty(ConnectionProperty.QUOTE_CURRENT_SCHEMA) && !isDoubleQuoted ? "\"" + schema.replaceAll("\"", "\"\"") + "\"" : schema;
        this._executeInternalStatement("SET SCHEMA " + schemaArgument);
    }

    private void _setDDLAutoCommit(boolean ddlAutoCommit) throws SQLException {
        this._assertOpen();
        if (ddlAutoCommit) {
            this._executeInternalStatement("SET TRANSACTION AUTOCOMMIT DDL ON", true);
            this._isDDLCommitted = true;
        } else {
            this._executeInternalStatement("SET TRANSACTION AUTOCOMMIT DDL OFF", true);
            this._isDDLCommitted = false;
        }
    }

    private DatabaseMetaData _getMetaData() throws SQLException {
        this._assertOpen();
        return this._databaseMetaData;
    }

    private void _addWarning(SQLWarning warning) {
        if (this._warnings == null) {
            this._warnings = warning;
        } else {
            this._warnings.setNextWarning(warning);
        }
    }

    private Statement _createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this._assertOpen();
        return HanaStatement.newInstance(this._tracer, this, resultSetType, resultSetConcurrency, resultSetHoldability, false, false);
    }

    private void _commit() throws SQLException {
        this._assertOpen();
        if (this.isAutoCommit()) {
            throw SQLExceptionSapDB.newInstance("error.connection.autocommit", new String[0]);
        }
        this._commitInternal();
    }

    private void _rollback() throws SQLException {
        this._assertOpen();
        if (this.isAutoCommit()) {
            throw SQLExceptionSapDB.newInstance("error.connection.autocommit", new String[0]);
        }
        this._rollbackInternal();
    }

    private boolean _isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue", String.valueOf(timeout));
        }
        if (this._isClosed()) {
            return false;
        }
        try {
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this.initExecuteDirect(session, 2, timeout, "SELECT 'PING' FROM SYS.DUMMY", null, -1, false);
            this.exchange(session, requestPacket, null, ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
        }
        catch (InternalReconnectException e) {
            Session session = e.getNewSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
            }
            this.handleTransaction(session, false);
            return this._isValid(timeout);
        }
        catch (SQLException exc) {
            this._close();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _send(Session session, HRequestPacket requestPacket, ExchangeFlag ... exchangeFlags) throws SQLException {
        block10: {
            if (this._outstandingPrefetchResultSet != null) {
                ResultSetSapDB outstandingPrefetchResultSet = this._outstandingPrefetchResultSet;
                try {
                    HReplyPacket replyPacket = this._receiveOutstandingPrefetch(this._outstandingPrefetchSession, outstandingPrefetchResultSet);
                    this._prefetchedCachedReplyMap.put(outstandingPrefetchResultSet, replyPacket);
                }
                catch (SQLException e) {
                    this._prefetchedCachedReplyMap.put(outstandingPrefetchResultSet, e);
                    if (!e.getSQLState().equals("HY000") || e.getErrorCode() != 139) break block10;
                    throw e;
                }
            }
        }
        EnumSet<ExchangeFlag> flags = exchangeFlags.length > 0 ? EnumSet.copyOf(Arrays.asList(exchangeFlags)) : EnumSet.noneOf(ExchangeFlag.class);
        boolean allowReconnectOrFallback = flags.contains((Object)ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
        try {
            this._tracer.checkTraceSettings();
            requestPacket.setStatementContextAndProfileTimes(this._statementContext, session.getSendTime(), session.getReceiveTime());
            this._sentBytes.getAndAdd(requestPacket.getLength());
            session.send(requestPacket, this._engineFeatures);
        }
        catch (RTEException e) {
            this._handleSendReceiveException(e, session, allowReconnectOrFallback, false);
        }
        finally {
            if (flags.contains((Object)ExchangeFlag.IS_PREPARED_EXECUTE)) {
                this._setLastExecutedSession(session);
            }
            if (requestPacket != null) {
                this._freeRequestPacket(requestPacket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HReplyPacket _receive(Session session, ExchangeFlag ... exchangeFlags) throws SQLException {
        if (this._outstandingPrefetchResultSet != null) {
            throw SQLExceptionSapDB.newInstance("error.resultset.invalidprefetch", new String[0]);
        }
        EnumSet<ExchangeFlag> flags = exchangeFlags.length > 0 ? EnumSet.copyOf(Arrays.asList(exchangeFlags)) : EnumSet.noneOf(ExchangeFlag.class);
        boolean isStatement = flags.contains((Object)ExchangeFlag.IS_STATEMENT);
        boolean isParse = flags.contains((Object)ExchangeFlag.IS_PARSE);
        boolean ignoreErrors = flags.contains((Object)ExchangeFlag.IGNORE_ERRORS);
        boolean allowReconnectOrFallback = flags.contains((Object)ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
        HReplyPacket replyPacket = null;
        SQLException sqlExceptionChain = null;
        HOptionsPart transFlags = null;
        HOptionsPart scpart = null;
        HMultiLineOptionsPart topoPart = null;
        HOptionsPart connectOptionsPart = null;
        boolean fallBack = false;
        try {
            this._tracer.checkTraceSettings();
            replyPacket = session.receive(this._engineFeatures);
            this._receivedBytes.getAndAdd(replyPacket.getLength());
            FunctionCode functionCode = replyPacket.getFunctionCode(0);
            for (HPartInfo partInfo : replyPacket.parts(0)) {
                switch (partInfo.getPartKind()) {
                    case Error: {
                        sqlExceptionChain = partInfo.getSQLExceptionChain();
                        break;
                    }
                    case TransactionFlags: {
                        transFlags = partInfo.getOptionsPart();
                        break;
                    }
                    case StatementContext: {
                        scpart = partInfo.getOptionsPart();
                        break;
                    }
                    case TopologyInformation: {
                        if (this._isIgnoringTopology) break;
                        topoPart = partInfo.getMultiLineOptionsPart();
                        break;
                    }
                    case ConnectOptions: {
                        connectOptionsPart = partInfo.getOptionsPart();
                        break;
                    }
                    case SessionVariable: {
                        if (!this._doCacheSessionVariables()) break;
                        this._cacheSessionVariables(partInfo.getSessionVariables());
                    }
                }
            }
            if (connectOptionsPart != null) {
                this._engineFeatures = new EngineFeatures(connectOptionsPart);
                String databaseName = this._connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME);
                if ((databaseName == null || databaseName.isEmpty()) && !this._engineFeatures.getDatabaseName().isEmpty()) {
                    this._connectionProperties.setProperty(ConnectionProperty.DATABASE_NAME, this._engineFeatures.getDatabaseName());
                }
                if (!this._isIgnoringTopology) {
                    this._distributionMode = this._engineFeatures.getDistributionMode();
                }
                if (this._sessionPool.getAnchorSession() == null && this._engineFeatures.getClientSideEncryptionVersion().getValue() >= ClientSideEncryptionVersion.Level1.getValue() && ConnectionSapDB._isServerAffectedByBug163474(this._engineFeatures.getServerVersionString())) {
                    this._connectionProperties.setProperty(ConnectionProperty.CLIENT_SIDE_ENCRYPTION_VERSION, String.valueOf(ClientSideEncryptionVersion.Unsupported.getValue()));
                    if (this._tracer.on()) {
                        this._tracer.printConnectionMessage(this, "Reconnecting with client-side encryption disabled", new String[0]);
                    }
                    throw new InternalConnectException(InternalConnectException.Reason.CSE_BUG_163474);
                }
            }
            if (topoPart != null) {
                this._processTopologyPart(session, topoPart, connectOptionsPart != null);
            }
            if (scpart != null) {
                block34: do {
                    switch (StatementContextOption.decode(scpart.getOptionName())) {
                        case StatementSequenceInfo: {
                            this._statementContext = scpart.getOptionBinaryValue(this._statementContext);
                            break;
                        }
                        case SchemaName: {
                            this._currentSchema = scpart.getOptionStringValue();
                            if (this._doCacheSessionVariables()) {
                                this._cacheSessionVariables(Collections.singletonMap("_SYS_DEFAULT_SCHEMA", this._currentSchema));
                            }
                            this._cacheOnSchemaChange();
                            break;
                        }
                        case FlagSet: {
                            if ((scpart.getOptionTinyIntValue() & StatementContextFlag.ActiveActive_FallbackRouting.getValue()) == 0 || !session.isHintRouted()) continue block34;
                            fallBack = true;
                        }
                    }
                } while (scpart.nextOption());
            }
            boolean doClearTransaction = false;
            boolean doCloseCursorsAtCommit = false;
            boolean doClosePendingPreparedStatementsAndResultSets = false;
            boolean doIncrementRollbackCount = false;
            TransactionState newTransactionState = null;
            boolean doAddSessionToTransaction = false;
            boolean doRefreshMetaData = false;
            if (transFlags != null) {
                boolean commit = false;
                boolean rollback = false;
                boolean writeTrans = false;
                boolean noWriteTrans = false;
                do {
                    switch (TransactionFlag.decode(transFlags.getOptionName())) {
                        case Committed: {
                            if (!transFlags.getOptionBooleanValue()) break;
                            commit = true;
                            break;
                        }
                        case RolledBack: {
                            if (!transFlags.getOptionBooleanValue()) break;
                            rollback = true;
                            break;
                        }
                        case NewIsolationLevel: {
                            int hanaIsolationLevel = transFlags.getOptionIntValue();
                            this._isolationLevel = ConnectionSapDB.getJdbcIsolationLevelForHanaIsolationLevel(hanaIsolationLevel);
                            break;
                        }
                        case DDLCommitModeChanged: {
                            this._isDDLCommitted = transFlags.getOptionBooleanValue();
                            break;
                        }
                        case WriteTransactionStarted: {
                            if (!transFlags.getOptionBooleanValue()) break;
                            writeTrans = true;
                            break;
                        }
                        case NoWriteTransactionStarted: {
                            if (!transFlags.getOptionBooleanValue()) break;
                            noWriteTrans = true;
                            break;
                        }
                        case SessionClosingTransactionError: {
                            this._close();
                            break;
                        }
                        case ReadOnlyMode: {
                            this._isReadOnly = transFlags.getOptionBooleanValue();
                        }
                    }
                } while (transFlags.nextOption());
                if (commit) {
                    doClearTransaction = true;
                    doCloseCursorsAtCommit = true;
                    doClosePendingPreparedStatementsAndResultSets = true;
                } else if (rollback) {
                    doClearTransaction = true;
                    doIncrementRollbackCount = true;
                    doClosePendingPreparedStatementsAndResultSets = true;
                }
                if (writeTrans) {
                    newTransactionState = TransactionState.WriteTransaction;
                } else if (noWriteTrans) {
                    newTransactionState = TransactionState.ReadTransaction;
                }
                if ((commit || rollback) && (writeTrans || noWriteTrans)) {
                    doAddSessionToTransaction = true;
                }
            } else if (!(this.isAutoCommit() || isParse || this._transaction.isWriteTransaction())) {
                newTransactionState = this._transaction.getNewTransactionState(session, functionCode);
            }
            if (!isParse) {
                switch (functionCode) {
                    case Connect: {
                        this._sessionPool.releaseAllHintRouted(this);
                        if (this._isDDLCommitted) {
                            doClearTransaction = true;
                            doCloseCursorsAtCommit = true;
                            doClosePendingPreparedStatementsAndResultSets = true;
                        }
                        doRefreshMetaData = true;
                        break;
                    }
                    case Commit: {
                        if (this._tracer.on()) {
                            this._tracer.printDistributionState(this, "Commit Tx " + this._transaction.getDisplayTransactionID());
                        }
                        doClearTransaction = true;
                        doCloseCursorsAtCommit = true;
                        doClosePendingPreparedStatementsAndResultSets = true;
                        break;
                    }
                    case Rollback: {
                        if (this._tracer.on()) {
                            this._tracer.printDistributionState(this, "Rollback Tx " + this._transaction.getDisplayTransactionID());
                        }
                        doClearTransaction = true;
                        doClosePendingPreparedStatementsAndResultSets = true;
                        doIncrementRollbackCount = true;
                    }
                }
            }
            if (isStatement && this.isAutoCommit()) {
                doClearTransaction = true;
                doCloseCursorsAtCommit = true;
                doClosePendingPreparedStatementsAndResultSets = true;
            }
            if (doClearTransaction) {
                this.clearTransaction(false);
            }
            if (doCloseCursorsAtCommit) {
                this._closeCursorsAtCommit();
            }
            if (doClosePendingPreparedStatementsAndResultSets) {
                this._closePendingPreparedStatementsAndResultSets();
            }
            if (doIncrementRollbackCount) {
                ++this._rollbackCount;
            }
            if (newTransactionState != null) {
                this._transaction.setTransactionState(session, newTransactionState);
            }
            if (doAddSessionToTransaction) {
                this._transaction.addSessionToTransaction(session);
            }
            if (doRefreshMetaData) {
                this._refreshMetaData();
            }
        }
        catch (RTEException e) {
            this._handleSendReceiveException(e, session, allowReconnectOrFallback, true);
        }
        finally {
            if (sqlExceptionChain != null) {
                if (sqlExceptionChain instanceof SQLWarning) {
                    this._addWarning((SQLWarning)sqlExceptionChain);
                } else {
                    if (this._transaction.getAutoCommit()) {
                        ++this._rollbackCount;
                    }
                    if (!ignoreErrors) {
                        throw sqlExceptionChain;
                    }
                }
            }
        }
        if (fallBack) {
            throw new InternalFallbackHintRoutedException("FallbackFlag");
        }
        return replyPacket;
    }

    private static boolean _isServerAffectedByBug163474(String serverVersion) {
        return serverVersion.startsWith("2.00.01") || serverVersion.startsWith("2.00.02");
    }

    private void _processTopologyPart(Session session, HMultiLineOptionsPart topologyPart, boolean isConnectReply) throws SQLException {
        DistributionMode clientDistributionMode;
        PublicAddress publicAddress;
        Address sessionAddress = session.getAddress();
        boolean isPublicAddress = sessionAddress instanceof PublicAddress;
        PublicAddress ownAddress = SystemInfo.getOwnAddress(topologyPart);
        boolean isAnchorConnectReply = isConnectReply && this._sessionPool.getAnchorSession() == null;
        String sidAndDatabaseName = this._getSidAndDatabaseName();
        boolean staleTopologyAssumed = false;
        if (isPublicAddress) {
            publicAddress = (PublicAddress)sessionAddress;
            if (isConnectReply) {
                Session anchorSession;
                if (!publicAddress.getSystemInfo().getSidAndDatabaseName().equals(sidAndDatabaseName)) {
                    if (this._tracer.on()) {
                        this._tracer.printSessionMessage(session, "SID+DatabaseName mismatch: Assuming stale topology", "Cached:   " + publicAddress.getSystemInfo().getSidAndDatabaseName(), "Received: " + sidAndDatabaseName);
                    }
                    staleTopologyAssumed = true;
                }
                if (!publicAddress.getSiteType().equals(ownAddress.getSiteType())) {
                    if (this._tracer.on()) {
                        this._tracer.printSessionMessage(session, "SiteType mismatch: Assuming stale topology and releasing all hint-routed sessions", "Cached:   " + publicAddress.getSiteType(), "Received: " + ownAddress.getSiteType());
                    }
                    staleTopologyAssumed = true;
                    this._sessionPool.releaseAllHintRouted(this);
                }
                if (publicAddress.getSiteVolumeID().getVolumeID() != ownAddress.getSiteVolumeID().getVolumeID()) {
                    if (this._tracer.on()) {
                        this._tracer.printSessionMessage(session, "VolumeID mismatch: Assuming stale topology", "Cached:   " + publicAddress.getSiteVolumeID().getVolumeID(), "Received: " + ownAddress.getSiteVolumeID().getVolumeID());
                    }
                    staleTopologyAssumed = true;
                }
                if (!isAnchorConnectReply && (anchorSession = this._sessionPool.getAnchorSession()) != null) {
                    if (anchorSession.isNoneOrPrimarySite() && session.isSecondarySite()) {
                        session.setHintRouted(true);
                    } else if (anchorSession.isSecondarySite() && session.isNoneOrPrimarySite()) {
                        if (this._tracer.on()) {
                            this._tracer.printSessionMessage(session, "Invalid routing: Assuming stale topology", "Anchor:    " + anchorSession.getTraceString(true, true), "Secondary: " + session.getTraceString(true, true));
                        }
                        staleTopologyAssumed = true;
                    }
                }
                if (staleTopologyAssumed) {
                    Topologies.clear();
                    throw new InternalConnectException(InternalConnectException.Reason.STALE_TOPOLOGY_ASSUMED);
                }
            }
            if (publicAddress.getSiteVolumeID().getSiteID() != ownAddress.getSiteVolumeID().getSiteID()) {
                if (this._tracer.on()) {
                    this._tracer.printSessionMessage(session, "Site ID mismatch: Releasing all hint-routed sessions", "Cached:   " + publicAddress.getSiteVolumeID().getSiteID(), "Received: " + ownAddress.getSiteVolumeID().getSiteID());
                }
                this._sessionPool.releaseAllHintRouted(this);
            }
        }
        if (this.getBooleanConnectionProperty(ConnectionProperty._TEST_SIMULATE_PORT_FORWARDING) || ownAddress.getPort() != sessionAddress.getPort()) {
            String siteType;
            if (this._tracer.on()) {
                this._tracer.printSessionMessage(session, "Port-forwarding detected: Ignoring topology", "Cached:   " + sessionAddress.getPort(), "Received: " + ownAddress.getPort());
            }
            if ((siteType = this._connectionProperties.getProperty(ConnectionProperty.SITE_TYPE).trim()).equalsIgnoreCase("PRIMARY") || siteType.equalsIgnoreCase("SECONDARY")) {
                throw SQLExceptionSapDB.newInstance("error.connection.invalidproperties", "siteType", "port-forwarding");
            }
            this._isIgnoringTopology = true;
            this._distributionMode = DistributionMode.Off;
            return;
        }
        PublicAddress[] outOwnAddress = new PublicAddress[1];
        SystemInfo systemInfo = new SystemInfo(sidAndDatabaseName, topologyPart, outOwnAddress);
        ownAddress = outOwnAddress[0];
        this._sessionPool.setSystemInfo(systemInfo);
        if (isAnchorConnectReply && (clientDistributionMode = DistributionMode.decode(this._connectionProperties.getProperty(ConnectionProperty.DISTRIBUTION))).isConnectionDistribution() && !this._engineFeatures.getDistributionMode().isConnectionDistribution() && systemInfo.getPerSiteIndexServerCount() > 1) {
            this._connectionProperties.setProperty(ConnectionProperty.DISTRIBUTION, DistributionMode.withoutConnectionDistribution(clientDistributionMode).name());
            if (this._tracer.on()) {
                this._tracer.printConnectionMessage(this, "Reconnecting with connection distribution disabled", new String[0]);
            }
            throw new InternalConnectException(InternalConnectException.Reason.CONNECTION_DISTRIBUTION_DISABLED);
        }
        this._sessionPool._setSessionPublicAddress(session, ownAddress);
        for (Map.Entry<SiteTypeVolumeID, Session> entry : this._sessionPool.getSessions().entrySet()) {
            SiteTypeVolumeID siteTypeVolumeID = entry.getKey();
            Session aSession = entry.getValue();
            if (aSession == session) continue;
            publicAddress = systemInfo.getAddress(siteTypeVolumeID);
            if (publicAddress != null) {
                this._sessionPool._setSessionPublicAddress(aSession, publicAddress);
                continue;
            }
            if (!this._tracer.on()) continue;
            this._tracer.printSessionMessage(session, "No public address for SiteTypeVolumeID " + entry.getKey(), new String[0]);
        }
        if (this._distributionMode.isConnectionDistribution()) {
            PreferredAddress preferredAddress;
            if (isPublicAddress) {
                publicAddress = (PublicAddress)sessionAddress;
                preferredAddress = Topologies.getPreferredAddress(publicAddress);
            } else {
                preferredAddress = (PreferredAddress)sessionAddress;
                publicAddress = ownAddress;
                Topologies.setPreferredAddress(publicAddress, preferredAddress);
            }
            if (preferredAddress != null) {
                Topologies.setTopologyInfo(preferredAddress, systemInfo, ownAddress.getSiteType());
            }
        }
    }

    private String _getSidAndDatabaseName() {
        String sid = this._engineFeatures.getSystemID();
        String databaseName = this._engineFeatures.getDatabaseName();
        if (databaseName == null || databaseName.isEmpty()) {
            databaseName = this._connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME);
        }
        String sidAndDatabaseName = databaseName != null && !databaseName.isEmpty() ? sid + databaseName : sid;
        return sidAndDatabaseName;
    }

    private void _handleSendReceiveException(RTEException e, Session session, boolean allowReconnectOrFallback, boolean receiveFailed) throws SQLException {
        Session anchorSession = this.getSessionPool().getAnchorSession();
        if (!this._isClosed() && !session.isConnected() && anchorSession != null) {
            if (!session.isHintRouted() && session.getSiteVolumeID().getSiteID() == anchorSession.getSiteVolumeID().getSiteID()) {
                this._sessionPool.releaseAll(this);
            } else {
                this._sessionPool.releaseAllHintRouted(this);
            }
        }
        if (allowReconnectOrFallback && session.isHintRouted()) {
            throw new InternalFallbackHintRoutedException(e);
        }
        if (receiveFailed || !allowReconnectOrFallback || !this.getBooleanConnectionProperty(ConnectionProperty.RECONNECT) || this._isInReconnect.get() || this._connectionProperties.getIntProperty(ConnectionProperty.COMMUNICATION_TIMEOUT) != 0 && e.isTimeoutError() || e.isDecompressError() || e.isInvalidPacketError() || this._transaction.isWriteTransaction() || this._isolationLevel == 4 || this._isolationLevel == 8) {
            throw ConnectionException.createException(e);
        }
        this._tryReconnect(e, anchorSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _authenticateAndConnectSession(Session session, boolean isAnchorSession) throws SQLException {
        try {
            String passwd;
            AbstractAuthenticationManager authenticationManager;
            if (this.getBooleanConnectionProperty(ConnectionProperty.NATIVE_AUTHENTICATION)) {
                try {
                    authenticationManager = new NativeAuthenticationManagerImpl();
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == -11204) {
                        if (this._tracer.on()) {
                            this._tracer.printDebugThrowable(e, "Cannot load native authentication library");
                        }
                        authenticationManager = new AuthenticationManager();
                    }
                    throw e;
                }
            } else {
                authenticationManager = new AuthenticationManager();
            }
            String userName = this._connectionProperties.getProperty(ConnectionProperty.USER);
            if (userName == null) {
                userName = "";
            }
            passwd = (passwd = this._connectionProperties.getProperty(ConnectionProperty.PASSWD)) == null ? "" : StringUtils.stripPasswd(passwd);
            if (isAnchorSession) {
                this._init();
            }
            authenticationManager.authenticate(this, session, userName, passwd);
            authenticationManager.connect(this, session, userName, passwd);
            session._switchToCommunicationTimeout();
            session.setConnectionID(this._engineFeatures.getConnectionID());
            this._sessionPool.addSession(session);
            if (this._tracer.on()) {
                this._tracer.printSessionOpened(session);
            }
            if (!isAnchorSession) {
                this._tracer.printDistributionState(this, "New session added");
            }
            session.setSendSessionContextFlag();
            if (this._sessionVariables._hasProperties()) {
                session.setSendSessionVariablesFlag();
            }
            if (this._clientInfo._hasProperties()) {
                session.setSendClientInfoFlag();
            }
            if (this._isReadOnly) {
                this._setReadOnly(true);
            }
            if (this._isolationLevel != 2) {
                this._setTransactionIsolation(this._isolationLevel, isAnchorSession);
            }
            if (!(this._currentSchema == null || this._currentSchema.isEmpty() || this._currentSchema.equals(this._defaultSchema) || session.isHintRouted())) {
                boolean tempDDLCommitted = this._isDDLCommitted;
                try {
                    this._isDDLCommitted = false;
                    this._setCurrentSchema(this._currentSchema);
                }
                finally {
                    this._isDDLCommitted = tempDDLCommitted;
                }
            }
            if (!this._isDDLCommitted) {
                this._setDDLAutoCommit(false);
            }
        }
        catch (SQLException e) {
            session.destroy();
            throw e;
        }
    }

    private void _tryReconnect(RTEException outerRteExc, Session anchorSession) throws SQLException {
        Session newSession;
        try {
            Address anchorAddress;
            this._isInReconnect.set(true);
            SiteType anchorSiteType = anchorSession != null && (anchorAddress = anchorSession.getAddress()) instanceof PublicAddress ? ((PublicAddress)anchorAddress).getSiteType() : SiteType.NONE;
            this.clearTransaction(true);
            this.reinitialize(false, false);
            newSession = this._connectAnchor(true, anchorSiteType);
        }
        catch (RTEException e) {
            throw ConnectionException.createException(outerRteExc);
        }
        finally {
            this._isInReconnect.set(false);
        }
        if (!newSession.isConnected()) {
            throw ConnectionException.createException(outerRteExc);
        }
        throw new InternalReconnectException(newSession);
    }

    private void _initClientInfoFromProperties() throws SQLException {
        this._setClientInfo("APPLICATION", this._connectionProperties.getProperty(ConnectionProperty.APPLICATION));
        this._setClientInfo("APPLICATIONUSER", this._connectionProperties.getProperty(ConnectionProperty.APPLICATIONUSER));
        for (Map.Entry<Object, Object> entry : this._info.entrySet()) {
            String sessionVariableValue;
            String sessionVariableName = ConnectionSapDB._getSessionVariableName(entry.getKey());
            if (sessionVariableName == null || (sessionVariableValue = ConnectionSapDB._getSessionVariableValue(entry.getValue())) == null) continue;
            this._setClientInfo(sessionVariableName, sessionVariableValue);
        }
    }

    private boolean _doCacheSessionVariables() {
        Session anchorSession = this.getSessionPool().getAnchorSession();
        return !this._isIgnoringTopology && anchorSession != null && !anchorSession.isSecondarySite();
    }

    private void _cacheSessionVariables(Map<String, String> map) {
        this._sessionVariables._updateProperties(map);
        this._sessionPool.setSendSessionVariablesFlag();
    }

    private void _executeInternalStatement(String sql) throws SQLException {
        this._executeInternalStatement(sql, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _executeInternalStatement(String sql, boolean onAllSessions) throws SQLException {
        InternalStatementSapDB is = InternalStatementSapDB.newInstance(this, false, true);
        try {
            if (onAllSessions) {
                is._executeUpdateOnAllSessions(sql);
            } else {
                is._executeUpdate(sql);
            }
        }
        finally {
            try {
                is._close(true, false);
            }
            catch (SQLException sQLException) {}
        }
    }

    private ColumnEncryptionKey _retrieveColumnEncryptionKey(String cekId, String ckpId) throws SQLException {
        byte[] encryptedCekBytes;
        String algorithmName;
        block16: {
            this._assertOpen();
            StatementSapDB is = null;
            ResultSetSapDB irs = null;
            try {
                String sql = "CALL SYS.CLIENTSIDE_ENCRYPTION_COLUMN_KEYVALUE_DEV( '" + UUIDUtils.toHexString(cekId) + "' , '" + UUIDUtils.toHexString(ckpId) + "' , ? )";
                is = InternalStatementSapDB.newInstance(this, false, true);
                irs = (InternalResultSetSapDB)is._executeQuery(sql);
                if (irs != null && irs._next()) {
                    algorithmName = irs._getString(1);
                    encryptedCekBytes = irs._getBytes(2);
                    break block16;
                }
                throw SQLExceptionSapDB.newInstance("error.columnencryptionkeynotfound", ckpId);
            }
            catch (SQLException e) {
                throw SQLExceptionSapDB.newInstance("error.columnencryptionkeynotfound", ckpId);
            }
            finally {
                if (irs != null) {
                    try {
                        irs._close(true, false);
                    }
                    catch (SQLException sQLException) {}
                }
                if (is != null) {
                    try {
                        is._close(true, false);
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        Key privateKey = this._retrieveClientPrivateKey(ckpId);
        byte[] decryptedCekBytes = RsaOaep.decrypt(privateKey, encryptedCekBytes);
        ColumnEncryptionKey columnEncryptionKey = new ColumnEncryptionKey(AesCbc.getKey(decryptedCekBytes, algorithmName), this._engineFeatures.getDatabaseName(), "", cekId, algorithmName);
        KeyCache.addColumnEncryptionKey(cekId, columnEncryptionKey);
        return columnEncryptionKey;
    }

    private void _storeClientKeyPair(String ckpName, String algorithmName, UUID uuid, RsaOaep rsaKeys) throws SQLException {
        this._assertOpen();
        Key publicKey = rsaKeys.getPublicKey();
        Key privateKey = rsaKeys.getPrivateKey();
        KeyCache.storeClientKeyPair(new ClientKeyPair(publicKey.getEncoded(), privateKey.getEncoded(), this._engineFeatures.getDatabaseName(), ckpName, uuid.toString(), algorithmName), this._connectionProperties.getProperty(ConnectionProperty.CSE_KEY_STORE_PASSWD));
        try {
            this._executeInternalStatement("CREATE CLIENTSIDE ENCRYPTION KEYPAIR \"" + ckpName + "\" ALGORITHM '" + algorithmName + "' ENCODED PUBLIC KEYVALUE '" + Base64Utils.encodePublicKey(publicKey.getEncoded()) + "' KEYPAIR ID '" + UUIDUtils.toHexString(uuid) + "'");
        }
        catch (SQLException e) {
            try {
                KeyCache.deleteClientKeyPair(uuid.toString(), this._connectionProperties.getProperty(ConnectionProperty.CSE_KEY_STORE_PASSWD));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }

    private Key _retrieveClientPublicKey(String uuid) throws SQLException {
        return KeyCache.getCachedPublicClientKey(uuid, this._connectionProperties.getProperty(ConnectionProperty.CSE_KEY_STORE_PASSWD));
    }

    private Key _retrieveClientPrivateKey(String uuid) throws SQLException {
        return KeyCache.getCachedPrivateClientKey(uuid, this._connectionProperties.getProperty(ConnectionProperty.CSE_KEY_STORE_PASSWD));
    }

    private void _saveAndAlterAutoCommitForGlobalTransaction() {
        boolean autoCommit;
        this._savedAutoCommitForGlobalTransaction = autoCommit = this._transaction.getAutoCommit();
        if (autoCommit) {
            this._transaction.setAutoCommit(false);
        }
    }

    private void _restoreAutoCommitForGlobalTransaction() {
        boolean autoCommit = this._transaction.getAutoCommit();
        if (autoCommit != this._savedAutoCommitForGlobalTransaction) {
            this._transaction.setAutoCommit(this._savedAutoCommitForGlobalTransaction);
        }
    }

    public synchronized int getMessageID() {
        return this._sessionPool.getAnchorSession().getMessageID();
    }

    public synchronized boolean isPrefetchReplyPacketCached(ResultSetSapDB resultSet) {
        return this._prefetchedCachedReplyMap.get(resultSet) instanceof HReplyPacket;
    }

    public synchronized boolean isPrefetchErrorCached(ResultSetSapDB resultSet) {
        return this._prefetchedCachedReplyMap.get(resultSet) instanceof SQLException;
    }

    public synchronized int prefetchedCachedReplyMapSize() {
        return this._prefetchedCachedReplyMap.size();
    }

    public synchronized SQLException getPrefetchCachedError(ResultSetSapDB resultSet) {
        Object object = this._prefetchedCachedReplyMap.get(resultSet);
        return object instanceof SQLException ? (SQLException)object : null;
    }

    public synchronized int getCurrentCacheSize() {
        return this._statementCache != null ? this._statementCache.getCurrentCacheSize() : -1;
    }

    public synchronized int getCurrentTrackSize() {
        return this._statementCache != null ? this._statementCache.getCurrentTrackSize() : -1;
    }

    public synchronized boolean isCached(String sql) {
        return this._statementCache != null && this._statementCache.isCached(sql);
    }

    public synchronized boolean isCached(ParseInfo parseInfo) {
        return this._statementCache != null && this._statementCache.isCached(parseInfo);
    }

    public synchronized boolean isTracked(String sql) {
        return this._statementCache != null && this._statementCache.isTracked(sql);
    }

    public static enum ExchangeFlag {
        NOP,
        IS_STATEMENT,
        IS_PREPARED_EXECUTE,
        IS_PARSE,
        IGNORE_ERRORS,
        ALLOW_RECONNECT_OR_FALLBACK;

    }
}

