/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HanaParameterMetaData;
import com.sap.db.jdbc.HanaResultSetMetaData;
import com.sap.db.jdbc.Hash;
import com.sap.db.jdbc.HashPartitionInfo;
import com.sap.db.jdbc.ParseID;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.PartitionParameterInfo;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.RangeInfo;
import com.sap.db.jdbc.RangePartitionInfo;
import com.sap.db.jdbc.RangeVoteCentre;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteTypeVolumeID;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.AbstractPutval;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.exceptions.BatchUpdateExceptionSapDB;
import com.sap.db.jdbc.exceptions.InternalFallbackHintRoutedException;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDBInterface;
import com.sap.db.jdbc.packet.ActiveActiveProtocolVersion;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HPartInfo;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.PartAttribute;
import com.sap.db.jdbc.packet.PartKind;
import com.sap.db.jdbc.packet.PartitionMethod;
import com.sap.db.jdbc.packet.PartitionParameterFunction;
import com.sap.db.jdbc.packet.RangeComparisonFunction;
import com.sap.db.jdbc.packet.TransactionState;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbcext.wrapper.CallableStatement;
import com.sap.db.jdbcext.wrapper.PreparedStatement;
import com.sap.db.util.CharsetUtils;
import com.sap.db.util.Dbg;
import com.sap.db.util.DbgInstanceCount;
import com.sap.db.util.MessageTranslator;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@ThreadSafe
public abstract class PreparedStatementSapDB
extends StatementSapDB
implements java.sql.PreparedStatement,
SQLParamController {
    public static final int UNLIMITED_STREAM_LENGTH = -1;
    private static final String INITIAL_PARAM_VALUE = "initParam";
    private static final PutvalComparator PUTVAL_COMPARATOR = new PutvalComparator();
    private static final ThreadLocal<Calendar> CALENDAR = new ThreadLocal<Calendar>(){

        @Override
        public Calendar initialValue() {
            return Calendar.getInstance();
        }
    };
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        public DecimalFormat initialValue() {
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMinimumIntegerDigits(1);
            decimalFormat.setDecimalSeparatorAlwaysShown(false);
            decimalFormat.setGroupingUsed(false);
            return decimalFormat;
        }
    };
    private final ParseInfo _parseInfo;
    @GuardedBy(value="this")
    private Session _session;
    @GuardedBy(value="this")
    private Object[] _inputArgs;
    @GuardedBy(value="this")
    private Object[] _rawInputArgs;
    @GuardedBy(value="this")
    private DataFormatDescription.NullIndicator _nullIndicator;
    @GuardedBy(value="this")
    private HDataPart _dataPart;
    @GuardedBy(value="this")
    private List<AbstractPutval> _putvals;
    @GuardedBy(value="this")
    private int _batchSize;
    @GuardedBy(value="this")
    private List<Object> _batchItems;
    @GuardedBy(value="this")
    private Map<SiteTypeVolumeID, List<Object>> _batchVolumeMap;
    private final AtomicInteger _computedVolumeID = new AtomicInteger(-1);

    public static PreparedStatementSapDB getPreparedStatementSapDB(java.sql.PreparedStatement preparedStatement) {
        java.sql.PreparedStatement ps = preparedStatement;
        while (!(ps instanceof PreparedStatementSapDB)) {
            if (ps instanceof PreparedStatement) {
                ps = ((PreparedStatement)ps).getInner();
                continue;
            }
            if (ps instanceof CallableStatement) {
                ps = ((CallableStatement)ps).getInner();
                continue;
            }
            return null;
        }
        return (PreparedStatementSapDB)ps;
    }

    protected PreparedStatementSapDB(Tracer tracer, ConnectionSapDB connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean isMetaDataStatement, boolean createInternalResultSets) throws SQLException {
        super(tracer, connection, resultSetType, resultSetConcurrency, resultSetHoldability, isMetaDataStatement, createInternalResultSets, true);
        this._session = this._connection.getSessionPool().getPrimarySession();
        ParseInfo parseInfo = this._connection._cacheOnPrepareGetCached(sql);
        this._parseInfo = parseInfo != null ? parseInfo : this._doParse(sql, this._session, false);
        this._connection._cacheOnPrepareSetTracked(this._parseInfo);
        int parameterCount = this._parseInfo.getParameterCount();
        this._inputArgs = new Object[parameterCount];
        this._rawInputArgs = new Object[parameterCount];
        this._clearParameters();
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeQuery") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeQuery", sql);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeQuery( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeUpdate", sql);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeUpdate( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "execute", sql);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("execute( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "addBatch") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "addBatch", sql);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("addBatch( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "clearBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearBatch", new Object[0]);
            }
            this._clearPreparedBatch();
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeBatch", new Object[0]);
            }
            int[] result = this._executePreparedBatch();
            if (on) {
                this._tracer.printResult(result);
            }
            int[] nArray = result;
            return nArray;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeUpdate", sql, autoGeneratedKeys);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeUpdate( String, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeUpdate", sql, columnIndexes);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeUpdate( String, int[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeUpdate", sql, columnNames);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeUpdate( String, String[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "execute", sql, autoGeneratedKeys);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("execute( String, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "execute", sql, columnIndexes);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("execute( String, int[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "execute", sql, columnNames);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("execute( String, String[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeLargeUpdate( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, autoGeneratedKeys);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeLargeUpdate( String, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, columnIndexes);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeLargeUpdate( String, int[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, columnNames);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeLargeUpdate( String, String[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeQuery") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeQuery", new Object[0]);
            }
            ResultSet result = this._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeUpdate", new Object[0]);
            }
            int result = this._executeUpdate();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "execute", new Object[0]);
            }
            boolean result = this._execute();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNull", parameterIndex, sqlType);
            }
            this._setNull(parameterIndex);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterIndex, this._obfuscateEncrypted(parameterIndex, x));
            }
            this._setObject(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterIndex, this._obfuscateEncrypted(parameterIndex, x), targetSqlType);
            }
            this._setObject(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBoolean(int parameterIndex, boolean x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBoolean") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBoolean", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setBoolean(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setByte(int parameterIndex, byte x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setByte") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setByte", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setByte(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setShort(int parameterIndex, short x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setShort") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setShort", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setShort(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setInt(int parameterIndex, int x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setInt") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setInt", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setInt(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setLong(int parameterIndex, long x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setLong") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setLong", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setLong(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setFloat(int parameterIndex, float x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setFloat") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFloat", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)Float.valueOf(x)));
            }
            this._setFloat(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setDouble(int parameterIndex, double x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setDouble") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDouble", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setDouble(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBigDecimal", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setBigDecimal(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDate", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setDate(parameterIndex, x, null);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTime", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setTime(parameterIndex, x, null);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTimestamp", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setTimestamp(parameterIndex, x, null);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setString(int parameterIndex, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setString", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setString(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBytes(int parameterIndex, byte[] x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBytes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBytes", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setBytes(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @Deprecated
    public synchronized void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setUnicodeStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setUnicodeStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setUnicodeStream(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "clearParameters") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearParameters", new Object[0]);
            }
            this._clearParameters();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "addBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "addBatch", new Object[0]);
            }
            this._addPreparedBatch();
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNull", parameterIndex, sqlType, typeName);
            }
            this._setNull(parameterIndex);
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDate", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), cal);
            }
            this._setDate(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTime", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), cal);
            }
            this._setTime(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTimestamp", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), cal);
            }
            this._setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setClob(int parameterIndex, Clob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setClob(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBlob(int parameterIndex, Blob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setBlob(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setArray(int parameterIndex, Array x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setArray", parameterIndex, x);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setArray( int, Array )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setRef(int parameterIndex, Ref x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setRef", parameterIndex, x);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setRef( int, Ref )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "getMetaData") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMetaData", new Object[0]);
            }
            ResultSetMetaData result = this._getMetaData();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSetMetaData resultSetMetaData = result;
            return resultSetMetaData;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setURL(int parameterIndex, URL x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setURL", parameterIndex, x);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setURL( int, URL )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "getParameterMetaData") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getParameterMetaData", new Object[0]);
            }
            ParameterMetaData result = this._getParameterMetaData();
            if (on) {
                this._tracer.printResult(result);
            }
            ParameterMetaData parameterMetaData = result;
            return parameterMetaData;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterIndex, this._obfuscateEncrypted(parameterIndex, x), targetSqlType, scaleOrLength);
            }
            this._setObject(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNString(int parameterIndex, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNString", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setString(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setAsciiStream(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setCharacterStream(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNCharacterStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setCharacterStream(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNCharacterStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setBinaryStream(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setClob(int parameterIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setClob(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setClob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNClob(int parameterIndex, NClob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setClob(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNClob(int parameterIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setClob(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setClob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBlob(int parameterIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setBlob(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setBlob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setRowId(int parameterIndex, RowId x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setRowId", parameterIndex, x);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setRowId( int, RowId )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setSQLXML", parameterIndex, x);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setSQLXML( int, SQLXML )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setObject", parameterIndex, x, targetSqlType);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setObject( int, Object, SQLType )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setObject", parameterIndex, x, targetSqlType, scaleOrLength);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setObject( int, Object, SQLType, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", new Object[0]);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("executeLargeUpdate()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public ConnectionSapDB getConnectionSapDB() {
        return this._connection;
    }

    @Override
    public StatementSapDB getStatementSapDB() {
        return this;
    }

    @Override
    public ResultSetSapDB getResultSetSapDB() {
        return this._getCurrentResultSet();
    }

    @Override
    public void assertControllerOpen() throws SQLException {
        if (this._connection._isClosed()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession(boolean avoidOpenSession, boolean handleTransaction) throws SQLException {
        PreparedStatementSapDB preparedStatementSapDB = this;
        synchronized (preparedStatementSapDB) {
            return this._getSession(avoidOpenSession, handleTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNullOrSpecialNull() {
        PreparedStatementSapDB preparedStatementSapDB = this;
        synchronized (preparedStatementSapDB) {
            return this._wasNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasSpecialNull() {
        PreparedStatementSapDB preparedStatementSapDB = this;
        synchronized (preparedStatementSapDB) {
            return this._nullIndicator == DataFormatDescription.NullIndicator.SPECIAL_NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNullIndicator(DataFormatDescription.NullIndicator nullIndicator) {
        PreparedStatementSapDB preparedStatementSapDB = this;
        synchronized (preparedStatementSapDB) {
            this._nullIndicator = nullIndicator;
        }
    }

    @Override
    protected ParseInfo _getParseInfo() {
        return this._parseInfo;
    }

    @Override
    protected void _setPoolable(boolean isPoolable) throws SQLException {
        this._connection._cacheOnSetPoolable(this._parseInfo, this._isPoolable.get(), isPoolable);
        super._setPoolable(isPoolable);
    }

    @Override
    protected boolean _shouldClosePending() {
        return this._parseInfo.hasOutputLOB() || this._parseInfo.hasResultSetLOB();
    }

    @Override
    protected void _clean() throws SQLException {
        PreparedStatementSapDB._clean(this.getInstanceClassName(), this._connection, this._parseInfo, this._isPoolable, this._isClosed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void _clean(String instanceClassName, ConnectionSapDB connection, ParseInfo parseInfo, AtomicBoolean isPoolable, AtomicBoolean isClosed) throws SQLException {
        if (connection._isClosed() || isClosed.get()) {
            return;
        }
        if (parseInfo != null) {
            ConnectionSapDB connectionSapDB = connection;
            synchronized (connectionSapDB) {
                if (connection._cacheOnDrop(parseInfo, isPoolable.get())) {
                    return;
                }
                connection._dropParseIDs(parseInfo);
            }
        }
        if (Dbg.runtimeEnabled) {
            DbgInstanceCount.incrementCleanedCount(instanceClassName);
        }
    }

    protected Object _obfuscateEncrypted(int parameterIndex, Object x) throws SQLException {
        return this._obfuscateEncrypted(this._getParameterConverter(parameterIndex), x);
    }

    protected Object _obfuscateEncrypted(String parameterName, Object x) throws SQLException {
        return this._obfuscateEncrypted(this._getParameterConverter(parameterName), x);
    }

    protected Object _obfuscateEncrypted(AbstractConverter converter, Object x) throws SQLException {
        return !this._tracer.getTraceConfiguration().isShowPlainTextCSEEnabled() && converter.isEncrypted() ? "***" : x;
    }

    protected ResultSet _executeQuery() throws SQLException {
        this._execute();
        ResultSetSapDB currentResultSet = this._getCurrentResultSet();
        if (currentResultSet == null) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.noresultset", new String[0]);
        }
        return currentResultSet;
    }

    protected int _executeUpdate() throws SQLException {
        if (this._parseInfo.isSelect()) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.resultset", new String[0]);
        }
        this._execute();
        return this._hasRowCount ? this._rowsAffected : 0;
    }

    protected boolean _execute() throws SQLException {
        this._assertOpen();
        Session session = this._getSessionForExecute();
        return this._execute(session);
    }

    protected void _addBatch() throws SQLException {
        this._addPreparedBatch();
    }

    protected int[] _executeBatch() throws SQLException {
        return this._executePreparedBatch();
    }

    protected boolean _wasNull() {
        return this._connection.emptyTimestampIsNull() ? this._nullIndicator == DataFormatDescription.NullIndicator.NULL || this._nullIndicator == DataFormatDescription.NullIndicator.SPECIAL_NULL : this._nullIndicator == DataFormatDescription.NullIndicator.NULL;
    }

    protected void _setNull(int parameterIndex) throws SQLException {
        this._getParameterConverter(parameterIndex);
        this._inputArgs[parameterIndex - 1] = null;
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _setObject(int parameterIndex, Object x) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setObject(x);
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _setBoolean(int parameterIndex, boolean x) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setBoolean(x);
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _setByte(int parameterIndex, byte x) throws SQLException {
        AbstractConverter converter = this._getParameterConverter(parameterIndex);
        this._inputArgs[parameterIndex - 1] = converter.setByte(x);
        this._setRawByteShortIntLog(converter, true, parameterIndex, x);
    }

    protected void _setShort(int parameterIndex, short x) throws SQLException {
        AbstractConverter converter = this._getParameterConverter(parameterIndex);
        this._inputArgs[parameterIndex - 1] = converter.setShort(x);
        this._setRawByteShortIntLog(converter, false, parameterIndex, x);
    }

    protected void _setInt(int parameterIndex, int x) throws SQLException {
        AbstractConverter converter = this._getParameterConverter(parameterIndex);
        this._inputArgs[parameterIndex - 1] = converter.setInt(x);
        this._setRawByteShortIntLog(converter, false, parameterIndex, x);
    }

    protected void _setLong(int parameterIndex, long x) throws SQLException {
        AbstractConverter converter = this._getParameterConverter(parameterIndex);
        this._inputArgs[parameterIndex - 1] = converter.setLong(x);
        this._setRawByteShortIntLog(converter, false, parameterIndex, x);
    }

    protected void _setRawByteShortIntLog(AbstractConverter converter, boolean forByte, int parameterIndex, long x) throws SQLException {
        if (this._isClientRoutingByRange()) {
            if (this._parseInfo.isPartitionParameter(parameterIndex)) {
                switch (converter.getColumnType()) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        this._rawInputArgs[parameterIndex - 1] = x;
                        break;
                    }
                    case 3: {
                        this._rawInputArgs[parameterIndex - 1] = new BigDecimal(x);
                        break;
                    }
                    case -15: 
                    case -9: 
                    case 12: {
                        this._rawInputArgs[parameterIndex - 1] = String.valueOf(x);
                        break;
                    }
                    default: {
                        this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                        break;
                    }
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
            }
        } else if (this._isClientRoutingByHash()) {
            if (this._parseInfo.isPartitionParameter(parameterIndex)) {
                switch (converter.getColumnType()) {
                    case -6: {
                        this._rawInputArgs[parameterIndex - 1] = String.valueOf(forByte ? x & 0xFFL : x);
                        break;
                    }
                    case -15: 
                    case -9: 
                    case -5: 
                    case 4: 
                    case 5: 
                    case 12: {
                        this._rawInputArgs[parameterIndex - 1] = String.valueOf(x);
                        break;
                    }
                    case 3: {
                        this._rawInputArgs[parameterIndex - 1] = this._translateDecimalForHashing(new BigDecimal(x), parameterIndex);
                        break;
                    }
                    case -3: 
                    case -2: {
                        if (forByte) {
                            this._rawInputArgs[parameterIndex - 1] = x >= 0L ? new String(new byte[]{(byte)x}, CharsetUtils.UTF_8) : String.valueOf(x & 0xFFL);
                            break;
                        }
                        this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                        break;
                    }
                    default: {
                        this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                        break;
                    }
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
            }
        }
    }

    protected void _setFloat(int parameterIndex, float x) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setFloat(x);
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _setDouble(int parameterIndex, double x) throws SQLException {
        AbstractConverter converter = this._getParameterConverter(parameterIndex);
        this._inputArgs[parameterIndex - 1] = converter.setDouble(x);
        if (this._isClientRoutingByRange()) {
            if (this._parseInfo.isPartitionParameter(parameterIndex)) {
                switch (converter.getColumnType()) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        this._rawInputArgs[parameterIndex - 1] = (long)x;
                        break;
                    }
                    case 3: {
                        if (converter.getScale() == 0) {
                            this._rawInputArgs[parameterIndex - 1] = new BigDecimal((long)x);
                            break;
                        }
                        String decString = this._translateDecimalForHashing(String.valueOf(x), parameterIndex);
                        this._rawInputArgs[parameterIndex - 1] = decString.equals(INITIAL_PARAM_VALUE) ? INITIAL_PARAM_VALUE : new BigDecimal(decString);
                        break;
                    }
                    case -15: 
                    case -9: 
                    case 12: {
                        this._rawInputArgs[parameterIndex - 1] = String.valueOf(x);
                        break;
                    }
                    default: {
                        this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                        break;
                    }
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
            }
        } else if (this._isClientRoutingByHash()) {
            if (this._parseInfo.isPartitionParameter(parameterIndex)) {
                switch (converter.getColumnType()) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        this._rawInputArgs[parameterIndex - 1] = String.valueOf((long)x);
                        break;
                    }
                    case 3: {
                        if (converter.getScale() == 0) {
                            this._rawInputArgs[parameterIndex - 1] = this._translateDecimalForHashing(String.valueOf((long)x), parameterIndex);
                            break;
                        }
                        this._rawInputArgs[parameterIndex - 1] = this._translateDecimalForHashing(String.valueOf(x), parameterIndex);
                        break;
                    }
                    case -15: 
                    case -9: 
                    case 12: {
                        this._rawInputArgs[parameterIndex - 1] = String.valueOf(x);
                        break;
                    }
                    default: {
                        this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                        break;
                    }
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
            }
        }
    }

    protected void _setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        AbstractConverter converter = this._getParameterConverter(parameterIndex);
        this._inputArgs[parameterIndex - 1] = converter.setBigDecimal(x);
        if (this._isClientRoutingByRange()) {
            if (this._parseInfo.isPartitionParameter(parameterIndex)) {
                if (x == null) {
                    this._rawInputArgs[parameterIndex - 1] = null;
                } else {
                    switch (converter.getColumnType()) {
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            try {
                                this._rawInputArgs[parameterIndex - 1] = x.longValue();
                            }
                            catch (NumberFormatException e) {
                                this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                            }
                            break;
                        }
                        case 3: {
                            this._rawInputArgs[parameterIndex - 1] = x.setScale(converter.getScale(), RoundingMode.FLOOR);
                            break;
                        }
                        default: {
                            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                            break;
                        }
                    }
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
            }
        } else if (this._isClientRoutingByHash()) {
            if (this._parseInfo.isPartitionParameter(parameterIndex)) {
                if (x == null) {
                    this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                } else {
                    switch (converter.getColumnType()) {
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            this._rawInputArgs[parameterIndex - 1] = String.valueOf(x.longValue());
                            break;
                        }
                        case 3: {
                            this._rawInputArgs[parameterIndex - 1] = this._translateDecimalForHashing(x, parameterIndex);
                            break;
                        }
                        default: {
                            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                            break;
                        }
                    }
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
            }
        }
    }

    protected void _setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setDate(x, cal);
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setTime(x, cal);
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setTimestamp(x, cal);
        if (this._isClientRoutingByRange()) {
            this._rawInputArgs[parameterIndex - 1] = this._parseInfo.isPartitionParameter(parameterIndex) ? (x == null ? null : (this._getParameterConverter(parameterIndex).getColumnType() == 93 ? x : INITIAL_PARAM_VALUE)) : INITIAL_PARAM_VALUE;
        } else if (this._isClientRoutingByHash()) {
            this._rawInputArgs[parameterIndex - 1] = this._parseInfo.isPartitionParameter(parameterIndex) ? (this._getParameterConverter(parameterIndex).getColumnType() == 93 ? x.toString() : INITIAL_PARAM_VALUE) : INITIAL_PARAM_VALUE;
        }
    }

    protected void _setString(int parameterIndex, String x) throws SQLException {
        AbstractConverter converter = this._getParameterConverter(parameterIndex);
        this._inputArgs[parameterIndex - 1] = converter.setString(x);
        if (this._isClientRoutingByRange()) {
            if (this._parseInfo.isPartitionParameter(parameterIndex)) {
                if (x == null) {
                    this._rawInputArgs[parameterIndex - 1] = null;
                } else {
                    switch (converter.getColumnType()) {
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            x = x.trim();
                            try {
                                this._rawInputArgs[parameterIndex - 1] = Long.valueOf(x);
                            }
                            catch (NumberFormatException e) {
                                try {
                                    x = x.replaceAll("[^0-9-.]", "");
                                    this._rawInputArgs[parameterIndex - 1] = Long.valueOf(x);
                                }
                                catch (NumberFormatException e1) {
                                    this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                                }
                            }
                            break;
                        }
                        case 3: {
                            try {
                                this._rawInputArgs[parameterIndex - 1] = new BigDecimal(x.trim());
                            }
                            catch (NumberFormatException e) {
                                this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                            }
                            break;
                        }
                        case 93: {
                            try {
                                this._rawInputArgs[parameterIndex - 1] = Timestamp.valueOf(x.trim());
                            }
                            catch (IllegalArgumentException e) {
                                this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                            }
                            break;
                        }
                        case -15: 
                        case -9: 
                        case 12: {
                            this._rawInputArgs[parameterIndex - 1] = x;
                            break;
                        }
                        default: {
                            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                            break;
                        }
                    }
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
            }
        } else if (this._isClientRoutingByHash()) {
            if (this._parseInfo.isPartitionParameter(parameterIndex)) {
                if (x == null) {
                    this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                } else {
                    switch (converter.getColumnType()) {
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            this._rawInputArgs[parameterIndex - 1] = x.trim().replaceFirst("^(?:(-)|\\+)?0*(?!$)", "$1");
                            break;
                        }
                        case 3: {
                            this._rawInputArgs[parameterIndex - 1] = this._translateDecimalForHashing(x.trim(), parameterIndex);
                            break;
                        }
                        case 93: {
                            x = x.trim();
                            if (x.contains(" .") || x.contains(". ")) {
                                this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                                break;
                            }
                            this._rawInputArgs[parameterIndex - 1] = x;
                            break;
                        }
                        case -15: 
                        case -9: 
                        case 12: {
                            this._rawInputArgs[parameterIndex - 1] = x;
                            break;
                        }
                        default: {
                            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                            break;
                        }
                    }
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
            }
        }
    }

    protected void _setBytes(int parameterIndex, byte[] x) throws SQLException {
        AbstractConverter converter = this._getParameterConverter(parameterIndex);
        this._inputArgs[parameterIndex - 1] = converter.setBytes(x);
        if (this._isClientRoutingByRange()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        } else if (this._isClientRoutingByHash()) {
            if (this._parseInfo.isPartitionParameter(parameterIndex)) {
                switch (converter.getColumnType()) {
                    case -3: 
                    case -2: {
                        this._rawInputArgs[parameterIndex - 1] = new String(x, CharsetUtils.UTF_8);
                        break;
                    }
                    default: {
                        this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
                        break;
                    }
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
            }
        }
    }

    protected void _setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setAsciiStream(x, length);
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _setUnicodeStream(int parameterIndex, InputStream x) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setUnicodeStream(x);
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setCharacterStream(x, length);
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setBinaryStream(x, length);
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _setClob(int parameterIndex, Clob x) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setClob(x);
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _setClob(int parameterIndex, Reader x, long length) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setCharacterStream(x, length);
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _setBlob(int parameterIndex, Blob x) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setBlob(x);
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setBinaryStream(x, length);
        if (this._isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = INITIAL_PARAM_VALUE;
        }
    }

    protected void _clearParameters() throws SQLException {
        int n = this._inputArgs.length;
        for (int i = 0; i < n; ++i) {
            this._inputArgs[i] = INITIAL_PARAM_VALUE;
            this._rawInputArgs[i] = INITIAL_PARAM_VALUE;
        }
    }

    protected ResultSetMetaData _getMetaData() {
        if (!this._parseInfo.isSelect() || this._parseInfo.getResultSetConverters() == null) {
            return null;
        }
        return new HanaResultSetMetaData(this._tracer, this._parseInfo);
    }

    protected ParameterMetaData _getParameterMetaData() {
        return new HanaParameterMetaData(this._tracer, this._parseInfo.getParameterConverters());
    }

    protected AbstractConverter _getParameterConverter(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this._parseInfo.getParameterCount()) {
            throw SQLExceptionSapDB.newInstance("error.invalid.parameter.index", String.valueOf(parameterIndex));
        }
        return this._parseInfo.getParameterConverter(parameterIndex);
    }

    protected AbstractConverter _getParameterConverter(String parameterName) throws SQLException {
        if (!this._parseInfo.isProcedure()) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.noprocedure", new String[0]);
        }
        AbstractConverter converter = this._parseInfo.getParameterConverter(parameterName);
        if (converter == null) {
            throw SQLExceptionSapDB.newInstance("error.invalid.parameter.name", parameterName);
        }
        return converter;
    }

    protected void _registerOutParameter(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this._parseInfo.getParameterCount()) {
            throw SQLExceptionSapDB.newInstance("error.invalid.parameter.index", String.valueOf(parameterIndex));
        }
    }

    protected void _registerOutParameter(String parameterName) throws SQLException {
        AbstractConverter converter = this._parseInfo.getParameterConverter(parameterName);
        if (converter == null) {
            throw SQLExceptionSapDB.newInstance("error.invalid.parameter.name", parameterName);
        }
    }

    protected HDataPart _getDataPart(int outputFieldPos) throws SQLException {
        if (this._dataPart == null) {
            throw SQLExceptionSapDB.newInstance("error.nooutparamdata", new String[0]);
        }
        if (outputFieldPos == -1) {
            throw SQLExceptionSapDB.newInstance("error.parameter.not.out.or.inout", new String[0]);
        }
        this._dataPart.moveToField(outputFieldPos);
        return this._dataPart;
    }

    private static SQLException _getNotCallableMethodException(String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.notcallable", methodSignature, "Statement", "PreparedStatement");
    }

    private Session _getSession(boolean avoidOpenSession, boolean handleTransaction) throws SQLException {
        boolean hintRouted;
        List<SiteTypeVolumeID> tableLocations = this._parseInfo != null ? this._parseInfo.getTableLocations() : null;
        boolean bl = hintRouted = this._shouldHintBasedRoute() && this._isHintBasedRoutingRequired();
        if ((this._connection.getDistributionMode().isStatementRouting() || hintRouted) && tableLocations != null && tableLocations.size() > 0) {
            int idx = (int)(this._parseInfo.getTableLocationCounter().getNextID() % (long)tableLocations.size());
            SiteTypeVolumeID siteTypeVolumeID = tableLocations.get(idx);
            if (siteTypeVolumeID.isValid()) {
                Session anchor = this._connection.getSessionPool().getAnchorSession();
                if (this._session.getAddress() instanceof PublicAddress && ((PublicAddress)this._session.getAddress()).isHSR() && this._isRoutedFromPrimaryToSecondary(anchor, siteTypeVolumeID) && (!this._shouldHintBasedRoute() || !this._connection._isSecondaryReady())) {
                    siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(siteTypeVolumeID.getVolumeID());
                }
                if (!this._connection.getDistributionMode().isStatementRouting() && !this._isRoutedFromPrimaryToSecondary(anchor, siteTypeVolumeID)) {
                    this._session = this._connection.getSessionPool().getPrimarySession();
                } else {
                    Session session = this._connection.getSessionPool().getSession(siteTypeVolumeID);
                    if (avoidOpenSession) {
                        if (session != null && session.isHintRouted()) {
                            this._connection._handleSuccessHintRouted();
                        }
                        return session != null ? session : this._session;
                    }
                    if (session == null) {
                        try {
                            session = this._connection._getSecondarySession(siteTypeVolumeID);
                        }
                        catch (SQLException e) {
                            if (anchor != null && anchor.isNoneOrPrimarySite() && siteTypeVolumeID.isSecondarySite()) {
                                this._connection._handleFailedHintRouted();
                                siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(siteTypeVolumeID.getVolumeID());
                                try {
                                    session = this._connection._getSecondarySession(siteTypeVolumeID);
                                }
                                catch (SQLException e1) {
                                    session = this._connection.getSessionPool().getPrimarySession();
                                }
                                if (session == null) {
                                    session = this._connection.getSessionPool().getPrimarySession();
                                }
                            }
                            session = this._connection.getSessionPool().getPrimarySession();
                        }
                        if (session == null) {
                            session = this._connection.getSessionPool().getPrimarySession();
                        }
                    }
                    this._session = session;
                }
            }
        } else {
            this._session = this._connection.getSessionPool().getPrimarySession();
        }
        if (handleTransaction) {
            this._connection.handleTransaction(this._session, true);
        }
        if (this._session.isHintRouted()) {
            this._connection._handleSuccessHintRouted();
        }
        return this._session;
    }

    private Session _getSession(SiteTypeVolumeID siteTypeVolumeID) throws SQLException {
        Session session = this._connection.getSessionPool().getSession(siteTypeVolumeID);
        Session anchor = this._connection.getSessionPool().getAnchorSession();
        if (this._session.getAddress() instanceof PublicAddress && ((PublicAddress)this._session.getAddress()).isHSR() && this._isRoutedFromPrimaryToSecondary(anchor, siteTypeVolumeID) && (!this._shouldHintBasedRoute() || !this._connection._isSecondaryReady())) {
            siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(siteTypeVolumeID.getVolumeID());
        }
        if (!this._connection.getDistributionMode().isStatementRouting() && !this._isRoutedFromPrimaryToSecondary(anchor, siteTypeVolumeID)) {
            session = this._connection.getSessionPool().getPrimarySession();
        } else if (session == null) {
            try {
                session = this._connection._getSecondarySession(siteTypeVolumeID);
            }
            catch (SQLException e) {
                if (anchor != null && anchor.isNoneOrPrimarySite() && siteTypeVolumeID.isSecondarySite()) {
                    this._connection._handleFailedHintRouted();
                    siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(siteTypeVolumeID.getVolumeID());
                    try {
                        session = this._connection._getSecondarySession(siteTypeVolumeID);
                    }
                    catch (SQLException e1) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                    if (session == null) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                }
                session = this._connection.getSessionPool().getPrimarySession();
            }
            if (session == null) {
                session = this._connection.getSessionPool().getPrimarySession();
            }
        }
        this._connection.handleTransaction(session, true);
        if (session.isHintRouted()) {
            this._connection._handleSuccessHintRouted();
        }
        this._session = session;
        return session;
    }

    private Session _getSessionForExecute() throws SQLException {
        Session session;
        boolean hintRouted;
        boolean bl = hintRouted = this._shouldHintBasedRoute() && this._isHintBasedRoutingRequired();
        if (this._isClientRouting() && (this._connection.getDistributionMode().isStatementRouting() || hintRouted)) {
            SiteTypeVolumeID siteTypeVolumeID = this._computeVolumeID();
            this._computedVolumeID.set(siteTypeVolumeID.getVolumeID());
            if (siteTypeVolumeID.isValid()) {
                session = this._getSession(siteTypeVolumeID);
                if (this._parseInfo.getParseID(session) == null) {
                    this._reparse(session);
                }
            } else {
                session = this.getSession(false, true);
            }
        } else {
            session = this.getSession(false, true);
        }
        this._session = session;
        return this._session;
    }

    private boolean _shouldHintBasedRoute() throws SQLException {
        TransactionState transactionState;
        Address address = this._session.getAddress();
        if (!(address instanceof PublicAddress)) {
            return false;
        }
        return this._connection.getEngineFeatures().getActiveActiveProtocolVersion().getValue() >= ActiveActiveProtocolVersion.Level1.getValue() && this._session != null && ((PublicAddress)this._session.getAddress()).isHSR() && this._parseInfo.getFunctionCode() == FunctionCode.Select && this._connection._getTransactionIsolation() == 2 && ((transactionState = this._connection.getTransactionState()) == TransactionState.None || transactionState == TransactionState.ReadTransaction);
    }

    private boolean _isHintBasedRoutingRequired() throws SQLException {
        List<SiteTypeVolumeID> tableLocations;
        Session anchor = this._connection.getSessionPool().getAnchorSession();
        if (anchor == null) {
            return false;
        }
        List<SiteTypeVolumeID> list = tableLocations = this._parseInfo != null ? this._parseInfo.getTableLocations() : null;
        if (tableLocations != null && tableLocations.size() > 0) {
            SiteTypeVolumeID siteTypeVolumeID = tableLocations.get(0);
            if (this._isRoutedFromPrimaryToSecondary(anchor, siteTypeVolumeID)) {
                return true;
            }
            if (this._isRoutedFromSecondaryToPrimary(anchor, siteTypeVolumeID)) {
                throw SQLExceptionSapDB.newInstance("error.invalid.routing", new String[0]);
            }
        } else if (this._parseInfo.getHashPartitionInfo() != null) {
            Map<Integer, SiteTypeVolumeID> partitionMap = this._parseInfo.getHashPartitionInfo().getPartitionAssignmentMap();
            if (partitionMap.size() > 0) {
                int partID = partitionMap.keySet().iterator().next();
                SiteTypeVolumeID siteTypeVolumeID = partitionMap.get(partID);
                if (this._isRoutedFromPrimaryToSecondary(anchor, siteTypeVolumeID)) {
                    return true;
                }
                if (this._isRoutedFromSecondaryToPrimary(anchor, siteTypeVolumeID)) {
                    throw SQLExceptionSapDB.newInstance("error.invalid.routing", new String[0]);
                }
            }
        } else if (this._parseInfo.getRangePartitionInfo() != null) {
            RangeInfo rangeInfo = this._parseInfo.getRangePartitionInfo().getRangeInfoList().get(0);
            SiteTypeVolumeID siteTypeVolumeID = rangeInfo.getSiteTypeVolumeID();
            if (this._isRoutedFromPrimaryToSecondary(anchor, siteTypeVolumeID)) {
                return true;
            }
            if (this._isRoutedFromSecondaryToPrimary(anchor, siteTypeVolumeID)) {
                throw SQLExceptionSapDB.newInstance("error.invalid.routing", new String[0]);
            }
        }
        return false;
    }

    private boolean _isRoutedFromPrimaryToSecondary(Session anchor, SiteTypeVolumeID siteTypeVolumeID) {
        return anchor != null && anchor.isNoneOrPrimarySite() && siteTypeVolumeID.isSecondarySite();
    }

    private boolean _isRoutedFromSecondaryToPrimary(Session anchor, SiteTypeVolumeID siteTypeVolumeID) {
        return anchor != null && anchor.isSecondarySite() && siteTypeVolumeID.isNoneOrPrimary();
    }

    private ParseInfo _doParse(String sql, Session session, boolean isReparse) throws SQLException {
        HReplyPacket replyPacket;
        if (sql == null || sql.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.null", new String[0]);
        }
        ParseInfo parseInfo = isReparse ? this._parseInfo : null;
        try {
            replyPacket = this._prepare(sql, session);
        }
        catch (InternalReconnectException e) {
            session = e.getNewSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
            }
            this._connection.handleTransaction(session, true);
            replyPacket = this._prepare(sql, session);
        }
        catch (InternalFallbackHintRoutedException e) {
            if (session.isHintRouted()) {
                this._connection._handleFailedHintRouted();
                SiteTypeVolumeID siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(session.getSiteVolumeID().getVolumeID());
                try {
                    session = this._connection._getSecondarySession(siteTypeVolumeID);
                    if (session == null) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                }
                catch (SQLException e1) {
                    session = this._connection.getSessionPool().getPrimarySession();
                }
                this._session = session;
                ParseID parseID = this._parseInfo.getParseID(session);
                if (parseID != null) {
                    return this._parseInfo;
                }
            }
            replyPacket = this._prepare(sql, session);
        }
        if (!isReparse) {
            parseInfo = new ParseInfo(sql, replyPacket.getFunctionCode(0), this._connection._getUniqueID());
        }
        ArrayList<AbstractConverter> converters = new ArrayList<AbstractConverter>();
        for (HPartInfo partInfo : replyPacket.parts(0)) {
            switch (partInfo.getPartKind()) {
                case StatementID: {
                    parseInfo.addParseID(session, new ParseID(partInfo.getStatementID()));
                    break;
                }
                case TableLocation: {
                    if (this._connection.isIgnoringTopology()) break;
                    parseInfo.setTableLocations(partInfo.getTableLocations(this._connection.getSessionPool().getSystemInfo().getSiteIDToSiteTypeMap()));
                    break;
                }
                case PartitionInformation: {
                    if (this._connection.isIgnoringTopology()) break;
                    this._setPartitionInfo(partInfo, parseInfo, isReparse, this._connection.getSessionPool().getSystemInfo().getSiteIDToSiteTypeMap());
                    break;
                }
                case ParameterMetaData: {
                    partInfo.getParameterMetaData(this._connection, parseInfo);
                    break;
                }
                case ResultSetMetaData: {
                    partInfo.getResultSetMetaData(this._connection, converters);
                    parseInfo.setResultSetConverters(converters);
                }
            }
        }
        if (session.isHintRouted()) {
            this._connection._handleSuccessHintRouted();
        }
        return parseInfo;
    }

    private void _reparse(Session session) throws SQLException {
        this._doParse(this._parseInfo.getSQL(), session, true);
    }

    private HReplyPacket _prepare(String sql, Session session) throws SQLException {
        HRequestPacket requestPacket = this._connection.initPrepare(session, this._resultSetHoldability, sql);
        HReplyPacket replyPacket = this._connection.exchange(session, requestPacket, this, ConnectionSapDB.ExchangeFlag.IS_PARSE, ConnectionSapDB.ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
        return replyPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _execute(Session session) throws SQLException {
        boolean isQuery;
        SiteTypeVolumeID siteTypeVolumeID;
        this._closeResultSets(true, this._connection.getBooleanConnectionProperty(ConnectionProperty.TRANSACTIONAL_LOBS));
        this._wasCancelled.set(false);
        this._dataPart = null;
        ParseID parseID = this._parseInfo.getParseID(session);
        if (parseID == null) {
            this._reparse(session);
            parseID = this._parseInfo.getParseID(session);
            if (parseID == null && session.isHintRouted()) {
                siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(session.getSiteVolumeID().getVolumeID());
                session = this._connection.getSessionPool().getSession(siteTypeVolumeID);
                if (session != null) {
                    parseID = this._parseInfo.getParseID(session);
                }
                if (parseID == null) {
                    session = this._connection.getSessionPool().getPrimarySession();
                    parseID = this._parseInfo.getParseID(session);
                }
                if (parseID == null) {
                    for (Map.Entry<Session, ParseID> entry : this._parseInfo.getParseIDs().entrySet()) {
                        Session aSession = entry.getKey();
                        ParseID aParseID = entry.getValue();
                        if (!aSession.isPrimarySite() || aParseID == null) continue;
                        parseID = aParseID;
                        break;
                    }
                    if (session == null || parseID == null) {
                        session = this._connection.getSessionPool().getPrimarySession();
                        this._reparse(session);
                        parseID = this._parseInfo.getParseID(session);
                    }
                }
            }
        }
        try {
            boolean truncated = false;
            HRequestPacket requestPacket = this._connection.initExecute(session, this._resultSetHoldability, this._queryTimeout, parseID);
            if (this._parseInfo.getInputParameterCount() > 0) {
                int n = this._parseInfo.getParameterCount();
                for (int i = 1; i <= n; ++i) {
                    AbstractConverter converter = this._parseInfo.getParameterConverter(i);
                    if (!converter.getParameterMode().isInput() || INITIAL_PARAM_VALUE != this._inputArgs[i - 1]) continue;
                    throw new SQLException(MessageTranslator.translate("error.missinginout", String.valueOf(i)), "02000");
                }
                HDataPart dataPart = requestPacket.addParametersPart();
                dataPart.putInputArgs(this._parseInfo.getParameterConverters(), this._inputArgs);
                if (this._parseInfo.hasInputLOB()) {
                    truncated = this._handleStreamsForExecute(dataPart, this._inputArgs);
                }
                dataPart.close();
            }
            if (truncated && this._connection.isAutoCommit()) {
                requestPacket.setAutoCommit(false);
            }
            requestPacket.close();
            ConnectionSapDB i = this._connection;
            synchronized (i) {
                this._connection._cacheOnExecute();
                HReplyPacket replyPacket = this._connection.exchange(session, requestPacket, this, ConnectionSapDB.ExchangeFlag.IS_STATEMENT, this._parseInfo.hasInputLOB() ? ConnectionSapDB.ExchangeFlag.NOP : ConnectionSapDB.ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK, ConnectionSapDB.ExchangeFlag.IS_PREPARED_EXECUTE);
                for (HPartInfo partInfo : replyPacket.parts(0)) {
                    switch (partInfo.getPartKind()) {
                        case PartitionInformation: {
                            if (this._connection.isIgnoringTopology()) break;
                            this._setPartitionInfo(partInfo, this._parseInfo, true, this._connection.getSessionPool().getSystemInfo().getSiteIDToSiteTypeMap());
                            break;
                        }
                        case TableLocation: {
                            if (this._connection.isIgnoringTopology()) break;
                            this._parseInfo.setTableLocations(partInfo.getTableLocations(this._connection.getSessionPool().getSystemInfo().getSiteIDToSiteTypeMap()));
                        }
                    }
                }
                if (this._parseInfo.isSelect()) {
                    isQuery = this._parseResult(session, replyPacket, this._parseInfo.getResultSetConverters(), true);
                } else {
                    int returnCode = replyPacket.findErrorCode(0);
                    if (this._parseInfo.hasInputLOB() && returnCode == 0) {
                        this._rowsAffected = -1;
                        this._hasRowCount = false;
                        replyPacket = this._handleStreamsForPutval(replyPacket, session);
                    }
                    isQuery = this._parseResult(session, replyPacket, this._parseInfo.getResultSetConverters(), false);
                    HDataPart outputParametersPart = replyPacket.findOutputParametersPart(0);
                    if (outputParametersPart != null) {
                        this._dataPart = outputParametersPart;
                        this._dataPart.setDataFormatDescription(this._parseInfo);
                    }
                }
                if (truncated && this._connection.isAutoCommit()) {
                    this._connection._commitInternal();
                }
            }
        }
        catch (InternalReconnectException e) {
            session = e.getNewSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
            }
            this._connection.handleTransaction(session, true);
            this._session = session;
            boolean n = this._execute(session);
            return n;
        }
        catch (InternalFallbackHintRoutedException e1) {
            if (session.isHintRouted()) {
                if (e1.getMessage() == null || !e1.getMessage().equals("FallbackFlag")) {
                    this._connection._handleFailedHintRouted();
                }
                siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(session.getSiteVolumeID().getVolumeID());
                try {
                    session = this._connection._getSecondarySession(siteTypeVolumeID);
                    if (session == null) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                }
                catch (SQLException e) {
                    session = this._connection.getSessionPool().getPrimarySession();
                }
                this._session = session;
            }
            boolean bl = this._execute(session);
            return bl;
        }
        finally {
            this._wasCancelled.set(false);
        }
        if (session.isHintRouted()) {
            this._connection._handleSuccessHintRouted();
        }
        return isQuery;
    }

    private boolean _handleStreamsForExecute(HDataPart dataPart, Object[] inputArgs) throws SQLException {
        boolean wasTruncated = false;
        this._putvals = new ArrayList<AbstractPutval>();
        int n = this._parseInfo.getParameterCount();
        for (int i = 1; i <= n; ++i) {
            AbstractConverter converter = this._parseInfo.getParameterConverter(i);
            Object inputArg = inputArgs[i - 1];
            if (!converter.isLOB() || !(inputArg instanceof AbstractPutval)) continue;
            this._putvals.add((AbstractPutval)inputArg);
        }
        Collections.sort(this._putvals, PUTVAL_COMPARATOR);
        for (AbstractPutval putval : this._putvals) {
            if (putval.isEOF() && (putval = putval.cloneForBatch()).isEOF()) {
                throw SQLExceptionSapDB.newInstance("error.stream.isatend", new String[0]);
            }
            putval.transferData(true, dataPart);
            if (!putval.isEOF()) {
                wasTruncated = true;
            }
            putval.setLocatorIDStale();
        }
        return wasTruncated;
    }

    private HReplyPacket _handleStreamsForPutval(HReplyPacket replyPacket, Session session) throws SQLException {
        if (this._putvals == null || this._putvals.isEmpty()) {
            return replyPacket;
        }
        for (HPartInfo partInfo : replyPacket.parts(0)) {
            if (partInfo.getPartKind() != PartKind.RowsAffected) continue;
            if (this._parseInfo.isSelect()) break;
            this._rowsAffected = partInfo.getRowsAffected();
            this._hasRowCount = true;
            break;
        }
        int putvalCount = this._putvals.size();
        AbstractPutval lastPutval = this._putvals.get(putvalCount - 1);
        int firstOpenPutval = 0;
        if (!lastPutval.isEOF()) {
            this._getChangedPutvalDescriptors(replyPacket);
        }
        while (!lastPutval.isEOF()) {
            HRequestPacket requestPacket = this._connection.initWriteLOB(session);
            HDataPart dataPart = requestPacket.addWriteLOBRequestPart();
            int putvalsHandled = 0;
            for (int i = firstOpenPutval; i < putvalCount && dataPart.canAddLOBDescriptor(21); ++i) {
                AbstractPutval putval = this._putvals.get(i);
                if (putval.isEOF() || putval.isLocatorIDStale()) {
                    ++firstOpenPutval;
                    continue;
                }
                putval.putDescriptor(false, dataPart);
                ++putvalsHandled;
                if (this._wasCancelled.get()) {
                    putval.markEOF();
                    ++firstOpenPutval;
                    continue;
                }
                putval.transferData(false, dataPart);
                if (!putval.isEOF()) continue;
                ++firstOpenPutval;
            }
            if (putvalsHandled == 0) {
                return replyPacket;
            }
            dataPart.close(putvalsHandled);
            requestPacket.close();
            replyPacket = this._connection.exchange(session, requestPacket, this, ConnectionSapDB.ExchangeFlag.NOP, ConnectionSapDB.ExchangeFlag.IS_PREPARED_EXECUTE);
        }
        if (this._wasCancelled.get()) {
            throw SQLExceptionSapDB.newInstance("error.statement.cancelled", new String[0]);
        }
        return replyPacket;
    }

    private void _getChangedPutvalDescriptors(HReplyPacket replyPacket) throws SQLException {
        byte[][] descriptors = replyPacket.findLOBLocators(0);
        int descriptorCount = descriptors.length;
        int descriptorIndex = 0;
        for (AbstractPutval putval : this._putvals) {
            if (putval.isEOF()) continue;
            if (descriptorIndex >= descriptorCount) {
                throw SQLExceptionSapDB.newInstance("error.internal.LOBDescriptorMissing", new String[0]);
            }
            putval.setLocatorID(descriptors[descriptorIndex++]);
        }
        if (descriptorIndex < descriptorCount) {
            throw SQLExceptionSapDB.newInstance("error.internal.ToManyLOBDescriptors", new String[0]);
        }
    }

    private void _addPreparedBatch() {
        ++this._batchSize;
        if (this._isClientRouting()) {
            List<Object> items;
            SiteTypeVolumeID siteTypeVolumeID = this._computeVolumeID();
            if (this._batchVolumeMap == null) {
                this._batchVolumeMap = new HashMap<SiteTypeVolumeID, List<Object>>();
            }
            if ((items = this._batchVolumeMap.get(siteTypeVolumeID)) == null) {
                items = new ArrayList<Object>();
                this._batchVolumeMap.put(siteTypeVolumeID, items);
            }
            items.add(this._inputArgs);
        } else {
            if (this._batchItems == null) {
                this._batchItems = new ArrayList<Object>();
            }
            this._batchItems.add(this._inputArgs);
        }
        int parameterCount = this._parseInfo.getParameterCount();
        Object[] nextRow = new Object[parameterCount];
        for (int i = 1; i <= parameterCount; ++i) {
            AbstractConverter converter = this._parseInfo.getParameterConverter(i);
            nextRow[i - 1] = converter.cloneObjectForBatch(this._inputArgs[i - 1]);
        }
        this._inputArgs = nextRow;
    }

    private void _clearPreparedBatch() {
        if (this._batchItems != null) {
            this._batchItems.clear();
        }
        if (this._batchVolumeMap != null) {
            this._batchVolumeMap.clear();
        }
        this._batchSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] _executePreparedBatch() throws SQLException {
        int[] updateCounts;
        ConnectionSapDB connectionSapDB = this._connection;
        synchronized (connectionSapDB) {
            this._connection._cacheOnExecute();
            if (this._isClientRouting() && this._batchVolumeMap != null && !this._batchVolumeMap.isEmpty()) {
                updateCounts = new int[this._batchSize];
                int itemCount = 0;
                for (Map.Entry<SiteTypeVolumeID, List<Object>> entry : this._batchVolumeMap.entrySet()) {
                    Session session;
                    SiteTypeVolumeID siteTypeVolumeID = entry.getKey();
                    List<Object> items = entry.getValue();
                    if (items.isEmpty()) continue;
                    if (this._batchItems == null) {
                        this._batchItems = new ArrayList<Object>();
                    } else {
                        this._batchItems.clear();
                    }
                    this._batchItems.addAll(items);
                    if (siteTypeVolumeID.isValid()) {
                        session = this._getSession(siteTypeVolumeID);
                        if (this._parseInfo.getParseID(session) == null) {
                            this._reparse(session);
                        }
                    } else {
                        session = this._getSession(false, true);
                    }
                    this._session = session;
                    int[] subsetUpdateCounts = this._executePreparedBatch(session);
                    System.arraycopy(subsetUpdateCounts, 0, updateCounts, itemCount, subsetUpdateCounts.length);
                    itemCount += subsetUpdateCounts.length;
                }
                this._batchSize = 0;
                this._batchVolumeMap.clear();
            } else {
                Session session = this._isClientRoutingByHashWithoutSplit() ? this._getSession(this._computeVolumeIDForHash()) : (this._isClientRoutingByRangeWithoutSplit() ? this._getSession(this._computeVolumeIDForRange()) : this._getSession(false, true));
                updateCounts = this._executePreparedBatch(session);
                this._batchSize = 0;
            }
        }
        return updateCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] _executePreparedBatch(Session session) throws SQLException {
        block23: {
            block22: {
                this._assertOpen();
                this._serverProcessingTime = 0L;
                parseID = this._parseInfo.getParseID(session);
                if (parseID == null) {
                    this._reparse(session);
                    parseID = this._parseInfo.getParseID(session);
                }
                if (this._parseInfo.isSelect()) {
                    throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchresultset", new Object[0]), new int[0]);
                }
                if (this._parseInfo.getFunctionCode() == FunctionCode.DBProcedureCall || this._parseInfo.getFunctionCode() == FunctionCode.DBProcedureCallWithResultSet) {
                    for (AbstractConverter converter : this._parseInfo.getParameterConverters()) {
                        if (!converter.getParameterMode().isOutput()) continue;
                        throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchprocout", new Object[0]), new int[0]);
                    }
                }
                if (this._batchItems == null) return new int[0];
                if (this._batchItems.isEmpty()) {
                    return new int[0];
                }
                localBatchItems = new ArrayList<Object>(this._batchItems);
                this._batchItems.clear();
                this._wasCancelled.set(false);
                count = localBatchItems.size();
                inputCursor = 0;
                noError = true;
                executeCount = -1;
                result = new int[count];
                this._rowsAffected = -1;
                truncated = false;
lbl27:
                // 3 sources

                while (true) {
                    if (inputCursor < count && noError) {
                        firstRecordNo = inputCursor;
                        requestPacket = this._connection.initExecute(session, this._resultSetHoldability, this._queryTimeout, parseID);
                        dataPart = requestPacket.addParametersPart();
                        if (executeCount == -1) {
                            requestPacket.addPartAttribute(PartAttribute.FirstPacket);
                        }
                        break block22;
                    }
                    if (truncated == false) return result;
                    if (this._connection.isAutoCommit() == false) return result;
                    this._connection._commitInternal();
                    return result;
                }
                finally {
                    this._wasCancelled.set(false);
                }
            }
            rowcnt = 0;
            do {
                row = (Object[])localBatchItems.get(inputCursor);
                n = this._parseInfo.getParameterCount();
                for (i = 1; i <= n; ++i) {
                    converter = this._parseInfo.getParameterConverter(i);
                    if (!converter.getParameterMode().isInput() || "initParam" != row[i - 1]) continue;
                    this._makeBatchCountArray(result, new int[0], firstRecordNo, count - firstRecordNo, -3);
                    throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchmissingin", new Object[]{Integer.toString(inputCursor + 1), Integer.toString(i)}), "0200", result);
                }
                if (!dataPart.putInputArgs(this._parseInfo.getParameterConverters(), row)) break;
                ++rowcnt;
                if (!this._parseInfo.hasInputLOB()) continue;
                looptruncated = this._handleStreamsForExecute(dataPart, row);
                if (looptruncated) {
                    truncated = true;
                }
                if (!truncated || !this._connection.isAutoCommit()) continue;
                requestPacket.setAutoCommit(false);
            } while (++inputCursor < count);
            if (inputCursor == count) {
                requestPacket.addPartAttribute(PartAttribute.LastPacket);
            }
            dataPart.close(inputCursor - firstRecordNo);
            if (rowcnt <= 0) ** GOTO lbl27
            try {
                requestPacket.close();
                replyPacket = this._connection.exchange(session, requestPacket, this, new ConnectionSapDB.ExchangeFlag[]{this._parseInfo.hasInputLOB() != false ? ConnectionSapDB.ExchangeFlag.NOP : ConnectionSapDB.ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK, ConnectionSapDB.ExchangeFlag.IS_PREPARED_EXECUTE});
            }
            catch (InternalReconnectException e) {
                session = e.getNewSession();
                if (session != null && session.isConnected()) {
                    this._connection.handleTransaction(session, true);
                    this._batchItems.addAll(localBatchItems);
                    i = this._executePreparedBatch(session);
                    this._wasCancelled.set(false);
                    return i;
                }
                throw SQLExceptionSapDB.newInstance("error.objectisclosed", new String[]{this.toString()});
            }
            catch (SQLException dbExc) {
                specific = (SQLExceptionSapDBInterface)dbExc;
                if (!this._connection.isAutoCommit()) {
                    this._rowsAffected = this._rowsAffected > 0 ? (this._rowsAffected += specific.getErrorPos() - 1) : specific.getErrorPos() - 1;
                }
                updateCounts = ((SQLExceptionSapDBInterface)dbExc).getUpdateCountsFromLastPacket();
                this._makeBatchCountArray(result, updateCounts, firstRecordNo, count - firstRecordNo, -3);
                throw new BatchUpdateExceptionSapDB(result, dbExc, (Integer)(inputCursor + 1));
            }
            executeCount = replyPacket.findRowsAffected(0);
            updateCounts = replyPacket.findBatchUpdateCounts(0);
            processingTime = replyPacket.findServerExecutionTime(0);
            if (this._serverProcessingTime != -1L) {
                this._serverProcessingTime = processingTime < 0L ? processingTime : (this._serverProcessingTime += processingTime);
            }
            if (!this._parseInfo.hasInputLOB()) break block23;
            this._handleStreamsForPutval(replyPacket, session);
        }
        this._makeBatchCountArray(result, updateCounts, firstRecordNo, inputCursor - firstRecordNo, -2);
        this._rowsAffected = executeCount;
        ** while (true)
    }

    private void _makeBatchCountArray(int[] resultArr, int[] updateCounts, int chunkOffset, int chunkLen, int defaultValue) {
        if (updateCounts == null) {
            for (int i = 0; i < chunkLen; ++i) {
                resultArr[chunkOffset + i] = defaultValue;
            }
        } else {
            for (int i = 0; i < chunkLen; ++i) {
                resultArr[chunkOffset + i] = i < updateCounts.length ? updateCounts[i] : defaultValue;
            }
        }
    }

    private boolean _isClientRouting() {
        return this._isClientRoutingByHash() || this._isClientRoutingByRange();
    }

    private boolean _isClientRoutingByHash() {
        if (!this._parseInfo.isHashPartitioned()) {
            return false;
        }
        return this._batchSize == 0 || this._parseInfo.getFunctionCode() == FunctionCode.Insert && this._connection.getBooleanConnectionProperty(ConnectionProperty.SPLIT_BATCH_COMMANDS) && this._parseInfo.getHashPartitionInfo().getPartitionMethod() == PartitionMethod.Hash;
    }

    private boolean _isClientRoutingByRange() {
        if (!this._parseInfo.isRangePartitioned()) {
            return false;
        }
        return this._batchSize == 0;
    }

    private boolean _isClientRoutingByHashWithoutSplit() {
        if (!this._parseInfo.isHashPartitioned()) {
            return false;
        }
        return this._parseInfo.getFunctionCode() == FunctionCode.Insert && this._parseInfo.getHashPartitionInfo().getPartitionMethod() == PartitionMethod.HashWithoutSplitBatch;
    }

    private boolean _isClientRoutingByRangeWithoutSplit() {
        if (!this._parseInfo.isRangePartitioned()) {
            return false;
        }
        return this._parseInfo.getFunctionCode() == FunctionCode.Insert && this._parseInfo.getRangePartitionInfo().getPartitionMethod() == PartitionMethod.RangeWithoutSplitBatch;
    }

    private String _translateDecimalForHashing(String s, int parameterIndex) throws SQLException {
        if (s.trim().isEmpty()) {
            return INITIAL_PARAM_VALUE;
        }
        return this._translateDecimalForHashing(new BigDecimal(s), parameterIndex);
    }

    private String _translateDecimalForHashing(BigDecimal bigDecimal, int parameterIndex) throws SQLException {
        int scale = this._getParameterConverter(parameterIndex).getScale();
        if (bigDecimal.scale() > scale) {
            return INITIAL_PARAM_VALUE;
        }
        DecimalFormat decimalFormat = DECIMAL_FORMAT.get();
        decimalFormat.setMaximumFractionDigits(scale);
        decimalFormat.setMinimumFractionDigits(scale);
        return decimalFormat.format(bigDecimal);
    }

    private SiteTypeVolumeID _getPrimarySiblingSiteVolumeID(int volumeID) {
        Session anchor = this._connection.getSessionPool().getAnchorSession();
        if (!this._connection.getDistributionMode().isStatementRouting() || anchor == null) {
            return new SiteTypeVolumeID(SiteType.PRIMARY, this._connection.getSessionPool().getPrimarySession().getSiteVolumeID().getVolumeID());
        }
        return new SiteTypeVolumeID(SiteType.PRIMARY, volumeID);
    }

    private SiteTypeVolumeID _computeVolumeID() {
        if (this._isClientRoutingByHash()) {
            try {
                return this._computeVolumeIDForHash();
            }
            catch (SQLException e) {
                return new SiteTypeVolumeID(SiteType.NONE, -1);
            }
        }
        if (this._isClientRoutingByRange()) {
            try {
                return this._computeVolumeIDForRange();
            }
            catch (SQLException e) {
                return new SiteTypeVolumeID(SiteType.NONE, -1);
            }
        }
        return new SiteTypeVolumeID(SiteType.NONE, -1);
    }

    private SiteTypeVolumeID _computeVolumeIDForHash() throws SQLException {
        HashPartitionInfo hashPartitionInfo = this._parseInfo.getHashPartitionInfo();
        if (hashPartitionInfo == null || this._rawInputArgs == null || this._rawInputArgs.length == 0) {
            return new SiteTypeVolumeID(SiteType.NONE, -1);
        }
        int parameterCount = hashPartitionInfo.getParameterCount();
        int partitionCount = hashPartitionInfo.getPartitionCount();
        List<PartitionParameterInfo> partitionParameterInfoList = hashPartitionInfo.getPartitionParameterInfoList();
        if (parameterCount <= 0 || partitionCount <= 0 || partitionParameterInfoList == null || partitionParameterInfoList.size() != parameterCount) {
            return new SiteTypeVolumeID(SiteType.NONE, -1);
        }
        int partindex = 0;
        int flag = -1;
        for (int i = 0; i < parameterCount; ++i) {
            PartitionParameterFunction partitionParameterFunction;
            PartitionParameterInfo partitionParameterInfo = partitionParameterInfoList.get(i);
            int parameterIndex = partitionParameterInfo.getParameterIndex();
            String value = (String)this._rawInputArgs[parameterIndex - 1];
            if (value == null || value.equals(INITIAL_PARAM_VALUE)) continue;
            if (this._getParameterConverter(parameterIndex).getColumnType() == 93 && (value = this._convertTimestampForPartitioning(value, partitionParameterFunction = partitionParameterInfo.getPartitionParameterFunction(), true)) == null) {
                return new SiteTypeVolumeID(SiteType.NONE, -1);
            }
            long hashVal = Hash.calculateHash(value);
            flag = 0;
            if ((partindex += (int)(hashVal % (long)partitionCount)) < partitionCount) continue;
            partindex %= partitionCount;
        }
        if (flag == -1) {
            return new SiteTypeVolumeID(SiteType.NONE, -1);
        }
        SiteTypeVolumeID siteTypeVolumeID = this._parseInfo.getHashPartitionInfo().getPartitionAssignmentMap().get(partindex + 1);
        if (siteTypeVolumeID == null) {
            return new SiteTypeVolumeID(SiteType.NONE, -1);
        }
        return siteTypeVolumeID;
    }

    private SiteTypeVolumeID _computeVolumeIDForRange() throws SQLException {
        RangePartitionInfo rangePartitionInfo = this._parseInfo.getRangePartitionInfo();
        if (rangePartitionInfo == null || this._rawInputArgs == null || this._rawInputArgs.length == 0) {
            return new SiteTypeVolumeID(SiteType.NONE, -1);
        }
        int parameterCount = rangePartitionInfo.getParameterCount();
        int rangeCount = rangePartitionInfo.getRangeCount();
        List<PartitionParameterInfo> partitionParameterInfoList = rangePartitionInfo.getPartitionParameterInfoList();
        List<RangeInfo> rangeInfoList = rangePartitionInfo.getRangeInfoList();
        if (parameterCount <= 0 || rangeCount <= 0 || partitionParameterInfoList == null || partitionParameterInfoList.size() != parameterCount || rangeInfoList.size() != rangeCount) {
            return new SiteTypeVolumeID(SiteType.NONE, -1);
        }
        RangeVoteCentre voteCentre = new RangeVoteCentre();
        block12: for (PartitionParameterInfo partitionParameterInfo : partitionParameterInfoList) {
            int parameterIndex = partitionParameterInfo.getParameterIndex();
            Object value = this._rawInputArgs[parameterIndex - 1];
            if (value == null) {
                RangeInfo rangeInfo = rangeInfoList.get(rangeCount - 1);
                if (!rangeInfo.isRestRange()) continue;
                voteCentre.vote(rangeCount - 1, rangeInfo);
                continue;
            }
            if (value instanceof String && value.equals(INITIAL_PARAM_VALUE)) continue;
            switch (this._getParameterConverter(parameterIndex).getColumnType()) {
                case 93: {
                    PartitionParameterFunction partitionParameterFunction = partitionParameterInfo.getPartitionParameterFunction();
                    Timestamp timestamp = (Timestamp)value;
                    String timestampString = this._convertTimestampForPartitioning(timestamp.toString(), partitionParameterFunction, false);
                    if (timestampString == null) continue block12;
                    value = Long.valueOf(timestampString);
                    break;
                }
                case -15: {
                    if (partitionParameterInfo.getAttributeType() != 67) break;
                    value = ((String)value).replaceAll("\\s+$", "");
                }
            }
            boolean expressVoting = false;
            boolean done = false;
            RangeComparisonFunction rangeComparisonFunction = partitionParameterInfo.getRangeComparisonFunction();
            block13: for (int j = 0; j < rangeCount && !done; ++j) {
                RangeInfo rangeInfo = rangeInfoList.get(j);
                if (expressVoting) {
                    voteCentre.vote(j, rangeInfo);
                    continue;
                }
                switch (rangeComparisonFunction) {
                    case EQ: {
                        if (!this._rangeEqualComparison(rangeInfo, value, parameterIndex)) continue block13;
                        voteCentre.vote(j, rangeInfo);
                        done = true;
                        continue block13;
                    }
                    case LE: {
                        if (this._rangeLessThanEqualComparison(rangeInfo, value, parameterIndex)) {
                            voteCentre.vote(j, rangeInfo);
                            continue block13;
                        }
                        RangeInfo lastRangeInfo = rangeInfoList.get(rangeCount - 1);
                        if (lastRangeInfo.isRestRange()) {
                            voteCentre.vote(rangeCount - 1, lastRangeInfo);
                        }
                        done = true;
                        continue block13;
                    }
                    case LT: {
                        if (this._rangeLessThanComparison(rangeInfo, value, parameterIndex)) {
                            voteCentre.vote(j, rangeInfo);
                            continue block13;
                        }
                        RangeInfo lastRangeInfo = rangeInfoList.get(rangeCount - 1);
                        if (lastRangeInfo.isRestRange()) {
                            voteCentre.vote(rangeCount - 1, lastRangeInfo);
                        }
                        done = true;
                        continue block13;
                    }
                    case GE: {
                        if (!this._rangeGreaterThanEqualComparison(rangeInfo, value, parameterIndex)) continue block13;
                        voteCentre.vote(j, rangeInfo);
                        expressVoting = true;
                        continue block13;
                    }
                    case GT: {
                        if (!this._rangeGreaterThanComparison(rangeInfo, value, parameterIndex)) continue block13;
                        voteCentre.vote(j, rangeInfo);
                        expressVoting = true;
                        continue block13;
                    }
                    case NE: {
                        if (this._rangeLessThanComparison(rangeInfo, value, parameterIndex) || this._rangeGreaterThanComparison(rangeInfo, value, parameterIndex)) {
                            voteCentre.vote(j, rangeInfo);
                            if (!this._rangeEqualComparison(rangeInfo, value, parameterIndex)) continue block13;
                            expressVoting = true;
                            continue block13;
                        }
                        expressVoting = true;
                    }
                }
            }
        }
        return voteCentre.getTopSiteTypeVolumeID();
    }

    private String _convertTimestampForPartitioning(String timestampString, PartitionParameterFunction partitionParameterFunction, boolean needDashes) {
        Timestamp timestamp;
        if (timestampString == null || timestampString.trim().isEmpty() || partitionParameterFunction == null) {
            return null;
        }
        String sep = needDashes ? "-" : "";
        Calendar calendar = CALENDAR.get();
        try {
            timestamp = Timestamp.valueOf(timestampString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        calendar.setTime(timestamp);
        switch (partitionParameterFunction) {
            case None: {
                return String.format("%04d%s%02d%s%02d", calendar.get(1), sep, calendar.get(2) + 1, sep, calendar.get(5));
            }
            case Year: {
                return String.format("%04d", calendar.get(1));
            }
            case Month: {
                return String.format("%04d%s%02d", calendar.get(1), sep, calendar.get(2) + 1);
            }
        }
        return null;
    }

    private boolean _rangeEqualComparison(RangeInfo rangeInfo, Object value, int paramIndex) throws SQLException {
        if (rangeInfo.isRestRange()) {
            return true;
        }
        switch (this._getParameterConverter(paramIndex).getColumnType()) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 93: {
                long longValue = (Long)value;
                long longFloor = rangeInfo.getLongFloor();
                if (rangeInfo.getMultiValueRange() == 1) {
                    return longFloor <= longValue && longValue < rangeInfo.getLongCeil();
                }
                return longFloor == longValue;
            }
            case 3: {
                BigDecimal bdValue = (BigDecimal)value;
                BigDecimal bdFloor = rangeInfo.getBdFloor();
                if (rangeInfo.getMultiValueRange() == 1) {
                    return bdFloor.compareTo(bdValue) <= 0 && bdValue.compareTo(rangeInfo.getBdCeil()) < 0;
                }
                return bdFloor.compareTo(bdValue) == 0;
            }
            case -15: 
            case -9: 
            case 12: {
                String stringValue = (String)value;
                String stringFloor = rangeInfo.getStringFloor();
                if (rangeInfo.getMultiValueRange() == 1) {
                    return stringFloor.compareTo(stringValue) <= 0 && stringValue.compareTo(rangeInfo.getStringCeil()) < 0;
                }
                return stringFloor.compareTo(stringValue) == 0;
            }
        }
        return false;
    }

    private boolean _rangeLessThanEqualComparison(RangeInfo rangeInfo, Object value, int paramIndex) throws SQLException {
        if (rangeInfo.isRestRange()) {
            return true;
        }
        switch (this._getParameterConverter(paramIndex).getColumnType()) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 93: {
                return rangeInfo.getLongFloor() <= (Long)value;
            }
            case 3: {
                return rangeInfo.getBdFloor().compareTo((BigDecimal)value) <= 0;
            }
            case -15: 
            case -9: 
            case 12: {
                return rangeInfo.getStringFloor().compareTo((String)value) <= 0;
            }
        }
        return false;
    }

    private boolean _rangeLessThanComparison(RangeInfo rangeInfo, Object value, int paramIndex) throws SQLException {
        if (rangeInfo.isRestRange()) {
            return true;
        }
        switch (this._getParameterConverter(paramIndex).getColumnType()) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 93: {
                return rangeInfo.getLongFloor() < (Long)value;
            }
            case 3: {
                return rangeInfo.getBdFloor().compareTo((BigDecimal)value) < 0;
            }
            case -15: 
            case -9: 
            case 12: {
                return rangeInfo.getStringFloor().compareTo((String)value) < 0;
            }
        }
        return false;
    }

    private boolean _rangeGreaterThanEqualComparison(RangeInfo rangeInfo, Object value, int paramIndex) throws SQLException {
        if (rangeInfo.isRestRange()) {
            return true;
        }
        switch (this._getParameterConverter(paramIndex).getColumnType()) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 93: {
                long longValue = (Long)value;
                if (rangeInfo.getMultiValueRange() == 1) {
                    return rangeInfo.getLongCeil() > longValue;
                }
                return rangeInfo.getLongFloor() >= longValue;
            }
            case 3: {
                BigDecimal bdValue = (BigDecimal)value;
                if (rangeInfo.getMultiValueRange() == 1) {
                    return rangeInfo.getBdCeil().compareTo(bdValue) > 0;
                }
                return rangeInfo.getBdFloor().compareTo(bdValue) >= 0;
            }
            case -15: 
            case -9: 
            case 12: {
                String stringValue = (String)value;
                if (rangeInfo.getMultiValueRange() == 1) {
                    return rangeInfo.getStringCeil().compareTo(stringValue) > 0;
                }
                return rangeInfo.getStringFloor().compareTo(stringValue) >= 0;
            }
        }
        return false;
    }

    private boolean _rangeGreaterThanComparison(RangeInfo rangeInfo, Object value, int paramIndex) throws SQLException {
        if (rangeInfo.isRestRange()) {
            return true;
        }
        switch (this._getParameterConverter(paramIndex).getColumnType()) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 93: {
                long longValue = (Long)value;
                if (rangeInfo.getMultiValueRange() == 1) {
                    return rangeInfo.getLongCeil() > longValue + 1L;
                }
                return rangeInfo.getLongFloor() > longValue;
            }
            case 3: {
                BigDecimal bdValue = (BigDecimal)value;
                if (rangeInfo.getMultiValueRange() == 1) {
                    int scale = this._getParameterConverter(paramIndex).getScale();
                    BigDecimal minValue = BigDecimal.valueOf(Math.pow(0.1, scale)).setScale(scale, RoundingMode.FLOOR);
                    return rangeInfo.getBdCeil().compareTo(bdValue.add(minValue)) > 0;
                }
                return rangeInfo.getBdFloor().compareTo(bdValue) > 0;
            }
            case -15: 
            case -9: 
            case 12: {
                String stringValue = (String)value;
                if (rangeInfo.getMultiValueRange() == 1) {
                    return rangeInfo.getStringCeil().compareTo(stringValue) > 0;
                }
                return rangeInfo.getStringFloor().compareTo(stringValue) > 0;
            }
        }
        return false;
    }

    private void _setPartitionInfo(HPartInfo partInfo, ParseInfo parseInfo, boolean isReparse, Map<Byte, SiteType> siteIDToSiteTypeMap) {
        switch (partInfo.getPartitionMethod()) {
            case Hash: 
            case HashWithoutSplitBatch: {
                HashPartitionInfo hashPartitionInfo = partInfo.getHashPartitionInfo(siteIDToSiteTypeMap);
                if (hashPartitionInfo == null) {
                    return;
                }
                parseInfo.setHashPartitionInfo(hashPartitionInfo);
                break;
            }
            case Range: 
            case RangeWithoutSplitBatch: {
                RangePartitionInfo rangePartitionInfo;
                if (!isReparse) {
                    this._computedVolumeID.set(-2);
                }
                if ((rangePartitionInfo = partInfo.getRangePartitionInfo(siteIDToSiteTypeMap)) == null) {
                    return;
                }
                parseInfo.setRangePartitionInfo(rangePartitionInfo);
            }
        }
    }

    public synchronized SiteVolumeID getSiteVolumeID() {
        return this._session.getSiteVolumeID();
    }

    public synchronized Session getSession() {
        return this._session;
    }

    public ParseInfo getParseInfo() {
        return this._parseInfo;
    }

    public List<SiteTypeVolumeID> getTableLocations() {
        return this._parseInfo.getTableLocations();
    }

    public HashPartitionInfo getHashPartitionInfo() {
        return this._parseInfo.getHashPartitionInfo();
    }

    public RangePartitionInfo getRangePartitionInfo() {
        return this._parseInfo.getRangePartitionInfo();
    }

    public synchronized Map<SiteTypeVolumeID, List<Object>> getBatchVolumeMap() {
        return this._batchVolumeMap != null ? Collections.unmodifiableMap(this._batchVolumeMap) : Collections.emptyMap();
    }

    public int getComputedVolumeID() {
        return this._computedVolumeID.get();
    }

    private static class PutvalComparator
    implements Comparator<AbstractPutval> {
        private PutvalComparator() {
        }

        @Override
        public int compare(AbstractPutval p1, AbstractPutval p2) {
            int inputFieldPos1 = p1.getInputFieldPos();
            int inputFieldPos2 = p2.getInputFieldPos();
            return inputFieldPos1 - inputFieldPos2;
        }
    }
}

