/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.HanaWebSocket;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.Topologies;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.Base64Utils;
import com.sap.db.util.CharsetUtils;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.SSLUtils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

@NotThreadSafe
public class SecureSession
extends Session {
    static final SessionFactory SECURE_SESSION_FACTORY = new SessionFactory(){

        @Override
        public Session newInstance(ConnectionSapDB connection, Address address, boolean doConnectExchange) throws RTEException {
            ConnectionProperties connectionProperties = connection.getConnectionProperties();
            try {
                SecureSession initialSession = new SecureSession(connection, address);
                initialSession._doInfoExchange();
                Session returnedSession = doConnectExchange ? initialSession._doConnectExchange(SECURE_SESSION_FACTORY, connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME)) : initialSession;
                Topologies.setUnreachable(address, false);
                return returnedSession;
            }
            catch (RTEException e) {
                Topologies.setUnreachable(address, true);
                throw e;
            }
        }
    };
    private final boolean _validateCertificate;
    private final String _hostNameInCertificate;
    private final String _keyStore;
    private final String _keyStoreType;
    private final String _keyStorePasswd;
    private final String _sslKeyStore;
    private final String _trustStore;
    private final String _trustStoreType;
    private final String _trustStorePasswd;
    private final String _sslTrustStore;
    private final String _sniHostname;
    @GuardedBy(value="_connection (implicit)")
    private final Socket _socket;
    @GuardedBy(value="_connection (implicit)")
    private final HanaWebSocket _webSocket;
    @GuardedBy(value="_connection (implicit)")
    private final InputStream _inputStream;
    @GuardedBy(value="_connection (implicit)")
    private final OutputStream _outputStream;

    SecureSession(ConnectionSapDB connection, Address address) throws RTEException {
        super(connection, address);
        this._validateCertificate = this._connectionProperties.getBooleanProperty(ConnectionProperty.VALIDATE_CERTIFICATE);
        this._hostNameInCertificate = this._connectionProperties.getProperty(ConnectionProperty.HOST_NAME_IN_CERTIFICATE);
        this._keyStore = this._connectionProperties.getProperty(ConnectionProperty.KEY_STORE);
        this._keyStoreType = this._connectionProperties.getProperty(ConnectionProperty.KEY_STORE_TYPE);
        this._keyStorePasswd = this._connectionProperties.getProperty(ConnectionProperty.KEY_STORE_PASSWD);
        this._sslKeyStore = this._connectionProperties.getProperty(ConnectionProperty.SSL_KEY_STORE);
        this._trustStore = this._connectionProperties.getProperty(ConnectionProperty.TRUST_STORE);
        this._trustStoreType = this._connectionProperties.getProperty(ConnectionProperty.TRUST_STORE_TYPE);
        this._trustStorePasswd = this._connectionProperties.getProperty(ConnectionProperty.TRUST_STORE_PASSWD);
        this._sslTrustStore = this._connectionProperties.getProperty(ConnectionProperty.SSL_TRUST_STORE);
        this._sniHostname = this._connectionProperties.getProperty(ConnectionProperty.SNI_HOSTNAME);
        HanaWebSocket[] webSocketOutputParm = new HanaWebSocket[1];
        try {
            this._socket = this._openSocket(webSocketOutputParm);
            this._webSocket = webSocketOutputParm[0];
            this._inputStream = this._socket.getInputStream();
            this._outputStream = this._socket.getOutputStream();
        }
        catch (IOException e) {
            this.destroy();
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", address.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
    }

    @Override
    protected Socket _getSocket() {
        return this._socket;
    }

    @Override
    protected HanaWebSocket _getWebSocket() {
        return this._webSocket;
    }

    @Override
    protected InputStream _getInputStream() {
        return this._inputStream;
    }

    @Override
    protected OutputStream _getOutputStream() {
        return this._outputStream;
    }

    private Socket _openSocket(HanaWebSocket[] webSocketOutputParm) throws RTEException {
        Socket socket = null;
        HanaWebSocket webSocket = null;
        Address address = (Address)this._address.get();
        String host = address.getHost();
        int port = address.getPort();
        String webSocketUrl = this._connectionProperties.getProperty(ConnectionProperty.WEB_SOCKET_URL);
        boolean isWebSocket = !webSocketUrl.isEmpty();
        String proxyHostName = this._connectionProperties.getProperty(ConnectionProperty.PROXY_HOST_NAME);
        SSLContext sc = null;
        SSLEngine sslEngine = null;
        SSLSocket sslSocket = null;
        try {
            Certificate[] certs;
            SSLSocketFactory factory;
            if (!this._validateCertificate) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                factory = sc.getSocketFactory();
            } else if (this._isSystemDefaultUsed()) {
                factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            } else {
                KeyManagerFactory kmf = this._getKeyManagerFactory(host);
                TrustManagerFactory tmf = this._getTrustManagerFactory(host);
                Object[] km = null;
                TrustManager[] tm = null;
                if (kmf != null) {
                    km = kmf.getKeyManagers();
                }
                if (tmf != null) {
                    tm = tmf.getTrustManagers();
                }
                sc = SSLContext.getInstance("TLS");
                sc.init((KeyManager[])km, tm, new SecureRandom());
                factory = sc.getSocketFactory();
            }
            if (isWebSocket) {
                if (sc == null) {
                    sc = SSLContext.getInstance("TLS");
                    sc.init(null, null, new SecureRandom());
                }
                Proxy proxy = null;
                Authenticator authenticator = null;
                if (!proxyHostName.isEmpty()) {
                    String proxyUserName;
                    int proxyPort = this._connectionProperties.getIntProperty(ConnectionProperty.PROXY_PORT);
                    char[] proxyPassword = this._connectionProperties.getProperty(ConnectionProperty.PROXY_PASSWD).toCharArray();
                    String proxyScpAccount = this._connectionProperties.getProperty(ConnectionProperty.PROXY_SCP_ACCOUNT);
                    if (!proxyScpAccount.isEmpty()) {
                        int idx = proxyScpAccount.indexOf(46);
                        if (idx != -1) {
                            byte[] leftPart = proxyScpAccount.substring(0, idx - 1).getBytes(CharsetUtils.US_ASCII);
                            byte[] rightPart = proxyScpAccount.substring(idx + 1).getBytes(CharsetUtils.US_ASCII);
                            proxyUserName = "1." + Base64Utils.encodeToString(leftPart) + '.' + Base64Utils.encodeToString(rightPart);
                        } else {
                            proxyUserName = "1." + Base64Utils.encodeToString(proxyScpAccount.getBytes(CharsetUtils.UTF_8));
                        }
                    } else {
                        proxyUserName = this._connectionProperties.getProperty(ConnectionProperty.PROXY_USER_NAME);
                    }
                    final String f_proxyUserName = proxyUserName;
                    final char[] f_proxyPassword = proxyPassword;
                    authenticator = new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(f_proxyUserName, f_proxyPassword);
                        }
                    };
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHostName, proxyPort));
                }
                webSocket = new HanaWebSocket(this._tracer, this._getWebSocketUri(address, webSocketUrl), proxy, authenticator, this._getConnectTimeout(), true, sc.createSSLEngine(), this._connectionProperties.getIntProperty(ConnectionProperty.WEB_SOCKET_PING_TIMEOUT));
                sslEngine = webSocket.getSSLEngine();
                sslEngine.setUseClientMode(true);
                socket = webSocket.getSocket();
            } else {
                socket = factory.createSocket();
                socket.connect(new InetSocketAddress(host, port), this._getConnectTimeout());
                sslSocket = (SSLSocket)socket;
                sslSocket.setUseClientMode(true);
            }
            this._setSocketOptions(socket);
            if (isWebSocket) {
                this._setWebSocketDefaults(this._connectionProperties);
            }
            ArrayList<Object> protocols = new ArrayList<Object>();
            String[] supportedProtocols = isWebSocket ? sslEngine.getSupportedProtocols() : sslSocket.getSupportedProtocols();
            for (String protocol : supportedProtocols) {
                if (!protocol.startsWith("TLS")) continue;
                protocols.add(protocol);
            }
            if (isWebSocket) {
                sslEngine.setEnabledProtocols(protocols.toArray(new String[0]));
            } else {
                sslSocket.setEnabledProtocols(protocols.toArray(new String[0]));
            }
            InetAddress inetAddress = InetAddress.getByName(host);
            if (Driver.getJavaVersion() >= 8 && !(inetAddress instanceof Inet6Address)) {
                SNIHostName serverName = new SNIHostName(this._sniHostname == null ? host : this._sniHostname);
                ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>(1);
                serverNames.add(serverName);
                SSLParameters params = isWebSocket ? sslEngine.getSSLParameters() : sslSocket.getSSLParameters();
                params.setServerNames(serverNames);
                if (isWebSocket) {
                    sslEngine.setSSLParameters(params);
                } else {
                    sslSocket.setSSLParameters(params);
                }
            }
            if (isWebSocket) {
                webSocket.doHandshake();
            } else {
                sslSocket.startHandshake();
            }
            SSLSession sslSession = isWebSocket ? sslEngine.getSession() : sslSocket.getSession();
            try {
                certs = sslSession.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                certs = new Certificate[]{};
            }
            this._validateHostName(certs, host, sslSession);
        }
        catch (NoSuchAlgorithmException e) {
            SQLException sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nosuchalgorithm", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", host, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        catch (KeyManagementException e) {
            SQLException sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagementexception", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", host, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        catch (UnknownHostException e) {
            this._throwRTEException(MessageTranslator.translate("error.unknown.host", host, e.getMessage(), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
        }
        catch (SSLHandshakeException e) {
            SQLException sqlex = e.getMessage().contains("PKIX path building failed") ? SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.certificatepath", e.getMessage()) : SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.handshake", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", address.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode(), sqlex);
        }
        catch (SSLException e) {
            SQLException sqlex = e.getMessage().contains("Received fatal alert: internal_error") ? SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nosslsupport", e.getMessage()) : SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.handshake", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", address.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode(), sqlex);
        }
        catch (IOException e) {
            this._throwRTEException(MessageTranslator.translate("error.host.connect", address.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode());
        }
        catch (RTEException e) {
            this._throwRTEException(e);
        }
        webSocketOutputParm[0] = webSocket;
        return socket;
    }

    private boolean _isSystemDefaultUsed() {
        return this._keyStore == null && this._keyStoreType == null && this._keyStorePasswd == null && this._sslKeyStore == null && this._trustStore == null && this._trustStorePasswd == null && this._trustStoreType == null && this._sslTrustStore == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManagerFactory _getKeyManagerFactory(String hostName) throws RTEException {
        SQLException sqlex;
        char[] passwd;
        KeyStore ks;
        KeyManagerFactory kmf;
        block31: {
            String type;
            String algorithm;
            String keyStoreFileName = this._getKeyStoreFileName();
            if (this._sslKeyStore == null && keyStoreFileName == null) {
                return null;
            }
            kmf = null;
            ks = null;
            if (this._sslKeyStore != null) {
                algorithm = "SunX509";
                type = "JKS";
                passwd = "".toCharArray();
            } else {
                algorithm = KeyManagerFactory.getDefaultAlgorithm();
                type = this._getKeyStoreType();
                passwd = this._getKeyStorePasswd().toCharArray();
            }
            try {
                kmf = KeyManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagerfactorynodefault", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                ks = KeyStore.getInstance(type);
            }
            catch (KeyStoreException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystore.create", this._getKeyStoreType(), e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                if (this._sslKeyStore != null) {
                    ks.load(null);
                    List<Certificate> certs = SecureSession._createCertificatesFromPEM(this._sslKeyStore);
                    List<PrivateKey> keys = SecureSession._createPrivateKeysFromPEM(this._sslKeyStore);
                    if (!keys.isEmpty()) {
                        ks.setKeyEntry("key-alias", keys.get(0), passwd, certs.toArray(new Certificate[0]));
                    }
                    break block31;
                }
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(keyStoreFileName);
                    ks.load(fis, passwd);
                }
                catch (FileNotFoundException e) {
                    sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystorefilenotfound", e.getMessage());
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystoreloadfailed.nosuchalgorithm", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (CertificateException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystoreloadfailed.certificate", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (IOException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystoreloadfailed.ioexception", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (InvalidKeySpecException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.invalidkeyspec", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (KeyStoreException e) {
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, "Key manager initialization failed: " + e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
            }
        }
        try {
            kmf.init(ks, passwd);
        }
        catch (KeyStoreException e) {
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, "Key manager initialization failed: " + e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
        catch (UnrecoverableKeyException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagerfactory.unrecoverablekey", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        catch (NoSuchAlgorithmException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagerfactory.nosuchalgorithm", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        return kmf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManagerFactory _getTrustManagerFactory(String hostName) throws RTEException {
        SQLException sqlex;
        KeyStore ks;
        TrustManagerFactory tmf;
        block28: {
            char[] passwd;
            String type;
            String algorithm;
            String trustStoreFileName = this._getTrustStoreFileName();
            if (this._sslTrustStore == null && trustStoreFileName == null) {
                return null;
            }
            tmf = null;
            ks = null;
            if (this._sslTrustStore != null) {
                algorithm = "SunX509";
                type = "JKS";
                passwd = null;
            } else {
                algorithm = TrustManagerFactory.getDefaultAlgorithm();
                type = this._getTrustStoreType();
                String passwdString = this._getTrustStorePasswd();
                passwd = passwdString != null ? passwdString.toCharArray() : null;
            }
            try {
                tmf = TrustManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.trustmanagerfactorynodefault", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                ks = KeyStore.getInstance(type);
            }
            catch (KeyStoreException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststore.create", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                if (this._sslTrustStore != null) {
                    ks.load(null);
                    List<Certificate> certs = SecureSession._createCertificatesFromPEM(this._sslTrustStore);
                    int n = certs.size();
                    for (int i = 0; i < n; ++i) {
                        ks.setCertificateEntry("cert-alias-" + String.valueOf(i), certs.get(i));
                    }
                    break block28;
                }
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(trustStoreFileName);
                    ks.load(fis, passwd);
                }
                catch (FileNotFoundException e) {
                    sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststorefilenotfound", e.getMessage());
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.nosuchalgorithm", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (CertificateException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.certificate", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (IOException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.ioexception", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (KeyStoreException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.trustmanagerfactory.keystore", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
        }
        try {
            tmf.init(ks);
        }
        catch (KeyStoreException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.trustmanagerfactory.keystore", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        return tmf;
    }

    private String _getKeyStoreFileName() {
        return this._keyStore != null ? this._keyStore : System.getProperty("javax.net.ssl.keyStore");
    }

    private String _getKeyStoreType() {
        return this._keyStoreType != null ? this._keyStoreType : "JKS";
    }

    private String _getKeyStorePasswd() {
        if (this._keyStorePasswd != null) {
            return this._keyStorePasswd;
        }
        String syspasswd = System.getProperty("javax.net.ssl.keyStorePassword");
        if (syspasswd != null) {
            return syspasswd;
        }
        return "";
    }

    private String _getTrustStoreFileName() {
        return this._trustStore != null ? this._trustStore : System.getProperty("javax.net.ssl.trustStore");
    }

    private String _getTrustStoreType() {
        return this._trustStoreType != null ? this._trustStoreType : "JKS";
    }

    private String _getTrustStorePasswd() {
        return this._trustStorePasswd != null ? this._trustStorePasswd : System.getProperty("javax.net.ssl.trustStorePassword");
    }

    private void _validateHostName(Certificate[] certs, String hostName, SSLSession sslSession) throws RTEException {
        if (!"*".equals(this._hostNameInCertificate) && this._validateCertificate) {
            SQLException sqlex;
            if (certs.length == 0) {
                sqlex = SQLExceptionSapDB.newInstance("error.ssl.nocertificatefound", new String[0]);
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                HostnameVerifier hostnameVerifier;
                X509Certificate x509cert = (X509Certificate)certs[0];
                X500Principal principal = x509cert.getSubjectX500Principal();
                String rfc2253name = principal.getName("RFC2253");
                Collection<List<?>> alternativenames = x509cert.getSubjectAlternativeNames();
                if (!(SSLUtils.validateHostName(rfc2253name, alternativenames, this._hostNameInCertificate == null ? hostName : this._hostNameInCertificate) || (hostnameVerifier = Driver.getHostnameVerifier()) != null && hostnameVerifier.verify(hostName, sslSession))) {
                    sqlex = SQLExceptionSapDB.newInstance("error.ssl.hostnameverificationfailed", rfc2253name, this._hostNameInCertificate == null ? hostName : this._hostNameInCertificate);
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
                }
            }
            catch (ClassCastException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nox509certificate", new String[0]);
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (CertificateParsingException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nox509certificate", new String[0]);
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
        }
    }

    private static List<Certificate> _createCertificatesFromPEM(String pem) throws CertificateException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        List<byte[]> certsBytes = Base64Utils.decodeCertificates(pem);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        for (byte[] certBytes : certsBytes) {
            Certificate cert = factory.generateCertificate(new ByteArrayInputStream(certBytes));
            certs.add(cert);
        }
        return certs;
    }

    private static List<PrivateKey> _createPrivateKeysFromPEM(String pem) throws NoSuchAlgorithmException, InvalidKeySpecException {
        ArrayList<PrivateKey> keys = new ArrayList<PrivateKey>();
        List<byte[]> keysBytes = Base64Utils.decodePrivateKeys(pem);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        for (byte[] keyBytes : keysBytes) {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            PrivateKey key = factory.generatePrivate(keySpec);
            keys.add(key);
        }
        return keys;
    }
}

