/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteTypeVolumeID;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.ServiceType;
import com.sap.db.jdbc.packet.TopologyInformationOption;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

@Immutable
final class SystemInfo {
    private final String _sidAndDatabaseName;
    private final Map<SiteTypeVolumeID, PublicAddress> _addresses;
    private final Map<Byte, SiteType> _siteIDToSiteTypeMap;

    static PublicAddress getOwnAddress(HMultiLineOptionsPart topologyPart) throws SQLException {
        return SystemInfo._processTopologyPart(null, topologyPart);
    }

    static boolean areDifferentSystems(SystemInfo first, SystemInfo second) {
        return !first._sidAndDatabaseName.equals(second._sidAndDatabaseName);
    }

    SystemInfo(String sidAndDatabaseName, HMultiLineOptionsPart topologyPart, PublicAddress[] outOwnAddress) throws SQLException {
        this._sidAndDatabaseName = sidAndDatabaseName;
        this._addresses = new TreeMap<SiteTypeVolumeID, PublicAddress>();
        this._siteIDToSiteTypeMap = new HashMap<Byte, SiteType>();
        outOwnAddress[0] = SystemInfo._processTopologyPart(this, topologyPart);
    }

    String getSidAndDatabaseName() {
        return this._sidAndDatabaseName;
    }

    Collection<PublicAddress> getAddresses() {
        return Collections.unmodifiableCollection(this._addresses.values());
    }

    PublicAddress getAddress(SiteTypeVolumeID siteTypeVolumeID) {
        return this._addresses.get(siteTypeVolumeID);
    }

    int getAddressCount() {
        return this._addresses.size();
    }

    Map<Byte, SiteType> getSiteIDToSiteTypeMap() {
        return Collections.unmodifiableMap(this._siteIDToSiteTypeMap);
    }

    SiteType getSiteType(byte siteID) {
        SiteType siteType = this._siteIDToSiteTypeMap.get(siteID);
        return siteType != null ? siteType : SiteType.NONE;
    }

    int getSiteCount() {
        return this._siteIDToSiteTypeMap.size();
    }

    int getPerSiteIndexServerCount() {
        int siteCount = this._siteIDToSiteTypeMap.size();
        int indexServerCount = 0;
        for (PublicAddress publicAddress : this._addresses.values()) {
            if (!publicAddress.isIndexServer()) continue;
            ++indexServerCount;
        }
        if (siteCount > 1) {
            indexServerCount /= siteCount;
        }
        return indexServerCount;
    }

    private static PublicAddress _processTopologyPart(SystemInfo systemInfo, HMultiLineOptionsPart topologyPart) throws SQLException {
        boolean returnOwnAddressOnly = systemInfo == null;
        PublicAddress ownAddress = null;
        do {
            String host = null;
            int port = -1;
            SiteVolumeID siteVolumeID = null;
            byte siteID = -1;
            int volumeID = -1;
            String tenantName = null;
            boolean isMaster = false;
            boolean isOwn = false;
            ServiceType serviceType = ServiceType.IndexServer;
            boolean isStandby = false;
            SiteType siteType = SiteType.NONE;
            do {
                switch (TopologyInformationOption.decode(topologyPart.getOptionName())) {
                    case HostName: {
                        host = topologyPart.getOptionStringValue();
                        break;
                    }
                    case HostPortNumber: {
                        port = topologyPart.getOptionIntValue();
                        break;
                    }
                    case TenantName: {
                        tenantName = topologyPart.getOptionStringValue();
                        break;
                    }
                    case VolumeID: {
                        siteVolumeID = new SiteVolumeID(topologyPart.getOptionIntValue());
                        siteID = siteVolumeID.getSiteID();
                        volumeID = siteVolumeID.getVolumeID();
                        break;
                    }
                    case IsMaster: {
                        isMaster = topologyPart.getOptionBooleanValue();
                        break;
                    }
                    case IsCurrentSession: {
                        isOwn = topologyPart.getOptionBooleanValue();
                        break;
                    }
                    case ServiceType: {
                        serviceType = ServiceType.decode(topologyPart.getOptionIntValue());
                        break;
                    }
                    case IsStandby: {
                        isStandby = topologyPart.getOptionBooleanValue();
                        break;
                    }
                    case SiteType: {
                        siteType = SiteType.decode(topologyPart.getOptionIntValue());
                        break;
                    }
                }
            } while (topologyPart.nextOption());
            if (returnOwnAddressOnly && !isOwn) continue;
            if (host == null) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Host name");
            }
            if (port == -1) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Port number");
            }
            if (siteID == -1) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Site ID");
            }
            if (volumeID == -1) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Volume ID");
            }
            PublicAddress address = new PublicAddress(host, port, systemInfo, tenantName, siteVolumeID, siteType, serviceType, isMaster, isStandby);
            if (returnOwnAddressOnly) {
                ownAddress = address;
                break;
            }
            systemInfo._addresses.put(new SiteTypeVolumeID(siteType, volumeID), address);
            systemInfo._siteIDToSiteTypeMap.put(siteID, siteType);
            if (!isOwn) continue;
            ownAddress = address;
        } while (topologyPart.nextLine());
        topologyPart.rewind();
        return ownAddress;
    }

    Map<SiteTypeVolumeID, PublicAddress> getAddressesMap() {
        return this._addresses;
    }
}

