/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.AesCbc;
import com.sap.db.util.ByteUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

@ThreadSafe
class DoubleConverter
extends AbstractNumericConverter {
    private static final Double MIN_VALUE = -1.7976931348623157E308;
    private static final Double MAX_VALUE = Double.MAX_VALUE;
    private static final BigDecimal MIN_VALUE_BIG_DECIMAL = BigDecimal.valueOf(MIN_VALUE);
    private static final BigDecimal MAX_VALUE_BIG_DECIMAL = BigDecimal.valueOf(MAX_VALUE);

    protected DoubleConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        if (this._isEncrypted) {
            return AesCbc.getEncryptedLength(8) + 1;
        }
        return 8;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Double)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (this._isEncrypted) {
            return AesCbc.getEncryptedLength(8) + 2;
        }
        return 9;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Double)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        Double value = (Double)data;
        if (this._isEncrypted) {
            byte[] encrypted = this._getEncryptedBuffer(ByteUtils.putDouble(value, new byte[8], 0));
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putDoubleAsDouble(value);
    }

    @Override
    protected int _getNullInputArgLength() {
        if (this._isEncrypted && !this._isDeterministic) {
            return AesCbc.getEncryptedLength(8) + 2;
        }
        return 1;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) throws SQLException {
        if (this._isEncrypted && !this._isDeterministic) {
            byte[] encrypted = this._getEncryptedBuffer(ByteUtils.putLong(-1L, new byte[8], 0));
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putNull(this._dataType);
    }

    @Override
    public int getColumnDisplaySize() {
        return String.valueOf(Double.MAX_VALUE).length() + 1;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : Double.valueOf(this._getValueAsDouble(controller, dataPart, false, decrypted));
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsDouble(controller, dataPart, true, null) != 0.0;
    }

    @Override
    public Double setBoolean(boolean value) throws SQLException {
        return value ? 1 : 0;
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (byte)this._getValueAsDouble(controller, dataPart, true, null);
    }

    @Override
    public Double setByte(byte value) throws SQLException {
        return value;
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (short)this._getValueAsDouble(controller, dataPart, true, null);
    }

    @Override
    public Double setShort(short value) throws SQLException {
        return value;
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (int)this._getValueAsDouble(controller, dataPart, true, null);
    }

    @Override
    public Double setInt(int value) throws SQLException {
        return value;
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (long)this._getValueAsDouble(controller, dataPart, true, null);
    }

    @Override
    public Double setLong(long value) throws SQLException {
        return value;
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (float)this._getValueAsDouble(controller, dataPart, true, null);
    }

    @Override
    public Double setFloat(float value) throws SQLException {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw this._newSetNumericValueInvalidException(String.valueOf(value));
        }
        if ((double)value < MIN_VALUE || (double)value > MAX_VALUE) {
            throw this._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return value;
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsDouble(controller, dataPart, true, null);
    }

    @Override
    public Double setDouble(double value) throws SQLException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw this._newSetNumericValueInvalidException(String.valueOf(value));
        }
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw this._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : BigDecimal.valueOf(this._getValueAsDouble(controller, dataPart, false, decrypted));
    }

    @Override
    public Double setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.compareTo(MIN_VALUE_BIG_DECIMAL) < 0 || value.compareTo(MAX_VALUE_BIG_DECIMAL) > 0) {
            throw this._newSetNumericValueOutOfRangeException(value.toPlainString(), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return value.doubleValue();
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : String.valueOf(this._getValueAsDouble(controller, dataPart, false, decrypted));
    }

    @Override
    public Double setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            double d = Double.valueOf(value.trim());
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                throw this._newSetConversionException(value, "double");
            }
            return d;
        }
        catch (NumberFormatException e) {
            throw this._newSetConversionException(value, "double");
        }
    }

    @Override
    public Double setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length != 1) {
            throw this._newSetNumericInvalidByteArrayLengthConversionException(Arrays.toString(value));
        }
        return value[0] & 0xFF;
    }

    private double _getValueAsDouble(SQLParamController controller, HDataPart dataPart, boolean doNullCheck, byte[] decrypted) throws SQLException {
        if (doNullCheck) {
            byte[] byArray = decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
            if (dataPart.isNull(this, controller, decrypted)) {
                return 0.0;
            }
        }
        if (this._isEncrypted) {
            if (decrypted == null) {
                decrypted = this._getDecryptedBuffer(dataPart);
            }
            return ByteUtils.getDouble(decrypted, 0);
        }
        return dataPart.getDoubleAsDouble();
    }
}

