/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum ServiceType {
    Other(0),
    NameServer(1),
    Preprocessor(2),
    IndexServer(3),
    StatisticsServer(4),
    XSEngine(5),
    Reserved_6(6),
    CompileServer(7),
    DPServer(8),
    DIServer(9),
    Unknown(-1);

    private static final ServiceType[] VALUES;

    public static ServiceType decode(int value) {
        return value >= 0 && value < VALUES.length - 1 ? VALUES[value] : Unknown;
    }

    public static String getDisplayName(int value) {
        return ServiceType.decode(value).name() + '(' + String.valueOf(value) + ')';
    }

    private ServiceType(int value) {
        if (value != this.ordinal() && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    static {
        VALUES = ServiceType.values();
    }
}

