/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HanaWebSocket;
import com.sap.db.jdbc.PreferredAddress;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.exceptions.RTEDecompressException;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.RTEInvalidPacketException;
import com.sap.db.jdbc.exceptions.RTETimeoutException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DBConnectInfo;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.PacketAnalyzer;
import com.sap.db.jdbc.packet.PacketOption;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.DbgInstanceCount;
import com.sap.db.util.MessageTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.cert.X509Certificate;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.lz4.LZ4JavaSafeCompressor;
import net.jpountz.lz4.LZ4JavaSafeFastDecompressor;
import org.java_websocket.exceptions.WebsocketNotConnectedException;

@NotThreadSafe
public abstract class Session
extends DbgInstanceCount {
    private static final Set<Session> INSTANCES = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final int MIN_COMPRESSION_SIZE = 10240;
    private static final double MAX_COMPRESSION_PERCENTAGE = 0.95;
    @GuardedBy(value="Session.class")
    private static LZ4Compressor _compressor;
    @GuardedBy(value="Session.class")
    private static LZ4FastDecompressor _decompressor;
    protected final WeakReference<ConnectionSapDB> _connection;
    protected final Tracer _tracer;
    protected final AtomicReference<Address> _address;
    protected final ConnectionProperties _connectionProperties;
    private final long _instantiationTime;
    private final int _connectTimeOut;
    private final int _socketTimeOut;
    private final int _requestPacketSize;
    private final AtomicInteger _connectionID;
    private final AtomicBoolean _isFirstReplyVerified;
    private final AtomicLong _sessionID;
    private final AtomicBoolean _isHintRouted;
    private final AtomicBoolean _isDestroyed;
    @GuardedBy(value="_connection (implicit)")
    private boolean _isPartOfTransaction;
    @GuardedBy(value="_connection (implicit)")
    private boolean _isPartOfDistributedTransaction;
    @GuardedBy(value="_connection (implicit)")
    private boolean _isSendSessionContextFlagSet;
    @GuardedBy(value="_connection (implicit)")
    private boolean _isSendSessionVariablesFlagSet;
    @GuardedBy(value="_connection (implicit)")
    private boolean _isSendClientInfoFlagSet;
    @GuardedBy(value="_connection (implicit)")
    private Properties _currentSessionVariablesAndClientInfoProperties;
    @GuardedBy(value="_connection (implicit)")
    private long _sendTime;
    @GuardedBy(value="_connection (implicit)")
    private long _receiveTime;
    @GuardedBy(value="_connection (implicit)")
    private long _totalSendTime;
    @GuardedBy(value="_connection (implicit)")
    private long _totalReceiveTime;
    @GuardedBy(value="_connection (implicit)")
    private long _sentPacketCount;
    @GuardedBy(value="_connection (implicit)")
    private long _receivedPacketCount;
    @GuardedBy(value="_connection (implicit)")
    private long _sentByteCount;
    @GuardedBy(value="_connection (implicit)")
    private long _receivedByteCount;
    @GuardedBy(value="_connection (implicit)")
    private long _uncompressedSentByteCount;
    @GuardedBy(value="_connection (implicit)")
    private long _uncompressedReceivedByteCount;
    @GuardedBy(value="_connection (implicit)")
    private int _messageID;
    @GuardedBy(value="_connection (implicit)")
    private SoftReference<byte[]> _compressionBuffer;
    private static int _compressedPacketCount;
    private static int _decompressedPacketCount;

    Session(ConnectionSapDB connection, Address address) throws RTEException {
        INSTANCES.add(this);
        this._instantiationTime = System.currentTimeMillis();
        this._connection = new WeakReference<ConnectionSapDB>(connection);
        this._tracer = connection.getTracer();
        this._address = new AtomicReference<Address>(address);
        this._connectionProperties = connection.getConnectionProperties();
        this._connectTimeOut = this._connectionProperties.getIntProperty(ConnectionProperty.CONNECT_TIMEOUT);
        this._socketTimeOut = this._connectionProperties.getIntProperty(ConnectionProperty.COMMUNICATION_TIMEOUT);
        this._requestPacketSize = PacketAnalyzer.align(this._connectionProperties.getIntProperty(ConnectionProperty.PACKET_SIZE));
        this._connectionID = new AtomicInteger();
        this._isFirstReplyVerified = new AtomicBoolean(false);
        this._sessionID = new AtomicLong(0L);
        this._isHintRouted = new AtomicBoolean();
        this._isDestroyed = new AtomicBoolean();
        this._currentSessionVariablesAndClientInfoProperties = new Properties();
        if (this._tracer.on()) {
            this._tracer.printSessionOpening(this);
        }
    }

    void destroy() {
        if (this._isDestroyed.get()) {
            return;
        }
        try {
            this._closeSocket();
            INSTANCES.remove(this);
        }
        finally {
            this._isDestroyed.set(true);
        }
    }

    protected abstract Socket _getSocket();

    protected abstract HanaWebSocket _getWebSocket();

    protected abstract InputStream _getInputStream();

    protected abstract OutputStream _getOutputStream();

    protected abstract X509Certificate[] _getPeerCertificateChain();

    public String toString() {
        return this.getTraceString(true, false);
    }

    public String getTraceString(boolean isFullString, boolean includeConnection) {
        ConnectionSapDB connection = includeConnection ? (ConnectionSapDB)this._connection.get() : null;
        return super.toString() + (includeConnection && connection != null ? " " + connection.getClass().getSimpleName() + "@" + Integer.toHexString(connection.hashCode()) : "") + " " + this._address.get().getTraceString(isFullString) + (isFullString ? " ConnectionID:" + this._connectionID.get() + " SessionID:" + this._sessionID.get() + " on " + String.valueOf(this._getSocket()) : "");
    }

    public long getInstantiationTime() {
        return this._instantiationTime;
    }

    public Address getAddress() {
        return this._address.get();
    }

    public SiteVolumeID getSiteVolumeID() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).getSiteVolumeID() : SiteVolumeID.DUMMY;
    }

    public SiteType getSiteType() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).getSiteType() : SiteType.NONE;
    }

    public boolean isNoneOrPrimarySite() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).isNoneOrPrimarySite() : true;
    }

    public boolean isPrimarySite() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).isPrimarySite() : false;
    }

    public boolean isSecondarySite() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).isSecondarySite() : false;
    }

    public int getConnectionID() {
        return this._connectionID.get();
    }

    public void setConnectionID(int connectionID) {
        this._connectionID.set(connectionID);
    }

    public boolean isHintRouted() {
        return this._isHintRouted.get();
    }

    public void setHintRouted(boolean isHintRouted) {
        this._isHintRouted.set(isHintRouted);
    }

    public boolean isConnected() {
        return !this._isDestroyed.get();
    }

    public boolean isWebSocketConnection() {
        return this._getWebSocket() != null;
    }

    public boolean isPartOfTransaction() {
        return this._isPartOfTransaction;
    }

    public boolean isPartOfDistributedTransaction() {
        return this._isPartOfDistributedTransaction;
    }

    public void joinTransaction() {
        this._isPartOfTransaction = true;
    }

    public void joinDistributedTransaction() {
        this._isPartOfTransaction = true;
        this._isPartOfDistributedTransaction = true;
    }

    public void leaveTransaction() {
        this._isPartOfTransaction = false;
        this._isPartOfDistributedTransaction = false;
    }

    public boolean isSendSessionContextFlagSet() {
        return this._isSendSessionContextFlagSet;
    }

    public void setSendSessionContextFlag() {
        this._isSendSessionContextFlagSet = true;
    }

    public void clearSendSessionContextFlag() {
        this._isSendSessionContextFlagSet = false;
    }

    public boolean isSendSessionVariablesFlagSet() {
        return this._isSendSessionVariablesFlagSet;
    }

    public void setSendSessionVariablesFlag() {
        if (!this._isHintRouted.get()) {
            return;
        }
        this._isSendSessionVariablesFlagSet = true;
    }

    public boolean isSendClientInfoFlagSet() {
        return this._isSendClientInfoFlagSet;
    }

    public void setSendClientInfoFlag() {
        this._isSendClientInfoFlagSet = true;
    }

    public void clearSendSessionVariablesAndClientInfoFlags(ConnectionSapDB connection) {
        Properties properties = new Properties();
        this._isSendSessionVariablesFlagSet = false;
        this._isSendClientInfoFlagSet = false;
        properties.putAll((Map<?, ?>)connection._getClientInfo());
        if (this._isHintRouted.get()) {
            properties.putAll((Map<?, ?>)connection._getSessionVariables());
        }
        this._currentSessionVariablesAndClientInfoProperties = properties;
    }

    public Properties getCurrentSessionVariablesAndClientInfoProperties() {
        return this._currentSessionVariablesAndClientInfoProperties;
    }

    public long getSendTime() {
        return this._sendTime;
    }

    public long getReceiveTime() {
        return this._receiveTime;
    }

    public long getTotalSendTime() {
        return this._totalSendTime;
    }

    public long getTotalReceiveTime() {
        return this._totalReceiveTime;
    }

    public long getSentPacketCount() {
        return this._sentPacketCount;
    }

    public long getReceivedPacketCount() {
        return this._receivedPacketCount;
    }

    public long getSentByteCount() {
        return this._sentByteCount;
    }

    public long getReceivedByteCount() {
        return this._receivedByteCount;
    }

    public long getUncompressedSentByteCount() {
        return this._uncompressedSentByteCount;
    }

    public long getUncompressedReceivedByteCount() {
        return this._uncompressedReceivedByteCount;
    }

    public double getSentCompressionRatio() {
        return (double)this._uncompressedSentByteCount / (double)this._sentByteCount;
    }

    public double getReceivedCompressionRatio() {
        return (double)this._uncompressedReceivedByteCount / (double)this._receivedByteCount;
    }

    HRequestPacket newRequestPacket() {
        return HRequestPacket.newInstance(new byte[this._requestPacketSize]);
    }

    void send(HRequestPacket requestPacket, EngineFeatures engineFeatures) throws RTEException {
        long beforeSend = Session._getMicroTime();
        this._sendPacket(requestPacket, engineFeatures);
        long afterSend = Session._getMicroTime();
        this._sendTime = afterSend - beforeSend;
        this._totalSendTime += this._sendTime;
        ++this._sentPacketCount;
    }

    HReplyPacket receive(EngineFeatures engineFeatures) throws RTEException {
        long beforeReceive = Session._getMicroTime();
        HReplyPacket replyPacket = this._receivePacket(engineFeatures);
        long afterReceive = Session._getMicroTime();
        this._receiveTime = afterReceive - beforeReceive;
        this._totalReceiveTime += this._receiveTime;
        ++this._receivedPacketCount;
        return replyPacket;
    }

    protected int _getConnectTimeout() {
        return this._connectTimeOut;
    }

    protected void _setSocketOptions(Socket socket) {
        try {
            socket.setSoTimeout(this._connectTimeOut);
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            socket.setSoLinger(true, 15);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    protected void _switchToCommunicationTimeout() {
        try {
            this._getSocket().setSoTimeout(this._socketTimeOut);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    protected void _sendPacket(HRequestPacket requestPacket, EngineFeatures engineFeatures) throws RTEException {
        byte[] packet = requestPacket.getRawPacketArray();
        int len = requestPacket.getLength();
        int uncompressedHeaderLength = 56;
        byte[] workBuffer = null;
        boolean isCompressed = false;
        ByteUtils.putLong(this._sessionID.get(), packet, 0);
        ByteUtils.putInt(this._messageID++, packet, 8);
        if (engineFeatures != null && engineFeatures.isCompressionEnabled() && len >= 10240) {
            try {
                int uncompressedRemainderLength = len - uncompressedHeaderLength;
                int maximumCompressedRemainderLength = (int)((double)uncompressedRemainderLength * 0.95);
                workBuffer = this._getCompressionWorkBuffer(uncompressedHeaderLength + maximumCompressedRemainderLength);
                int compressedRemainderLength = Session._getCompressor().compress(packet, uncompressedHeaderLength, uncompressedRemainderLength, workBuffer, uncompressedHeaderLength, maximumCompressedRemainderLength);
                isCompressed = true;
                len = uncompressedHeaderLength + compressedRemainderLength;
                int varpartLength = 24 + compressedRemainderLength;
                int compressionVarpartLength = 24 + uncompressedRemainderLength;
                packet[22] = (byte)(packet[22] | PacketOption.IsCompressed.getValue());
                ByteUtils.putInt(varpartLength, packet, 12);
                ByteUtils.putInt(compressionVarpartLength, packet, 24);
                System.arraycopy(packet, 0, workBuffer, 0, uncompressedHeaderLength);
            }
            catch (LZ4Exception lZ4Exception) {
                // empty catch block
            }
        }
        if (this._tracer.on()) {
            this._tracer.printPacket(packet, engineFeatures);
        }
        if (isCompressed) {
            this._sendBytes(workBuffer, len);
        } else {
            this._sendBytes(packet, len);
        }
        this._sentByteCount += (long)len;
        this._uncompressedSentByteCount += (long)requestPacket.getLength();
    }

    protected HReplyPacket _receivePacket(EngineFeatures engineFeatures) throws RTEException {
        int uncompressedRemainderLength;
        boolean isCompressed;
        int uncompressedHeaderLength = 56;
        byte[] uncompressedHeader = new byte[uncompressedHeaderLength];
        if (this._receiveBytes(uncompressedHeader, 0, uncompressedHeaderLength) < uncompressedHeaderLength) {
            this._throwRTEException(MessageTranslator.translate("error.data.receivefailed", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
        long sessionID = ByteUtils.getLong(uncompressedHeader, 0);
        int packetCount = ByteUtils.getInt(uncompressedHeader, 8);
        if (!this._isFirstReplyVerified.get()) {
            if (sessionID != 0L || packetCount != 0) {
                this._throwRTEException(MessageTranslator.translate("error.data.receivefailed", new Object[0]), RteReturnCode.REQUEST_UNKNOWN);
            }
            this._isFirstReplyVerified.set(true);
        }
        this._sessionID.set(sessionID);
        int varpartLength = ByteUtils.getInt(uncompressedHeader, 12);
        if (varpartLength < 0) {
            this._throwRTEInvalidPacketException(MessageTranslator.translate("error.packet.too.large", new Object[0]), RteReturnCode.SQLPACKETLIMIT);
        }
        boolean bl = isCompressed = (ByteUtils.getByte(uncompressedHeader, 22) & PacketOption.IsCompressed.getValue()) != 0;
        if (isCompressed) {
            int compressionVarpartLength = ByteUtils.getInt(uncompressedHeader, 24);
            if (compressionVarpartLength < 0) {
                this._throwRTEInvalidPacketException(MessageTranslator.translate("error.packet.invalid", new Object[0]), RteReturnCode.REQUEST_UNKNOWN);
            }
            uncompressedRemainderLength = compressionVarpartLength - 24;
        } else {
            uncompressedRemainderLength = varpartLength - 24;
        }
        byte[] packet = new byte[uncompressedHeaderLength + uncompressedRemainderLength];
        System.arraycopy(uncompressedHeader, 0, packet, 0, uncompressedHeaderLength);
        if (isCompressed) {
            int compressedRemainderLength = varpartLength - 24;
            byte[] workBuffer = this._getCompressionWorkBuffer(compressedRemainderLength);
            this._receiveRemainderOfPacket(workBuffer, 0, compressedRemainderLength);
            try {
                int decompressedLength = Session._getDecompressor().decompress(workBuffer, 0, packet, uncompressedHeaderLength, uncompressedRemainderLength);
                if (decompressedLength != compressedRemainderLength) {
                    this._throwRTEDecompressException(MessageTranslator.translate("error.packet.decompress.failed", new Object[0]), RteReturnCode.SQLNOTOK, null);
                }
            }
            catch (LZ4Exception e) {
                this._throwRTEDecompressException(MessageTranslator.translate("error.packet.decompress.failed", new Object[0]), RteReturnCode.SQLNOTOK, e);
            }
            this._receivedByteCount += (long)(uncompressedHeaderLength + compressedRemainderLength);
        } else {
            this._receiveRemainderOfPacket(packet, uncompressedHeaderLength, uncompressedRemainderLength);
            this._receivedByteCount += (long)packet.length;
        }
        this._uncompressedReceivedByteCount += (long)packet.length;
        if (this._tracer.on()) {
            this._tracer.printPacket(packet, engineFeatures);
        }
        return HReplyPacket.newInstance(this._tracer, packet);
    }

    protected void _doInfoExchange() throws RTEException {
        byte[] request = new byte[14];
        byte[] reply = new byte[8];
        ByteUtils.putLongBigEndian(-1L, request, 0);
        ByteUtils.putByte(4, request, 4);
        ByteUtils.putShortBigEndian(20, request, 5);
        ByteUtils.putByte(4, request, 7);
        ByteUtils.putShortBigEndian(1, request, 8);
        ByteUtils.putByte(1, request, 11);
        ByteUtils.putByte(1, request, 12);
        ByteUtils.putByte(1, request, 13);
        this._sendBytes(request, 14);
        int len = this._receiveBytes(reply, 0, 8);
        if (len < 8) {
            this._throwRTEException(MessageTranslator.translate("error.recv.connect", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
    }

    protected Session _doConnectExchange(SessionFactory factory, String databaseName) throws RTEException {
        if (databaseName == null || databaseName.isEmpty()) {
            return this;
        }
        HRequestPacket requestPacket = this.newRequestPacket();
        requestPacket.initDBConnectInfo(databaseName);
        this.send(requestPacket, null);
        HReplyPacket replyPacket = this.receive(null);
        DBConnectInfo dbConnectInfo = replyPacket.findDBConnectInfo(0);
        if (dbConnectInfo == null) {
            SQLException sqlException = replyPacket.findSQLExceptionChain(0);
            if (sqlException == null) {
                sqlException = SQLExceptionSapDB.newInstance("error.internal.unknownError", new String[0]);
            }
            this._throwRTEException(sqlException.getMessage(), RteReturnCode.decode(sqlException.getErrorCode()), -708);
        }
        if (dbConnectInfo.isOnCorrectDatabase()) {
            return this;
        }
        String hostName = dbConnectInfo.getHost();
        int portNumber = dbConnectInfo.getPort();
        if (hostName == null || hostName.isEmpty() || portNumber <= 0) {
            this._throwRTEException(MessageTranslator.translate("error.unknown.host", hostName + ":" + portNumber, "No additional information", RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
        }
        if (this._tracer.on()) {
            this._tracer.printSessionMessage(this, "Redirecting to " + hostName + ":" + portNumber, new String[0]);
        }
        this.destroy();
        PreferredAddress address = new PreferredAddress(hostName, portNumber);
        Session newSession = factory.newInstance((ConnectionSapDB)this._connection.get(), address, false);
        return newSession;
    }

    protected URI _getWebSocketUri(Address address, String resource) throws RTEException {
        URI webSocketUri = null;
        String uriString = "ws://" + address.toString() + (resource.charAt(0) != '/' ? "/" : "") + resource.trim();
        try {
            webSocketUri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            this._throwRTEException(MessageTranslator.translate("error.invalid.websocket.uri", address.getHost(), address.getPort(), resource, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
        return webSocketUri;
    }

    protected void _setWebSocketDefaults(ConnectionProperties connectionProperties) {
        connectionProperties.setProperty(ConnectionProperty.IGNORE_TOPOLOGY, "true");
        if (!connectionProperties.hasProperty(ConnectionProperty.COMPRESS)) {
            connectionProperties.setProperty(ConnectionProperty.COMPRESS, "true");
        }
        if (!connectionProperties.hasProperty(ConnectionProperty.RECONNECT)) {
            connectionProperties.setProperty(ConnectionProperty.RECONNECT, "false");
        }
    }

    protected void _throwRTETimeoutException(String message, RteReturnCode rteReturnCode) throws RTEException {
        this.destroy();
        throw new RTETimeoutException(this._tracer, message, rteReturnCode);
    }

    protected void _throwRTEDecompressException(String message, RteReturnCode rteReturnCode, Throwable cause) throws RTEException {
        this.destroy();
        throw new RTEDecompressException(this._tracer, message, rteReturnCode, cause);
    }

    protected void _throwRTEInvalidPacketException(String message, RteReturnCode rteReturnCode) throws RTEException {
        this.destroy();
        throw new RTEInvalidPacketException(this._tracer, message, rteReturnCode);
    }

    protected void _throwRTEException(String message, RteReturnCode rteReturnCode) throws RTEException {
        this.destroy();
        throw new RTEException(this._tracer, message, rteReturnCode);
    }

    protected void _throwRTEException(String message, RteReturnCode rteReturnCode, int detailErrorCode) throws RTEException {
        this.destroy();
        throw new RTEException(this._tracer, message, rteReturnCode, detailErrorCode);
    }

    protected void _throwRTEException(String message, RteReturnCode rteReturnCode, Throwable cause) throws RTEException {
        this.destroy();
        throw new RTEException(this._tracer, message, rteReturnCode, cause);
    }

    protected void _throwRTEException(String message, RteReturnCode rteReturnCode, int detailErrorCode, Throwable cause) throws RTEException {
        this.destroy();
        throw new RTEException(this._tracer, message, rteReturnCode, detailErrorCode, cause);
    }

    protected void _throwRTEException(RTEException e) throws RTEException {
        this.destroy();
        throw e;
    }

    private static long _getMicroTime() {
        return System.nanoTime() / 1000L;
    }

    private static synchronized LZ4Compressor _getCompressor() {
        if (_compressor != null) {
            return _compressor;
        }
        _compressor = LZ4JavaSafeCompressor.INSTANCE;
        return _compressor;
    }

    private static synchronized LZ4FastDecompressor _getDecompressor() {
        if (_decompressor != null) {
            return _decompressor;
        }
        _decompressor = LZ4JavaSafeFastDecompressor.INSTANCE;
        return _decompressor;
    }

    private byte[] _getCompressionWorkBuffer(int requiredSize) {
        byte[] buffer;
        if (this._compressionBuffer != null && (buffer = this._compressionBuffer.get()) != null && buffer.length >= requiredSize) {
            return buffer;
        }
        this._compressionBuffer = null;
        buffer = new byte[requiredSize];
        this._compressionBuffer = new SoftReference<byte[]>(buffer);
        return buffer;
    }

    private void _sendBytes(byte[] buffer, int len) throws RTEException {
        HanaWebSocket webSocket = this._getWebSocket();
        try {
            if (webSocket != null) {
                webSocket.send(buffer, len);
            } else {
                this._getOutputStream().write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            this._throwRTEException(MessageTranslator.translate("error.send.write", e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
        }
        catch (RTEException e) {
            this._throwRTEException(e);
        }
    }

    private int _receiveBytes(byte[] buffer, int off, int len) throws RTEException {
        HanaWebSocket webSocket = this._getWebSocket();
        try {
            if (webSocket != null) {
                webSocket.receive(buffer, off, len);
                return len;
            }
            return this._getInputStream().read(buffer, off, len);
        }
        catch (SocketTimeoutException e) {
            this._throwRTETimeoutException(MessageTranslator.translate("error.data.receivefailed.reason", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
        catch (IOException e) {
            this._throwRTEException(MessageTranslator.translate("error.data.receivefailed.reason", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
        catch (RTEException e) {
            this._throwRTEException(e);
        }
        throw new AssertionError((Object)"_throwRTEException didn't throw an RTEException");
    }

    private void _receiveRemainderOfPacket(byte[] packet, int off, int len) throws RTEException {
        while (len > 0) {
            int n = this._receiveBytes(packet, off, len);
            if (n == -1) {
                this._throwRTEException(MessageTranslator.translate("error.data.receivefailed", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            off += n;
            len -= n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _closeSocket() {
        Socket socket = this._getSocket();
        HanaWebSocket webSocket = this._getWebSocket();
        if (socket == null) {
            return;
        }
        if (this._tracer.on()) {
            this._tracer.printSessionClosing(this);
            this._tracer.printSessionStatistics(this);
        }
        try {
            if (webSocket != null) {
                webSocket.close();
            } else {
                socket.close();
            }
        }
        catch (IOException iOException) {
        }
        catch (WebsocketNotConnectedException websocketNotConnectedException) {
        }
        finally {
            this._isDestroyed.set(true);
            if (this._tracer.on()) {
                this._tracer.printSessionClosed(this);
            }
        }
    }

    int getMessageID() {
        return this._messageID;
    }
}

