/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;
import com.sap.db.util.MessageTranslator;

@Immutable
public enum DataType {
    NULL(0, null, 1111, "VOID"),
    TINYINT(1, "java.lang.Short", -6, "TINYINT"),
    SMALLINT(2, "java.lang.Short", 5, "SMALLINT", 1),
    INT(3, "java.lang.Integer", 4, "INTEGER", 1),
    BIGINT(4, "java.lang.Long", -5, "BIGINT", 1),
    DECIMAL(5, "java.math.BigDecimal", 3, "DECIMAL", 5),
    REAL(6, "java.lang.Float", 7, "REAL", 5),
    DOUBLE(7, "java.lang.Double", 8, "DOUBLE", 5),
    CHAR(8, "java.lang.String", 1, "CHAR"),
    VARCHAR1(9, "java.lang.String", 12, "VARCHAR"),
    NCHAR(10, "java.lang.String", -15, "NCHAR"),
    NVARCHAR(11, "java.lang.String", -9, "NVARCHAR"),
    BINARY(12, "[B", -2, "BINARY"),
    VARBINARY(13, "[B", -3, "VARBINARY"),
    DATE(14, "java.sql.Date", 91, "DATE", 4),
    TIME(15, "java.sql.Time", 92, "TIME", 4),
    TIMESTAMP(16, "java.sql.Timestamp", 93, "TIMESTAMP", 4),
    TIME_TZ(17, "java.sql.Time", 92, null),
    TIME_LTZ(18, "java.sql.Time", 92, null),
    TIMESTAMP_TZ(19, "java.sql.Timestamp", 93, null),
    TIMESTAMP_LTZ(20, "java.sql.Timestamp", 93, null),
    INTERVAL_YM(21, "java.lang.Object", 1111, null),
    INTERVAL_DS(22, "java.lang.Object", 1111, null),
    ROWID(23, "java.sql.RowId", -8, null),
    UROWID(24, "java.sql.RowId", -8, null),
    CLOB(25, "java.sql.Clob", 2005, "CLOB", 2),
    NCLOB(26, "java.sql.NClob", 2011, "NCLOB", 2),
    BLOB(27, "java.sql.Blob", 2004, "BLOB", 2),
    BOOLEAN(28, "java.lang.Boolean", 16, "BOOLEAN", 4),
    STRING(29, "java.lang.String", 1, "CHAR"),
    NSTRING(30, "java.lang.String", -15, "NCHAR"),
    BLOCATOR(31, "java.sql.Blob", 2004, "BLOB", 2),
    NLOCATOR(32, "java.sql.NClob", 2011, "NCLOB", 2),
    BSTRING(33, "[B", -2, "BINARY"),
    DECIMAL_DIGIT_ARRAY(34, "[B", 1111, null),
    VARCHAR2(35, "java.lang.String", 12, "VARCHAR"),
    VARCHAR3(36, "java.lang.Object", -1, null),
    NVARCHAR3(37, "java.lang.Object", -1, null),
    VARBINARY3(38, "java.lang.Object", -1, null),
    VARGROUP(39, "java.lang.Object", -1, null),
    TINYINT_NOTNULL(40, "java.lang.Object", -1, null),
    SMALLINT_NOTNULL(41, "java.lang.Object", -1, null),
    INT_NOTNULL(42, "java.lang.Object", -1, null),
    BIGINT_NOTNULL(43, "java.lang.Object", -1, null),
    ARGUMENT(44, "java.lang.Object", -1, null),
    TABLE(45, "java.lang.Object", -1, null),
    CURSOR(46, "java.lang.Object", -1, null),
    SMALLDECIMAL(47, "java.lang.Object", -1, null, 1),
    ABAPSTREAM(48, "java.lang.Object", 2002, "ABAPSTREAM"),
    ABAPSTRUCT(49, "java.lang.Object", 2002, "ABAPSTRUCT"),
    ARRAY(50, "java.sql.Array", 2003, "ARRAY"),
    TEXT(51, "java.sql.NClob", 2011, "TEXT", 2),
    SHORTTEXT(52, "java.lang.String", -9, "SHORTTEXT"),
    BINTEXT(53, "java.sql.NClob", 2011, "BINTEXT", 2),
    FIXEDPOINTDECIMAL(54, "java.lang.Object", -1, null),
    ALPHANUM(55, "java.lang.String", -9, "ALPHANUM"),
    TLOCATOR(56, "java.lang.Object", -1, null),
    UNDEFINED_57(57, "java.lang.Object", -1, null),
    UNDEFINED_58(58, "java.lang.Object", -1, null),
    UNDEFINED_59(59, "java.lang.Object", -1, null),
    UNDEFINED_60(60, "java.lang.Object", -1, null),
    LONGDATE(61, "java.sql.Timestamp", 93, "TIMESTAMP", 4),
    SECONDDATE(62, "java.sql.Timestamp", 93, "TIMESTAMP", 4),
    DAYDATE(63, "java.sql.Date", 91, "DATE", 4),
    SECONDTIME(64, "java.sql.Time", 92, "TIME", 4),
    CSDATE(65, "java.lang.Object", -1, null),
    CSTIME(66, "java.lang.Object", -1, null),
    UNDEFINED_67(67, "java.lang.Object", -1, null),
    UNDEFINED_68(68, "java.lang.Object", -1, null),
    UNDEFINED_69(69, "java.lang.Object", -1, null),
    LOCATOR(70, "java.sql.Clob", 2005, "CLOB", 2),
    BLOB_DISK(71, "java.lang.Object", -1, null),
    CLOB_DISK(72, "java.lang.Object", -1, null),
    NCLOB_DISK(73, "java.lang.Object", -1, null),
    GEOMETRY(74, "[B", -1, "ST_GEOMETRY"),
    POINT(75, "[B", -1, "ST_POINT"),
    FIXED16(76, "java.math.BigDecimal", 3, "DECIMAL", 1, 16),
    BLOB_HYBRID(77, "java.lang.Object", -1, null),
    CLOB_HYBRID(78, "java.lang.Object", -1, null),
    NCLOB_HYBRID(79, "java.lang.Object", -1, null),
    POINTZ(80, "java.lang.String", -1, null),
    FIXED8(81, "java.math.BigDecimal", 3, "DECIMAL", 1, 8),
    FIXED12(82, "java.math.BigDecimal", 3, "DECIMAL", 1, 12),
    CIPHERTEXT(90, "[B", -3, "VARBINARY"),
    Unknown(-1, "java.lang.String", -1, null);

    private static final DataType[] VALUES;
    private final int _typeCode;
    private final String _javaClassName;
    private final int _sqlType;
    private final String _sqlTypeName;
    private final boolean _isSigned;
    private final boolean _isLOB;
    private final boolean _hasMagicNullValue;
    private final byte _fixedByteCount;

    public static DataType decode(int typeCode) {
        return typeCode >= 0 && typeCode < VALUES.length - 1 ? VALUES[typeCode] : Unknown;
    }

    public static String getDisplayName(int value) {
        return DataType.decode(value).name() + '(' + String.valueOf(value) + ')';
    }

    private DataType(int typeCode, String javaClassName, int sqlType, String sqlTypeName) {
        this(typeCode, javaClassName, sqlType, sqlTypeName, 0, -1);
    }

    private DataType(int typeCode, String javaClassName, int sqlType, String sqlTypeName, int props) {
        this(typeCode, javaClassName, sqlType, sqlTypeName, props, -1);
    }

    private DataType(int typeCode, String javaClassName, int sqlType, String sqlTypeName, int props, byte fixedByteCount) {
        this._typeCode = typeCode;
        this._javaClassName = javaClassName;
        this._sqlType = sqlType;
        this._sqlTypeName = sqlTypeName != null ? sqlTypeName : MessageTranslator.translate("unknowntype", new Object[0]);
        this._isSigned = (props & 1) == 1;
        this._isLOB = (props & 2) == 2;
        this._hasMagicNullValue = (props & 4) == 4;
        this._fixedByteCount = fixedByteCount;
    }

    public byte getTypeCode() {
        return (byte)this._typeCode;
    }

    public String getDisplayName() {
        return this.name() + '(' + String.valueOf(this.getTypeCode()) + ')';
    }

    public String getJavaClassName() {
        return this._javaClassName;
    }

    public int getSQLType() {
        return this._sqlType == -1 ? 1111 : this._sqlType;
    }

    public String getSQLTypeName() {
        return this._sqlTypeName;
    }

    public boolean isSigned() {
        return this._isSigned;
    }

    public boolean isLOB() {
        return this._isLOB;
    }

    public boolean hasMagicNullValue() {
        return this._hasMagicNullValue;
    }

    public byte getFixedByteCount() {
        return this._fixedByteCount;
    }

    static {
        VALUES = DataType.values();
    }

    static class Constants {
        static final int PROP_NONE = 0;
        static final int PROP_SIGNED = 1;
        static final int PROP_LOB = 2;
        static final int PROP_MAGICNULL = 4;

        Constants() {
        }
    }
}

