/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum DistributionProtocolVersion {
    Base(0),
    StatementSequenceNumberSupported(1),
    TransactionCommitRollbackWithStart(2),
    MultiplePartitionSpecSupported(3),
    RangePartitionSpecSupported(4),
    RouteWithoutSplitBatchSupported(5),
    Unknown(-1);

    private static final DistributionProtocolVersion[] VALUES;

    public static DistributionProtocolVersion decode(int value) {
        return value >= 0 && value < VALUES.length - 1 ? VALUES[value] : Unknown;
    }

    public static String getDisplayName(int value) {
        return DistributionProtocolVersion.decode(value).name() + '(' + String.valueOf(value) + ')';
    }

    private DistributionProtocolVersion(int value) {
        if (value != this.ordinal() && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    static {
        VALUES = DistributionProtocolVersion.values();
    }
}

