/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.packet.ActiveActiveProtocolVersion;
import com.sap.db.jdbc.packet.ClientSideEncryptionVersion;
import com.sap.db.jdbc.packet.ConnectOption;
import com.sap.db.jdbc.packet.DataFormatVersion;
import com.sap.db.jdbc.packet.DistributionMode;
import com.sap.db.jdbc.packet.HOptionsPart;

@Immutable
public final class EngineFeatures {
    private final int _connectionID;
    private final String _systemID;
    private final DataFormatVersion _dataFormatVersion;
    private final DistributionMode _distributionMode;
    private final boolean _useTransactionFlagsOnly;
    private final boolean _ignoreUnknownParts;
    private final DataFormatVersion _dataFormatVersion2;
    private final boolean _xopenXAProtocolSupported;
    private final ActiveActiveProtocolVersion _activeActiveProtocolVersion;
    private final boolean _queryTimeoutSupported;
    private final String _databaseName;
    private final ClientSideEncryptionVersion _clientSideEncryptionVersion;
    private final boolean _isCompressionEnabled;
    private final String _serverVersionString;
    private final boolean _support32BitFetchSize;
    private final boolean _supportSavepointSQL;

    public EngineFeatures(HOptionsPart optionsPart) {
        int connectionID = 0;
        String systemID = null;
        DataFormatVersion dataFormatVersion = null;
        DistributionMode distributionMode = DistributionMode.Off;
        boolean useTransactionFlagsOnly = false;
        boolean ignoreUnknownParts = false;
        DataFormatVersion dataFormatVersion2 = null;
        boolean xopenXAProtocolSupported = false;
        ActiveActiveProtocolVersion activeActiveProtocolVersion = ActiveActiveProtocolVersion.Unsupported;
        boolean queryTimeoutSupported = false;
        String databaseName = "";
        ClientSideEncryptionVersion clientSideEncryptionVersion = ClientSideEncryptionVersion.Unsupported;
        boolean isCompressionEnabled = false;
        String serverVersionString = "";
        int flagSet1 = 0;
        do {
            switch (ConnectOption.decode(optionsPart.getOptionName())) {
                case ConnectionID: {
                    connectionID = optionsPart.getOptionIntValue();
                    break;
                }
                case SystemID: {
                    systemID = optionsPart.getOptionStringValue();
                    break;
                }
                case DataFormatVersion: {
                    dataFormatVersion = DataFormatVersion.decode(optionsPart.getOptionIntValue());
                    break;
                }
                case ClientDistributionMode: {
                    distributionMode = DistributionMode.decode(optionsPart.getOptionIntValue());
                    break;
                }
                case UseTransactionFlagsOnly: {
                    useTransactionFlagsOnly = optionsPart.getOptionBooleanValue();
                    break;
                }
                case IgnoreUnknownParts: {
                    ignoreUnknownParts = true;
                    break;
                }
                case DataFormatVersion2: {
                    dataFormatVersion2 = DataFormatVersion.decode(optionsPart.getOptionIntValue());
                    break;
                }
                case XOpenXAProtocolSupported: {
                    xopenXAProtocolSupported = true;
                    break;
                }
                case ActiveActiveProtocolVersion: {
                    activeActiveProtocolVersion = ActiveActiveProtocolVersion.decode(optionsPart.getOptionIntValue());
                    break;
                }
                case QueryTimeoutSupported: {
                    queryTimeoutSupported = optionsPart.getOptionBooleanValue();
                    break;
                }
                case DatabaseName: {
                    databaseName = optionsPart.getOptionStringValue();
                    break;
                }
                case ClientSideColumnEncryptionVersion: {
                    clientSideEncryptionVersion = ClientSideEncryptionVersion.decode(optionsPart.getOptionIntValue());
                    break;
                }
                case CompressionLevelAndFlags: {
                    isCompressionEnabled = (optionsPart.getOptionIntValue() & 0x200) != 0;
                    break;
                }
                case FullVersionString: {
                    serverVersionString = optionsPart.getOptionStringValue();
                    break;
                }
                case FlagSet1: {
                    flagSet1 = optionsPart.getOptionIntValue();
                    break;
                }
            }
        } while (optionsPart.nextOption());
        this._connectionID = connectionID;
        this._systemID = systemID;
        this._dataFormatVersion = dataFormatVersion;
        this._distributionMode = distributionMode;
        this._useTransactionFlagsOnly = useTransactionFlagsOnly;
        this._ignoreUnknownParts = ignoreUnknownParts;
        this._dataFormatVersion2 = dataFormatVersion2;
        this._xopenXAProtocolSupported = xopenXAProtocolSupported;
        this._activeActiveProtocolVersion = activeActiveProtocolVersion;
        this._queryTimeoutSupported = queryTimeoutSupported;
        this._databaseName = databaseName;
        this._clientSideEncryptionVersion = clientSideEncryptionVersion;
        this._isCompressionEnabled = isCompressionEnabled;
        this._serverVersionString = serverVersionString;
        this._support32BitFetchSize = (flagSet1 & 8) != 0;
        this._supportSavepointSQL = (flagSet1 & 0x20) != 0;
    }

    public int getConnectionID() {
        return this._connectionID;
    }

    public String getSystemID() {
        return this._systemID;
    }

    public DataFormatVersion getDataFormatVersion() {
        return this._dataFormatVersion;
    }

    public DistributionMode getDistributionMode() {
        return this._distributionMode;
    }

    public boolean useTransactionFlagsOnly() {
        return this._useTransactionFlagsOnly;
    }

    public boolean ignoresUnknownParts() {
        return this._ignoreUnknownParts;
    }

    public DataFormatVersion getDataFormatVersion2() {
        return this._dataFormatVersion2;
    }

    public boolean isXOpenXAProtocolSupported() {
        return this._xopenXAProtocolSupported;
    }

    public ActiveActiveProtocolVersion getActiveActiveProtocolVersion() {
        return this._activeActiveProtocolVersion;
    }

    public boolean isQueryTimeoutSupported() {
        return this._queryTimeoutSupported;
    }

    public String getDatabaseName() {
        return this._databaseName;
    }

    public ClientSideEncryptionVersion getClientSideEncryptionVersion() {
        return this._clientSideEncryptionVersion;
    }

    public boolean isCompressionEnabled() {
        return this._isCompressionEnabled;
    }

    public String getServerVersionString() {
        return this._serverVersionString;
    }

    public boolean support32BitFetchSize() {
        return this._support32BitFetchSize;
    }

    public boolean supportSavepointSQL() {
        return this._supportSavepointSQL;
    }
}

