/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.PartitionParameterInfo;
import com.sap.db.jdbc.RangeInfo;
import com.sap.db.jdbc.packet.PartitionMethod;
import java.util.Collections;
import java.util.List;

@Immutable
public final class RangePartitionInfo {
    private final PartitionMethod _partitionMethod;
    private final List<PartitionParameterInfo> _partitionParameterInfoList;
    private final List<RangeInfo> _rangeInfoList;
    private final int _rangeCount;
    private final int _parameterCount;
    private final int _partitionCount;

    public RangePartitionInfo(PartitionMethod partitionMethod, List<PartitionParameterInfo> partitionParameterInfoList, List<RangeInfo> rangeInfoList, int rangeCount, int parameterCount, int partitionCount) {
        this._partitionMethod = partitionMethod;
        this._partitionParameterInfoList = Collections.unmodifiableList(partitionParameterInfoList);
        this._rangeInfoList = Collections.unmodifiableList(rangeInfoList);
        this._rangeCount = rangeCount;
        this._parameterCount = parameterCount;
        this._partitionCount = partitionCount;
    }

    public PartitionMethod getPartitionMethod() {
        return this._partitionMethod;
    }

    public List<PartitionParameterInfo> getPartitionParameterInfoList() {
        return this._partitionParameterInfoList;
    }

    public List<RangeInfo> getRangeInfoList() {
        return this._rangeInfoList;
    }

    public int getRangeCount() {
        return this._rangeCount;
    }

    public int getParameterCount() {
        return this._parameterCount;
    }

    public int getPartitionCount() {
        return this._partitionCount;
    }
}

