/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.RangeInfo;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteTypeVolumeID;
import java.util.HashMap;
import java.util.Map;

@NotThreadSafe
class RangeVoteCentre {
    private final Map<Integer, Integer> _rangeVoteMap = new HashMap<Integer, Integer>();
    private int _topVoteCount = 0;
    private SiteTypeVolumeID _topSiteTypeVolumeID = new SiteTypeVolumeID(SiteType.NONE, -1);

    public SiteTypeVolumeID getTopSiteTypeVolumeID() {
        return this._topSiteTypeVolumeID;
    }

    public void vote(int rangeNum, RangeInfo range) {
        Integer votes = this._rangeVoteMap.get(rangeNum);
        if (votes != null) {
            this._rangeVoteMap.put(rangeNum, votes + 1);
            if (votes + 1 > this._topVoteCount) {
                this._topVoteCount = votes + 1;
                this._topSiteTypeVolumeID = range.getSiteTypeVolumeID();
            }
        } else {
            this._rangeVoteMap.put(rangeNum, 1);
            if (this._topVoteCount == 0) {
                this._topVoteCount = 1;
                this._topSiteTypeVolumeID = range.getSiteTypeVolumeID();
            }
        }
    }
}

