/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum SQLReplyOptions {
    SQLStatementType(1),
    ColumnEncryptionKeyName(2),
    ColumnEncryptionKeyID(3),
    EncryptionAlgorithmName(4),
    ClientKeyPairName(5),
    ClientKeyPairID(6),
    EncodedPublicKeyValue(7),
    PreColumnEncryptionKeyID(8),
    NewColumnEncryptionKeyID(9),
    TableName(10),
    ColumnName(11),
    HiddenColumnName(12),
    SecondHiddenColumnName(13),
    EncryptionType(14),
    PrimaryKey(15),
    SchemaName(16),
    Unknown(-1);

    private static final SQLReplyOptions[] VALUES;

    public static SQLReplyOptions decode(int value) {
        return value >= 1 && value < VALUES.length ? VALUES[value - 1] : Unknown;
    }

    public static String getDisplayName(int value) {
        return SQLReplyOptions.decode(value).name() + '(' + value + ')';
    }

    private SQLReplyOptions(int value) {
        if (value != this.ordinal() + 1 && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    static {
        VALUES = SQLReplyOptions.values();
    }
}

