/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.trace;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.ParseID;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.PreparedStatementSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.TraceListener;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.PacketAnalyzer;
import com.sap.db.jdbc.trace.TraceConfiguration;
import com.sap.db.jdbc.trace.TraceControl;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.util.FileUtils;
import com.sap.db.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
public class Tracer {
    private static final String CURRENT_WRITE_POSITION = "<CURRENT WRITE POSITION>";
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat("0.000"));
    private static final ThreadLocal<DateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    private static final ThreadLocal<CurrentTimes> CURRENT_JDBC_API_TIMES = ThreadLocal.withInitial(() -> new CurrentTimes());
    private final boolean _isForOneConnection;
    private final String _traceListenerClassName;
    private final TraceControl _traceControl;
    private final AtomicBoolean _isTraceOn;
    private final AtomicBoolean _isTraceSuspended;
    private final AtomicBoolean _isPerformanceTraceOn;
    @GuardedBy(value="this")
    private final PacketAnalyzer _packetAnalyzer;
    @GuardedBy(value="this")
    private final TraceConfiguration _traceConfiguration;
    @GuardedBy(value="this")
    private ConnectionSapDB _connection;
    @GuardedBy(value="this")
    private String _traceFileName;
    @GuardedBy(value="this")
    private File _traceFile;
    @GuardedBy(value="this")
    private long _traceSize;
    @GuardedBy(value="this")
    private boolean _isWritingHeader;
    @GuardedBy(value="this")
    private TraceListener _traceListener;
    @GuardedBy(value="this")
    private int _wrapCount;
    @GuardedBy(value="this")
    private Thread _lastThread;

    public static Tracer getDummyTracer() {
        return DummyTracer.INSTANCE;
    }

    public Tracer(boolean isForOneConnection) {
        this(isForOneConnection, null, null, null);
    }

    public Tracer(boolean isForOneConnection, String traceListenerClassName, String traceFileName, String traceOptions) {
        this._isForOneConnection = isForOneConnection;
        this._traceListenerClassName = traceListenerClassName;
        this._traceControl = new TraceControl(this);
        this._isTraceOn = new AtomicBoolean(false);
        this._isTraceSuspended = new AtomicBoolean(false);
        this._isPerformanceTraceOn = new AtomicBoolean(false);
        this._packetAnalyzer = new PacketAnalyzer();
        TraceConfiguration traceConfiguration = null;
        boolean usesTraceFile = true;
        if (traceOptions != null) {
            if (traceListenerClassName != null) {
                traceConfiguration = new TraceConfiguration(null, traceOptions);
                usesTraceFile = false;
            } else if (traceFileName != null) {
                traceConfiguration = new TraceConfiguration(traceFileName, traceOptions);
            }
        }
        if (traceConfiguration == null) {
            traceConfiguration = new TraceConfiguration();
        }
        this._traceConfiguration = traceConfiguration;
        if (usesTraceFile) {
            this.setTraceFileName(this._traceConfiguration.getTraceFileName());
            this._setTraceSize(this._traceConfiguration.getTraceSize());
        }
    }

    public boolean isForOneConnection() {
        return this._isForOneConnection;
    }

    public TraceControl getTraceControl() {
        return this._traceControl;
    }

    public boolean on() {
        return this._isTraceOn.get();
    }

    public boolean isTraceSuspended() {
        return this._isTraceSuspended.get();
    }

    public boolean pon() {
        return this._isPerformanceTraceOn.get();
    }

    public TraceConfiguration getTraceConfiguration() {
        return this._traceConfiguration;
    }

    public synchronized ConnectionSapDB getConnection() {
        return this._connection;
    }

    public synchronized void setConnection(ConnectionSapDB connection) {
        this._connection = connection;
    }

    public synchronized File getTraceFile() {
        if (this._traceFile != null) {
            return this._traceFile;
        }
        if (this._traceFileName == null || this._traceFileName.isEmpty()) {
            this._traceFileName = "jdbctrace.prt";
        }
        try {
            String fileName = FileUtils.getFileName(this._traceFileName);
            String fileExtension = FileUtils.getFileExtension(this._traceFileName);
            String directoryName = FileUtils.getDirectoryName(this._traceFileName);
            File directory = FileUtils.createDirectoryIfNecessary(directoryName);
            this._traceFile = File.createTempFile(fileName, fileExtension, directory);
            FileUtils.limitAccessToReadWriteByOwner(this._traceFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._traceFile;
    }

    public synchronized boolean setTraceFileName(String traceFileName) {
        boolean wasNameChanged;
        boolean bl = wasNameChanged = !traceFileName.equals(this._traceFileName);
        if (!wasNameChanged) {
            return false;
        }
        this._traceFileName = traceFileName;
        this._traceFile = null;
        return true;
    }

    public synchronized boolean setTraceSize(String traceSize) {
        try {
            return this._setTraceSize(Long.parseLong(traceSize));
        }
        catch (NumberFormatException e) {
            return this._setTraceSize(Long.MAX_VALUE);
        }
    }

    public synchronized TraceListener getTraceListener() {
        return this._traceListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchTraceOn() {
        if (this._isTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isTraceOn.set(true);
            this._traceConfiguration.setTraceEnabled(true);
            this._open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchTraceOff() {
        if (!this._isTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isTraceOn.set(false);
            this._traceConfiguration.setTraceEnabled(false);
            this._close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendTrace() {
        if (!this._isTraceOn.get() || this._isTraceSuspended.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isTraceSuspended.set(true);
            this._writelnWithTimestamp("Tracing suspended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTrace() {
        if (!this._isTraceOn.get() || !this._isTraceSuspended.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isTraceSuspended.set(false);
            this._writelnWithTimestamp("Tracing resumed");
            try {
                this._isWritingHeader = true;
                this._writeObjectTrees();
            }
            finally {
                this._isWritingHeader = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchPerformanceTraceOn() {
        if (this._isPerformanceTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isPerformanceTraceOn.set(true);
            this._traceConfiguration.setPerformanceTraceEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchPerformanceTraceOff() {
        if (!this._isPerformanceTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isPerformanceTraceOn.set(false);
            this._traceConfiguration.setPerformanceTraceEnabled(false);
            TraceRecordPublisher.getInstance().close();
        }
    }

    public synchronized void checkTraceSettings() {
        if (!this._traceConfiguration.hasTraceSettingsChanged()) {
            return;
        }
        this._traceConfiguration.loadTraceSettings();
        boolean wasTraceFileNameChanged = this.setTraceFileName(this._traceConfiguration.getTraceFileName());
        boolean wasTraceSizeChanged = this._setTraceSize(this._traceConfiguration.getTraceSize());
        if (this._traceConfiguration.isTraceEnabled()) {
            if (wasTraceFileNameChanged || wasTraceSizeChanged) {
                this.switchTraceOff();
            } else if (this._isTraceOn.get()) {
                this._writeTraceConfiguration();
            }
            this.switchTraceOn();
        } else {
            this.switchTraceOff();
        }
        if (this._traceConfiguration.isPerformanceTraceEnabled()) {
            this.switchPerformanceTraceOn();
        } else {
            this.switchPerformanceTraceOff();
        }
    }

    public synchronized void refreshTraceSettings() {
        if (this._traceConfiguration.isTraceEnabled()) {
            this.switchTraceOn();
        } else {
            this.switchTraceOff();
        }
        if (this._traceConfiguration.isPerformanceTraceEnabled()) {
            this.switchPerformanceTraceOn();
        } else {
            this.switchPerformanceTraceOff();
        }
    }

    public synchronized void printCurrentStackTrace(String message) {
        if (this._traceListener == null || this._isTraceSuspended.get()) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(message);
        this._writelnWithIndent(this._getStackTraceString(new Throwable()));
    }

    public synchronized void printConnectionOpening(ConnectionSapDB connection, String ... indentedMessages) {
        this._printConnectionTrace(connection, false, connection.isReconnecting() ? "reconnecting" : "opening", null, indentedMessages);
    }

    public synchronized void printConnectionOpened(ConnectionSapDB connection) {
        this._printConnectionTrace(connection, true, connection.isReconnecting() ? "reconnected" : "opened", null, new String[0]);
    }

    public synchronized void printConnectionMessage(ConnectionSapDB connection, String message, String ... indentedMessages) {
        this._printConnectionTrace(connection, false, "message", message, indentedMessages);
    }

    public synchronized void printConnectionClosing(ConnectionSapDB connection) {
        this._printConnectionTrace(connection, true, "closing", null, new String[0]);
    }

    public synchronized void printConnectionClosed(ConnectionSapDB connection) {
        this._printConnectionTrace(connection, false, "closed", null, new String[0]);
    }

    public synchronized void printSessionOpening(Session session) {
        this._printSessionTrace(session, false, "opening", null, new String[0]);
    }

    public synchronized void printSessionOpened(Session session) {
        this._printSessionTrace(session, true, "opened", null, new String[0]);
    }

    public synchronized void printSessionMessage(Session session, String message, String ... indentedMessages) {
        this._printSessionTrace(session, false, "message", message, indentedMessages);
    }

    public synchronized void printSessionClosing(Session session) {
        this._printSessionTrace(session, true, "closing", null, new String[0]);
    }

    public synchronized void printSessionClosed(Session session) {
        this._printSessionTrace(session, false, "closed", null, new String[0]);
    }

    private void _printConnectionTrace(ConnectionSapDB connection, boolean isFullTraceString, String messageType, String message, String ... indentedMessages) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CONNECTIONS)) {
            return;
        }
        String text = "Connection " + messageType + ": " + connection.getTraceString(isFullTraceString) + (message != null ? " " + message : "");
        this._checkThreadChange();
        this._writelnWithTimestamp(text);
        if (indentedMessages != null) {
            for (String s : indentedMessages) {
                this._writelnWithIndent(s);
            }
        }
    }

    private void _printSessionTrace(Session session, boolean isFullTraceString, String messageType, String message, String ... indentedMessages) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CONNECTIONS)) {
            return;
        }
        String text = "Session " + messageType + ": " + session.getTraceString(isFullTraceString, true) + (message != null ? " " + message : "");
        this._checkThreadChange();
        this._writelnWithTimestamp(text);
        if (indentedMessages != null) {
            for (String s : indentedMessages) {
                this._writelnWithIndent(s);
            }
        }
    }

    public synchronized void printCall(Class<?> clas, String name, Object ... arguments) {
        this.printCall(clas.getCanonicalName(), name, arguments);
    }

    public synchronized void printCall(Object caller, String name, Object ... arguments) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        Tracer.CURRENT_JDBC_API_TIMES.get()._reset(this._traceConfiguration.isShowElapsedTimesEnabled());
        this._checkThreadChange();
        this._writelnWithTimestamp(caller + "." + name + "(" + this._getArgumentsString(arguments) + ")");
    }

    public synchronized void printResult(Object result) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("=> " + this._getValueAsString(result), true);
    }

    public synchronized void printVoidResult() {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("=> void", true);
    }

    public synchronized void printException(Throwable e) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(this._getStackTraceString(e), true);
        this._checkStopOnError(e);
    }

    public synchronized void printStatementCached(ParseInfo parseInfo) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement cached: " + parseInfo.toString());
    }

    public synchronized void printStatementReused(ParseInfo parseInfo) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement reused: " + parseInfo.toString());
    }

    public synchronized void printStatementEvicted(ParseInfo parseInfo, String reason) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement evicted (" + reason + "): " + parseInfo.toString());
    }

    public synchronized void printStatementQueuedForLazyDrop(ParseID parseID) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement queued for lazy drop: " + parseID);
    }

    public synchronized void printStatementsDequeuedForLazyDrop(List<ParseID> parseIDs) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statements dequeued for lazy drop: " + Arrays.toString(parseIDs.toArray()));
    }

    public synchronized void printStatementQueuedForPendingClose(PreparedStatementSapDB statement) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement queued for pending close: " + statement);
    }

    public synchronized void printStatementDequeuedForPendingClose(PreparedStatementSapDB statement) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement dequeued for pending close: " + statement);
    }

    public synchronized void printResultSetQueuedForPendingClose(ResultSetSapDB resultSet) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Result set queued for pending close: " + resultSet);
    }

    public synchronized void printResultSetDequeuedForPendingClose(ResultSetSapDB resultSet) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Result set dequeued for pending close: " + resultSet);
    }

    public synchronized void printPacket(byte[] packet, EngineFeatures engineFeatures) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.PACKET)) {
            return;
        }
        this._checkThreadChange();
        this._packetAnalyzer.parse(packet);
        this._writelnWithTimestamp("<Packet " + this._packetAnalyzer.getDisplayPacketHeader() + ">");
        while (this._packetAnalyzer.nextSegment()) {
            this._writeln("  <Segment " + this._packetAnalyzer.getDisplaySegmentHeader() + ">");
            while (this._packetAnalyzer.nextPart()) {
                this._writeln("    <Part " + this._packetAnalyzer.getDisplayPartHeader() + ">");
                this._writeln("      <PartBuffer>");
                this._writeln("        " + this._packetAnalyzer.getDisplayPartDataAsBinaryString());
                this._writeln("        " + this._packetAnalyzer.getDisplayPartData(engineFeatures));
                this._writeln("      </PartBuffer>");
                this._writeln("    </Part>");
            }
            this._writeln("  </Segment>");
        }
        this._writeln("</Packet>");
    }

    public synchronized void printPacketElapsedSendTime(long elapsedTime) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.PACKET)) {
            return;
        }
        if (!this._traceConfiguration.isShowElapsedTimesEnabled()) {
            return;
        }
        this._checkThreadChange();
        this._writeln("Send time: " + this._getDisplayElapsedTime(elapsedTime));
    }

    public synchronized void printPacketElapsedReceiveTime(long elapsedTime, long pingPacketCount) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.PACKET)) {
            return;
        }
        if (!this._traceConfiguration.isShowElapsedTimesEnabled()) {
            return;
        }
        this._checkThreadChange();
        this._writeln("Receive time: " + this._getDisplayElapsedTime(elapsedTime) + (pingPacketCount > 0L ? " (includes " + pingPacketCount + " ping packets)" : ""));
    }

    public synchronized void printDistribution(ConnectionSapDB connection, String message) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.DISTRIBUTION)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Distribution: " + (connection != null ? connection.getTraceString(true) + " " : "") + message);
    }

    public synchronized void printDistributionState(ConnectionSapDB connection, String message) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.DISTRIBUTION)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Distribution: " + (connection != null ? connection.getTraceString(true) + " " : "") + message);
        for (Session session : connection.getSessionPool().getSessions().values()) {
            this._writelnWithIndent(session.getTraceString(true, false));
        }
    }

    public synchronized void printConnectionStatistics(ConnectionSapDB connection) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.STATISTICS)) {
            return;
        }
        if (!connection.isPreparedStatementCacheEnabled()) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Connection statistics: " + connection.getTraceString(true));
        this._writelnWithIndent("PreparedStatementCurrentCacheSize:         " + connection.getPreparedStatementCurrentCacheSize());
        this._writelnWithIndent("PreparedStatementCurrentTrackSize:         " + connection.getPreparedStatementCurrentTrackSize());
        this._writelnWithIndent("PreparedStatementCount:                    " + connection.getPreparedStatementCount());
        this._writelnWithIndent("PreparedStatementCacheHitCount:            " + connection.getPreparedStatementCacheHitCount());
        this._writelnWithIndent("PreparedStatementExecuteCount:             " + connection.getPreparedStatementExecuteCount());
        this._writelnWithIndent("PreparedStatementDropCount:                " + connection.getPreparedStatementDropCount());
        this._writelnWithIndent("PreparedStatementApproxUniqueSQLTextCount: " + connection.getPreparedStatementApproxUniqueSQLTextCount());
        this._writelnWithIndent("PreparedStatementCacheRejectedFullCount:   " + connection.getPreparedStatementCacheRejectedFullCount());
        this._writelnWithIndent("PreparedStatementCacheEvictedFullCount:    " + connection.getPreparedStatementCacheEvictedFullCount());
        this._writelnWithIndent("PreparedStatementCacheEvictedColdCount:    " + connection.getPreparedStatementCacheEvictedColdCount());
        this._writelnWithIndent("PreparedStatementTrackEvictedFullCount:    " + connection.getPreparedStatementTrackEvictedFullCount());
        this._writelnWithIndent("PreparedStatementTrackEvictedColdCount:    " + connection.getPreparedStatementTrackEvictedColdCount());
    }

    public synchronized void printSessionStatistics(Session session) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.STATISTICS)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Session statistics: " + session.getTraceString(true, true));
        this._writelnWithIndent("Duration:            " + this._getDisplayDuration(System.currentTimeMillis() - session.getInstantiationTime()));
        this._writelnWithIndent("SentPacketCount:     " + session.getSentPacketCount() + " TotalTime: " + this._getDisplayNanoseconds(session.getTotalSendTime()));
        this._writelnWithIndent("ReceivedPacketCount: " + session.getReceivedPacketCount() + " TotalTime: " + this._getDisplayNanoseconds(session.getTotalReceiveTime()));
        this._writelnWithIndent("SentByteCount:       " + this._getDisplayByteCount(session.getSentByteCount()) + " Uncompressed: " + this._getDisplayByteCount(session.getUncompressedSentByteCount()) + " CompressionRatio: " + this._getDisplayCompressionRatio(session.getSentCompressionRatio()));
        this._writelnWithIndent("ReceivedByteCount:   " + this._getDisplayByteCount(session.getReceivedByteCount()) + " Uncompressed: " + this._getDisplayByteCount(session.getUncompressedReceivedByteCount()) + " CompressionRatio: " + this._getDisplayCompressionRatio(session.getReceivedCompressionRatio()));
    }

    public synchronized void printCleaning(String caller) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CLEANERS)) {
            return;
        }
        Tracer.CURRENT_JDBC_API_TIMES.get()._reset(this._traceConfiguration.isShowElapsedTimesEnabled());
        this._checkThreadChange();
        this._writelnWithTimestamp(caller + ".clean()");
    }

    public synchronized void printCleaned() {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CLEANERS)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("=> void", true);
    }

    public synchronized void printFinalizing(String caller) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CLEANERS)) {
            return;
        }
        Tracer.CURRENT_JDBC_API_TIMES.get()._reset(this._traceConfiguration.isShowElapsedTimesEnabled());
        this._checkThreadChange();
        this._writelnWithTimestamp(caller + ".finalize()");
    }

    public synchronized void printFinalized() {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CLEANERS)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("=> void", true);
    }

    public synchronized void printDebugMessage(String message) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.DEBUG)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(message);
    }

    public synchronized void printDebugThrowable(Throwable t, String message) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.DEBUG)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(message);
        this._writelnWithIndent(this._getStackTraceString(t));
        this._checkStopOnError(t);
    }

    public synchronized void accumulateNetworkTime(long nanoTime) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API) && !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CLEANERS)) {
            return;
        }
        if (!this._traceConfiguration.isShowElapsedTimesEnabled()) {
            return;
        }
        Tracer.CURRENT_JDBC_API_TIMES.get()._accumulate(nanoTime);
    }

    private void _open() {
        if (this._traceListenerClassName != null) {
            try {
                Class<?> clas = Class.forName(this._traceListenerClassName);
                Object obj = clas.newInstance();
                if (obj instanceof TraceListener) {
                    this._traceListener = (TraceListener)obj;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                System.err.println(e.getMessage());
            }
        } else {
            this._traceListener = new FileTraceListener();
        }
        this._traceListener.traceStarted();
        this._wrapCount = 0;
        this._writeHeader();
    }

    private void _close() {
        if (this._traceListener == null) {
            return;
        }
        this._traceListener.traceStopped();
        this._traceListener = null;
    }

    private boolean _setTraceSize(long traceSize) {
        if (traceSize < 8192L) {
            traceSize = 8192L;
        }
        if (traceSize == this._traceSize) {
            return false;
        }
        this._traceSize = traceSize;
        return true;
    }

    private void _writeln() {
        this._writeln(null);
    }

    private void _writeln(String text) {
        if (this._traceListener == null) {
            return;
        }
        this._traceListener.traceReceived(text != null ? text : "");
    }

    private void _writelnWithTimestamp(String text) {
        this._writelnWithTimestamp(text, false);
    }

    private void _writelnWithTimestamp(String text, boolean includeTimes) {
        String elapsedTimes;
        CurrentTimes times;
        String displayText;
        String timestamp = this._traceConfiguration.isShowTimestampsEnabled() ? DATE_FORMAT.get().format(new Timestamp(System.currentTimeMillis())) + ": " : "";
        String string = displayText = text != null ? text : "";
        if (includeTimes && this._traceConfiguration.isShowElapsedTimesEnabled() && (times = Tracer.CURRENT_JDBC_API_TIMES.get())._isValid()) {
            long totalTime = System.nanoTime() - times._apiStartTime;
            long networkTime = times._networkTime;
            long apiTime = totalTime - networkTime;
            elapsedTimes = " (API: " + this._getDisplayElapsedTime(apiTime) + ", Network: " + this._getDisplayElapsedTime(networkTime) + ", Total: " + this._getDisplayElapsedTime(totalTime) + ")";
        } else {
            elapsedTimes = "";
        }
        this._writeln(timestamp + displayText + elapsedTimes);
    }

    private void _writelnWithIndent(String text) {
        this._writeln("  " + (text != null ? text : ""));
    }

    private void _writeHeader() {
        try {
            this._isWritingHeader = true;
            this._writeln("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body><PRE><PLAINTEXT>");
            this._writeln("Java version:   " + Driver.getJavaVersion());
            this._writeln("ClassLoader:    " + Tracer.class.getClassLoader());
            this._writeln("Process ID:     " + Driver.getProcessID());
            this._writeln("Driver version: " + Driver.getVersionInfo().toString());
            this._writeln();
            this._writeTraceConfiguration();
            this._writeln();
            this._writeHostProperties();
            this._writeln();
            this._writeSystemProperties();
            this._writeln();
            if (this._wrapCount > 0) {
                this._writeln("Warning: Trace wrapped around " + this._wrapCount + " times.");
                this._writeln();
            }
            this._writeObjectTrees();
        }
        finally {
            this._isWritingHeader = false;
        }
    }

    private void _writeObjectTrees() {
        Set<ConnectionSapDB> connections = this._isForOneConnection ? (this._connection != null ? Collections.singleton(this._connection) : Collections.emptySet()) : Driver.getConnections();
        if (!connections.isEmpty()) {
            this._writeln("Object tree begin:");
            for (ConnectionSapDB connection : connections) {
                this._writeln(connection.toString());
                for (StatementSapDB statement : connection.getStatements()) {
                    this._writelnWithIndent(statement.toString());
                }
            }
            this._writeln("Object tree end:");
        }
    }

    private void _writeTraceConfiguration() {
        StringBuilder builder = new StringBuilder(64);
        this._writeln("Trace configuration:");
        for (TraceConfiguration.TraceLevel traceLevel : TraceConfiguration.TraceLevel.values()) {
            if (!this._traceConfiguration.hasTraceLevel(traceLevel)) continue;
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append((Object)traceLevel);
        }
        this._writeln("  Levels:                                       " + builder.toString());
        this._writeln("  Show plain-text client-side encrypted values: " + (this._traceConfiguration.isShowPlainTextCSEEnabled() ? "Enabled" : "Disabled"));
        this._writeln("  Show timestamps:                              " + (this._traceConfiguration.isShowTimestampsEnabled() ? "Enabled" : "Disabled"));
        this._writeln("  Show elapsed times:                           " + (this._traceConfiguration.isShowElapsedTimesEnabled() ? "Enabled" : "Disabled"));
        this._writeln("  Trace file size:                              " + this._traceConfiguration.getDisplayTraceSize() + " " + this._traceConfiguration.getDisplayTraceSizeUnits());
        int stopOnError = this._traceConfiguration.getStopOnError();
        this._writeln("  Stop on error:                                " + (stopOnError == 0 ? "Disabled" : String.valueOf(stopOnError)));
    }

    private void _writeHostProperties() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            this._writeln("Host properties:");
            this._writeProperty("Host name", localHost.getHostName());
            this._writeProperty("Canonical host name", localHost.getCanonicalHostName());
            this._writeProperty("Host address", localHost.getHostAddress());
        }
        catch (Throwable t) {
            this._writeln("Can't get host properties: " + t.getMessage());
        }
    }

    private void _writeSystemProperties() {
        try {
            TreeMap<Object, Object> systemProperties = new TreeMap<Object, Object>(System.getProperties());
            this._writeln("System properties:");
            for (Map.Entry entry : systemProperties.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (key.equalsIgnoreCase("line.separator")) {
                    value = value.replace("\r", "\\r").replace("\n", "\\n");
                }
                this._writeProperty(key, value);
            }
        }
        catch (Throwable t) {
            this._writeln("Can't get system properties: " + t.getMessage());
        }
    }

    private void _writeProperty(String key, String value) {
        this._writeln(String.format("  %-33s %s", key + ':', value));
    }

    private void _checkThreadChange() {
        Thread thread = Thread.currentThread();
        if (thread == this._lastThread) {
            return;
        }
        this._lastThread = thread;
        this._writelnWithTimestamp("---- Thread " + Integer.toHexString(thread.hashCode()) + " " + thread.getName());
    }

    private void _checkStopOnError(Throwable t) {
        int stopOnError = this._traceConfiguration.getStopOnError();
        if (stopOnError != 0 && t instanceof SQLException && ((SQLException)t).getErrorCode() == stopOnError) {
            this._close();
        }
    }

    private String _getStackTraceString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private String _getArgumentsString(Object[] arguments) {
        switch (arguments.length) {
            case 0: {
                return "";
            }
            case 1: {
                return this._getValueAsString(arguments[0]);
            }
        }
        StringBuilder builder = new StringBuilder(64);
        for (Object arg : arguments) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(this._getValueAsString(arg));
        }
        return builder.toString();
    }

    private String _getValueAsString(Object object) {
        return object instanceof String ? StringUtils.quote(object.toString(), '\"', '\u0000', true, true) : String.valueOf(object);
    }

    private String _getDisplayDuration(long milliseconds) {
        long s = milliseconds / 1000L;
        return String.format("%d hours %d minutes %d seconds", s / 3600L, s % 3600L / 60L, s % 60L);
    }

    private String _getDisplayNanoseconds(long nanoseconds) {
        return nanoseconds / 1000000L + " ms";
    }

    private String _getDisplayByteCount(long byteCount) {
        return DECIMAL_FORMAT.get().format((double)byteCount / 1048576.0) + " MB";
    }

    private String _getDisplayCompressionRatio(double ratio) {
        return DECIMAL_FORMAT.get().format(ratio);
    }

    private String _getDisplayElapsedTime(long elapsedTime) {
        return elapsedTime / 1000L + " \u03bcs";
    }

    private class FileTraceListener
    implements TraceListener {
        @GuardedBy(value="Tracer.this")
        private RandomAccessFile _log;

        private FileTraceListener() {
        }

        @Override
        public void traceStarted() {
            File traceFile = Tracer.this.getTraceFile();
            if (traceFile == null) {
                return;
            }
            this.traceStopped();
            try {
                this._log = new RandomAccessFile(traceFile, "rw");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }

        @Override
        public void traceReceived(String text) {
            if (this._log == null) {
                return;
            }
            try {
                if (text != null) {
                    this._log.write(text.getBytes(StandardCharsets.UTF_8));
                }
                this._log.write(10);
                this._checkFileSize();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void traceStopped() {
            if (this._log == null) {
                return;
            }
            try {
                this._log.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this._log = null;
            }
        }

        private void _checkFileSize() throws IOException {
            if (this._log == null || Tracer.this._isWritingHeader || Tracer.this._traceSize == Long.MAX_VALUE) {
                return;
            }
            long offset = this._log.getFilePointer();
            if (offset + (long)Tracer.CURRENT_WRITE_POSITION.length() > Tracer.this._traceSize) {
                while (offset < Tracer.this._traceSize) {
                    this._log.write(32);
                    ++offset;
                }
                this._log.seek(0L);
                Tracer.this._wrapCount++;
                Tracer.this._writeHeader();
                offset = this._log.getFilePointer();
            }
            this._log.writeBytes(Tracer.CURRENT_WRITE_POSITION);
            this._log.seek(offset);
        }
    }

    private static class CurrentTimes {
        private static final long NANOSECONDS_UNDEFINED = -1L;
        private long _apiStartTime;
        private long _networkTime;

        private CurrentTimes() {
            this._init();
        }

        private void _init() {
            this._apiStartTime = -1L;
            this._networkTime = -1L;
        }

        private void _reset(boolean isShowElapsedTimesEnabled) {
            if (isShowElapsedTimesEnabled) {
                this._apiStartTime = System.nanoTime();
                this._networkTime = 0L;
            } else {
                this._init();
            }
        }

        private boolean _isValid() {
            return this._apiStartTime != -1L;
        }

        private void _accumulate(long networkTime) {
            this._networkTime += networkTime;
        }
    }

    private static class DummyTracer
    extends Tracer {
        private static final DummyTracer INSTANCE = new DummyTracer();

        private DummyTracer() {
            super(false);
        }

        @Override
        public boolean on() {
            return false;
        }

        @Override
        public boolean pon() {
            return false;
        }
    }
}

