/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.packet.ActiveActiveProtocolVersion;
import com.sap.db.jdbc.packet.ClientSideEncryptionVersion;
import com.sap.db.jdbc.packet.ConnectOption;
import com.sap.db.jdbc.packet.DataFormatVersion;
import com.sap.db.jdbc.packet.DistributionMode;
import com.sap.db.jdbc.packet.HOptionsPart;

@Immutable
public final class EngineFeatures {
    private final int _connectionID;
    private final String _systemID;
    private final DataFormatVersion _dataFormatVersion;
    private final DistributionMode _distributionMode;
    private final boolean _useTransactionFlagsOnly;
    private final boolean _ignoreUnknownParts;
    private final DataFormatVersion _dataFormatVersion2;
    private final boolean _xopenXAProtocolSupported;
    private final ActiveActiveProtocolVersion _activeActiveProtocolVersion;
    private final boolean _queryTimeoutSupported;
    private final String _serverVersionString;
    private final String _databaseName;
    private final boolean _implicitXASessionSupported;
    private final ClientSideEncryptionVersion _clientSideEncryptionVersion;
    private final boolean _isCompressionEnabled;
    private final int _reconnectWaitTimeout;
    private final boolean _holdCursorOverRollbackSupported;
    private final boolean _supportDropStatementIDPart;
    private final boolean _support32BitFetchSize;
    private final boolean _supportSavepointSQL;
    private final boolean _supportDeferredPrepare;
    private final boolean _supportImplicitXAJoinOnPrepare;
    private final boolean _supportSessionContextPartOnConnect;
    private final boolean _supportIdlePing;
    private final boolean _supportIdlePingDuringRequest;
    private final int _lrrPingTime;

    public EngineFeatures(HOptionsPart optionsPart) {
        int connectionID = 0;
        String systemID = null;
        DataFormatVersion dataFormatVersion = null;
        DistributionMode distributionMode = DistributionMode.Off;
        boolean useTransactionFlagsOnly = false;
        boolean ignoreUnknownParts = false;
        DataFormatVersion dataFormatVersion2 = null;
        boolean xopenXAProtocolSupported = false;
        ActiveActiveProtocolVersion activeActiveProtocolVersion = ActiveActiveProtocolVersion.Unsupported;
        boolean queryTimeoutSupported = false;
        String serverVersionString = "";
        String databaseName = "";
        boolean implicitXASessionSupported = false;
        ClientSideEncryptionVersion clientSideEncryptionVersion = ClientSideEncryptionVersion.Unsupported;
        boolean isCompressionEnabled = false;
        int reconnectWaitTimeout = -1;
        int flagSet1 = 0;
        int lrrPingTime = 0;
        if (optionsPart != null) {
            do {
                switch (ConnectOption.decode(optionsPart.getOptionName())) {
                    case ConnectionID: {
                        connectionID = optionsPart.getOptionIntValue();
                        break;
                    }
                    case SystemID: {
                        systemID = optionsPart.getOptionStringValue();
                        break;
                    }
                    case DataFormatVersion: {
                        dataFormatVersion = DataFormatVersion.decode(optionsPart.getOptionIntValue());
                        break;
                    }
                    case ClientDistributionMode: {
                        distributionMode = DistributionMode.decode(optionsPart.getOptionIntValue());
                        break;
                    }
                    case UseTransactionFlagsOnly: {
                        useTransactionFlagsOnly = optionsPart.getOptionBooleanValue();
                        break;
                    }
                    case IgnoreUnknownParts: {
                        ignoreUnknownParts = true;
                        break;
                    }
                    case DataFormatVersion2: {
                        dataFormatVersion2 = DataFormatVersion.decode(optionsPart.getOptionIntValue());
                        break;
                    }
                    case XOpenXAProtocolSupported: {
                        xopenXAProtocolSupported = true;
                        break;
                    }
                    case ActiveActiveProtocolVersion: {
                        activeActiveProtocolVersion = ActiveActiveProtocolVersion.decode(optionsPart.getOptionIntValue());
                        break;
                    }
                    case QueryTimeoutSupported: {
                        queryTimeoutSupported = optionsPart.getOptionBooleanValue();
                        break;
                    }
                    case FullVersionString: {
                        serverVersionString = optionsPart.getOptionStringValue();
                        break;
                    }
                    case DatabaseName: {
                        databaseName = optionsPart.getOptionStringValue();
                        break;
                    }
                    case ImplicitXASessionSupported: {
                        implicitXASessionSupported = optionsPart.getOptionBooleanValue();
                        break;
                    }
                    case ClientSideColumnEncryptionVersion: {
                        clientSideEncryptionVersion = ClientSideEncryptionVersion.decode(optionsPart.getOptionIntValue());
                        break;
                    }
                    case CompressionLevelAndFlags: {
                        isCompressionEnabled = (optionsPart.getOptionIntValue() & 0x200) != 0;
                        break;
                    }
                    case ClientReconnectWaitTimeout: {
                        reconnectWaitTimeout = optionsPart.getOptionIntValue();
                        break;
                    }
                    case FlagSet1: {
                        flagSet1 = optionsPart.getOptionIntValue();
                        break;
                    }
                    case LRRPingTime: {
                        lrrPingTime = optionsPart.getOptionIntValue();
                        break;
                    }
                }
            } while (optionsPart.nextOption());
        }
        this._connectionID = connectionID;
        this._systemID = systemID;
        this._dataFormatVersion = dataFormatVersion;
        this._distributionMode = distributionMode;
        this._useTransactionFlagsOnly = useTransactionFlagsOnly;
        this._ignoreUnknownParts = ignoreUnknownParts;
        this._dataFormatVersion2 = dataFormatVersion2;
        this._xopenXAProtocolSupported = xopenXAProtocolSupported;
        this._activeActiveProtocolVersion = activeActiveProtocolVersion;
        this._queryTimeoutSupported = queryTimeoutSupported;
        this._serverVersionString = serverVersionString;
        this._databaseName = databaseName;
        this._implicitXASessionSupported = implicitXASessionSupported;
        this._clientSideEncryptionVersion = clientSideEncryptionVersion;
        this._isCompressionEnabled = isCompressionEnabled;
        this._reconnectWaitTimeout = reconnectWaitTimeout;
        this._holdCursorOverRollbackSupported = (flagSet1 & 1) != 0;
        this._supportDropStatementIDPart = (flagSet1 & 2) != 0;
        this._support32BitFetchSize = (flagSet1 & 8) != 0;
        this._supportSavepointSQL = (flagSet1 & 0x20) != 0;
        this._supportDeferredPrepare = (flagSet1 & 0x40) != 0;
        this._supportImplicitXAJoinOnPrepare = (flagSet1 & 0x80) != 0;
        this._supportSessionContextPartOnConnect = (flagSet1 & 0x100) != 0;
        this._supportIdlePing = (flagSet1 & 0x400) != 0;
        this._supportIdlePingDuringRequest = (flagSet1 & 0x800) != 0;
        this._lrrPingTime = lrrPingTime;
    }

    public int getConnectionID() {
        return this._connectionID;
    }

    public String getSystemID() {
        return this._systemID;
    }

    public DataFormatVersion getDataFormatVersion() {
        return this._dataFormatVersion;
    }

    public DistributionMode getDistributionMode() {
        return this._distributionMode;
    }

    public boolean useTransactionFlagsOnly() {
        return this._useTransactionFlagsOnly;
    }

    public boolean ignoresUnknownParts() {
        return this._ignoreUnknownParts;
    }

    public DataFormatVersion getDataFormatVersion2() {
        return this._dataFormatVersion2;
    }

    public boolean isXOpenXAProtocolSupported() {
        return this._xopenXAProtocolSupported;
    }

    public ActiveActiveProtocolVersion getActiveActiveProtocolVersion() {
        return this._activeActiveProtocolVersion;
    }

    public boolean isQueryTimeoutSupported() {
        return this._queryTimeoutSupported;
    }

    public String getServerVersionString() {
        return this._serverVersionString;
    }

    public String getDatabaseName() {
        return this._databaseName;
    }

    public boolean isImplicitXASessionSupported() {
        return this._implicitXASessionSupported;
    }

    public ClientSideEncryptionVersion getClientSideEncryptionVersion() {
        return this._clientSideEncryptionVersion;
    }

    public boolean isCompressionEnabled() {
        return this._isCompressionEnabled;
    }

    public int getReconnectWaitTimeout() {
        return this._reconnectWaitTimeout;
    }

    public boolean holdCursorOverRollbackSupported() {
        return this._holdCursorOverRollbackSupported;
    }

    public boolean supportDropStatementIDPart() {
        return this._supportDropStatementIDPart;
    }

    public boolean support32BitFetchSize() {
        return this._support32BitFetchSize;
    }

    public boolean supportSavepointSQL() {
        return this._supportSavepointSQL;
    }

    public boolean supportDeferredPrepare() {
        return this._supportDeferredPrepare;
    }

    public boolean supportImplicitXAJoinOnPrepare() {
        return this._supportImplicitXAJoinOnPrepare;
    }

    public boolean supportSessionContextPartOnConnect() {
        return this._supportSessionContextPartOnConnect;
    }

    public boolean supportIdlePing() {
        return this._supportIdlePing;
    }

    public boolean supportIdlePingDuringRequest() {
        return this._supportIdlePingDuringRequest;
    }

    public int getLRRPingTime() {
        return this._lrrPingTime;
    }
}

