/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.DriverSapDB;
import com.sap.db.jdbc.HanaConnection;
import com.sap.db.jdbc.HanaConnectionFinalize;
import com.sap.db.jdbc.HanaConnectionPhantom;
import com.sap.db.jdbc.PreferredAddress;
import com.sap.db.jdbc.trace.TraceControl;
import com.sap.db.jdbc.trace.Tracer;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ThreadSafe
public class Driver
extends DriverSapDB {
    public static final Driver INSTANCE;
    public static final TraceControl pptracer;

    public static Driver getInstance() {
        return INSTANCE;
    }

    public static Driver singleton() {
        return INSTANCE;
    }

    protected static ConnectionSapDB _createConnection(Tracer tracer, Properties info, ConnectionProperties connectionProperties, List<PreferredAddress> preferredAddresses) {
        HanaConnection connection = Driver._createPhantomClass(connectionProperties) ? HanaConnectionPhantom.newInstance(tracer, info, connectionProperties, preferredAddresses) : (Driver._createFinalizerClass(connectionProperties) ? HanaConnectionFinalize.newInstance(tracer, info, connectionProperties, preferredAddresses) : HanaConnection.newInstance(tracer, info, connectionProperties, preferredAddresses));
        return connection;
    }

    static {
        Driver.checkJavaVersionMaximum8();
        INSTANCE = new Driver();
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException e) {
            System.err.println("Can't register driver: " + INSTANCE.getClass().getCanonicalName() + ": " + e.getMessage());
        }
        pptracer = Driver.getTracer().getTraceControl();
    }
}

