/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HanaWebSocket;
import com.sap.db.jdbc.PreferredAddress;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.SecureSession;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.Topologies;
import com.sap.db.jdbc.exceptions.RTEDecompressException;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.RTEInvalidPacketException;
import com.sap.db.jdbc.exceptions.RTETimeoutException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DBConnectInfo;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.PacketAnalyzer;
import com.sap.db.jdbc.packet.PacketOption;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.BufferUtils;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.DbgInstanceCount;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.ProxyUtils;
import com.sap.db.util.SocketUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.ReadPendingException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.WritePendingException;
import java.security.cert.Certificate;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.cert.X509Certificate;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.lz4.LZ4JavaSafeCompressor;
import net.jpountz.lz4.LZ4JavaSafeFastDecompressor;
import org.java_websocket.exceptions.WebsocketNotConnectedException;

@NotThreadSafe
public abstract class Session
extends DbgInstanceCount {
    private static final Set<Session> INSTANCES = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final int MIN_COMPRESSION_SIZE = 10240;
    private static final double MAX_COMPRESSION_PERCENTAGE = 0.95;
    @GuardedBy(value="Session.class")
    private static LZ4Compressor _compressor;
    @GuardedBy(value="Session.class")
    private static LZ4FastDecompressor _decompressor;
    protected final WeakReference<ConnectionSapDB> _connection;
    protected final Lock _socketLock;
    protected final Tracer _tracer;
    protected final AtomicReference<Address> _address;
    protected final ConnectionProperties _connectionProperties;
    private final long _instantiationTime;
    private final String _bindAddress;
    private final int _heartbeatPingRequestTimeout;
    private final int _requestPacketSize;
    private final AtomicInteger _connectionID;
    private final AtomicBoolean _isFirstReplyVerified;
    private final AtomicLong _sessionID;
    private final AtomicInteger _messageID;
    private final AtomicLong _sendTime;
    private final AtomicLong _receiveTime;
    private final AtomicLong _totalSendTime;
    private final AtomicLong _totalReceiveTime;
    private final AtomicLong _sentPacketCount;
    private final AtomicLong _receivedPacketCount;
    private final AtomicLong _sentByteCount;
    private final AtomicLong _receivedByteCount;
    private final AtomicLong _uncompressedSentByteCount;
    private final AtomicLong _uncompressedReceivedByteCount;
    private final AtomicBoolean _isHintRouted;
    private final AtomicBoolean _isDestroyed;
    private final SessionType _sessionType;
    private final String _hostAddress;
    @GuardedBy(value="_socketLock")
    private int _timeout;
    @GuardedBy(value="_socketLock")
    private Socket _socket;
    @GuardedBy(value="_socketLock")
    private HanaWebSocket _webSocket;
    @GuardedBy(value="_socketLock")
    private AsynchronousSocketChannel _channel;
    @GuardedBy(value="_socketLock")
    private InputStream _inputStream;
    @GuardedBy(value="_socketLock")
    private OutputStream _outputStream;
    @GuardedBy(value="_socketLock")
    private ByteBuffer _sendBuffer;
    @GuardedBy(value="_socketLock")
    private ByteBuffer _receiveBuffer;
    @GuardedBy(value="_socketLock")
    private SoftReference<byte[]> _compressionBuffer;
    @GuardedBy(value="_socketLock")
    private HRequestPacket _pingPacket;
    @GuardedBy(value="_socketLock")
    private boolean _isDuringRequest;
    @GuardedBy(value="_connection (implicit)")
    private boolean _isPartOfTransaction;
    @GuardedBy(value="_connection (implicit)")
    private boolean _isPartOfDistributedTransaction;
    @GuardedBy(value="_connection (implicit)")
    private boolean _isSendSessionContextFlagSet;
    @GuardedBy(value="_connection (implicit)")
    private boolean _isSendSessionVariablesFlagSet;
    @GuardedBy(value="_connection (implicit)")
    private boolean _isSendClientInfoFlagSet;
    @GuardedBy(value="_connection (implicit)")
    private Properties _currentSessionVariablesAndClientInfoProperties;
    private static int _compressedPacketCount;
    private static int _decompressedPacketCount;
    private final AtomicInteger _pingSentCount;
    private final AtomicInteger _pingReceivedCount;

    public static Session newInstance(SessionFactory factory, ConnectionSapDB connection, Address address, boolean doConnectExchange) throws RTEException {
        ConnectionProperties connectionProperties = connection.getConnectionProperties();
        try {
            Session initialSession = factory.newInstance(connection, address);
            initialSession._doInfoExchange();
            Session returnedSession = doConnectExchange ? initialSession._doConnectExchange(factory, connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME), connectionProperties.getProperty(ConnectionProperty.NETWORK_GROUP)) : initialSession;
            Topologies.setUnreachable(address, false);
            return returnedSession;
        }
        catch (RTEException e) {
            Topologies.setUnreachable(address, true);
            throw e;
        }
    }

    Session(ConnectionSapDB connection, Address address) throws RTEException {
        INSTANCES.add(this);
        this._instantiationTime = System.currentTimeMillis();
        this._connection = new WeakReference<ConnectionSapDB>(connection);
        this._socketLock = new ReentrantLock();
        this._tracer = connection.getTracer();
        this._address = new AtomicReference<Address>(address);
        this._connectionProperties = connection.getConnectionProperties();
        this._bindAddress = this._connectionProperties.getProperty(ConnectionProperty.BIND_ADDRESS);
        this._heartbeatPingRequestTimeout = this._connectionProperties.getIntProperty(ConnectionProperty.HEARTBEAT_PING_REQUEST_TIMEOUT);
        this._requestPacketSize = PacketAnalyzer.align(this._connectionProperties.getIntProperty(ConnectionProperty.PACKET_SIZE));
        this._connectionID = new AtomicInteger();
        this._isFirstReplyVerified = new AtomicBoolean(false);
        this._sessionID = new AtomicLong(0L);
        this._messageID = new AtomicInteger();
        this._sendTime = new AtomicLong();
        this._receiveTime = new AtomicLong();
        this._totalSendTime = new AtomicLong();
        this._totalReceiveTime = new AtomicLong();
        this._sentPacketCount = new AtomicLong();
        this._receivedPacketCount = new AtomicLong();
        this._sentByteCount = new AtomicLong();
        this._receivedByteCount = new AtomicLong();
        this._uncompressedSentByteCount = new AtomicLong();
        this._uncompressedReceivedByteCount = new AtomicLong();
        this._isHintRouted = new AtomicBoolean();
        this._isDestroyed = new AtomicBoolean();
        this._sessionType = SessionType._getSessionType(this instanceof SecureSession, this._connectionProperties);
        this._currentSessionVariablesAndClientInfoProperties = new Properties();
        if (this._tracer.on()) {
            this._tracer.printSessionOpening(this);
        }
        this._hostAddress = this._connect();
        this._pingSentCount = new AtomicInteger();
        this._pingReceivedCount = new AtomicInteger();
    }

    void destroy() {
        try {
            this._socketLock.lock();
            if (this._isDestroyed.getAndSet(true)) {
                return;
            }
            if (this._tracer.on()) {
                this._tracer.printSessionClosing(this);
                this._tracer.printSessionStatistics(this);
            }
            if (this._sessionType.isChannel()) {
                this._closeChannel();
            } else {
                this._closeSocket();
            }
            INSTANCES.remove(this);
            if (this._tracer.on()) {
                this._tracer.printSessionClosed(this);
            }
        }
        finally {
            this._socketLock.unlock();
        }
    }

    protected abstract void _sendBytes(byte[] var1, int var2, boolean var3) throws RTEException;

    protected abstract int _receiveBytes(byte[] var1, int var2, int var3) throws RTEException;

    protected abstract void _writeBytes(byte[] var1, int var2, boolean var3) throws RTEException;

    protected abstract int _readBytes(byte[] var1, int var2, int var3, boolean var4) throws RTEException;

    public String toString() {
        return this.getTraceString(true, false);
    }

    public String getTraceString(boolean isFullString, boolean includeConnection) {
        ConnectionSapDB connection = includeConnection ? (ConnectionSapDB)this._connection.get() : null;
        return super.toString() + (includeConnection && connection != null ? " " + connection.getClass().getSimpleName() + "@" + Integer.toHexString(connection.hashCode()) : "") + " " + this._address.get().getTraceString(isFullString) + (isFullString ? " ConnectionID:" + this._connectionID.get() + " SessionID:" + this._sessionID.get() + " on " + (this._sessionType.isChannel() ? this._channel : this._socket) : "");
    }

    public long getInstantiationTime() {
        return this._instantiationTime;
    }

    public Address getAddress() {
        return this._address.get();
    }

    public SiteVolumeID getSiteVolumeID() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).getSiteVolumeID() : SiteVolumeID.DUMMY;
    }

    public SiteType getSiteType() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).getSiteType() : SiteType.NONE;
    }

    public boolean isNoneOrPrimarySite() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).isNoneOrPrimarySite() : true;
    }

    public boolean isPrimarySite() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).isPrimarySite() : false;
    }

    public boolean isSecondarySite() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).isSecondarySite() : false;
    }

    public int getConnectionID() {
        return this._connectionID.get();
    }

    public void setConnectionID(int connectionID) {
        this._connectionID.set(connectionID);
    }

    public boolean isHintRouted() {
        return this._isHintRouted.get();
    }

    public void setHintRouted(boolean isHintRouted) {
        this._isHintRouted.set(isHintRouted);
    }

    public boolean isConnected() {
        return !this._isDestroyed.get();
    }

    public boolean isWebSocketConnection() {
        return this._webSocket != null;
    }

    public SessionType getSessionType() {
        return this._sessionType;
    }

    public String getIPAddress() {
        return this._hostAddress;
    }

    public boolean isPartOfTransaction() {
        return this._isPartOfTransaction;
    }

    public boolean isPartOfDistributedTransaction() {
        return this._isPartOfDistributedTransaction;
    }

    public void joinTransaction() {
        this._isPartOfTransaction = true;
    }

    public void joinDistributedTransaction() {
        this._isPartOfTransaction = true;
        this._isPartOfDistributedTransaction = true;
    }

    public void leaveTransaction() {
        this._isPartOfTransaction = false;
        this._isPartOfDistributedTransaction = false;
    }

    public boolean isSendSessionContextFlagSet() {
        return this._isSendSessionContextFlagSet;
    }

    public void setSendSessionContextFlag() {
        this._isSendSessionContextFlagSet = true;
    }

    public void clearSendSessionContextFlag() {
        this._isSendSessionContextFlagSet = false;
    }

    public boolean isSendSessionVariablesFlagSet() {
        return this._isSendSessionVariablesFlagSet;
    }

    public void setSendSessionVariablesFlag() {
        if (!this._isHintRouted.get()) {
            return;
        }
        this._isSendSessionVariablesFlagSet = true;
    }

    public boolean isSendClientInfoFlagSet() {
        return this._isSendClientInfoFlagSet;
    }

    public void setSendClientInfoFlag() {
        this._isSendClientInfoFlagSet = true;
    }

    public void clearSendSessionVariablesAndClientInfoFlags(ConnectionSapDB connection) {
        Properties properties = new Properties();
        this._isSendSessionVariablesFlagSet = false;
        this._isSendClientInfoFlagSet = false;
        properties.putAll((Map<?, ?>)connection._getClientInfo());
        if (this._isHintRouted.get()) {
            properties.putAll((Map<?, ?>)connection._getSessionVariables());
        }
        this._currentSessionVariablesAndClientInfoProperties = properties;
    }

    public Properties getCurrentSessionVariablesAndClientInfoProperties() {
        return this._currentSessionVariablesAndClientInfoProperties;
    }

    public long getSendTime() {
        return this._sendTime.get();
    }

    public long getReceiveTime() {
        return this._receiveTime.get();
    }

    public long getTotalSendTime() {
        return this._totalSendTime.get();
    }

    public long getTotalReceiveTime() {
        return this._totalReceiveTime.get();
    }

    public long getSentPacketCount() {
        return this._sentPacketCount.get();
    }

    public long getReceivedPacketCount() {
        return this._receivedPacketCount.get();
    }

    public long getSentByteCount() {
        return this._sentByteCount.get();
    }

    public long getReceivedByteCount() {
        return this._receivedByteCount.get();
    }

    public long getUncompressedSentByteCount() {
        return this._uncompressedSentByteCount.get();
    }

    public long getUncompressedReceivedByteCount() {
        return this._uncompressedReceivedByteCount.get();
    }

    public double getSentCompressionRatio() {
        return (double)this._uncompressedSentByteCount.get() / (double)this._sentByteCount.get();
    }

    public double getReceivedCompressionRatio() {
        return (double)this._uncompressedReceivedByteCount.get() / (double)this._receivedByteCount.get();
    }

    protected X509Certificate[] _getPeerCertificateChain() {
        return null;
    }

    protected Certificate[] _getPeerCertificates() {
        return null;
    }

    public void writeProxy(byte[] buffer, int len) throws RTEException {
        this._writeBytes(buffer, len, false);
    }

    public int readProxy(byte[] buffer, int off, int len, boolean strictLength) throws RTEException {
        return this._readBytes(buffer, off, len, strictLength);
    }

    public Session _processDBConnectInfoPart(SessionFactory factory, DBConnectInfo dbConnectInfo) throws RTEException {
        String hostName = dbConnectInfo.getHost();
        int portNumber = dbConnectInfo.getPort();
        if (hostName == null || hostName.isEmpty() || portNumber <= 0) {
            this._throwRTEException(MessageTranslator.translate("error.unknown.host", hostName + ":" + portNumber, "No additional information", RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
        }
        if (this._tracer.on()) {
            this._tracer.printSessionMessage(this, "Redirecting to " + hostName + ":" + portNumber, new String[0]);
        }
        this.destroy();
        PreferredAddress address = new PreferredAddress(hostName, portNumber);
        Session newSession = Session.newInstance(factory, (ConnectionSapDB)this._connection.get(), address, false);
        return newSession;
    }

    HRequestPacket newRequestPacket() {
        return HRequestPacket.newInstance(new byte[this._requestPacketSize]);
    }

    void send(HRequestPacket requestPacket, EngineFeatures engineFeatures) throws RTEException {
        try {
            this._socketLock.lock();
            this._sendPacket(requestPacket, engineFeatures, false);
            this._isDuringRequest = true;
        }
        finally {
            this._socketLock.unlock();
        }
    }

    HReplyPacket receive(EngineFeatures engineFeatures) throws RTEException {
        try {
            this._socketLock.lock();
            this._isDuringRequest = false;
            HReplyPacket hReplyPacket = this._receivePacket(engineFeatures);
            return hReplyPacket;
        }
        finally {
            this._socketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPing() {
        boolean wasAcquired = false;
        if (this._isDestroyed.get()) {
            return;
        }
        try {
            wasAcquired = this._socketLock.tryLock();
            if (!wasAcquired) {
                return;
            }
            if (this._isDuringRequest && !((ConnectionSapDB)this._connection.get()).supportIdlePingDuringRequest()) {
                return;
            }
            if (this._pingPacket == null) {
                this._pingPacket = HRequestPacket.newInstance(new byte[56]);
            }
            this._pingPacket.initPing();
            this._sendPacket(this._pingPacket, null, true);
            this._pingSentCount.incrementAndGet();
        }
        catch (RTEException rTEException) {
        }
        finally {
            if (wasAcquired) {
                this._socketLock.unlock();
            }
        }
    }

    int getTimeout() {
        try {
            this._socketLock.lock();
            int n = this._timeout;
            return n;
        }
        finally {
            this._socketLock.unlock();
        }
    }

    void setTimeout(int milliseconds) {
        try {
            this._socketLock.lock();
            this._timeout = milliseconds;
            if (!this._sessionType.isChannel()) {
                this._socket.setSoTimeout(this._timeout);
            }
        }
        catch (SocketException socketException) {
        }
        finally {
            this._socketLock.unlock();
        }
    }

    protected String _connect() throws RTEException {
        InetSocketAddress socketAddress;
        int port;
        String host;
        Address address;
        String hostAddress;
        block21: {
            hostAddress = null;
            address = this._address.get();
            host = address.getHost();
            port = address.getPort();
            if (this._sessionType.isProxy()) {
                String proxyHostName = this._connectionProperties.getProperty(ConnectionProperty.PROXY_HOST_NAME);
                int proxyPort = this._connectionProperties.getIntProperty(ConnectionProperty.PROXY_PORT);
                socketAddress = new InetSocketAddress(proxyHostName, proxyPort);
            } else {
                socketAddress = new InetSocketAddress(host, port);
            }
            this._timeout = this._connectionProperties.getIntProperty(ConnectionProperty.CONNECT_TIMEOUT);
            if (this._sessionType.isChannel()) {
                try {
                    this._channel = AsynchronousSocketChannel.open();
                    this._setChannelOptions(this._channel);
                    if (this._bindAddress != null && !this._bindAddress.isEmpty()) {
                        this._channel.bind(new InetSocketAddress(this._bindAddress, 0));
                    }
                    Future<Void> connectFuture = this._channel.connect(socketAddress);
                    if (this._timeout > 0) {
                        connectFuture.get(this._timeout, TimeUnit.MILLISECONDS);
                        break block21;
                    }
                    connectFuture.get();
                }
                catch (UnresolvedAddressException e) {
                    this._throwRTEException(MessageTranslator.translate("error.unknown.host", socketAddress.toString(), e.getMessage(), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
                }
                catch (IOException | InterruptedException | SecurityException | AlreadyConnectedException | ConnectionPendingException | UnsupportedAddressTypeException | CancellationException | ExecutionException | TimeoutException e) {
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", socketAddress.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
                }
            } else {
                try {
                    this._socket = new Socket();
                    this._setSocketOptions(this._socket);
                    if (this._bindAddress != null && !this._bindAddress.isEmpty()) {
                        this._socket.bind(new InetSocketAddress(this._bindAddress, 0));
                    }
                    this._socket.connect(socketAddress, this._timeout);
                    this._inputStream = this._socket.getInputStream();
                    this._outputStream = this._socket.getOutputStream();
                }
                catch (UnknownHostException e) {
                    this._throwRTEException(MessageTranslator.translate("error.unknown.host", socketAddress.toString(), e.getMessage(), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
                }
                catch (IOException | IllegalArgumentException | IllegalBlockingModeException e) {
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", socketAddress.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
                }
            }
        }
        if (this._sessionType.isProxy()) {
            String proxyUserName = this._connectionProperties.getProperty(ConnectionProperty.PROXY_USER_NAME);
            String proxyPassword = this._connectionProperties.getProperty(ConnectionProperty.PROXY_PASSWD);
            if (this._sessionType.isHttpProxy()) {
                ProxyUtils.doHttpAuthentication(this._tracer, this, host, port, proxyUserName, proxyPassword);
            } else {
                String proxyScpAccount = this._connectionProperties.getProperty(ConnectionProperty.PROXY_SCP_ACCOUNT);
                ProxyUtils.doSocksAuthentication(this._tracer, this, host, port, proxyUserName, proxyPassword, proxyScpAccount);
            }
        }
        if (this._sessionType.isChannel()) {
            try {
                hostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (IOException e) {
                this._throwRTEException(MessageTranslator.translate("error.host.connect", socketAddress.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
            }
        } else {
            hostAddress = this._socket.getLocalAddress().getHostAddress();
            if (this._sessionType.isWebSocket()) {
                String webSocketUrl = this._connectionProperties.getProperty(ConnectionProperty.WEB_SOCKET_URL);
                this._webSocket = new HanaWebSocket(this._tracer, this._connectionProperties, this._getWebSocketUri(address, webSocketUrl), this._socket);
                this._setWebSocketDefaults(this._connectionProperties);
            }
        }
        return hostAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _writeChannel(byte[] buffer, int len, boolean isPing) throws RTEException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, 0, len);
        int remaining = len;
        try {
            int sendBufferSize = this._channel.getOption(StandardSocketOptions.SO_SNDBUF);
            if (this._sendBuffer == null || this._sendBuffer.capacity() != sendBufferSize) {
                this._sendBuffer = this._channelAllocate(sendBufferSize);
            }
            BufferUtils.clear(this._sendBuffer);
            BufferUtils.limit(this._sendBuffer, Math.min(remaining, this._sendBuffer.capacity()));
            while (remaining > 0) {
                if (this._sendBuffer.position() == 0) {
                    BufferUtils.limit(byteBuffer, byteBuffer.position() + Math.min(remaining, this._sendBuffer.capacity()));
                    this._sendBuffer.put(byteBuffer);
                    BufferUtils.limit(byteBuffer, len);
                    BufferUtils.flip(this._sendBuffer);
                }
                Future<Integer> future = this._channel.write(this._sendBuffer);
                int count = isPing ? future.get(this._heartbeatPingRequestTimeout, TimeUnit.MILLISECONDS) : (this._timeout > 0 ? future.get(this._timeout, TimeUnit.MILLISECONDS).intValue() : future.get().intValue());
                if (this._sendBuffer.remaining() == 0) {
                    BufferUtils.flip(this._sendBuffer);
                }
                remaining -= count;
            }
        }
        catch (TimeoutException e) {
            this._throwRTETimeoutException(MessageTranslator.translate("error.send.write", e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
        }
        catch (IOException | InterruptedException | NotYetConnectedException | WritePendingException | ExecutionException e) {
            this._throwRTEException(MessageTranslator.translate("error.send.write", e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final int _readChannel(byte[] buffer, int off, int len, boolean strictLength) throws RTEException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, off, len);
        int remaining = len;
        try {
            int receiveBufferSize = this._channel.getOption(StandardSocketOptions.SO_RCVBUF);
            if (this._receiveBuffer == null || this._receiveBuffer.capacity() != receiveBufferSize) {
                this._receiveBuffer = this._channelAllocate(receiveBufferSize);
            }
            while (true) {
                if (remaining <= 0) {
                    return len;
                }
                BufferUtils.clear(this._receiveBuffer);
                BufferUtils.limit(this._receiveBuffer, Math.min(remaining, this._receiveBuffer.capacity()));
                Future<Integer> future = this._channel.read(this._receiveBuffer);
                int count = this._timeout > 0 ? future.get(this._timeout, TimeUnit.MILLISECONDS).intValue() : future.get().intValue();
                if (count == -1) {
                    return count;
                }
                if (count > 0) {
                    BufferUtils.flip(this._receiveBuffer);
                    byteBuffer.put(this._receiveBuffer);
                }
                if (count > 0 && !strictLength) {
                    return count;
                }
                remaining -= count;
            }
        }
        catch (TimeoutException e) {
            this._throwRTETimeoutException(MessageTranslator.translate("error.data.receivefailed.reason", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            throw new AssertionError((Object)"_throwRTEException didn't throw an RTEException");
        }
        catch (IOException | IllegalArgumentException | InterruptedException | NotYetConnectedException | ReadPendingException | ExecutionException e) {
            this._throwRTEException(MessageTranslator.translate("error.data.receivefailed.reason", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            throw new AssertionError((Object)"_throwRTEException didn't throw an RTEException");
        }
    }

    protected final void _writeSocket(byte[] buffer, int len) throws RTEException {
        try {
            this._outputStream.write(buffer, 0, len);
        }
        catch (IOException e) {
            this._throwRTEException(MessageTranslator.translate("error.send.write", e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
        }
    }

    protected final int _readSocket(byte[] buffer, int off, int len) throws RTEException {
        try {
            return this._inputStream.read(buffer, off, len);
        }
        catch (SocketTimeoutException e) {
            this._throwRTETimeoutException(MessageTranslator.translate("error.data.receivefailed.reason", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
        catch (IOException e) {
            this._throwRTEException(MessageTranslator.translate("error.data.receivefailed.reason", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
        throw new AssertionError((Object)"_throwRTEException didn't throw an RTEException");
    }

    protected final void _writeWebSocket(byte[] buffer, int len) throws RTEException {
        try {
            this._webSocket._writeSocket(buffer, len);
        }
        catch (RTEException e) {
            this._throwRTEException(e);
        }
    }

    protected final int _readWebSocket(byte[] buffer, int off, int len) throws RTEException {
        try {
            return this._webSocket._readSocket(buffer, off, len);
        }
        catch (RTEException e) {
            this._throwRTEException(e);
            throw new AssertionError((Object)"_throwRTEException didn't throw an RTEException");
        }
    }

    protected void _setSocketOptions(Socket socket) {
        try {
            socket.setSoTimeout(this._timeout);
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            socket.setSoLinger(true, 15);
            SocketUtils.setKeepAliveOptions(socket, this._connectionProperties.getIntProperty(ConnectionProperty.TCP_KEEP_ALIVE_IDLE), this._connectionProperties.getIntProperty(ConnectionProperty.TCP_KEEP_ALIVE_INTERVAL), this._connectionProperties.getIntProperty(ConnectionProperty.TCP_KEEP_ALIVE_COUNT));
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    protected void _setChannelOptions(AsynchronousSocketChannel channel) {
        try {
            channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
            channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            SocketUtils.setKeepAliveOptions(channel, this._connectionProperties.getIntProperty(ConnectionProperty.TCP_KEEP_ALIVE_IDLE), this._connectionProperties.getIntProperty(ConnectionProperty.TCP_KEEP_ALIVE_INTERVAL), this._connectionProperties.getIntProperty(ConnectionProperty.TCP_KEEP_ALIVE_COUNT));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void _sendPacket(HRequestPacket requestPacket, EngineFeatures engineFeatures, boolean isPing) throws RTEException {
        long beforeSend = Session._getNanoTime();
        byte[] packet = requestPacket.getRawPacketArray();
        int len = requestPacket.getLength();
        int uncompressedHeaderLength = 56;
        byte[] workBuffer = null;
        boolean isCompressed = false;
        ByteUtils.putLong(this._sessionID.get(), packet, 0);
        ByteUtils.putInt(this._messageID.getAndIncrement(), packet, 8);
        if (engineFeatures != null && engineFeatures.isCompressionEnabled() && len >= 10240) {
            try {
                int uncompressedRemainderLength = len - uncompressedHeaderLength;
                int maximumCompressedRemainderLength = (int)((double)uncompressedRemainderLength * 0.95);
                workBuffer = this._getCompressionWorkBuffer(uncompressedHeaderLength + maximumCompressedRemainderLength);
                int compressedRemainderLength = Session._getCompressor().compress(packet, uncompressedHeaderLength, uncompressedRemainderLength, workBuffer, uncompressedHeaderLength, maximumCompressedRemainderLength);
                isCompressed = true;
                len = uncompressedHeaderLength + compressedRemainderLength;
                int varpartLength = 24 + compressedRemainderLength;
                int compressionVarpartLength = 24 + uncompressedRemainderLength;
                packet[22] = (byte)(packet[22] | PacketOption.IsCompressed.getValue());
                ByteUtils.putInt(varpartLength, packet, 12);
                ByteUtils.putInt(compressionVarpartLength, packet, 24);
                System.arraycopy(packet, 0, workBuffer, 0, uncompressedHeaderLength);
            }
            catch (LZ4Exception lZ4Exception) {
                // empty catch block
            }
        }
        long beforeTrace = Session._getNanoTime();
        if (this._tracer.on()) {
            this._tracer.printPacket(packet, engineFeatures);
        }
        long afterTrace = Session._getNanoTime();
        if (isCompressed) {
            this._sendBytes(workBuffer, len, isPing);
        } else {
            this._sendBytes(packet, len, isPing);
        }
        long afterSend = Session._getNanoTime();
        this._sentByteCount.addAndGet(len);
        this._uncompressedSentByteCount.addAndGet(requestPacket.getLength());
        this._sentPacketCount.incrementAndGet();
        long sendTime = beforeTrace - beforeSend + (afterSend - afterTrace);
        this._sendTime.set(sendTime);
        this._totalSendTime.addAndGet(sendTime);
        if (this._tracer.on()) {
            this._tracer.accumulateNetworkTime(sendTime);
            this._tracer.printPacketElapsedSendTime(sendTime);
        }
    }

    protected HReplyPacket _receivePacket(EngineFeatures engineFeatures) throws RTEException {
        int receivedByteCount;
        int uncompressedRemainderLength;
        boolean isCompressed;
        long beforeTrace;
        long sessionID;
        long beforeReceive = Session._getNanoTime();
        int uncompressedHeaderLength = 56;
        byte[] uncompressedHeader = new byte[uncompressedHeaderLength];
        long pingReceivedByteCount = 0L;
        long pingReceivedPacketCount = 0L;
        long pingReceiveTime = 0L;
        while (true) {
            FunctionCode functionCode;
            if (this._receiveBytes(uncompressedHeader, 0, uncompressedHeaderLength) < uncompressedHeaderLength) {
                this._throwRTEException(MessageTranslator.translate("error.data.receivefailed", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            sessionID = ByteUtils.getLong(uncompressedHeader, 0);
            int packetCount = ByteUtils.getInt(uncompressedHeader, 8);
            if (!this._isFirstReplyVerified.get()) {
                if (sessionID != 0L || packetCount != 0) {
                    this._throwRTEException(MessageTranslator.translate("error.data.receivefailed", new Object[0]), RteReturnCode.REQUEST_UNKNOWN);
                }
                this._isFirstReplyVerified.set(true);
            }
            if ((functionCode = FunctionCode.decode(ByteUtils.getShort(uncompressedHeader, 46))) != FunctionCode.Ping) break;
            this._pingReceivedCount.incrementAndGet();
            beforeTrace = Session._getNanoTime();
            if (this._tracer.on()) {
                this._tracer.printPacket(uncompressedHeader, engineFeatures);
            }
            pingReceivedByteCount += (long)uncompressedHeaderLength;
            ++pingReceivedPacketCount;
            pingReceiveTime += beforeTrace - beforeReceive;
            beforeReceive = Session._getNanoTime();
        }
        this._sessionID.set(sessionID);
        int varpartLength = ByteUtils.getInt(uncompressedHeader, 12);
        if (varpartLength < 0) {
            this._throwRTEInvalidPacketException(MessageTranslator.translate("error.packet.too.large", new Object[0]), RteReturnCode.SQLPACKETLIMIT);
        }
        boolean bl = isCompressed = (ByteUtils.getByte(uncompressedHeader, 22) & PacketOption.IsCompressed.getValue()) != 0;
        if (isCompressed) {
            int compressionVarpartLength = ByteUtils.getInt(uncompressedHeader, 24);
            if (compressionVarpartLength < 0) {
                this._throwRTEInvalidPacketException(MessageTranslator.translate("error.packet.invalid", new Object[0]), RteReturnCode.REQUEST_UNKNOWN);
            }
            uncompressedRemainderLength = compressionVarpartLength - 24;
        } else {
            uncompressedRemainderLength = varpartLength - 24;
        }
        byte[] packet = new byte[uncompressedHeaderLength + uncompressedRemainderLength];
        System.arraycopy(uncompressedHeader, 0, packet, 0, uncompressedHeaderLength);
        if (isCompressed) {
            int compressedRemainderLength = varpartLength - 24;
            byte[] workBuffer = this._getCompressionWorkBuffer(compressedRemainderLength);
            this._receiveRemainderOfPacket(workBuffer, 0, compressedRemainderLength);
            try {
                int decompressedLength = Session._getDecompressor().decompress(workBuffer, 0, packet, uncompressedHeaderLength, uncompressedRemainderLength);
                if (decompressedLength != compressedRemainderLength) {
                    this._throwRTEDecompressException(MessageTranslator.translate("error.packet.decompress.failed", new Object[0]), RteReturnCode.SQLNOTOK, null);
                }
            }
            catch (LZ4Exception e) {
                this._throwRTEDecompressException(MessageTranslator.translate("error.packet.decompress.failed", new Object[0]), RteReturnCode.SQLNOTOK, e);
            }
            receivedByteCount = uncompressedHeaderLength + compressedRemainderLength;
        } else {
            this._receiveRemainderOfPacket(packet, uncompressedHeaderLength, uncompressedRemainderLength);
            receivedByteCount = packet.length;
        }
        beforeTrace = Session._getNanoTime();
        if (this._tracer.on()) {
            this._tracer.printPacket(packet, engineFeatures);
        }
        long afterTrace = Session._getNanoTime();
        HReplyPacket replyPacket = HReplyPacket.newInstance(this._tracer, packet);
        long afterReceive = Session._getNanoTime();
        this._receivedByteCount.addAndGet(pingReceivedByteCount + (long)receivedByteCount);
        this._uncompressedReceivedByteCount.addAndGet(pingReceivedByteCount + (long)packet.length);
        this._receivedPacketCount.addAndGet(pingReceivedPacketCount + 1L);
        long receiveTime = pingReceiveTime + (beforeTrace - beforeReceive) + (afterReceive - afterTrace);
        this._receiveTime.set(receiveTime);
        this._totalReceiveTime.addAndGet(receiveTime);
        if (this._tracer.on()) {
            this._tracer.accumulateNetworkTime(receiveTime);
            this._tracer.printPacketElapsedReceiveTime(receiveTime, pingReceivedPacketCount);
        }
        return replyPacket;
    }

    protected void _doInfoExchange() throws RTEException {
        byte[] request = new byte[14];
        byte[] reply = new byte[8];
        ByteUtils.putLongBigEndian(-1L, request, 0);
        ByteUtils.putByte(4, request, 4);
        ByteUtils.putShortBigEndian(20, request, 5);
        ByteUtils.putByte(4, request, 7);
        ByteUtils.putShortBigEndian(1, request, 8);
        ByteUtils.putByte(1, request, 11);
        ByteUtils.putByte(1, request, 12);
        ByteUtils.putByte(1, request, 13);
        this._sendBytes(request, 14, false);
        int len = this._receiveBytes(reply, 0, 8);
        if (len < 8) {
            this._throwRTEException(MessageTranslator.translate("error.recv.connect", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
    }

    protected Session _doConnectExchange(SessionFactory factory, String databaseName, String networkGroup) throws RTEException {
        if (databaseName == null || databaseName.isEmpty()) {
            return this;
        }
        HRequestPacket requestPacket = this.newRequestPacket();
        requestPacket.initDBConnectInfo(databaseName, networkGroup);
        this.send(requestPacket, null);
        HReplyPacket replyPacket = this.receive(null);
        DBConnectInfo dbConnectInfo = replyPacket.findDBConnectInfo(0);
        if (dbConnectInfo == null) {
            SQLException sqlException = replyPacket.findSQLExceptionChain(null, 0);
            if (sqlException == null) {
                sqlException = SQLExceptionSapDB.newInstance("error.internal.unknownError", new String[0]);
            }
            this._throwRTEException(sqlException.getMessage(), RteReturnCode.decode(sqlException.getErrorCode()), -708);
        }
        if (dbConnectInfo.isOnCorrectDatabase()) {
            return this;
        }
        return this._processDBConnectInfoPart(factory, dbConnectInfo);
    }

    protected URI _getWebSocketUri(Address address, String resource) throws RTEException {
        URI webSocketUri = null;
        String uriString = "ws://" + address.toString() + (resource.charAt(0) != '/' ? "/" : "") + resource.trim();
        try {
            webSocketUri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            this._throwRTEException(MessageTranslator.translate("error.invalid.websocket.uri", address.getHost(), address.getPort(), resource, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
        return webSocketUri;
    }

    protected void _setWebSocketDefaults(ConnectionProperties connectionProperties) {
        connectionProperties.setProperty(ConnectionProperty.IGNORE_TOPOLOGY, "true");
        if (!connectionProperties.hasProperty(ConnectionProperty.COMPRESS)) {
            connectionProperties.setProperty(ConnectionProperty.COMPRESS, "true");
        }
        if (!connectionProperties.hasProperty(ConnectionProperty.RECONNECT)) {
            connectionProperties.setProperty(ConnectionProperty.RECONNECT, "false");
        }
    }

    protected void _throwRTETimeoutException(String message, RteReturnCode rteReturnCode) throws RTEException {
        this.destroy();
        throw new RTETimeoutException(this._tracer, message, rteReturnCode);
    }

    protected void _throwRTEDecompressException(String message, RteReturnCode rteReturnCode, Throwable cause) throws RTEException {
        this.destroy();
        throw new RTEDecompressException(this._tracer, message, rteReturnCode, cause);
    }

    protected void _throwRTEInvalidPacketException(String message, RteReturnCode rteReturnCode) throws RTEException {
        this.destroy();
        throw new RTEInvalidPacketException(this._tracer, message, rteReturnCode);
    }

    protected void _throwRTEException(String message, RteReturnCode rteReturnCode) throws RTEException {
        this.destroy();
        throw new RTEException(this._tracer, message, rteReturnCode);
    }

    protected void _throwRTEException(String message, RteReturnCode rteReturnCode, int detailErrorCode) throws RTEException {
        this.destroy();
        throw new RTEException(this._tracer, message, rteReturnCode, detailErrorCode);
    }

    protected void _throwRTEException(String message, RteReturnCode rteReturnCode, Throwable cause) throws RTEException {
        this.destroy();
        throw new RTEException(this._tracer, message, rteReturnCode, cause);
    }

    protected void _throwRTEException(String message, RteReturnCode rteReturnCode, int detailErrorCode, Throwable cause) throws RTEException {
        this.destroy();
        throw new RTEException(this._tracer, message, rteReturnCode, detailErrorCode, cause);
    }

    protected void _throwRTEException(RTEException e) throws RTEException {
        this.destroy();
        throw e;
    }

    private static long _getNanoTime() {
        return System.nanoTime();
    }

    private static synchronized LZ4Compressor _getCompressor() {
        if (_compressor != null) {
            return _compressor;
        }
        _compressor = LZ4JavaSafeCompressor.INSTANCE;
        return _compressor;
    }

    private static synchronized LZ4FastDecompressor _getDecompressor() {
        if (_decompressor != null) {
            return _decompressor;
        }
        _decompressor = LZ4JavaSafeFastDecompressor.INSTANCE;
        return _decompressor;
    }

    private ByteBuffer _channelAllocate(int size) {
        if (this._sessionType.isDirectMemory()) {
            return ByteBuffer.allocateDirect(size);
        }
        return ByteBuffer.allocate(size);
    }

    private byte[] _getCompressionWorkBuffer(int requiredSize) {
        byte[] buffer;
        if (this._compressionBuffer != null && (buffer = this._compressionBuffer.get()) != null && buffer.length >= requiredSize) {
            return buffer;
        }
        this._compressionBuffer = null;
        buffer = new byte[requiredSize];
        this._compressionBuffer = new SoftReference<byte[]>(buffer);
        return buffer;
    }

    private void _receiveRemainderOfPacket(byte[] packet, int off, int len) throws RTEException {
        while (len > 0) {
            int n = this._receiveBytes(packet, off, len);
            if (n == -1) {
                this._throwRTEException(MessageTranslator.translate("error.data.receivefailed", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            off += n;
            len -= n;
        }
    }

    private void _closeChannel() {
        if (this._channel == null) {
            return;
        }
        try {
            this._channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void _closeSocket() {
        if (this._socket == null) {
            return;
        }
        try {
            if (this._webSocket != null) {
                this._webSocket.close();
            } else {
                this._socket.close();
            }
        }
        catch (IOException | WebsocketNotConnectedException exception) {
            // empty catch block
        }
    }

    int getMessageID() {
        return this._messageID.get();
    }

    protected void _kill() {
        try {
            this._socketLock.lock();
            if (this._sessionType.isChannel()) {
                this._closeChannel();
            } else {
                this._closeSocket();
            }
        }
        finally {
            this._socketLock.unlock();
        }
    }

    protected void _killUnsafe() {
        if (this._sessionType.isChannel()) {
            this._closeChannel();
        } else {
            this._closeSocket();
        }
    }

    int getPingSentCount() {
        return this._pingSentCount.get();
    }

    void clearPingSentCount() {
        this._pingSentCount.set(0);
    }

    int getPingReceivedCount() {
        return this._pingReceivedCount.get();
    }

    void clearPingReceivedCount() {
        this._pingReceivedCount.set(0);
    }

    public static enum SessionType {
        TCP_SOCKET(new SessionFlag[0]),
        TCP_SOCKET_WITH_HTTPPROXY(SessionFlag.HTTPPROXY),
        TCP_SOCKET_WITH_SOCKSPROXY(SessionFlag.SOCKSPROXY),
        TCP_CHANNEL(SessionFlag.CHANNEL),
        TCP_CHANNEL_WITH_HTTPPROXY(SessionFlag.CHANNEL, SessionFlag.HTTPPROXY),
        TCP_CHANNEL_WITH_SOCKSPROXY(SessionFlag.CHANNEL, SessionFlag.SOCKSPROXY),
        TCP_CHANNEL_DIRECT(SessionFlag.CHANNEL, SessionFlag.DIRECT_MEMORY),
        TCP_CHANNEL_DIRECT_WITH_HTTPPROXY(SessionFlag.CHANNEL, SessionFlag.DIRECT_MEMORY, SessionFlag.HTTPPROXY),
        TCP_CHANNEL_DIRECT_WITH_SOCKSPROXY(SessionFlag.CHANNEL, SessionFlag.DIRECT_MEMORY, SessionFlag.SOCKSPROXY),
        TCP_WEBSOCKET(SessionFlag.WEBSOCKET),
        TCP_WEBSOCKET_WITH_HTTPPROXY(SessionFlag.WEBSOCKET, SessionFlag.HTTPPROXY),
        TLS_SOCKET(SessionFlag.SECURE),
        TLS_SOCKET_WITH_HTTPPROXY(SessionFlag.SECURE, SessionFlag.HTTPPROXY),
        TLS_SOCKET_WITH_SOCKSPROXY(SessionFlag.SECURE, SessionFlag.SOCKSPROXY),
        TLS_CHANNEL(SessionFlag.SECURE, SessionFlag.CHANNEL),
        TLS_CHANNEL_WITH_HTTPPROXY(SessionFlag.SECURE, SessionFlag.CHANNEL, SessionFlag.HTTPPROXY),
        TLS_CHANNEL_WITH_SOCKSPROXY(SessionFlag.SECURE, SessionFlag.CHANNEL, SessionFlag.SOCKSPROXY),
        TLS_CHANNEL_DIRECT(SessionFlag.SECURE, SessionFlag.CHANNEL, SessionFlag.DIRECT_MEMORY),
        TLS_CHANNEL_DIRECT_WITH_HTTPPROXY(SessionFlag.SECURE, SessionFlag.CHANNEL, SessionFlag.DIRECT_MEMORY, SessionFlag.HTTPPROXY),
        TLS_CHANNEL_DIRECT_WITH_SOCKSPROXY(SessionFlag.SECURE, SessionFlag.CHANNEL, SessionFlag.DIRECT_MEMORY, SessionFlag.SOCKSPROXY),
        TLS_WEBSOCKET(SessionFlag.SECURE, SessionFlag.WEBSOCKET),
        TLS_WEBSOCKET_WITH_HTTPPROXY(SessionFlag.SECURE, SessionFlag.WEBSOCKET, SessionFlag.HTTPPROXY);

        private final Set<SessionFlag> _flags;

        private static SessionType _getSessionType(boolean isSecure, ConnectionProperties connectionProperties) {
            String webSocketUrl = connectionProperties.getProperty(ConnectionProperty.WEB_SOCKET_URL);
            boolean isWebSocket = !webSocketUrl.isEmpty();
            boolean isChannel = !isWebSocket && connectionProperties.getBooleanProperty(ConnectionProperty.NON_BLOCKING_IO);
            boolean isDirectMemory = isChannel && connectionProperties.getBooleanProperty(ConnectionProperty.NON_BLOCKING_IO_DIRECT_MEMORY);
            String proxyHostName = connectionProperties.getProperty(ConnectionProperty.PROXY_HOST_NAME);
            boolean hasProxy = !proxyHostName.isEmpty();
            boolean isProxyHttp = connectionProperties.getBooleanProperty(ConnectionProperty.PROXY_HTTP);
            SessionType sessionType = isSecure ? (isWebSocket ? (hasProxy ? TLS_WEBSOCKET_WITH_HTTPPROXY : TLS_WEBSOCKET) : (isChannel ? (isDirectMemory ? (hasProxy ? (isProxyHttp ? TLS_CHANNEL_DIRECT_WITH_HTTPPROXY : TLS_CHANNEL_DIRECT_WITH_SOCKSPROXY) : TLS_CHANNEL_DIRECT) : (hasProxy ? (isProxyHttp ? TLS_CHANNEL_WITH_HTTPPROXY : TLS_CHANNEL_WITH_SOCKSPROXY) : TLS_CHANNEL)) : (hasProxy ? (isProxyHttp ? TLS_SOCKET_WITH_HTTPPROXY : TLS_SOCKET_WITH_SOCKSPROXY) : TLS_SOCKET))) : (isWebSocket ? (hasProxy ? TCP_WEBSOCKET_WITH_HTTPPROXY : TCP_WEBSOCKET) : (isChannel ? (isDirectMemory ? (hasProxy ? (isProxyHttp ? TCP_CHANNEL_DIRECT_WITH_HTTPPROXY : TCP_CHANNEL_DIRECT_WITH_SOCKSPROXY) : TCP_CHANNEL_DIRECT) : (hasProxy ? (isProxyHttp ? TCP_CHANNEL_WITH_HTTPPROXY : TCP_CHANNEL_WITH_SOCKSPROXY) : TCP_CHANNEL)) : (hasProxy ? (isProxyHttp ? TCP_SOCKET_WITH_HTTPPROXY : TCP_SOCKET_WITH_SOCKSPROXY) : TCP_SOCKET)));
            return sessionType;
        }

        private SessionType(SessionFlag ... flags) {
            this._flags = flags.length > 0 ? EnumSet.copyOf(Arrays.asList(flags)) : EnumSet.noneOf(SessionFlag.class);
        }

        public boolean isSecure() {
            return this._flags.contains((Object)SessionFlag.SECURE);
        }

        public boolean isWebSocket() {
            return this._flags.contains((Object)SessionFlag.WEBSOCKET);
        }

        public boolean isChannel() {
            return this._flags.contains((Object)SessionFlag.CHANNEL);
        }

        public boolean isDirectMemory() {
            return this._flags.contains((Object)SessionFlag.DIRECT_MEMORY);
        }

        public boolean isHttpProxy() {
            return this._flags.contains((Object)SessionFlag.HTTPPROXY);
        }

        public boolean isSocksProxy() {
            return this._flags.contains((Object)SessionFlag.SOCKSPROXY);
        }

        public boolean isProxy() {
            return this.isHttpProxy() || this.isSocksProxy();
        }
    }

    static enum SessionFlag {
        SECURE,
        WEBSOCKET,
        CHANNEL,
        DIRECT_MEMORY,
        HTTPPROXY,
        SOCKSPROXY;

    }
}

