/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.converters.ServerConverter;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HPart;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.PacketAnalyzer;
import com.sap.db.jdbc.packet.PartAttribute;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.Cesu8Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.List;

@NotThreadSafe
public class HDataPart
extends HPart {
    private final HRequestPacket _requestPacket;
    private final boolean _isLastPacket;
    private final boolean _isRowNotFound;
    private final boolean _isResultSetClosedOnServer;
    private int _recordCount;
    private int _currentRecordOffset;
    private int _currentFieldOffset;
    private int _currentRecordIndex;
    private int _currentFieldIndex;
    private DataFormatDescription _dataFormatDescription;
    private int _outputFieldCount;
    private boolean _currentFieldIsEncrypted;
    private DataType _currentFieldDataType;

    public static HDataPart createEmptyPart() {
        return new HDataPart(null, null, 0, 0, Type.EMPTY);
    }

    public static HDataPart createArrayPart(HDataPart rsDataPart, int fieldIndex, AbstractConverter converter) {
        rsDataPart.moveToField(fieldIndex);
        int elementCount = rsDataPart.getIntAsInt();
        int offset = rsDataPart._offset + rsDataPart._getNonNullDataOffset() + 4;
        int length = rsDataPart._getNonNullDataLength() - 4;
        HDataPart dataPart = new HDataPart(null, rsDataPart._packet, offset, length, Type.ARRAY);
        final int f_elementCount = elementCount;
        final AbstractConverter f_converter = converter;
        dataPart.setDataFormatDescription(new DataFormatDescription(){

            @Override
            public int getOutputFieldCount() {
                return f_elementCount;
            }

            @Override
            public DataType getOutputFieldDataType(int outputFieldPos) {
                return f_converter.getDataType();
            }

            @Override
            public boolean isOutputFieldEncrypted(int outputFieldPos) {
                return false;
            }

            @Override
            public int getResultSetColumnCount() {
                return 0;
            }

            @Override
            public AbstractConverter getResultSetConverter(int columnIndex) {
                return null;
            }
        });
        return dataPart;
    }

    public static HDataPart createResultSetPart(byte[] packet, int offset, int length) {
        return new HDataPart(null, packet, offset, length, Type.RESULT_SET);
    }

    public static HDataPart createOutputParametersPart(byte[] packet, int offset, int length) {
        return new HDataPart(null, packet, offset, length, Type.OUTPUT_PARAMETERS);
    }

    public static HDataPart createParametersPart(HRequestPacket requestPacket, int offset) {
        return new HDataPart(requestPacket, requestPacket.getRawPacketArray(), offset, -1, Type.PARAMETERS);
    }

    public static HDataPart createWriteLobRequestPart(HRequestPacket requestPacket, int offset) {
        return new HDataPart(requestPacket, requestPacket.getRawPacketArray(), offset, -1, Type.WRITE_LOB_REQUEST);
    }

    public static int getDataLengthIndicatorLength(int dataLen) {
        int len = dataLen <= 245 ? 1 : (dataLen <= Short.MAX_VALUE ? 3 : 5);
        return len;
    }

    private HDataPart(HRequestPacket requestPacket, byte[] packet, int offset, int length, Type type) {
        super(packet, offset, length, type != Type.PARAMETERS && type != Type.WRITE_LOB_REQUEST);
        this._requestPacket = requestPacket;
        switch (type) {
            case EMPTY: {
                this._recordCount = 0;
                this._isLastPacket = true;
                this._isRowNotFound = true;
                this._isResultSetClosedOnServer = true;
                break;
            }
            case ARRAY: {
                this._recordCount = 1;
                this._isLastPacket = true;
                this._isRowNotFound = true;
                this._isResultSetClosedOnServer = true;
                this._currentRecordOffset = 0;
                this._currentFieldOffset = 0;
                this._currentRecordIndex = 1;
                this._currentFieldIndex = 1;
                break;
            }
            case RESULT_SET: 
            case OUTPUT_PARAMETERS: {
                byte attributes = this.getByte(1);
                this._recordCount = PacketAnalyzer.getArgumentCount(this._packet, this._offset);
                this._isLastPacket = (attributes & PartAttribute.LastPacket.getValue()) != 0;
                this._isRowNotFound = (attributes & PartAttribute.RowNotFound.getValue()) != 0;
                boolean bl = this._isResultSetClosedOnServer = (attributes & PartAttribute.ResultSetClosed.getValue()) != 0;
                if (this._recordCount <= 0) break;
                this._currentRecordOffset = 16;
                this._currentFieldOffset = 16;
                this._currentRecordIndex = 1;
                this._currentFieldIndex = 1;
                break;
            }
            case PARAMETERS: 
            case WRITE_LOB_REQUEST: {
                this._recordCount = 0;
                this._isLastPacket = true;
                this._isRowNotFound = true;
                this._isResultSetClosedOnServer = true;
                this._currentRecordOffset = 0;
                this._currentFieldOffset = 0;
                this._currentRecordIndex = 1;
                this._currentFieldIndex = 1;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected type: " + (Object)((Object)type)));
            }
        }
    }

    public int getRecordCount() {
        return this._recordCount;
    }

    public boolean isLastPacket() {
        return this._isLastPacket;
    }

    public boolean isRowNotFound() {
        return this._isRowNotFound;
    }

    public boolean isResultSetClosedOnServer() {
        return this._isResultSetClosedOnServer;
    }

    public int getAvailableSpace() {
        return this._requestPacket.getAvailableSpace() - this._currentFieldOffset;
    }

    public int getCurrentFieldOffset() {
        return this._currentFieldOffset;
    }

    public DataFormatDescription getDataFormatDescription() {
        return this._dataFormatDescription;
    }

    public void setDataFormatDescription(DataFormatDescription dataFormatDescription) {
        this._dataFormatDescription = dataFormatDescription;
        this._outputFieldCount = this._dataFormatDescription.getOutputFieldCount();
        this._updateCurrentFieldCachedValues();
    }

    public int getNonNullDataOffset() {
        return this._offset + this._getNonNullDataOffset();
    }

    public int getNonNullDataLength() {
        return this._getNonNullDataLength();
    }

    public int getEncryptedDataOffset() {
        int dataOffset = this._getDataOffsetFromDataLengthIndicator(true);
        return dataOffset != -1 ? this._offset + dataOffset : -1;
    }

    public int getEncryptedDataLength() {
        return this._getNonNullDataLengthFromDataLengthIndicator();
    }

    public void close() {
        this.close(this._recordCount);
    }

    public void close(int recordCount) {
        this._checkModifiable();
        this._requestPacket._closePart(recordCount, this._currentFieldOffset);
    }

    public boolean nextRecord() {
        if (this._currentRecordIndex >= this._recordCount) {
            return false;
        }
        while (this._currentFieldIndex <= this._outputFieldCount) {
            this._nextField();
        }
        this._currentRecordOffset = this._currentFieldOffset;
        ++this._currentRecordIndex;
        this._currentFieldIndex = 1;
        this._updateCurrentFieldCachedValues();
        return true;
    }

    public void moveToField(int fieldIndex) {
        if (fieldIndex > this._outputFieldCount) {
            throw new AssertionError((Object)("Invalid field index: " + fieldIndex + " > " + this._outputFieldCount));
        }
        if (fieldIndex < this._currentFieldIndex) {
            this._currentFieldOffset = this._currentRecordOffset;
            this._currentFieldIndex = 1;
            this._updateCurrentFieldCachedValues();
        }
        while (this._currentFieldIndex < fieldIndex) {
            this._nextField();
        }
    }

    public boolean isNull(AbstractConverter converter, SQLParamController controller) {
        return this.isNull(converter, controller, null);
    }

    public boolean isNull(AbstractConverter converter, SQLParamController controller, byte[] decrypted) {
        DataFormatDescription.NullIndicator nullIndicator;
        block7: {
            DataType dataType;
            block4: {
                block5: {
                    block8: {
                        block6: {
                            boolean isEncrypted = converter.isEncrypted();
                            boolean isDeterministic = converter.isDeterministic();
                            dataType = converter.getDataType();
                            if (!isEncrypted) break block4;
                            if (isDeterministic) break block5;
                            if (decrypted != null) break block6;
                            nullIndicator = DataFormatDescription.NullIndicator.NULL;
                            break block7;
                        }
                        if (!dataType.hasMagicNullValue()) break block8;
                        nullIndicator = HDataPart._getNullIndicator(dataType, decrypted, 0);
                        break block7;
                    }
                    switch (decrypted[0]) {
                        case 0: {
                            nullIndicator = DataFormatDescription.NullIndicator.NULL;
                            break block7;
                        }
                        case 1: {
                            nullIndicator = DataFormatDescription.NullIndicator.NOT_NULL;
                            break block7;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected byte at null marker position: " + decrypted[0]));
                        }
                    }
                }
                nullIndicator = HDataPart._isNull(ByteUtils.getUByte(this._packet, this._offset + this._currentFieldOffset) == 255);
                break block7;
            }
            nullIndicator = HDataPart._getNullIndicator(dataType, this._packet, this._offset + this._currentFieldOffset);
        }
        controller.setNullIndicator(nullIndicator);
        return nullIndicator == DataFormatDescription.NullIndicator.NULL;
    }

    public DataFormatDescription.NullIndicator getNullIndicator(AbstractConverter converter, SQLParamController controller, byte[] decrypted) {
        boolean isEncrypted = converter.isEncrypted();
        boolean isDeterministic = converter.isDeterministic();
        DataType dataType = converter.getDataType();
        DataFormatDescription.NullIndicator nullIndicator = isEncrypted ? (!isDeterministic ? (decrypted == null ? DataFormatDescription.NullIndicator.NULL : HDataPart._getNullIndicator(dataType, decrypted, 0)) : (ByteUtils.getUByte(this._packet, this._offset + this._currentFieldOffset) == 255 ? DataFormatDescription.NullIndicator.NULL : HDataPart._getNullIndicator(dataType, decrypted, 0))) : HDataPart._getNullIndicator(dataType, this._packet, this._offset + this._currentFieldOffset);
        controller.setNullIndicator(nullIndicator);
        return nullIndicator;
    }

    public boolean getBooleanAsBoolean() {
        return this.getBoolean(this._getNonNullDataOffset());
    }

    public short getTinyIntAsShort() {
        return (short)this.getUByte(this._getNonNullDataOffset());
    }

    public short getSmallIntAsShort() {
        return this.getShort(this._getNonNullDataOffset());
    }

    public int getIntAsInt() {
        return this.getInt(this._getNonNullDataOffset());
    }

    public long getBigIntAsLong() {
        return this.getLong(this._getNonNullDataOffset());
    }

    public float getRealAsFloat() {
        return this.getFloat(this._getNonNullDataOffset());
    }

    public double getDoubleAsDouble() {
        return this.getDouble(this._getNonNullDataOffset());
    }

    public BigDecimal getDecimalAsBigDecimal(int fraction) {
        return this.getDecimalAsBigDecimal(this._getNonNullDataOffset(), fraction);
    }

    public BigDecimal getFixedDecimalAsBigDecimal(int fraction, DataType dataType) {
        return this.getFixedDecimalAsBigDecimal(this._getNonNullDataOffset(), fraction, dataType);
    }

    public String getCharacterAsString() {
        return this.getString(this._getNonNullDataOffset(), this._getNonNullDataLength());
    }

    public byte[] getBinaryAsBytes() {
        return this.getBytes(this._getNonNullDataOffset(), this._getNonNullDataLength());
    }

    public boolean getLOBIsLastChunk(int lobFieldOffset) {
        return (this.getByte(lobFieldOffset + 1) & 4) != 0;
    }

    public long getLOBCharLength(int lobFieldOffset) {
        return this.getLong(lobFieldOffset + 4);
    }

    public long getLOBByteLength(int lobFieldOffset) {
        return this.getLong(lobFieldOffset + 12);
    }

    public byte[] getLOBLocatorID(int lobFieldOffset) {
        return this.getBytes(lobFieldOffset + 20, 8);
    }

    public ByteBuffer getLOBByteBuffer(int lobFieldOffset) {
        return ByteBuffer.wrap(this._packet, this._offset + lobFieldOffset + 32, this.getInt(lobFieldOffset + 28)).slice().order(ByteOrder.LITTLE_ENDIAN);
    }

    public boolean putInputArgs(List<AbstractConverter> converters, Object[] inputArgs) throws SQLException {
        int inputArgLength;
        Object inputArg;
        if (this._recordCount >= 0x7FFFFFFE) {
            return false;
        }
        int requiredSpace = 0;
        int i = 0;
        for (AbstractConverter converter : converters) {
            inputArg = inputArgs[i];
            inputArgLength = converter.getInputArgLength(inputArg);
            requiredSpace += inputArgLength;
            ++i;
        }
        if (!this._checkAvailableSpaceForInputArgs(requiredSpace = PacketAnalyzer.align(requiredSpace))) {
            return false;
        }
        i = 0;
        for (AbstractConverter converter : converters) {
            inputArgLength = converter.putInputArg(this, inputArg = inputArgs[i]);
            if (inputArgLength == -1) {
                throw new AssertionError((Object)"Packet size insufficient for input arguments");
            }
            ++i;
        }
        ++this._recordCount;
        return true;
    }

    public boolean putServerInputArgs(List<ServerConverter.ServerInputArg> serverInputArgs) throws SQLException {
        int serverInputArgLength;
        if (this._recordCount >= 0x7FFFFFFE) {
            return false;
        }
        int requiredSpace = 0;
        int i = 0;
        for (ServerConverter.ServerInputArg serverInputArg : serverInputArgs) {
            serverInputArgLength = ServerConverter.getServerInputArgLength(serverInputArg);
            requiredSpace += serverInputArgLength;
            ++i;
        }
        if (!this._checkAvailableSpaceForInputArgs(requiredSpace = PacketAnalyzer.align(requiredSpace))) {
            return false;
        }
        i = 0;
        for (ServerConverter.ServerInputArg serverInputArg : serverInputArgs) {
            serverInputArgLength = ServerConverter.putServerInputArg(this, serverInputArg);
            if (serverInputArgLength == -1) {
                throw new AssertionError((Object)"Packet size insufficient for server input arguments");
            }
            ++i;
        }
        ++this._recordCount;
        return true;
    }

    public int putNull(DataType dataType) {
        this._checkModifiable();
        if (this.getAvailableSpace() < 1) {
            return -1;
        }
        this.putByte(dataType.getTypeCode() + 128, this._currentFieldOffset);
        ++this._currentFieldOffset;
        return 1;
    }

    public int putBooleanAsBoolean(boolean value) {
        this._checkModifiable();
        int len = 2;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.BOOLEAN.getTypeCode(), this._currentFieldOffset);
        this.putBoolean(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putShortAsTinyInt(short value) {
        this._checkModifiable();
        int len = 2;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.TINYINT.getTypeCode(), this._currentFieldOffset);
        this.putByte(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putShortAsSmallInt(short value) {
        this._checkModifiable();
        int len = 3;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.SMALLINT.getTypeCode(), this._currentFieldOffset);
        this.putShort(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putIntAsInt(int value) {
        this._checkModifiable();
        int len = 5;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.INT.getTypeCode(), this._currentFieldOffset);
        this.putInt(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putLongAsBigInt(long value) {
        this._checkModifiable();
        int len = 9;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.BIGINT.getTypeCode(), this._currentFieldOffset);
        this.putLong(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putFloatAsReal(float value) {
        this._checkModifiable();
        int len = 5;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.REAL.getTypeCode(), this._currentFieldOffset);
        this.putFloat(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putDoubleAsDouble(double value) {
        this._checkModifiable();
        int len = 9;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.DOUBLE.getTypeCode(), this._currentFieldOffset);
        this.putDouble(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putBigDecimalAsDecimal(BigDecimal value) {
        this._checkModifiable();
        int len = 17;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.DECIMAL.getTypeCode(), this._currentFieldOffset);
        this.putBigDecimalAsDecimal(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putBigDecimalAsFixedDecimal(BigDecimal value, int fraction, DataType dataType) {
        this._checkModifiable();
        int len = dataType.getFixedByteCount() + 1;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(dataType.getTypeCode(), this._currentFieldOffset);
        this.putBigDecimalAsFixedDecimal(value, this._currentFieldOffset + 1, fraction, dataType);
        this._currentFieldOffset += len;
        return len;
    }

    public int putBytesAsDate(byte[] value) {
        this._checkModifiable();
        int len = 5;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.DATE.getTypeCode(), this._currentFieldOffset);
        this.putBytes(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putBytesAsTime(byte[] value) {
        this._checkModifiable();
        int len = 5;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.TIME.getTypeCode(), this._currentFieldOffset);
        this.putBytes(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putBytesAsTimestamp(byte[] value) {
        this._checkModifiable();
        int len = 9;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.TIMESTAMP.getTypeCode(), this._currentFieldOffset);
        this.putBytes(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putIntAsDayDate(int value) {
        this._checkModifiable();
        int len = 5;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.DAYDATE.getTypeCode(), this._currentFieldOffset);
        this.putInt(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putIntAsSecondTime(int value) {
        this._checkModifiable();
        int len = 5;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.SECONDTIME.getTypeCode(), this._currentFieldOffset);
        this.putInt(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putLongAsSecondDate(long value) {
        this._checkModifiable();
        int len = 9;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.SECONDDATE.getTypeCode(), this._currentFieldOffset);
        this.putLong(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putLongAsLongDate(long value) {
        this._checkModifiable();
        int len = 9;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.LONGDATE.getTypeCode(), this._currentFieldOffset);
        this.putLong(value, this._currentFieldOffset + 1);
        this._currentFieldOffset += len;
        return len;
    }

    public int putStringAsString(String value) {
        this._checkModifiable();
        int dataLen = Cesu8Utils.getByteLength(value);
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        int len = 1 + dataLengthIndicatorLen + dataLen;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.STRING.getTypeCode(), this._currentFieldOffset);
        this._putDataLengthIndicator(dataLen, this._currentFieldOffset + 1);
        this.putString(value, this._currentFieldOffset + 1 + dataLengthIndicatorLen);
        this._currentFieldOffset += len;
        return len;
    }

    public int putBytesAsBinary(byte[] value) {
        return this.putBytesAsBinary(value, 0, value.length);
    }

    public int putBytesAsBinary(byte[] value, int offset, int length) {
        this._checkModifiable();
        int dataLen = length;
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        int len = 1 + dataLengthIndicatorLen + dataLen;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.BINARY.getTypeCode(), this._currentFieldOffset);
        this._putDataLengthIndicator(dataLen, this._currentFieldOffset + 1);
        this.putBytes(value, offset, length, this._currentFieldOffset + 1 + dataLengthIndicatorLen);
        this._currentFieldOffset += len;
        return len;
    }

    public int putEncryptedBytes(byte[] buffer) {
        this._checkModifiable();
        int dataLen = buffer.length;
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        int len = 1 + dataLengthIndicatorLen + dataLen;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putByte(DataType.CIPHERTEXT.getTypeCode(), this._currentFieldOffset);
        this._putDataLengthIndicator(dataLen, this._currentFieldOffset + 1);
        this.putBytes(buffer, 0, dataLen, this._currentFieldOffset + 1 + dataLengthIndicatorLen);
        this._currentFieldOffset += len;
        return len;
    }

    public boolean canAddLOBDescriptor(int descriptorLength) {
        return this._requestPacket.getArgumentCount() < Integer.MAX_VALUE && this.getAvailableSpace() > descriptorLength;
    }

    public int putLOBDescriptor(boolean isExecuteRequest, DataType dataType, byte[] locatorID) {
        int len;
        this._checkModifiable();
        boolean putParameterDescriptor = isExecuteRequest || locatorID == null;
        int n = len = putParameterDescriptor ? 10 : 21;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        if (putParameterDescriptor) {
            this.putByte(dataType.getTypeCode(), this._currentFieldOffset + 0);
            this.putByte(0, this._currentFieldOffset + 1);
            this.putInt(0, this._currentFieldOffset + 2);
            this.putInt(0, this._currentFieldOffset + 6);
        } else {
            this.putBytes(locatorID, this._currentFieldOffset + 0);
            this.putByte(0, this._currentFieldOffset + 8);
            this.putLong(0L, this._currentFieldOffset + 9);
            this.putInt(0, this._currentFieldOffset + 17);
        }
        this._currentFieldOffset += len;
        return len;
    }

    public boolean fillWithReader(boolean isExecuteRequest, Reader reader, int descriptorOffset) throws SQLException {
        this._checkModifiable();
        boolean isReaderExhausted = false;
        int availableSpace = this.getAvailableSpace();
        int options = 2;
        int position = this._currentFieldOffset;
        try {
            while (!isReaderExhausted && availableSpace > 3) {
                int bytesWritten = Cesu8Utils.putBytes(reader, this._packet, this._offset + this._currentFieldOffset, availableSpace);
                if (bytesWritten == -1) {
                    isReaderExhausted = true;
                    options |= 4;
                    continue;
                }
                this._currentFieldOffset += bytesWritten;
                availableSpace -= bytesWritten;
            }
        }
        catch (IOException e) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", e.getMessage());
        }
        int chunkLength = this._currentFieldOffset - position;
        this._updateLOBDescriptor(isExecuteRequest, descriptorOffset, options, chunkLength, position);
        return isReaderExhausted;
    }

    public boolean fillWithStream(boolean isExecuteRequest, InputStream stream, int descriptorOffset) throws SQLException {
        this._checkModifiable();
        boolean isStreamExhausted = false;
        int availableSpace = this.getAvailableSpace();
        int options = 2;
        int position = this._currentFieldOffset;
        try {
            while (!isStreamExhausted && availableSpace > 0) {
                int bytesRead = stream.read(this._packet, this._offset + this._currentFieldOffset, availableSpace);
                if (bytesRead == -1) {
                    isStreamExhausted = true;
                    options |= 4;
                    continue;
                }
                this._currentFieldOffset += bytesRead;
                availableSpace -= bytesRead;
            }
        }
        catch (IOException e) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", e.getMessage());
        }
        int chunkLength = this._currentFieldOffset - position;
        this._updateLOBDescriptor(isExecuteRequest, descriptorOffset, options, chunkLength, position);
        return isStreamExhausted;
    }

    private boolean _checkAvailableSpaceForInputArgs(int requiredSpace) {
        int availableSpace = this.getAvailableSpace();
        if (requiredSpace > availableSpace) {
            if (this._recordCount == 0) {
                this._requestPacket._resize(this._requestPacket.getLength() + this._currentFieldOffset + requiredSpace);
                this._packet = this._requestPacket.getRawPacketArray();
            } else {
                return false;
            }
        }
        return true;
    }

    private void _putDataLengthIndicator(int dataLen, int off) {
        if (dataLen <= 245) {
            this.putByte(dataLen, off);
        } else if (dataLen <= Short.MAX_VALUE) {
            this.putByte(246, off);
            this.putShort(dataLen, off + 1);
        } else {
            this.putByte(247, off);
            this.putInt(dataLen, off + 1);
        }
    }

    private void _nextField() {
        this._currentFieldOffset += this._getFieldLength();
        ++this._currentFieldIndex;
        this._updateCurrentFieldCachedValues();
    }

    private int _getFieldLength() {
        if (this._currentFieldIsEncrypted) {
            return this._getFieldLengthFromDataLengthIndicator();
        }
        switch (this._currentFieldDataType) {
            case BOOLEAN: {
                return 1;
            }
            case TINYINT: {
                return this.getByte(this._currentFieldOffset) == 0 ? 1 : 2;
            }
            case SMALLINT: {
                return this.getByte(this._currentFieldOffset) == 0 ? 1 : 3;
            }
            case INT: {
                return this.getByte(this._currentFieldOffset) == 0 ? 1 : 5;
            }
            case BIGINT: {
                return this.getByte(this._currentFieldOffset) == 0 ? 1 : 9;
            }
            case REAL: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
            case DECIMAL: {
                return 16;
            }
            case FIXED8: {
                return this.getByte(this._currentFieldOffset) == 0 ? 1 : 9;
            }
            case FIXED12: {
                return this.getByte(this._currentFieldOffset) == 0 ? 1 : 13;
            }
            case FIXED16: {
                return this.getByte(this._currentFieldOffset) == 0 ? 1 : 17;
            }
            case DATE: 
            case TIME: 
            case DAYDATE: 
            case SECONDTIME: {
                return 4;
            }
            case TIMESTAMP: 
            case SECONDDATE: 
            case LONGDATE: {
                return 8;
            }
            case CHAR: 
            case VARCHAR1: 
            case NCHAR: 
            case NVARCHAR: 
            case SHORTTEXT: 
            case STRING: 
            case NSTRING: 
            case VARCHAR2: 
            case ALPHANUM: 
            case BINARY: 
            case VARBINARY: 
            case BSTRING: 
            case GEOMETRY: 
            case POINT: 
            case ARRAY: {
                return this._getFieldLengthFromDataLengthIndicator();
            }
            case CLOB: 
            case NCLOB: 
            case TEXT: 
            case BINTEXT: 
            case LOCATOR: 
            case NLOCATOR: 
            case BLOB: 
            case BLOCATOR: {
                return this.getByte(this._currentFieldOffset + 1) == 1 ? 2 : 32 + this.getInt(this._currentFieldOffset + 28);
            }
            case TABLE: {
                return 8;
            }
        }
        throw new AssertionError((Object)("Unexpected data type: " + (Object)((Object)this._currentFieldDataType)));
    }

    private int _getFieldLengthFromDataLengthIndicator() {
        int lengthIndicator = this.getUByte(this._currentFieldOffset);
        switch (lengthIndicator) {
            case 246: {
                return this.getShort(this._currentFieldOffset + 1) + 3;
            }
            case 247: {
                return this.getInt(this._currentFieldOffset + 1) + 5;
            }
            case 255: {
                return 1;
            }
        }
        if (lengthIndicator <= 245) {
            return lengthIndicator + 1;
        }
        throw new AssertionError((Object)("Unexpected length indicator: " + lengthIndicator));
    }

    private static DataFormatDescription.NullIndicator _getNullIndicator(DataType dataType, byte[] buffer, int offset) {
        switch (dataType) {
            case BOOLEAN: {
                return HDataPart._isNull(ByteUtils.getByte(buffer, offset) == 1);
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case FIXED8: 
            case FIXED12: 
            case FIXED16: {
                return HDataPart._isNull(ByteUtils.getByte(buffer, offset) == 0);
            }
            case REAL: {
                return HDataPart._isNull(ByteUtils.getInt(buffer, offset) == -1);
            }
            case DOUBLE: {
                return HDataPart._isNull(ByteUtils.getLong(buffer, offset) == -1L);
            }
            case DECIMAL: {
                return HDataPart._isNull(ByteUtils.getLong(buffer, offset) == 0L && ByteUtils.getLong(buffer, offset + 8) == 0x7000000000000000L);
            }
            case DATE: {
                return HDataPart._isNull(ByteUtils.getInt(buffer, offset) == 0x1000001);
            }
            case TIME: {
                return HDataPart._isNull(ByteUtils.getInt(buffer, offset) == 0);
            }
            case TIMESTAMP: {
                return HDataPart._isNull(ByteUtils.getLong(buffer, offset) == 0x1000001L);
            }
            case DAYDATE: {
                int val = ByteUtils.getInt(buffer, offset);
                if (val == 0) {
                    return DataFormatDescription.NullIndicator.SPECIAL_NULL;
                }
                if (val == 3652062) {
                    return DataFormatDescription.NullIndicator.NULL;
                }
                return DataFormatDescription.NullIndicator.NOT_NULL;
            }
            case SECONDTIME: {
                int val = ByteUtils.getInt(buffer, offset);
                if (val == 0) {
                    return DataFormatDescription.NullIndicator.SPECIAL_NULL;
                }
                if (val == 86402) {
                    return DataFormatDescription.NullIndicator.NULL;
                }
                return DataFormatDescription.NullIndicator.NOT_NULL;
            }
            case SECONDDATE: {
                long val = ByteUtils.getLong(buffer, offset);
                if (val == 0L) {
                    return DataFormatDescription.NullIndicator.SPECIAL_NULL;
                }
                if (val == 315538070401L) {
                    return DataFormatDescription.NullIndicator.NULL;
                }
                return DataFormatDescription.NullIndicator.NOT_NULL;
            }
            case LONGDATE: {
                long val = ByteUtils.getLong(buffer, offset);
                if (val == 0L) {
                    return DataFormatDescription.NullIndicator.SPECIAL_NULL;
                }
                if (val == 3155380704000000001L) {
                    return DataFormatDescription.NullIndicator.NULL;
                }
                return DataFormatDescription.NullIndicator.NOT_NULL;
            }
            case CHAR: 
            case VARCHAR1: 
            case NCHAR: 
            case NVARCHAR: 
            case SHORTTEXT: 
            case STRING: 
            case NSTRING: 
            case VARCHAR2: 
            case ALPHANUM: 
            case BINARY: 
            case VARBINARY: 
            case BSTRING: 
            case GEOMETRY: 
            case POINT: 
            case ARRAY: {
                return HDataPart._isNull(ByteUtils.getUByte(buffer, offset) == 255);
            }
            case CLOB: 
            case NCLOB: 
            case TEXT: 
            case BINTEXT: 
            case LOCATOR: 
            case NLOCATOR: 
            case BLOB: 
            case BLOCATOR: {
                return HDataPart._isNull(ByteUtils.getByte(buffer, offset + 1) == 1);
            }
            case TABLE: {
                return DataFormatDescription.NullIndicator.NOT_NULL;
            }
        }
        throw new AssertionError((Object)("Unexpected data type: " + (Object)((Object)dataType)));
    }

    private static DataFormatDescription.NullIndicator _isNull(boolean isNull) {
        return isNull ? DataFormatDescription.NullIndicator.NULL : DataFormatDescription.NullIndicator.NOT_NULL;
    }

    private int _getNonNullDataOffset() {
        if (this._currentFieldIsEncrypted) {
            throw new AssertionError((Object)"_getNonNullDataOffset() invoked when current field is encrypted");
        }
        switch (this._currentFieldDataType) {
            case BOOLEAN: 
            case REAL: 
            case DOUBLE: 
            case DECIMAL: {
                return this._currentFieldOffset;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case FIXED8: 
            case FIXED12: 
            case FIXED16: {
                return this._currentFieldOffset + 1;
            }
            case DATE: 
            case TIME: 
            case DAYDATE: 
            case SECONDTIME: 
            case TIMESTAMP: 
            case SECONDDATE: 
            case LONGDATE: {
                return this._currentFieldOffset;
            }
            case CHAR: 
            case VARCHAR1: 
            case NCHAR: 
            case NVARCHAR: 
            case SHORTTEXT: 
            case STRING: 
            case NSTRING: 
            case VARCHAR2: 
            case ALPHANUM: 
            case BINARY: 
            case VARBINARY: 
            case BSTRING: 
            case GEOMETRY: 
            case POINT: 
            case ARRAY: {
                return this._getDataOffsetFromDataLengthIndicator(false);
            }
            case CLOB: 
            case NCLOB: 
            case TEXT: 
            case BINTEXT: 
            case LOCATOR: 
            case NLOCATOR: 
            case BLOB: 
            case BLOCATOR: {
                return this._currentFieldOffset;
            }
            case TABLE: {
                return this._currentFieldOffset;
            }
        }
        throw new AssertionError((Object)("Unexpected data type: " + (Object)((Object)this._currentFieldDataType)));
    }

    private int _getDataOffsetFromDataLengthIndicator(boolean isNullIndicatorValid) {
        int lengthIndicator = this.getUByte(this._currentFieldOffset);
        switch (lengthIndicator) {
            case 246: {
                return this._currentFieldOffset + 3;
            }
            case 247: {
                return this._currentFieldOffset + 5;
            }
            case 255: {
                if (isNullIndicatorValid) {
                    return -1;
                }
                throw new AssertionError((Object)("Unexpected length indicator: " + lengthIndicator));
            }
        }
        if (lengthIndicator <= 245) {
            return this._currentFieldOffset + 1;
        }
        throw new AssertionError((Object)("Unexpected length indicator: " + lengthIndicator));
    }

    private int _getNonNullDataLength() {
        if (this._currentFieldIsEncrypted) {
            throw new AssertionError((Object)"_getNonNullDataLength() invoked when current field is encrypted");
        }
        switch (this._currentFieldDataType) {
            case BOOLEAN: 
            case TINYINT: {
                return 1;
            }
            case SMALLINT: {
                return 2;
            }
            case INT: 
            case REAL: {
                return 4;
            }
            case BIGINT: 
            case DOUBLE: 
            case FIXED8: {
                return 8;
            }
            case FIXED12: {
                return 12;
            }
            case DECIMAL: 
            case FIXED16: {
                return 16;
            }
            case DATE: 
            case TIME: 
            case DAYDATE: 
            case SECONDTIME: {
                return 4;
            }
            case TIMESTAMP: 
            case SECONDDATE: 
            case LONGDATE: {
                return 8;
            }
            case CHAR: 
            case VARCHAR1: 
            case NCHAR: 
            case NVARCHAR: 
            case SHORTTEXT: 
            case STRING: 
            case NSTRING: 
            case VARCHAR2: 
            case ALPHANUM: 
            case BINARY: 
            case VARBINARY: 
            case BSTRING: 
            case GEOMETRY: 
            case POINT: 
            case ARRAY: {
                return this._getNonNullDataLengthFromDataLengthIndicator();
            }
            case CLOB: 
            case NCLOB: 
            case TEXT: 
            case BINTEXT: 
            case LOCATOR: 
            case NLOCATOR: 
            case BLOB: 
            case BLOCATOR: {
                return 32;
            }
            case TABLE: {
                return 8;
            }
        }
        throw new AssertionError((Object)("Unexpected data type: " + (Object)((Object)this._currentFieldDataType)));
    }

    private int _getNonNullDataLengthFromDataLengthIndicator() {
        int lengthIndicator = this.getUByte(this._currentFieldOffset);
        switch (lengthIndicator) {
            case 246: {
                return this.getShort(this._currentFieldOffset + 1);
            }
            case 247: {
                return this.getInt(this._currentFieldOffset + 1);
            }
            case 255: {
                throw new AssertionError((Object)("Unexpected length indicator: " + lengthIndicator));
            }
        }
        if (lengthIndicator <= 245) {
            return lengthIndicator;
        }
        throw new AssertionError((Object)("Unexpected length indicator: " + lengthIndicator));
    }

    private void _updateLOBDescriptor(boolean isExecuteRequest, int descriptorOffset, int options, int chunkLength, int position) {
        if (isExecuteRequest) {
            this.putByte(options, descriptorOffset + 1);
            this.putInt(chunkLength, descriptorOffset + 2);
            this.putInt(chunkLength == 0 ? 0 : position, descriptorOffset + 6);
        } else {
            this.putByte(options, descriptorOffset + 8);
            this.putLong(0L, descriptorOffset + 9);
            this.putInt(chunkLength, descriptorOffset + 17);
        }
    }

    private void _updateCurrentFieldCachedValues() {
        if (this._dataFormatDescription == null || this._currentFieldIndex < 1 || this._currentFieldIndex > this._outputFieldCount) {
            return;
        }
        this._currentFieldIsEncrypted = this._dataFormatDescription.isOutputFieldEncrypted(this._currentFieldIndex);
        this._currentFieldDataType = this._dataFormatDescription.getOutputFieldDataType(this._currentFieldIndex);
    }

    private static enum Type {
        EMPTY,
        ARRAY,
        RESULT_SET,
        OUTPUT_PARAMETERS,
        PARAMETERS,
        WRITE_LOB_REQUEST;

    }
}

