/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractDateTimeConverter;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

@ThreadSafe
class SecondTimeConverter
extends AbstractDateTimeConverter {
    protected SecondTimeConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(4) + 1;
        }
        return 4;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Integer)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(4) + 2;
        }
        return 5;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Integer)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        int value = (Integer)data;
        if (this._isEncrypted) {
            byte[] encrypted = this._getEncryptedBuffer(ByteUtils.putInt(value, new byte[4], 0));
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putIntAsSecondTime(value);
    }

    @Override
    protected int _getNullInputArgLength() {
        if (this._isEncrypted && !this._isDeterministic) {
            return this._cipher.getEncryptedLength(4) + 2;
        }
        return 1;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) throws SQLException {
        if (this._isEncrypted && !this._isDeterministic) {
            byte[] encrypted = this._getEncryptedBuffer(ByteUtils.putInt(86402, new byte[4], 0));
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putNull(DataType.TIME);
    }

    @Override
    public int getPrecision() {
        return 8;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getTime(controller, dataPart, null);
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Time) {
            return this.setTime((Time)value, null);
        }
        if (value instanceof Timestamp) {
            return this.setTimestamp((Timestamp)value, null);
        }
        if (value instanceof Date) {
            Date utilDate = (Date)value;
            return this.setTime(new Time(utilDate.getTime()), null);
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        return this._defaultSetObject(value);
    }

    @Override
    public java.sql.Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getDate(controller, dataPart, cal);
    }

    @Override
    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getTime(controller, dataPart, cal);
    }

    @Override
    public Integer setTime(Time value, Calendar cal) throws SQLException {
        return value != null ? Integer.valueOf(SecondTimeConverter._convertMillisecondsToSecondTime(value.getTime(), cal, this._getTimeZone())) : null;
    }

    @Override
    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getTimestamp(controller, dataPart, cal);
    }

    @Override
    public Integer setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        return value != null ? Integer.valueOf(SecondTimeConverter._convertMillisecondsToSecondTime(value.getTime(), cal, this._getTimeZone())) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted ? this._getDecryptedBuffer(dataPart) : null;
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(this, controller, decrypted);
        switch (nullIndicator) {
            case NOT_NULL: {
                try {
                    Calendar calendar;
                    if (this._timeZonePerObject) {
                        this._calLock.lock();
                        calendar = this._cal;
                    } else {
                        calendar = (Calendar)_staticCal.get();
                    }
                    String string = String.valueOf(new Time(SecondTimeConverter._convertSecondTimeToMilliseconds(this._getValueAsSecondTime(dataPart, decrypted), calendar, false)));
                    return string;
                }
                finally {
                    if (this._timeZonePerObject) {
                        this._calLock.unlock();
                    }
                }
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : "";
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    @Override
    public Integer setString(String value) throws SQLException {
        return value != null ? Integer.valueOf(SecondTimeConverter._convertStringToSecondTime(value, this._getTimeZone())) : null;
    }

    private int _getValueAsSecondTime(HDataPart dataPart, byte[] decrypted) throws SQLException {
        int secondTime;
        if (this._isEncrypted) {
            if (decrypted == null) {
                decrypted = this._getDecryptedBuffer(dataPart);
            }
            secondTime = ByteUtils.getInt(decrypted, 0);
        } else {
            secondTime = dataPart.getIntAsInt();
        }
        return secondTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.sql.Date _getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        byte[] decrypted = this._isEncrypted ? this._getDecryptedBuffer(dataPart) : null;
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(this, controller, decrypted);
        switch (nullIndicator) {
            case NOT_NULL: {
                try {
                    Calendar calendar;
                    if (cal == null) {
                        if (this._timeZonePerObject) {
                            this._calLock.lock();
                            calendar = this._cal;
                        } else {
                            calendar = (Calendar)_staticCal.get();
                        }
                    } else {
                        calendar = cal;
                    }
                    java.sql.Date date = new java.sql.Date(SecondTimeConverter._convertSecondTimeToMilliseconds(this._getValueAsSecondTime(dataPart, decrypted), calendar, true));
                    return date;
                }
                finally {
                    if (cal == null && this._timeZonePerObject) {
                        this._calLock.unlock();
                    }
                }
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : new java.sql.Date(-62135769601000L);
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Time _getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        byte[] decrypted = this._isEncrypted ? this._getDecryptedBuffer(dataPart) : null;
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(this, controller, decrypted);
        switch (nullIndicator) {
            case NOT_NULL: {
                try {
                    Calendar calendar;
                    if (cal == null) {
                        if (this._timeZonePerObject) {
                            this._calLock.lock();
                            calendar = this._cal;
                        } else {
                            calendar = (Calendar)_staticCal.get();
                        }
                    } else {
                        calendar = cal;
                    }
                    Time time = new Time(SecondTimeConverter._convertSecondTimeToMilliseconds(this._getValueAsSecondTime(dataPart, decrypted), calendar, false));
                    return time;
                }
                finally {
                    if (cal == null && this._timeZonePerObject) {
                        this._calLock.unlock();
                    }
                }
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : new Time(-62135769601000L);
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp _getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        byte[] decrypted = this._isEncrypted ? this._getDecryptedBuffer(dataPart) : null;
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(this, controller, decrypted);
        switch (nullIndicator) {
            case NOT_NULL: {
                try {
                    Calendar calendar;
                    if (cal == null) {
                        if (this._timeZonePerObject) {
                            this._calLock.lock();
                            calendar = this._cal;
                        } else {
                            calendar = (Calendar)_staticCal.get();
                        }
                    } else {
                        calendar = cal;
                    }
                    Timestamp timestamp = new Timestamp(SecondTimeConverter._convertSecondTimeToMilliseconds(this._getValueAsSecondTime(dataPart, decrypted), calendar, true));
                    return timestamp;
                }
                finally {
                    if (cal == null && this._timeZonePerObject) {
                        this._calLock.unlock();
                    }
                }
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : new Timestamp(-62135769601000L);
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }
}

