/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.StringUtils;
import com.sap.db.util.security.AbstractAuthenticationManager;
import com.sap.db.util.security.AuthenticationMethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Set;

@NotThreadSafe
public class NativeAuthenticationManagerImpl
extends AbstractAuthenticationManager {
    static final String METHOD_NAME = "NATIVE";
    private final Object _nativeAuthenticationManager;
    private final Class<?> _class;
    private byte[] _finalValue;

    public NativeAuthenticationManagerImpl() throws SQLException {
        try {
            this._nativeAuthenticationManager = Driver.loadNativeAuthentication().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this._class = this._nativeAuthenticationManager.getClass();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw SQLExceptionSapDB.newInstance("error.library.notloaded", "jniAuthentication", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session authenticate(SessionFactory factory, ConnectionSapDB connection, Session session, String userName, String passwd, Set<AuthenticationMethodType> activeMethods) throws RTEException, SQLException {
        String userStripped = StringUtils.stripUserName(userName);
        try {
            Method method = this._class.getMethod("init", String.class, String.class);
            long authManager = (Long)method.invoke(this._nativeAuthenticationManager, userStripped, passwd);
            if (authManager == 0L) {
                throw SQLExceptionSapDB.newInstance("error.connect.nativeauthenticationfailed", "invoke returned non-zero");
            }
            try {
                this._doAuthenticate(connection, session, authManager);
            }
            catch (Throwable throwable) {
                method = this._class.getMethod("release", Long.TYPE);
                method.invoke(this._nativeAuthenticationManager, authManager);
                throw throwable;
            }
            method = this._class.getMethod("release", Long.TYPE);
            method.invoke(this._nativeAuthenticationManager, authManager);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw SQLExceptionSapDB.newInstance("error.connect.nativeauthenticationfailed", e.toString());
        }
        return session;
    }

    @Override
    public void setClientProofPart(HAuthenticationPart authenticationPart, String userName, String passwd) throws SQLException {
        authenticationPart.addArg();
        authenticationPart.addRawBytes(this._finalValue);
    }

    @Override
    public String getMethodName() {
        return METHOD_NAME;
    }

    @Override
    public byte[] evaluateConnectReply(Tracer tracer, HAuthenticationPart authenticationPart) throws SQLException {
        return null;
    }

    private void _doAuthenticate(ConnectionSapDB connection, Session session, long authManager) throws SQLException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        boolean isFinal;
        Method methodEvaluate = this._class.getMethod("evaluate", Long.TYPE, byte[].class);
        byte[] inputData = null;
        Class<?> outputDataClass = null;
        Method methodGetValue = null;
        Method methodIsFinal = null;
        do {
            Object outputData;
            if ((outputData = methodEvaluate.invoke(this._nativeAuthenticationManager, authManager, inputData)) == null) {
                throw SQLExceptionSapDB.newInstance("error.connect.nativeauthenticationfailed", new String[0]);
            }
            if (outputDataClass == null) {
                outputDataClass = outputData.getClass();
                methodGetValue = outputDataClass.getMethod("getValue", new Class[0]);
                methodIsFinal = outputDataClass.getMethod("isFinal", new Class[0]);
            }
            this._finalValue = (byte[])methodGetValue.invoke(outputData, new Object[0]);
            if (this._finalValue == null) {
                throw SQLExceptionSapDB.newInstance("error.connect.nativeauthenticationfailed", new String[0]);
            }
            isFinal = (Boolean)methodIsFinal.invoke(outputData, new Object[0]);
            if (isFinal) continue;
            inputData = this._exchangePackets(connection, session, this._finalValue);
        } while (!isFinal);
    }

    private byte[] _exchangePackets(ConnectionSapDB connection, Session session, byte[] value) throws SQLException {
        HRequestPacket requestPacket = connection.initAuthenticate(session);
        HAuthenticationPart authenticationPart = requestPacket.addAuthenticationPart();
        authenticationPart.addArg();
        authenticationPart.addRawBytes(value);
        authenticationPart.close();
        requestPacket.close();
        HReplyPacket replyPacket = connection.exchange(session, requestPacket, null, new ConnectionSapDB.ExchangeFlag[0]);
        authenticationPart = replyPacket.findAuthenticationPart(0);
        if (authenticationPart == null) {
            throw SQLExceptionSapDB.newInstance("error.connect.nativeauthenticationfailed", new String[0]);
        }
        return authenticationPart.getPartData();
    }
}

