/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbcext.RowSetParameter;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

@ThreadSafe
public class RowSetSapDB
extends WrapperDummy
implements RowSet,
Serializable,
Cloneable {
    @GuardedBy(value="this")
    private final List<RowSetListener> _listeners = new ArrayList<RowSetListener>();
    @GuardedBy(value="this")
    private final List<RowSetParameter> _parms = new ArrayList<RowSetParameter>();
    @GuardedBy(value="this")
    private String _url;
    @GuardedBy(value="this")
    private String _dataSourceName;
    @GuardedBy(value="this")
    private String _userName;
    @GuardedBy(value="this")
    private String _passwd;
    @GuardedBy(value="this")
    private int _isolationLevel = 2;
    @GuardedBy(value="this")
    private Map<String, Class<?>> _typeMap;
    @GuardedBy(value="this")
    private String _command;
    @GuardedBy(value="this")
    private boolean _isReadOnly = true;
    @GuardedBy(value="this")
    private int _maxFieldSize;
    @GuardedBy(value="this")
    private int _maxRows;
    @GuardedBy(value="this")
    private boolean _escapeProcessing;
    @GuardedBy(value="this")
    private int _queryTimeout;
    @GuardedBy(value="this")
    private int _rowSetType = 1003;
    @GuardedBy(value="this")
    private int _rowSetConcurrency = 1007;
    @GuardedBy(value="this")
    private Connection _conn;
    @GuardedBy(value="this")
    private CallableStatement _cs;
    @GuardedBy(value="this")
    private ResultSet _rs;

    @Override
    public synchronized String getUrl() throws SQLException {
        return this._url;
    }

    @Override
    public synchronized void setUrl(String url) throws SQLException {
        this._url = url;
        this._dataSourceName = null;
    }

    @Override
    public synchronized String getDataSourceName() {
        return this._dataSourceName;
    }

    @Override
    public synchronized void setDataSourceName(String dataSourceName) throws SQLException {
        this._dataSourceName = dataSourceName;
        this._url = null;
    }

    @Override
    public synchronized String getUsername() {
        return this._userName;
    }

    @Override
    public synchronized void setUsername(String userName) throws SQLException {
        this._userName = userName;
    }

    @Override
    public synchronized String getPassword() {
        return this._passwd;
    }

    @Override
    public synchronized void setPassword(String passwd) throws SQLException {
        this._passwd = passwd;
    }

    @Override
    public synchronized int getTransactionIsolation() {
        return this._isolationLevel;
    }

    @Override
    public synchronized void setTransactionIsolation(int isolationLevel) throws SQLException {
        this._isolationLevel = isolationLevel;
    }

    @Override
    public synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        return this._typeMap != null ? Collections.unmodifiableMap(this._typeMap) : null;
    }

    @Override
    public synchronized void setTypeMap(Map<String, Class<?>> typeMap) throws SQLException {
        this._typeMap = typeMap != null ? new TreeMap(typeMap) : null;
    }

    @Override
    public synchronized String getCommand() {
        return this._command;
    }

    @Override
    public synchronized void setCommand(String command) throws SQLException {
        this._command = command;
        this._parms.clear();
    }

    @Override
    public synchronized boolean isReadOnly() {
        return this._isReadOnly;
    }

    @Override
    public synchronized void setReadOnly(boolean isReadOnly) throws SQLException {
        this._isReadOnly = isReadOnly;
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        return this._maxFieldSize;
    }

    @Override
    public synchronized void setMaxFieldSize(int maxFieldSize) throws SQLException {
        this._maxFieldSize = maxFieldSize;
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        return this._maxRows;
    }

    @Override
    public synchronized void setMaxRows(int maxRows) throws SQLException {
        this._maxRows = maxRows;
    }

    @Override
    public synchronized boolean getEscapeProcessing() throws SQLException {
        return this._escapeProcessing;
    }

    @Override
    public synchronized void setEscapeProcessing(boolean escapeProcessing) throws SQLException {
        this._escapeProcessing = escapeProcessing;
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        return this._queryTimeout;
    }

    @Override
    public synchronized void setQueryTimeout(int queryTimeout) throws SQLException {
        this._queryTimeout = queryTimeout;
    }

    @Override
    public synchronized void setType(int rowSetType) throws SQLException {
        this._rowSetType = rowSetType;
    }

    @Override
    public synchronized void setConcurrency(int rowSetConcurrency) throws SQLException {
        this._rowSetConcurrency = rowSetConcurrency;
    }

    @Override
    public synchronized void addRowSetListener(RowSetListener listener) {
        if (listener == null || this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    @Override
    public synchronized void removeRowSetListener(RowSetListener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    @Override
    public synchronized void execute() throws SQLException {
        try {
            this._conn = this._connect();
            this._conn.setTransactionIsolation(this._isolationLevel);
            this._conn.setTypeMap(this._typeMap);
            this._cs = this._conn.prepareCall(this._command, this._rowSetType, this._rowSetConcurrency);
            this._cs.setMaxFieldSize(this._maxFieldSize);
            this._cs.setMaxRows(this._maxRows);
            this._cs.setEscapeProcessing(this._escapeProcessing);
            this._cs.setQueryTimeout(this._queryTimeout);
            for (RowSetParameter parm : this._parms) {
                parm.setValue(this._cs);
            }
            this._rs = this._cs.executeQuery();
            this._notifyRowSetChanged();
        }
        catch (SQLException e) {
            if (this._rs != null) {
                try {
                    this._rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (this._cs != null) {
                try {
                    this._cs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (this._conn != null) {
                try {
                    this._conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        this._parms.clear();
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NULL, parameterIndex, (Object)sqlType));
    }

    @Override
    public synchronized void setNull(String parameterName, int sqlType) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NULL, parameterName, (Object)sqlType));
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NULL, parameterIndex, (Object)sqlType, typeName));
    }

    @Override
    public synchronized void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NULL, parameterName, (Object)sqlType, typeName));
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_OBJECT, parameterIndex, x));
    }

    @Override
    public synchronized void setObject(String parameterName, Object x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_OBJECT, parameterName, x));
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_OBJECT, parameterIndex, x, targetSqlType));
    }

    @Override
    public synchronized void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_OBJECT, parameterName, x, targetSqlType));
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_OBJECT, parameterIndex, x, targetSqlType, scaleOrLength));
    }

    @Override
    public synchronized void setObject(String parameterName, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_OBJECT, parameterName, x, targetSqlType, scaleOrLength));
    }

    @Override
    public synchronized void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BOOLEAN, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setBoolean(String parameterName, boolean x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BOOLEAN, parameterName, (Object)x));
    }

    @Override
    public synchronized void setByte(int parameterIndex, byte x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BYTE, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setByte(String parameterName, byte x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BYTE, parameterName, (Object)x));
    }

    @Override
    public synchronized void setShort(int parameterIndex, short x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_SHORT, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setShort(String parameterName, short x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_SHORT, parameterName, (Object)x));
    }

    @Override
    public synchronized void setInt(int parameterIndex, int x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_INT, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setInt(String parameterName, int x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_INT, parameterName, (Object)x));
    }

    @Override
    public synchronized void setLong(int parameterIndex, long x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_LONG, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setLong(String parameterName, long x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_LONG, parameterName, (Object)x));
    }

    @Override
    public synchronized void setFloat(int parameterIndex, float x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_FLOAT, parameterIndex, (Object)Float.valueOf(x)));
    }

    @Override
    public synchronized void setFloat(String parameterName, float x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_FLOAT, parameterName, (Object)Float.valueOf(x)));
    }

    @Override
    public synchronized void setDouble(int parameterIndex, double x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_DOUBLE, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setDouble(String parameterName, double x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_DOUBLE, parameterName, (Object)x));
    }

    @Override
    public synchronized void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BIGDECIMAL, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BIGDECIMAL, parameterName, (Object)x));
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_DATE, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setDate(String parameterName, Date x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_DATE, parameterName, (Object)x));
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_DATE, parameterIndex, (Object)x, cal));
    }

    @Override
    public synchronized void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_DATE, parameterName, (Object)x, cal));
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_TIME, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setTime(String parameterName, Time x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_TIME, parameterName, (Object)x));
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_TIME, parameterIndex, (Object)x, cal));
    }

    @Override
    public synchronized void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_TIME, parameterName, (Object)x, cal));
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_TIMESTAMP, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_TIMESTAMP, parameterName, (Object)x));
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_TIME, parameterIndex, (Object)x, cal));
    }

    @Override
    public synchronized void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_TIME, parameterName, (Object)x, cal));
    }

    @Override
    public synchronized void setString(int parameterIndex, String x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_STRING, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setString(String parameterName, String x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_STRING, parameterName, (Object)x));
    }

    @Override
    public synchronized void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BYTES, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setBytes(String parameterName, byte[] x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BYTES, parameterName, (Object)x));
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_CHARACTERSTREAM, parameterIndex, (Object)x, length));
    }

    @Override
    public synchronized void setCharacterStream(String parameterName, Reader x, int length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_CHARACTERSTREAM, parameterName, (Object)x, length));
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_ASCIISTREAM, parameterIndex, (Object)x, length));
    }

    @Override
    public synchronized void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_ASCIISTREAM, parameterName, (Object)x, length));
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BINARYSTREAM, parameterIndex, (Object)x, length));
    }

    @Override
    public synchronized void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BINARYSTREAM, parameterName, (Object)x, length));
    }

    @Override
    public synchronized void setURL(int parameterIndex, URL x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_URL, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setClob(int parameterIndex, Clob x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_CLOB, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setClob(String parameterName, Clob x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_CLOB, parameterName, (Object)x));
    }

    @Override
    public synchronized void setBlob(int parameterIndex, Blob x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BLOB, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setBlob(String parameterName, Blob x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BLOB, parameterName, (Object)x));
    }

    @Override
    public synchronized void setArray(int parameterIndex, Array x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_ARRAY, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setRef(int parameterIndex, Ref x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_REF, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setNString(int parameterIndex, String x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NSTRING, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setNString(String parameterName, String x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NSTRING, parameterName, (Object)x));
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_CHARACTERSTREAM, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setCharacterStream(String parameterName, Reader x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_CHARACTERSTREAM, parameterName, (Object)x));
    }

    @Override
    public synchronized void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NCHARACTERSTREAM, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setNCharacterStream(String parameterName, Reader x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NCHARACTERSTREAM, parameterName, (Object)x));
    }

    @Override
    public synchronized void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NCHARACTERSTREAM, parameterIndex, (Object)x, length));
    }

    @Override
    public synchronized void setNCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NCHARACTERSTREAM, parameterName, (Object)x, length));
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_ASCIISTREAM, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_ASCIISTREAM, parameterName, (Object)x));
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BINARYSTREAM, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BINARYSTREAM, parameterName, (Object)x));
    }

    @Override
    public synchronized void setClob(int parameterIndex, Reader x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_CLOB, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setClob(String parameterName, Reader x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_CLOB, parameterName, (Object)x));
    }

    @Override
    public synchronized void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_CLOB, parameterIndex, (Object)x, length));
    }

    @Override
    public synchronized void setClob(String parameterName, Reader x, long length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_CLOB, parameterName, (Object)x, length));
    }

    @Override
    public synchronized void setNClob(int parameterIndex, NClob x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NCLOB, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setNClob(String parameterName, NClob x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NCLOB, parameterName, (Object)x));
    }

    @Override
    public synchronized void setNClob(int parameterIndex, Reader x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NCLOB, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setNClob(String parameterName, Reader x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NCLOB, parameterName, (Object)x));
    }

    @Override
    public synchronized void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NCLOB, parameterIndex, (Object)x, length));
    }

    @Override
    public synchronized void setNClob(String parameterName, Reader x, long length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_NCLOB, parameterName, (Object)x, length));
    }

    @Override
    public synchronized void setBlob(int parameterIndex, InputStream x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BLOB, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setBlob(String parameterName, InputStream x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BLOB, parameterName, (Object)x));
    }

    @Override
    public synchronized void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BLOB, parameterIndex, (Object)x, length));
    }

    @Override
    public synchronized void setBlob(String parameterName, InputStream x, long length) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_BLOB, parameterName, (Object)x, length));
    }

    @Override
    public synchronized void setRowId(int parameterIndex, RowId x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_ROWID, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setRowId(String parameterName, RowId x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_ROWID, parameterName, (Object)x));
    }

    @Override
    public synchronized void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_SQLXML, parameterIndex, (Object)x));
    }

    @Override
    public synchronized void setSQLXML(String parameterName, SQLXML x) throws SQLException {
        this._parms.add(new RowSetParameter(RowSetParameter.JavaType.J_SQLXML, parameterName, (Object)x));
    }

    @Override
    public synchronized boolean next() throws SQLException {
        this._checkState();
        boolean ret = this._rs.next();
        this._notifyCursorMoved();
        return ret;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this._rs != null) {
            try {
                this._rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this._cs != null) {
            try {
                this._cs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this._conn != null) {
            try {
                this._conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        this._checkState();
        return this._rs.wasNull();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this._checkState();
        return this._rs.getWarnings();
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this._checkState();
        this._rs.clearWarnings();
    }

    @Override
    public synchronized String getCursorName() throws SQLException {
        this._checkState();
        return this._rs.getCursorName();
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this._checkState();
        return this._rs.getMetaData();
    }

    @Override
    public synchronized int findColumn(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.findColumn(columnLabel);
    }

    @Override
    public synchronized Object getObject(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getObject(columnIndex);
    }

    @Override
    public synchronized Object getObject(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getObject(columnLabel);
    }

    @Override
    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getBoolean(columnIndex);
    }

    @Override
    public synchronized boolean getBoolean(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getBoolean(columnLabel);
    }

    @Override
    public synchronized byte getByte(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getByte(columnIndex);
    }

    @Override
    public synchronized byte getByte(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getByte(columnLabel);
    }

    @Override
    public synchronized short getShort(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getShort(columnIndex);
    }

    @Override
    public synchronized short getShort(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getShort(columnLabel);
    }

    @Override
    public synchronized int getInt(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getInt(columnIndex);
    }

    @Override
    public synchronized int getInt(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getInt(columnLabel);
    }

    @Override
    public synchronized long getLong(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getLong(columnIndex);
    }

    @Override
    public synchronized long getLong(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getLong(columnLabel);
    }

    @Override
    public synchronized float getFloat(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getFloat(columnIndex);
    }

    @Override
    public synchronized float getFloat(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getFloat(columnLabel);
    }

    @Override
    public synchronized double getDouble(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getDouble(columnIndex);
    }

    @Override
    public synchronized double getDouble(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getDouble(columnLabel);
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this._checkState();
        return this._rs.getBigDecimal(columnIndex, scale);
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this._checkState();
        return this._rs.getBigDecimal(columnLabel, scale);
    }

    @Override
    public synchronized Date getDate(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getDate(columnIndex);
    }

    @Override
    public synchronized Date getDate(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getDate(columnLabel);
    }

    @Override
    public synchronized Time getTime(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getTime(columnIndex);
    }

    @Override
    public synchronized Time getTime(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getTime(columnLabel);
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getTimestamp(columnIndex);
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getTimestamp(columnLabel);
    }

    @Override
    public synchronized String getString(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getString(columnIndex);
    }

    @Override
    public synchronized String getString(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getString(columnLabel);
    }

    @Override
    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getBytes(columnIndex);
    }

    @Override
    public synchronized byte[] getBytes(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getBytes(columnLabel);
    }

    @Override
    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getAsciiStream(columnIndex);
    }

    @Override
    public synchronized InputStream getAsciiStream(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getAsciiStream(columnLabel);
    }

    @Override
    @Deprecated
    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getUnicodeStream(columnIndex);
    }

    @Override
    @Deprecated
    public synchronized InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getUnicodeStream(columnLabel);
    }

    @Override
    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getBinaryStream(columnIndex);
    }

    @Override
    public synchronized InputStream getBinaryStream(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getBinaryStream(columnLabel);
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        this._checkState();
        return this._rs.isBeforeFirst();
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        this._checkState();
        return this._rs.isAfterLast();
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        this._checkState();
        return this._rs.isFirst();
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        this._checkState();
        return this._rs.isLast();
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        this._checkState();
        this._rs.beforeFirst();
        this._notifyCursorMoved();
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        this._checkState();
        this._rs.afterLast();
        this._notifyCursorMoved();
    }

    @Override
    public synchronized boolean first() throws SQLException {
        this._checkState();
        boolean ret = this._rs.first();
        this._notifyCursorMoved();
        return ret;
    }

    @Override
    public synchronized boolean last() throws SQLException {
        this._checkState();
        boolean ret = this._rs.first();
        this._notifyCursorMoved();
        return ret;
    }

    @Override
    public synchronized int getRow() throws SQLException {
        this._checkState();
        return this._rs.getRow();
    }

    @Override
    public synchronized boolean absolute(int row) throws SQLException {
        this._checkState();
        boolean ret = this._rs.absolute(row);
        this._notifyCursorMoved();
        return ret;
    }

    @Override
    public synchronized boolean relative(int rows) throws SQLException {
        this._checkState();
        boolean ret = this._rs.relative(rows);
        this._notifyCursorMoved();
        return ret;
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        this._checkState();
        boolean ret = this._rs.previous();
        this._notifyCursorMoved();
        return ret;
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        this._checkState();
        return this._rs.getFetchDirection();
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        this._checkState();
        this._rs.setFetchDirection(direction);
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        this._checkState();
        return this._rs.getFetchSize();
    }

    @Override
    public synchronized void setFetchSize(int fetchSize) throws SQLException {
        this._checkState();
        this._rs.setFetchSize(fetchSize);
    }

    @Override
    public synchronized int getType() throws SQLException {
        this._checkState();
        return this._rs.getType();
    }

    @Override
    public synchronized int getConcurrency() throws SQLException {
        this._checkState();
        return this._rs.getConcurrency();
    }

    @Override
    public synchronized boolean rowInserted() throws SQLException {
        this._checkState();
        return this._rs.rowInserted();
    }

    @Override
    public synchronized boolean rowUpdated() throws SQLException {
        this._checkState();
        return this._rs.rowUpdated();
    }

    @Override
    public synchronized boolean rowDeleted() throws SQLException {
        this._checkState();
        return this._rs.rowDeleted();
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        this._checkState();
        this._rs.insertRow();
        this._notifyRowChanged();
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        this._checkState();
        this._rs.updateRow();
        this._notifyRowChanged();
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        this._checkState();
        this._rs.deleteRow();
        this._notifyRowChanged();
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        this._checkState();
        this._rs.refreshRow();
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this._checkState();
        this._rs.cancelRowUpdates();
        this._notifyRowChanged();
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this._checkState();
        this._rs.moveToInsertRow();
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        this._checkState();
        this._rs.moveToCurrentRow();
    }

    @Override
    public synchronized Statement getStatement() throws SQLException {
        this._checkState();
        return this._rs.getStatement();
    }

    @Override
    public synchronized Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this._checkState();
        return this._rs.getObject(columnIndex, map);
    }

    @Override
    public synchronized Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        this._checkState();
        return this._rs.getObject(columnLabel, map);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getBigDecimal(columnIndex);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getBigDecimal(columnLabel);
    }

    @Override
    public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this._checkState();
        return this._rs.getDate(columnIndex, cal);
    }

    @Override
    public synchronized Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this._checkState();
        return this._rs.getDate(columnLabel, cal);
    }

    @Override
    public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this._checkState();
        return this._rs.getTime(columnIndex, cal);
    }

    @Override
    public synchronized Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this._checkState();
        return this._rs.getTime(columnLabel, cal);
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this._checkState();
        return this._rs.getTimestamp(columnIndex, cal);
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this._checkState();
        return this._rs.getTimestamp(columnLabel, cal);
    }

    @Override
    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getCharacterStream(columnIndex);
    }

    @Override
    public synchronized Reader getCharacterStream(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getCharacterStream(columnLabel);
    }

    @Override
    public synchronized Clob getClob(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getClob(columnIndex);
    }

    @Override
    public synchronized Clob getClob(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getClob(columnLabel);
    }

    @Override
    public synchronized Blob getBlob(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getBlob(columnIndex);
    }

    @Override
    public synchronized Blob getBlob(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getBlob(columnLabel);
    }

    @Override
    public synchronized Array getArray(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getArray(columnIndex);
    }

    @Override
    public synchronized Array getArray(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getArray(columnLabel);
    }

    @Override
    public synchronized Ref getRef(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getRef(columnIndex);
    }

    @Override
    public synchronized Ref getRef(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getRef(columnLabel);
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        this._checkState();
        this._rs.updateNull(columnIndex);
    }

    @Override
    public synchronized void updateNull(String columnLabel) throws SQLException {
        this._checkState();
        this._rs.updateNull(columnLabel);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        this._checkState();
        this._rs.updateObject(columnIndex, x);
    }

    @Override
    public synchronized void updateObject(String columnLabel, Object x) throws SQLException {
        this._checkState();
        this._rs.updateObject(columnLabel, x);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this._checkState();
        this._rs.updateObject(columnIndex, x, scale);
    }

    @Override
    public synchronized void updateObject(String columnLabel, Object x, int scale) throws SQLException {
        this._checkState();
        this._rs.updateObject(columnLabel, x, scale);
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this._checkState();
        this._rs.updateBoolean(columnIndex, x);
    }

    @Override
    public synchronized void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this._checkState();
        this._rs.updateBoolean(columnLabel, x);
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        this._checkState();
        this._rs.updateByte(columnIndex, x);
    }

    @Override
    public synchronized void updateByte(String columnLabel, byte x) throws SQLException {
        this._checkState();
        this._rs.updateByte(columnLabel, x);
    }

    @Override
    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        this._checkState();
        this._rs.updateShort(columnIndex, x);
    }

    @Override
    public synchronized void updateShort(String columnLabel, short x) throws SQLException {
        this._checkState();
        this._rs.updateShort(columnLabel, x);
    }

    @Override
    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        this._checkState();
        this._rs.updateInt(columnIndex, x);
    }

    @Override
    public synchronized void updateInt(String columnLabel, int x) throws SQLException {
        this._checkState();
        this._rs.updateInt(columnLabel, x);
    }

    @Override
    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        this._checkState();
        this._rs.updateLong(columnIndex, x);
    }

    @Override
    public synchronized void updateLong(String columnLabel, long x) throws SQLException {
        this._checkState();
        this._rs.updateLong(columnLabel, x);
    }

    @Override
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        this._checkState();
        this._rs.updateFloat(columnIndex, x);
    }

    @Override
    public synchronized void updateFloat(String columnLabel, float x) throws SQLException {
        this._checkState();
        this._rs.updateFloat(columnLabel, x);
    }

    @Override
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        this._checkState();
        this._rs.updateDouble(columnIndex, x);
    }

    @Override
    public synchronized void updateDouble(String columnLabel, double x) throws SQLException {
        this._checkState();
        this._rs.updateDouble(columnLabel, x);
    }

    @Override
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this._checkState();
        this._rs.updateBigDecimal(columnIndex, x);
    }

    @Override
    public synchronized void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this._checkState();
        this._rs.updateBigDecimal(columnLabel, x);
    }

    @Override
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        this._checkState();
        this._rs.updateDate(columnIndex, x);
    }

    @Override
    public synchronized void updateDate(String columnLabel, Date x) throws SQLException {
        this._checkState();
        this._rs.updateDate(columnLabel, x);
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        this._checkState();
        this._rs.updateTime(columnIndex, x);
    }

    @Override
    public synchronized void updateTime(String columnLabel, Time x) throws SQLException {
        this._checkState();
        this._rs.updateTime(columnLabel, x);
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this._checkState();
        this._rs.updateTimestamp(columnIndex, x);
    }

    @Override
    public synchronized void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this._checkState();
        this._rs.updateTimestamp(columnLabel, x);
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        this._checkState();
        this._rs.updateString(columnIndex, x);
    }

    @Override
    public synchronized void updateString(String columnLabel, String x) throws SQLException {
        this._checkState();
        this._rs.updateString(columnLabel, x);
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this._checkState();
        this._rs.updateBytes(columnIndex, x);
    }

    @Override
    public synchronized void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this._checkState();
        this._rs.updateBytes(columnLabel, x);
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this._checkState();
        this._rs.updateAsciiStream(columnIndex, x);
    }

    @Override
    public synchronized void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this._checkState();
        this._rs.updateAsciiStream(columnLabel, x);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this._checkState();
        this._rs.updateCharacterStream(columnIndex, x);
    }

    @Override
    public synchronized void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        this._checkState();
        this._rs.updateCharacterStream(columnLabel, x);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this._checkState();
        this._rs.updateBinaryStream(columnIndex, x);
    }

    @Override
    public synchronized void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this._checkState();
        this._rs.updateBinaryStream(columnLabel, x);
    }

    @Override
    public synchronized URL getURL(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getURL(columnIndex);
    }

    @Override
    public synchronized URL getURL(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getURL(columnLabel);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Clob x) throws SQLException {
        this._checkState();
        this._rs.updateClob(columnIndex, x);
    }

    @Override
    public synchronized void updateClob(String columnLabel, Clob x) throws SQLException {
        this._checkState();
        this._rs.updateClob(columnLabel, x);
    }

    @Override
    public synchronized void updateBlob(int columnIndex, Blob x) throws SQLException {
        this._checkState();
        this._rs.updateBlob(columnIndex, x);
    }

    @Override
    public synchronized void updateBlob(String columnLabel, Blob x) throws SQLException {
        this._checkState();
        this._rs.updateBlob(columnLabel, x);
    }

    @Override
    public synchronized void updateArray(int columnIndex, Array x) throws SQLException {
        this._checkState();
        this._rs.updateArray(columnIndex, x);
    }

    @Override
    public synchronized void updateArray(String columnLabel, Array x) throws SQLException {
        this._checkState();
        this._rs.updateArray(columnLabel, x);
    }

    @Override
    public synchronized void updateRef(int columnIndex, Ref x) throws SQLException {
        this._checkState();
        this._rs.updateRef(columnIndex, x);
    }

    @Override
    public synchronized void updateRef(String columnLabel, Ref x) throws SQLException {
        this._checkState();
        this._rs.updateRef(columnLabel, x);
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        this._checkState();
        return this._rs.getHoldability();
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        if (this._conn == null || this._cs == null || this._rs == null) {
            return true;
        }
        return this._rs.isClosed();
    }

    @Override
    public synchronized String getNString(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getNString(columnIndex);
    }

    @Override
    public synchronized String getNString(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getNString(columnLabel);
    }

    @Override
    public synchronized Reader getNCharacterStream(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getNCharacterStream(columnIndex);
    }

    @Override
    public synchronized Reader getNCharacterStream(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getNCharacterStream(columnLabel);
    }

    @Override
    public synchronized NClob getNClob(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getNClob(columnIndex);
    }

    @Override
    public synchronized NClob getNClob(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getNClob(columnLabel);
    }

    @Override
    public synchronized RowId getRowId(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getRowId(columnIndex);
    }

    @Override
    public synchronized RowId getRowId(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getRowId(columnLabel);
    }

    @Override
    public synchronized SQLXML getSQLXML(int columnIndex) throws SQLException {
        this._checkState();
        return this._rs.getSQLXML(columnIndex);
    }

    @Override
    public synchronized SQLXML getSQLXML(String columnLabel) throws SQLException {
        this._checkState();
        return this._rs.getSQLXML(columnLabel);
    }

    @Override
    public synchronized void updateNString(int columnIndex, String x) throws SQLException {
        this._checkState();
        this._rs.updateNString(columnIndex, x);
    }

    @Override
    public synchronized void updateNString(String columnLabel, String x) throws SQLException {
        this._checkState();
        this._rs.updateNString(columnLabel, x);
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this._checkState();
        this._rs.updateAsciiStream(columnIndex, x);
    }

    @Override
    public synchronized void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this._checkState();
        this._rs.updateAsciiStream(columnLabel, x);
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this._checkState();
        this._rs.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this._checkState();
        this._rs.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this._checkState();
        this._rs.updateCharacterStream(columnIndex, x);
    }

    @Override
    public synchronized void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        this._checkState();
        this._rs.updateCharacterStream(columnLabel, x);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this._checkState();
        this._rs.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        this._checkState();
        this._rs.updateCharacterStream(columnLabel, x, length);
    }

    @Override
    public synchronized void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this._checkState();
        this._rs.updateNCharacterStream(columnIndex, x);
    }

    @Override
    public synchronized void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        this._checkState();
        this._rs.updateNCharacterStream(columnLabel, x);
    }

    @Override
    public synchronized void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this._checkState();
        this._rs.updateNCharacterStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        this._checkState();
        this._rs.updateNCharacterStream(columnLabel, x, length);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this._checkState();
        this._rs.updateBinaryStream(columnIndex, x);
    }

    @Override
    public synchronized void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this._checkState();
        this._rs.updateBinaryStream(columnLabel, x);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this._checkState();
        this._rs.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this._checkState();
        this._rs.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Reader x) throws SQLException {
        this._checkState();
        this._rs.updateClob(columnIndex, x);
    }

    @Override
    public synchronized void updateClob(String columnLabel, Reader x) throws SQLException {
        this._checkState();
        this._rs.updateClob(columnLabel, x);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        this._checkState();
        this._rs.updateClob(columnIndex, x, length);
    }

    @Override
    public synchronized void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        this._checkState();
        this._rs.updateClob(columnLabel, x, length);
    }

    @Override
    public synchronized void updateNClob(int columnIndex, NClob x) throws SQLException {
        this._checkState();
        this._rs.updateNClob(columnIndex, x);
    }

    @Override
    public synchronized void updateNClob(String columnLabel, NClob x) throws SQLException {
        this._checkState();
        this._rs.updateNClob(columnLabel, x);
    }

    @Override
    public synchronized void updateNClob(int columnIndex, Reader x) throws SQLException {
        this._checkState();
        this._rs.updateNClob(columnIndex, x);
    }

    @Override
    public synchronized void updateNClob(String columnLabel, Reader x) throws SQLException {
        this._checkState();
        this._rs.updateNClob(columnLabel, x);
    }

    @Override
    public synchronized void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        this._checkState();
        this._rs.updateNClob(columnIndex, x, length);
    }

    @Override
    public synchronized void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        this._checkState();
        this._rs.updateNClob(columnLabel, x, length);
    }

    @Override
    public synchronized void updateBlob(int columnIndex, InputStream x) throws SQLException {
        this._checkState();
        this._rs.updateBlob(columnIndex, x);
    }

    @Override
    public synchronized void updateBlob(String columnLabel, InputStream x) throws SQLException {
        this._checkState();
        this._rs.updateBlob(columnLabel, x);
    }

    @Override
    public synchronized void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        this._checkState();
        this._rs.updateBlob(columnIndex, x, length);
    }

    @Override
    public synchronized void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        this._checkState();
        this._rs.updateBlob(columnLabel, x, length);
    }

    @Override
    public synchronized void updateRowId(int columnIndex, RowId x) throws SQLException {
        this._checkState();
        this._rs.updateRowId(columnIndex, x);
    }

    @Override
    public synchronized void updateRowId(String columnLabel, RowId x) throws SQLException {
        this._checkState();
        this._rs.updateRowId(columnLabel, x);
    }

    @Override
    public synchronized void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        this._checkState();
        this._rs.updateSQLXML(columnIndex, x);
    }

    @Override
    public synchronized void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
        this._checkState();
        this._rs.updateSQLXML(columnLabel, x);
    }

    @Override
    public synchronized <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this._checkState();
        return this._rs.getObject(columnIndex, type);
    }

    @Override
    public synchronized <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this._checkState();
        return this._rs.getObject(columnLabel, type);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        this._checkState();
        this._rs.updateObject(columnIndex, x, targetSqlType);
    }

    @Override
    public synchronized void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        this._checkState();
        this._rs.updateObject(columnLabel, x, targetSqlType);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this._checkState();
        this._rs.updateObject(columnIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public synchronized void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this._checkState();
        this._rs.updateObject(columnLabel, x, targetSqlType, scaleOrLength);
    }

    private Connection _connect() throws SQLException {
        if (this.getDataSourceName() != null) {
            try {
                InitialContext initialcontext = new InitialContext();
                DataSource datasource = (DataSource)initialcontext.lookup(this.getDataSourceName());
                return datasource.getConnection(this.getUsername(), this.getPassword());
            }
            catch (NamingException e) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.JNDILookup", new String[0]);
            }
        }
        if (this.getUrl() != null) {
            return DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        }
        return null;
    }

    private void _checkState() throws SQLException {
        if (this._conn == null || this._cs == null || this._rs == null) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
    }

    private void _notifyRowSetChanged() {
        if (this._listeners.isEmpty()) {
            return;
        }
        RowSetEvent e = new RowSetEvent(this);
        for (RowSetListener l : this._listeners) {
            l.rowSetChanged(e);
        }
    }

    private void _notifyCursorMoved() {
        if (this._listeners.isEmpty()) {
            return;
        }
        RowSetEvent e = new RowSetEvent(this);
        for (RowSetListener l : this._listeners) {
            l.cursorMoved(e);
        }
    }

    private void _notifyRowChanged() {
        if (this._listeners.isEmpty()) {
            return;
        }
        RowSetEvent e = new RowSetEvent(this);
        for (RowSetListener l : this._listeners) {
            l.rowChanged(e);
        }
    }
}

