/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum StatementContextOption {
    StatementSequenceInfo(1),
    ServerProcessingTime(2),
    SchemaName(3),
    FlagSet(4),
    QueryTimeout(5),
    ClientReconnectionWaitTimeout(6),
    ServerCPUTime(7),
    ServerMemoryUsage(8),
    Unknown(-1);

    private static final StatementContextOption[] VALUES;

    public static StatementContextOption decode(int value) {
        return value >= 1 && value < VALUES.length ? VALUES[value - 1] : Unknown;
    }

    public static String getDisplayName(int value) {
        return StatementContextOption.decode(value).name() + '(' + value + ')';
    }

    private StatementContextOption(int value) {
        if (value != this.ordinal() + 1 && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    static {
        VALUES = StatementContextOption.values();
    }
}

