/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HanaParameterMetaData;
import com.sap.db.jdbc.HanaResultSetMetaData;
import com.sap.db.jdbc.HashPartitionInfo;
import com.sap.db.jdbc.InternalCallableStatementSapDB;
import com.sap.db.jdbc.InternalPreparedStatementSapDB;
import com.sap.db.jdbc.ParseID;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.RangePartitionInfo;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteTypeVolumeID;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.SystemInfo;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.AbstractGetval;
import com.sap.db.jdbc.converters.AbstractPutval;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.converters.ServerConverter;
import com.sap.db.jdbc.converters.TableConverter;
import com.sap.db.jdbc.exceptions.BatchUpdateExceptionSapDB;
import com.sap.db.jdbc.exceptions.InternalFallbackHintRoutedException;
import com.sap.db.jdbc.exceptions.InternalFallbackSecondaryException;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.ActiveActiveProtocolVersion;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HPartInfo;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.PartAttribute;
import com.sap.db.jdbc.packet.PartKind;
import com.sap.db.jdbc.packet.TransactionState;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbcext.wrapper.CallableStatement;
import com.sap.db.jdbcext.wrapper.PreparedStatement;
import com.sap.db.util.Dbg;
import com.sap.db.util.DbgInstanceCount;
import com.sap.db.util.HexUtils;
import com.sap.db.util.MessageTranslator;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public abstract class PreparedStatementSapDB
extends StatementSapDB
implements java.sql.PreparedStatement,
SQLParamController {
    public static final int UNLIMITED_STREAM_LENGTH = -1;
    protected static final Object UNINITIALIZED_PARAMETER_VALUE = new Object(){

        public String toString() {
            return "<uninitialized>";
        }
    };
    private static final PutvalComparator PUTVAL_COMPARATOR = new PutvalComparator();
    protected final String _sql;
    protected final boolean _isDummy;
    protected final boolean _isDeferredPrepare;
    protected final AtomicReference<ParseInfo> _parseInfo;
    private final TimeZone _timeZone;
    private final Integer _forceRouteSiteID;
    private final boolean _transactionalLobs;
    private final int _transactionalLobsVersion;
    private final Object _lockAppLobs;
    @GuardedBy(value="_lockAppLobs")
    private List<AbstractGetval> _appLobs;
    @GuardedBy(value="this")
    private Session _session;
    @GuardedBy(value="this")
    private DataFormatDescription.NullIndicator _nullIndicator;
    @GuardedBy(value="this")
    private HDataPart _dataPart;
    @GuardedBy(value="this")
    private List<AbstractPutval> _putvals;
    @GuardedBy(value="this")
    private int _batchSize;
    @GuardedBy(value="this")
    private Object[] _inputArgs;
    @GuardedBy(value="this")
    private List<Object[]> _batchItems;
    @GuardedBy(value="this")
    private Map<SiteTypeVolumeID, List<Object[]>> _batchVolumeMap;
    @GuardedBy(value="this")
    private List<ServerConverter.ServerInputArg> _serverInputArgs;
    @GuardedBy(value="this")
    private List<List<ServerConverter.ServerInputArg>> _serverBatchItems;
    @GuardedBy(value="this")
    private boolean _fullCompileOnPrepare;
    private final AtomicInteger _computedVolumeID = new AtomicInteger(-1);

    public static PreparedStatementSapDB getPreparedStatementSapDB(java.sql.PreparedStatement preparedStatement) {
        java.sql.PreparedStatement ps = preparedStatement;
        while (!(ps instanceof PreparedStatementSapDB)) {
            if (ps instanceof PreparedStatement) {
                ps = ((PreparedStatement)ps).getInner();
                continue;
            }
            if (ps instanceof CallableStatement) {
                ps = ((CallableStatement)ps).getInner();
                continue;
            }
            return null;
        }
        return (PreparedStatementSapDB)ps;
    }

    protected PreparedStatementSapDB(Tracer tracer, ConnectionSapDB connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String commandInfoSource, int commandInfoLine, StatementSapDB.StatementFlag ... statementFlags) throws SQLException {
        super(tracer, connection, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, statementFlags);
        boolean isForceRoute;
        this._sql = sql;
        EnumSet<StatementSapDB.StatementFlag> flags = statementFlags.length > 0 ? EnumSet.copyOf(Arrays.asList(statementFlags)) : EnumSet.noneOf(StatementSapDB.StatementFlag.class);
        this._isDummy = flags.contains((Object)StatementSapDB.StatementFlag.DUMMY);
        this._isDeferredPrepare = flags.contains((Object)StatementSapDB.StatementFlag.DEFER_PREPARE);
        this._parseInfo = new AtomicReference();
        this._timeZone = this._isDeferredPrepare ? TimeZone.getDefault() : null;
        this._forceRouteSiteID = this instanceof InternalPreparedStatementSapDB || this instanceof InternalCallableStatementSapDB ? null : this._connection._getAndUnsetForceRouteSiteIDIfSpecified();
        this._transactionalLobs = connection.getTransactionalLobs();
        this._transactionalLobsVersion = connection.getTransactionalLobsVersion();
        Object object = this._lockAppLobs = this._transactionalLobs && this._transactionalLobsVersion >= 1 ? new Object() : null;
        if (this._isDummy) {
            return;
        }
        if (this._forceRouteSiteID != null) {
            isForceRoute = true;
            this._session = this._getOrOpenSessionForForceRouteSiteID(this._forceRouteSiteID);
        } else {
            isForceRoute = false;
            this._session = this._connection.getSessionPool().getPrimarySession();
        }
        boolean bl = this._fullCompileOnPrepare = !connection.getDistributionMode().isStatementRouting() || connection.isIgnoringTopology();
        if (sql == null || sql.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.null", new String[0]);
        }
        ParseInfo parseInfo = this._connection._cacheOnPrepareGetCached(sql);
        if (parseInfo != null) {
            this._setParseInfo(parseInfo);
        } else if (!this._isDeferredPrepare) {
            this._session = this._doParse(sql, this._session, false, isForceRoute);
            parseInfo = this._parseInfo.get();
        }
        if (this._isDeferredPrepare) {
            this._serverInputArgs = new ArrayList<ServerConverter.ServerInputArg>();
        } else {
            int parameterCount = parseInfo.getParameterCount();
            this._inputArgs = new Object[parameterCount];
            this._clearParameters();
        }
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeQuery") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeQuery", sql);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeQuery( String )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeUpdate", sql);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeUpdate( String )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "execute", sql);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("execute( String )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "addBatch") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "addBatch", sql);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("addBatch( String )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "clearBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearBatch", new Object[0]);
            }
            this._clearPreparedBatch();
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeBatch", new Object[0]);
            }
            int[] result = this._executePreparedBatch();
            if (on) {
                this._tracer.printResult(result);
            }
            int[] nArray = result;
            return nArray;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeUpdate", sql, autoGeneratedKeys);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeUpdate( String, int )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeUpdate", sql, columnIndexes);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeUpdate( String, int[] )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeUpdate", sql, columnNames);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeUpdate( String, String[] )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "execute", sql, autoGeneratedKeys);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("execute( String, int )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "execute", sql, columnIndexes);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("execute( String, int[] )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "execute", sql, columnNames);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("execute( String, String[] )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeLargeUpdate( String )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, autoGeneratedKeys);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeLargeUpdate( String, int )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, columnIndexes);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeLargeUpdate( String, int[] )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, columnNames);
                }
                throw PreparedStatementSapDB._getNotCallableMethodException("executeLargeUpdate( String, String[] )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeQuery") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeQuery", new Object[0]);
            }
            ResultSet result = this._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeUpdate", new Object[0]);
            }
            int result = this._executeUpdate();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "execute", new Object[0]);
            }
            boolean result = this._execute();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNull", parameterIndex, sqlType);
            }
            this._setNull(parameterIndex, sqlType);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterIndex, this._obfuscateEncrypted(parameterIndex, x));
            }
            this._setObject(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterIndex, this._obfuscateEncrypted(parameterIndex, x), targetSqlType);
            }
            this._setObject(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBoolean(int parameterIndex, boolean x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBoolean") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBoolean", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setBoolean(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setByte(int parameterIndex, byte x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setByte") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setByte", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setByte(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setShort(int parameterIndex, short x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setShort") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setShort", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setShort(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setInt(int parameterIndex, int x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setInt") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setInt", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setInt(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setLong(int parameterIndex, long x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setLong") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setLong", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setLong(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setFloat(int parameterIndex, float x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setFloat") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFloat", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)Float.valueOf(x)));
            }
            this._setFloat(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setDouble(int parameterIndex, double x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setDouble") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDouble", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setDouble(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBigDecimal", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setBigDecimal(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDate", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setDate(parameterIndex, x, null);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTime", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setTime(parameterIndex, x, null);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTimestamp", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setTimestamp(parameterIndex, x, null);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setString(int parameterIndex, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setString", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setString(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBytes(int parameterIndex, byte[] x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBytes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBytes", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setBytes(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setAsciiStream(parameterIndex, x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @Deprecated
    public synchronized void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setUnicodeStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setUnicodeStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setUnicodeStream(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setBinaryStream(parameterIndex, x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "clearParameters") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearParameters", new Object[0]);
            }
            this._clearParameters();
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "addBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "addBatch", new Object[0]);
            }
            this._addPreparedBatch();
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNull", parameterIndex, sqlType, typeName);
            }
            this._setNull(parameterIndex, sqlType);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDate", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), cal);
            }
            this._setDate(parameterIndex, x, cal);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTime", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), cal);
            }
            this._setTime(parameterIndex, x, cal);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTimestamp", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), cal);
            }
            this._setTimestamp(parameterIndex, x, cal);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setCharacterStream(parameterIndex, x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setClob(int parameterIndex, Clob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setClob(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBlob(int parameterIndex, Blob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setBlob(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setArray(int parameterIndex, Array x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setArray", parameterIndex, x);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setArray( int, Array )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setRef(int parameterIndex, Ref x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setRef", parameterIndex, x);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setRef( int, Ref )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "getMetaData") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMetaData", new Object[0]);
            }
            ResultSetMetaData result = this._getMetaData();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSetMetaData resultSetMetaData = result;
            return resultSetMetaData;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setURL(int parameterIndex, URL x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setURL", parameterIndex, x);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setURL( int, URL )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "getParameterMetaData") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getParameterMetaData", new Object[0]);
            }
            ParameterMetaData result = this._getParameterMetaData();
            if (on) {
                this._tracer.printResult(result);
            }
            ParameterMetaData parameterMetaData = result;
            return parameterMetaData;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterIndex, this._obfuscateEncrypted(parameterIndex, x), targetSqlType, scaleOrLength);
            }
            this._setObject(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNString(int parameterIndex, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNString", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setString(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setAsciiStream(parameterIndex, x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setAsciiStream(parameterIndex, x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setCharacterStream(parameterIndex, x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setCharacterStream(parameterIndex, x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNCharacterStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setCharacterStream(parameterIndex, x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNCharacterStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setCharacterStream(parameterIndex, x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setBinaryStream(parameterIndex, x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setBinaryStream(parameterIndex, x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setClob(int parameterIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setClob(parameterIndex, x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setClob(parameterIndex, x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNClob(int parameterIndex, NClob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setNClob(parameterIndex, x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNClob(int parameterIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setNClob(parameterIndex, x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setNClob(parameterIndex, x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBlob(int parameterIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x));
            }
            this._setBlob(parameterIndex, x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterIndex, this._obfuscateEncrypted(parameterIndex, (Object)x), length);
            }
            this._setBlob(parameterIndex, x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setRowId(int parameterIndex, RowId x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setRowId", parameterIndex, x);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setRowId( int, RowId )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setSQLXML", parameterIndex, x);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setSQLXML( int, SQLXML )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setObject", parameterIndex, x, targetSqlType);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setObject( int, Object, SQLType )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setObject", parameterIndex, x, targetSqlType, scaleOrLength);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("setObject( int, Object, SQLType, int )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", new Object[0]);
                }
                throw PreparedStatementSapDB._getUnsupportedMethodException("executeLargeUpdate()");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public ConnectionSapDB getConnectionSapDB() {
        return this._connection;
    }

    @Override
    public StatementSapDB getStatementSapDB() {
        return this;
    }

    @Override
    public ResultSetSapDB getResultSetSapDB() {
        return this._getCurrentResultSet();
    }

    @Override
    public void assertControllerOpen() throws SQLException {
        if (this._connection._isClosed()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession(boolean avoidOpenSession) throws SQLException {
        PreparedStatementSapDB preparedStatementSapDB = this;
        synchronized (preparedStatementSapDB) {
            return this._getSession(avoidOpenSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNullOrSpecialNull() {
        PreparedStatementSapDB preparedStatementSapDB = this;
        synchronized (preparedStatementSapDB) {
            return this._wasNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasSpecialNull() {
        PreparedStatementSapDB preparedStatementSapDB = this;
        synchronized (preparedStatementSapDB) {
            return this._nullIndicator == DataFormatDescription.NullIndicator.SPECIAL_NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNullIndicator(DataFormatDescription.NullIndicator nullIndicator) {
        PreparedStatementSapDB preparedStatementSapDB = this;
        synchronized (preparedStatementSapDB) {
            this._nullIndicator = nullIndicator;
        }
    }

    @Override
    protected ParseInfo _getParseInfo() {
        return this._parseInfo.get();
    }

    @Override
    protected FunctionCode _getFunctionCode() {
        ParseInfo parseInfo = this._parseInfo.get();
        return parseInfo != null ? parseInfo.getFunctionCode() : null;
    }

    @Override
    protected void _setPoolable(boolean isPoolable) throws SQLException {
        ParseInfo parseInfo = this._parseInfo.get();
        if (parseInfo != null) {
            this._connection._cacheOnSetPoolable(parseInfo, this._isPoolable.get(), isPoolable);
        }
        super._setPoolable(isPoolable);
    }

    @Override
    protected boolean _shouldClosePending() {
        if (this._transactionalLobsVersion >= 1) {
            return this._hasAppLobs();
        }
        ParseInfo parseInfo = this._parseInfo.get();
        if (parseInfo == null) {
            return false;
        }
        return parseInfo.hasOutputLOB() || parseInfo.hasResultSetLOB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _clearAppLobs() throws SQLException {
        ArrayList<AbstractGetval> appLobs;
        if (!this._transactionalLobs || this._transactionalLobsVersion <= 0) {
            return;
        }
        Iterator iterator = this._lockAppLobs;
        synchronized (iterator) {
            if (this._appLobs == null || this._appLobs.isEmpty()) {
                return;
            }
            appLobs = new ArrayList<AbstractGetval>(this._appLobs);
        }
        for (AbstractGetval appLob : appLobs) {
            appLob.removeAppLob(false);
        }
    }

    @Override
    protected void _clean() throws SQLException {
        PreparedStatementSapDB._clean(this.getInstanceClassName(), this._connection, this._parseInfo, this._isPoolable, this._isClosed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppLob(AbstractGetval appLob) {
        Object object = this._lockAppLobs;
        synchronized (object) {
            if (this._appLobs == null) {
                this._appLobs = new ArrayList<AbstractGetval>();
            }
            this._appLobs.add(appLob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppLob(AbstractGetval appLob, boolean allowClose) throws SQLException {
        boolean isEmpty;
        boolean wasRemoved;
        Object object = this._lockAppLobs;
        synchronized (object) {
            if (this._appLobs == null || this._appLobs.isEmpty()) {
                return;
            }
            wasRemoved = this._appLobs.remove(appLob);
            isEmpty = this._appLobs.isEmpty();
        }
        if (allowClose && this._isClosePending() && wasRemoved && isEmpty) {
            this._close(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _hasAppLobs() {
        if (this._lockAppLobs == null) {
            return false;
        }
        Object object = this._lockAppLobs;
        synchronized (object) {
            return this._appLobs != null && !this._appLobs.isEmpty();
        }
    }

    protected static void _clean(String instanceClassName, ConnectionSapDB connection, AtomicReference<ParseInfo> parseInfo, AtomicBoolean isPoolable, AtomicBoolean isClosed) throws SQLException {
        if (connection._isClosed() || isClosed.get()) {
            return;
        }
        PreparedStatementSapDB._cacheOrDropParseInfo(connection, parseInfo, isPoolable);
        if (Dbg.runtimeEnabled) {
            DbgInstanceCount.incrementCleanedCount(instanceClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void _cacheOrDropParseInfo(ConnectionSapDB connection, AtomicReference<ParseInfo> parseInfoRef, AtomicBoolean isPoolable) throws SQLException {
        ParseInfo parseInfo = parseInfoRef.getAndSet(null);
        if (parseInfo != null) {
            ConnectionSapDB connectionSapDB = connection;
            synchronized (connectionSapDB) {
                parseInfo._clearParameters();
                if (connection._cacheOnDrop(parseInfo, isPoolable.get())) {
                    return;
                }
                connection._dropParseIDs(parseInfo);
            }
        }
    }

    protected synchronized ParseInfo _ensurePrepared() throws SQLException {
        ParseInfo parseInfo = this._parseInfo.get();
        if (parseInfo == null) {
            this._session = this._doParse(this._sql, this._session, false, this._forceRouteSiteID != null);
            parseInfo = this._parseInfo.get();
        }
        return parseInfo;
    }

    protected Object _obfuscateEncrypted(int parameterIndex, Object x) throws SQLException {
        if (this._isDeferredPrepare) {
            return x;
        }
        return this._obfuscateEncrypted(this._getParameterConverter(parameterIndex), x);
    }

    protected Object _obfuscateEncrypted(String parameterName, Object x) throws SQLException {
        if (this._isDeferredPrepare) {
            return x;
        }
        return this._obfuscateEncrypted(this._getParameterConverter(parameterName), x);
    }

    protected Object _obfuscateEncrypted(AbstractConverter converter, Object x) throws SQLException {
        return !this._tracer.getTraceConfiguration().isShowPlainTextCSEEnabled() && converter.isEncrypted() ? "***" : x;
    }

    protected ResultSet _executeQuery() throws SQLException {
        this._execute();
        ResultSetSapDB currentResultSet = this._getCurrentResultSet();
        if (currentResultSet == null) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.noresultset", new String[0]);
        }
        return currentResultSet;
    }

    protected int _executeUpdate() throws SQLException {
        if (!this._isDeferredPrepare && this._parseInfo.get().isSelect()) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.resultset", new String[0]);
        }
        this._execute();
        return this._hasRowCount ? this._rowsAffected : 0;
    }

    protected boolean _execute() throws SQLException {
        Session session;
        boolean isForceRoute;
        this._assertOpen();
        if (this._forceRouteSiteID != null) {
            isForceRoute = true;
            this._connection._assertForceRouteAllowed();
            session = this._session != null && this._session.isConnected() ? this._session : (this._session = this._getOrOpenSessionForForceRouteSiteID(this._forceRouteSiteID));
        } else {
            isForceRoute = false;
            session = this._getSessionForExecute();
        }
        return this._execute(session, isForceRoute);
    }

    protected void _addBatch() throws SQLException {
        this._addPreparedBatch();
    }

    protected int[] _executeBatch() throws SQLException {
        return this._executePreparedBatch();
    }

    protected boolean _wasNull() {
        return this._connection.emptyTimestampIsNull() ? this._nullIndicator == DataFormatDescription.NullIndicator.NULL || this._nullIndicator == DataFormatDescription.NullIndicator.SPECIAL_NULL : this._nullIndicator == DataFormatDescription.NullIndicator.NULL;
    }

    protected void _setServerInputArg(int parameterIndex, ServerConverter.ServerInputArg serverInputArg) {
        for (int i = this._serverInputArgs.size(); i < parameterIndex; ++i) {
            this._serverInputArgs.add(null);
        }
        this._serverInputArgs.set(parameterIndex - 1, serverInputArg);
    }

    protected void _setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newNull(sqlType));
        } else {
            this._getParameterConverter(parameterIndex);
            this._inputArgs[parameterIndex - 1] = null;
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setObject(int parameterIndex, Object x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newObject(x, this._timeZone));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setObject(x);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newBoolean(x));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setBoolean(x);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setByte(int parameterIndex, byte x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newByte(x));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setByte(x);
            this._parseInfo.get()._setByteShortIntLong(true, parameterIndex, x, this._isBatch());
        }
    }

    protected void _setShort(int parameterIndex, short x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newShort(x));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setShort(x);
            this._parseInfo.get()._setByteShortIntLong(false, parameterIndex, x, this._isBatch());
        }
    }

    protected void _setInt(int parameterIndex, int x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newInt(x));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setInt(x);
            this._parseInfo.get()._setByteShortIntLong(false, parameterIndex, x, this._isBatch());
        }
    }

    protected void _setLong(int parameterIndex, long x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newLong(x));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setLong(x);
            this._parseInfo.get()._setByteShortIntLong(false, parameterIndex, x, this._isBatch());
        }
    }

    protected void _setFloat(int parameterIndex, float x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newFloat(x));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setFloat(x);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setDouble(int parameterIndex, double x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newDouble(x));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setDouble(x);
            this._parseInfo.get()._setDouble(parameterIndex, x, this._isBatch());
        }
    }

    protected void _setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newBigDecimal(x));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setBigDecimal(x);
            this._parseInfo.get()._setBigDecimal(parameterIndex, x, this._isBatch());
        }
    }

    protected void _setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newDate(x, cal, this._timeZone));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setDate(x, cal);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newTime(x, cal, this._timeZone));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setTime(x, cal);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newTimestamp(x, cal, this._timeZone));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setTimestamp(x, cal);
            this._parseInfo.get()._setTimestamp(parameterIndex, x, this._isBatch());
        }
    }

    protected void _setString(int parameterIndex, String x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newString(x));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setString(x);
            this._parseInfo.get()._setString(parameterIndex, x, this._isBatch());
        }
    }

    protected void _setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newBytes(x));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setBytes(x);
            this._parseInfo.get()._setBytes(parameterIndex, x, this._isBatch());
        }
    }

    protected void _setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newAsciiStream(x, length));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setAsciiStream(x, length);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setUnicodeStream(int parameterIndex, InputStream x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newUnicodeStream(x));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setUnicodeStream(x);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newCharacterStream(x, length));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setCharacterStream(x, length);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newBinaryStream(x, length));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setBinaryStream(x, length);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setClob(int parameterIndex, Clob x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newClob(x, parameterIndex - 1));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setClob(x);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setClob(int parameterIndex, Reader x, long length) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newClob(x, length, parameterIndex - 1));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setCharacterStream(x, length);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setNClob(int parameterIndex, NClob x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newNClob(x, parameterIndex - 1));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setClob(x);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newNClob(x, length, parameterIndex - 1));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setCharacterStream(x, length);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setBlob(int parameterIndex, Blob x) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newBlob(x, parameterIndex - 1));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setBlob(x);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this._isDeferredPrepare) {
            this._setServerInputArg(parameterIndex, ServerConverter.ServerInputArg.newBlob(x, length, parameterIndex - 1));
        } else {
            this._inputArgs[parameterIndex - 1] = this._getParameterConverter(parameterIndex).setBinaryStream(x, length);
            this._parseInfo.get()._setUninitialized(parameterIndex, this._isBatch());
        }
    }

    protected void _clearParameters() throws SQLException {
        if (this._isDeferredPrepare) {
            this._serverInputArgs.clear();
        } else {
            int n = this._inputArgs.length;
            for (int i = 0; i < n; ++i) {
                this._inputArgs[i] = UNINITIALIZED_PARAMETER_VALUE;
            }
            ParseInfo parseInfo = this._parseInfo.get();
            if (parseInfo != null) {
                parseInfo._clearParameters();
            }
        }
    }

    protected ResultSetMetaData _getMetaData() throws SQLException {
        ParseInfo parseInfo = this._ensurePrepared();
        if (!parseInfo.isSelect() || parseInfo.getResultSetConverters() == null) {
            return null;
        }
        return new HanaResultSetMetaData(this._tracer, parseInfo);
    }

    protected ParameterMetaData _getParameterMetaData() throws SQLException {
        ParseInfo parseInfo = this._ensurePrepared();
        return new HanaParameterMetaData(this._tracer, parseInfo.getParameterConverters());
    }

    protected AbstractConverter _getParameterConverter(int parameterIndex) throws SQLException {
        ParseInfo parseInfo = this._ensurePrepared();
        if (parameterIndex < 1 || parameterIndex > parseInfo.getParameterCount()) {
            throw SQLExceptionSapDB.newInstance("error.invalid.parameter.index", String.valueOf(parameterIndex));
        }
        return parseInfo.getParameterConverter(parameterIndex);
    }

    protected AbstractConverter _getParameterConverter(String parameterName) throws SQLException {
        ParseInfo parseInfo = this._ensurePrepared();
        if (!parseInfo.isProcedure()) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.noprocedure", new String[0]);
        }
        AbstractConverter converter = parseInfo.getParameterConverter(parameterName);
        if (converter == null) {
            throw SQLExceptionSapDB.newInstance("error.invalid.parameter.name", parameterName);
        }
        return converter;
    }

    protected void _registerOutParameter(int parameterIndex) throws SQLException {
        if (this._isDeferredPrepare) {
            return;
        }
        if (parameterIndex < 1 || parameterIndex > this._parseInfo.get().getParameterCount()) {
            throw SQLExceptionSapDB.newInstance("error.invalid.parameter.index", String.valueOf(parameterIndex));
        }
    }

    protected void _registerOutParameter(String parameterName) throws SQLException {
        if (this._isDeferredPrepare) {
            return;
        }
        AbstractConverter converter = this._parseInfo.get().getParameterConverter(parameterName);
        if (converter == null) {
            throw SQLExceptionSapDB.newInstance("error.invalid.parameter.name", parameterName);
        }
    }

    protected HDataPart _getDataPart(int outputFieldPos) throws SQLException {
        if (this._dataPart == null) {
            throw SQLExceptionSapDB.newInstance("error.nooutparamdata", new String[0]);
        }
        if (outputFieldPos == -1) {
            throw SQLExceptionSapDB.newInstance("error.parameter.not.out.or.inout", new String[0]);
        }
        this._dataPart.moveToField(outputFieldPos);
        return this._dataPart;
    }

    private static SQLException _getNotCallableMethodException(String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.notcallable", methodSignature, "Statement", "PreparedStatement");
    }

    private boolean _isBatch() {
        return this._batchSize > 0;
    }

    private void _setParseInfo(ParseInfo parseInfo) throws SQLException {
        this._parseInfo.set(parseInfo);
        this._connection._cacheOnPrepareSetTracked(parseInfo);
    }

    private Session _getSession(boolean avoidOpenSession) throws SQLException {
        boolean hintRouted;
        ParseInfo parseInfo = this._parseInfo.get();
        List<SiteTypeVolumeID> tableLocations = parseInfo != null ? parseInfo.getTableLocations() : null;
        boolean bl = hintRouted = this._shouldHintBasedRoute() && this._isHintBasedRoutingRequired();
        if ((this._connection.getDistributionMode().isStatementRouting() || hintRouted) && tableLocations != null && tableLocations.size() > 0) {
            int idx = (int)(parseInfo.getTableLocationCounter().getNextID() % (long)tableLocations.size());
            SiteTypeVolumeID siteTypeVolumeID = tableLocations.get(idx);
            if (siteTypeVolumeID.isValid()) {
                Session anchor = this._connection.getSessionPool().getAnchorSession();
                if (this._session.getAddress() instanceof PublicAddress && ((PublicAddress)this._session.getAddress()).isHSR() && this._isRoutedFromPrimaryToSecondary(anchor, siteTypeVolumeID) && (!this._shouldHintBasedRoute() || !this._connection._isSecondaryReady())) {
                    siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(siteTypeVolumeID.getVolumeID());
                }
                if (!this._connection.getDistributionMode().isStatementRouting() && !this._isRoutedFromPrimaryToSecondary(anchor, siteTypeVolumeID)) {
                    this._session = this._connection.getSessionPool().getPrimarySession();
                } else {
                    Session session = this._connection.getSessionPool().getSession(siteTypeVolumeID);
                    if (avoidOpenSession) {
                        if (session != null && session.isHintRouted()) {
                            this._connection._handleSuccessHintRouted();
                        }
                        return session != null ? session : this._session;
                    }
                    if (session == null) {
                        try {
                            session = this._connection._getSecondarySession(siteTypeVolumeID);
                        }
                        catch (SQLException e) {
                            if (anchor != null && anchor.isNoneOrPrimarySite() && siteTypeVolumeID.isSecondarySite()) {
                                this._connection._handleFailedHintRouted();
                                siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(siteTypeVolumeID.getVolumeID());
                                try {
                                    session = this._connection._getSecondarySession(siteTypeVolumeID);
                                }
                                catch (SQLException e1) {
                                    session = this._connection.getSessionPool().getPrimarySession();
                                }
                                if (session == null) {
                                    session = this._connection.getSessionPool().getPrimarySession();
                                }
                            }
                            session = this._connection.getSessionPool().getPrimarySession();
                        }
                        if (session == null) {
                            session = this._connection.getSessionPool().getPrimarySession();
                        }
                    }
                    this._session = session;
                }
            }
        } else {
            this._session = this._connection.getSessionPool().getPrimarySession();
        }
        if (this._session.isHintRouted()) {
            this._connection._handleSuccessHintRouted();
        }
        return this._session;
    }

    private Session _getSession(SiteTypeVolumeID siteTypeVolumeID) throws SQLException {
        Session session = this._connection.getSessionPool().getSession(siteTypeVolumeID);
        Session anchor = this._connection.getSessionPool().getAnchorSession();
        if (this._session.getAddress() instanceof PublicAddress && ((PublicAddress)this._session.getAddress()).isHSR() && this._isRoutedFromPrimaryToSecondary(anchor, siteTypeVolumeID) && (!this._shouldHintBasedRoute() || !this._connection._isSecondaryReady())) {
            siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(siteTypeVolumeID.getVolumeID());
        }
        if (!this._connection.getDistributionMode().isStatementRouting() && !this._isRoutedFromPrimaryToSecondary(anchor, siteTypeVolumeID)) {
            session = this._connection.getSessionPool().getPrimarySession();
        } else if (session == null) {
            try {
                session = this._connection._getSecondarySession(siteTypeVolumeID);
            }
            catch (SQLException e) {
                if (anchor != null && anchor.isNoneOrPrimarySite() && siteTypeVolumeID.isSecondarySite()) {
                    this._connection._handleFailedHintRouted();
                    siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(siteTypeVolumeID.getVolumeID());
                    try {
                        session = this._connection._getSecondarySession(siteTypeVolumeID);
                    }
                    catch (SQLException e1) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                    if (session == null) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                }
                session = this._connection.getSessionPool().getPrimarySession();
            }
            if (session == null) {
                session = this._connection.getSessionPool().getPrimarySession();
            }
        }
        if (session.isHintRouted()) {
            this._connection._handleSuccessHintRouted();
        }
        this._session = session;
        return session;
    }

    private Session _getSessionForExecute() throws SQLException {
        Session session;
        if (this._isDeferredPrepare) {
            session = this._connection.getSessionPool().getPrimarySession();
        } else {
            boolean hintRouted;
            boolean bl = hintRouted = this._shouldHintBasedRoute() && this._isHintBasedRoutingRequired();
            if (this._isClientRouting() && (this._connection.getDistributionMode().isStatementRouting() || hintRouted)) {
                SiteTypeVolumeID siteTypeVolumeID = this._computeVolumeID();
                this._computedVolumeID.set(siteTypeVolumeID.getVolumeID());
                if (siteTypeVolumeID.isValid()) {
                    session = this._getSession(siteTypeVolumeID);
                    if (this._parseInfo.get().getParseID(session) == null) {
                        session = this._reparse(session);
                    }
                } else {
                    session = this.getSession(false);
                }
            } else {
                session = this.getSession(false);
            }
        }
        this._session = session;
        return this._session;
    }

    private boolean _shouldHintBasedRoute() throws SQLException {
        TransactionState transactionState;
        if (this._isDeferredPrepare) {
            return false;
        }
        Address address = this._session.getAddress();
        if (!(address instanceof PublicAddress)) {
            return false;
        }
        return this._connection.getEngineFeatures().getActiveActiveProtocolVersion().getValue() >= ActiveActiveProtocolVersion.Level1.getValue() && this._session != null && ((PublicAddress)this._session.getAddress()).isHSR() && this._connection._getTransactionIsolation() == 2 && ((transactionState = this._connection.getTransactionState()) == TransactionState.None || transactionState == TransactionState.ReadTransaction);
    }

    private boolean _isHintBasedRoutingRequired() throws SQLException {
        SiteTypeVolumeID siteTypeVolumeID;
        List<SiteTypeVolumeID> tableLocations;
        Session anchor = this._connection.getSessionPool().getAnchorSession();
        if (anchor == null) {
            return false;
        }
        ParseInfo parseInfo = this._parseInfo.get();
        List<SiteTypeVolumeID> list = tableLocations = this._parseInfo != null ? parseInfo.getTableLocations() : null;
        if (tableLocations != null && tableLocations.size() > 0) {
            SiteTypeVolumeID siteTypeVolumeID2 = tableLocations.get(0);
            if (this._isRoutedFromPrimaryToSecondary(anchor, siteTypeVolumeID2)) {
                return true;
            }
            if (this._isRoutedFromSecondaryToPrimary(anchor, siteTypeVolumeID2)) {
                throw SQLExceptionSapDB.newInstance("error.invalid.routing", new String[0]);
            }
        } else if ((parseInfo.isHashPartitioned() || parseInfo.isRangePartitioned()) && (siteTypeVolumeID = parseInfo.getFirstPartitionVolumeID()) != null) {
            if (this._isRoutedFromPrimaryToSecondary(anchor, siteTypeVolumeID)) {
                return true;
            }
            if (this._isRoutedFromSecondaryToPrimary(anchor, siteTypeVolumeID)) {
                throw SQLExceptionSapDB.newInstance("error.invalid.routing", new String[0]);
            }
        }
        return false;
    }

    private boolean _isRoutedFromPrimaryToSecondary(Session anchor, SiteTypeVolumeID siteTypeVolumeID) {
        return anchor != null && anchor.isNoneOrPrimarySite() && siteTypeVolumeID.isSecondarySite();
    }

    private boolean _isRoutedFromSecondaryToPrimary(Session anchor, SiteTypeVolumeID siteTypeVolumeID) {
        return anchor != null && anchor.isSecondarySite() && siteTypeVolumeID.isNoneOrPrimary();
    }

    private Session _doParse(String sql, Session session, boolean isReparse, boolean isForceRoute) throws SQLException {
        HReplyPacket replyPacket;
        ParseInfo parseInfo = isReparse ? this._parseInfo.get() : null;
        try {
            replyPacket = this._prepare(sql, session, isForceRoute);
        }
        catch (InternalReconnectException e) {
            session = e.getNewSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.objectisclosed", this.toString());
            }
            replyPacket = this._prepare(sql, session, false);
        }
        catch (InternalFallbackSecondaryException e) {
            session = this._connection.getSessionPool().getAnchorSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.objectisclosed", this.toString());
            }
            if (parseInfo != null && parseInfo.getParseID(session) != null) {
                return session;
            }
            replyPacket = this._prepare(sql, session, false);
        }
        catch (InternalFallbackHintRoutedException e) {
            if (session.isHintRouted()) {
                this._connection._handleFailedHintRouted();
                SiteTypeVolumeID siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(session.getSiteVolumeID().getVolumeID());
                try {
                    session = this._connection._getSecondarySession(siteTypeVolumeID);
                    if (session == null) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                }
                catch (SQLException e1) {
                    session = this._connection.getSessionPool().getPrimarySession();
                }
                this._session = session;
                ParseID parseID = parseInfo.getParseID(session);
                if (parseID != null) {
                    return session;
                }
            }
            replyPacket = this._prepare(sql, session, false);
        }
        return this._handlePrepareReply(sql, session, isReparse, parseInfo, replyPacket, true);
    }

    private Session _handlePrepareReply(String sql, Session session, boolean isReparse, ParseInfo parseInfo, HReplyPacket replyPacket, boolean accumulateServerKPIs) throws SQLException {
        boolean foundStatementIDPart = false;
        if (!isReparse) {
            parseInfo = new ParseInfo(this._tracer, this._connection, sql, replyPacket.getFunctionCode(0), this._connection._getUniqueID());
        }
        ArrayList<AbstractConverter> converters = new ArrayList<AbstractConverter>();
        for (HPartInfo partInfo : replyPacket.parts(0)) {
            switch (partInfo.getPartKind()) {
                case StatementID: {
                    parseInfo.addParseID(session, new ParseID(partInfo.getStatementID()));
                    foundStatementIDPart = true;
                    break;
                }
                case TableLocation: {
                    SystemInfo systemInfo;
                    if (this._connection.isIgnoringTopology() || (systemInfo = this._connection.getSessionPool().getSystemInfo()) == null) break;
                    parseInfo.setTableLocations(partInfo.getTableLocations(systemInfo.getSiteIDToSiteTypeMap()));
                    break;
                }
                case StatementContext: {
                    if (!accumulateServerKPIs) break;
                    this._serverKPIs.accumulate(partInfo.getOptionsPart());
                    break;
                }
                case PartitionInformation: {
                    SystemInfo systemInfo;
                    if (this._connection.isIgnoringTopology() || (systemInfo = this._connection.getSessionPool().getSystemInfo()) == null || isReparse) break;
                    parseInfo.addPartitionInformationNode(partInfo, systemInfo.getSiteIDToSiteTypeMap());
                    break;
                }
                case ParameterMetaData: {
                    partInfo.getParameterMetaData(this._connection, parseInfo);
                    break;
                }
                case ResultSetMetaData: {
                    partInfo.getResultSetMetaData(this._connection, converters);
                    parseInfo.setResultSetConverters(converters);
                }
            }
        }
        if (!foundStatementIDPart) {
            return null;
        }
        if (session.isHintRouted()) {
            this._connection._handleSuccessHintRouted();
        }
        if (!isReparse) {
            this._setParseInfo(parseInfo);
        }
        return session;
    }

    private Session _reparse(Session session) throws SQLException {
        this._fullCompileOnPrepare = true;
        return this._doParse(this._parseInfo.get().getSQL(), session, true, false);
    }

    private HReplyPacket _prepare(String sql, Session session, boolean isForceRoute) throws SQLException {
        HRequestPacket requestPacket = this._connection.initPrepare(session, this._resultSetHoldability, sql, this._fullCompileOnPrepare, this._commandInfoSource, this._commandInfoLine);
        this._session = session;
        HReplyPacket replyPacket = this._connection.exchange(session, requestPacket, this, ConnectionSapDB.ExchangeFlag.IS_PREPARE_ONLY, isForceRoute ? ConnectionSapDB.ExchangeFlag.FORCE_ROUTE_NO_FALLBACK : ConnectionSapDB.ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
        return replyPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _execute(Session session, boolean isForceRoute) throws SQLException {
        boolean isQuery;
        SiteTypeVolumeID siteTypeVolumeID;
        ParseInfo parseInfo = this._parseInfo.get();
        Set<String> tableOutputParameters = null;
        ParseID parseID = null;
        this._resetForExecute();
        this._wasCancelled.set(false);
        this._dataPart = null;
        if (parseInfo != null && (parseID = parseInfo.getParseID(session)) == null && (parseID = parseInfo.getParseID(session = this._reparse(session))) == null && session.isHintRouted()) {
            siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(session.getSiteVolumeID().getVolumeID());
            session = this._connection.getSessionPool().getSession(siteTypeVolumeID);
            if (session != null) {
                parseID = parseInfo.getParseID(session);
            }
            if (parseID == null) {
                session = this._connection.getSessionPool().getPrimarySession();
                parseID = parseInfo.getParseID(session);
            }
            if (parseID == null) {
                for (Map.Entry<Session, ParseID> entry : parseInfo.getParseIDs().entrySet()) {
                    Session aSession = entry.getKey();
                    ParseID aParseID = entry.getValue();
                    if (!aSession.isPrimarySite() || aParseID == null) continue;
                    parseID = aParseID;
                    break;
                }
                if (session == null || parseID == null) {
                    session = this._connection.getSessionPool().getPrimarySession();
                    session = this._reparse(session);
                    parseID = parseInfo.getParseID(session);
                }
            }
        }
        try {
            boolean hasInputArgs;
            HRequestPacket requestPacket;
            boolean truncated = false;
            boolean isPrepareAndExecuteRequest = false;
            if (this._isDeferredPrepare) {
                if (parseInfo == null) {
                    requestPacket = this._connection.initPrepareAndExecute(session, this._resultSetHoldability, this._queryTimeout, this._sql, this._commandInfoSource, this._commandInfoLine);
                    isPrepareAndExecuteRequest = true;
                } else {
                    requestPacket = this._connection.initExecute(session, this._resultSetHoldability, this._queryTimeout, parseID, false, this._commandInfoSource, this._commandInfoLine);
                }
                hasInputArgs = this._serverInputArgs.size() > 0;
            } else {
                requestPacket = this._connection.initExecute(session, this._resultSetHoldability, this._queryTimeout, parseID, isForceRoute, this._commandInfoSource, this._commandInfoLine);
                boolean bl = hasInputArgs = parseInfo.getInputParameterCount() > 0;
                if (hasInputArgs) {
                    int n = parseInfo.getParameterCount();
                    for (int i = 1; i <= n; ++i) {
                        AbstractConverter converter = parseInfo.getParameterConverter(i);
                        if (!converter.getParameterMode().isInput() || UNINITIALIZED_PARAMETER_VALUE != this._inputArgs[i - 1]) continue;
                        throw new SQLException(MessageTranslator.translate("error.missinginout", String.valueOf(i)), "02000");
                    }
                }
            }
            if (hasInputArgs) {
                HDataPart dataPart = requestPacket.addParametersPart();
                if (this._isDeferredPrepare) {
                    dataPart.putServerInputArgs(this._serverInputArgs);
                    if (this._hasInputLOB(parseInfo)) {
                        truncated = this._handleStreamsForExecute(dataPart, this._serverInputArgs);
                    }
                } else {
                    dataPart.putInputArgs(parseInfo.getParameterConverters(), this._inputArgs);
                    if (parseInfo.hasInputLOB()) {
                        truncated = this._handleStreamsForExecute(dataPart, this._inputArgs);
                    }
                }
                dataPart.close();
            }
            if (truncated && this._connection.isAutoCommit()) {
                requestPacket.setAutoCommit(false);
            }
            requestPacket.close();
            ConnectionSapDB i = this._connection;
            synchronized (i) {
                HDataPart outputParametersPart;
                this._connection._cacheOnExecute();
                ConnectionSapDB.ExchangeFlag lastFlag = isForceRoute ? ConnectionSapDB.ExchangeFlag.FORCE_ROUTE_NO_FALLBACK : (this._hasInputLOB(parseInfo) ? ConnectionSapDB.ExchangeFlag.NOP : ConnectionSapDB.ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
                this._session = session;
                HReplyPacket replyPacket = this._connection.exchange(session, requestPacket, this, ConnectionSapDB.ExchangeFlag.IS_STATEMENT, ConnectionSapDB.ExchangeFlag.IS_PREPARED_EXECUTE, isPrepareAndExecuteRequest ? ConnectionSapDB.ExchangeFlag.IGNORE_ERRORS : ConnectionSapDB.ExchangeFlag.NOP, lastFlag);
                if (isPrepareAndExecuteRequest) {
                    session = this._handlePrepareReply(this._sql, session, false, null, replyPacket, false);
                    parseInfo = this._parseInfo.get();
                    SQLException sqlExceptionChain = replyPacket.findSQLExceptionChain(this._connection, 0);
                    if (sqlExceptionChain != null && !(sqlExceptionChain instanceof SQLWarning)) {
                        throw sqlExceptionChain;
                    }
                }
                for (HPartInfo partInfo : replyPacket.parts(0)) {
                    switch (partInfo.getPartKind()) {
                        case PartitionInformation: {
                            SystemInfo systemInfo;
                            if (this._connection.isIgnoringTopology() || (systemInfo = this._connection.getSessionPool().getSystemInfo()) == null) break;
                            parseInfo.addPartitionInformationNode(partInfo, systemInfo.getSiteIDToSiteTypeMap());
                            break;
                        }
                        case TableLocation: {
                            SystemInfo systemInfo;
                            if (this._connection.isIgnoringTopology() || (systemInfo = this._connection.getSessionPool().getSystemInfo()) == null) break;
                            parseInfo.setTableLocations(partInfo.getTableLocations(systemInfo.getSiteIDToSiteTypeMap()));
                        }
                    }
                }
                if (parseInfo == null) {
                    throw new AssertionError((Object)"Unexpected null ParseInfo");
                }
                int returnCode = replyPacket.findErrorCode(0);
                if (parseInfo.hasInputLOB() && returnCode == 0) {
                    replyPacket = this._handleStreamsForPutval(replyPacket, session, false);
                }
                if ((outputParametersPart = replyPacket.findOutputParametersPart(0)) != null) {
                    this._dataPart = outputParametersPart;
                    this._dataPart.setDataFormatDescription(parseInfo);
                    tableOutputParameters = this._getTableOutputParameters();
                }
                isQuery = this._parseResult(session, replyPacket, parseInfo.getResultSetConverters(), tableOutputParameters);
                if (truncated && this._connection.isAutoCommit()) {
                    this._connection._commitInternal();
                }
            }
        }
        catch (InternalReconnectException e) {
            session = e.getNewSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.objectisclosed", this.toString());
            }
            this._session = session;
            boolean n = this._execute(session, false);
            return n;
        }
        catch (InternalFallbackSecondaryException e) {
            session = this._connection.getSessionPool().getAnchorSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.objectisclosed", this.toString());
            }
            this._session = session;
            boolean n = this._execute(session, false);
            return n;
        }
        catch (InternalFallbackHintRoutedException e1) {
            if (session.isHintRouted()) {
                if (e1.getMessage() == null || !e1.getMessage().equals("FallbackFlag")) {
                    this._connection._handleFailedHintRouted();
                }
                siteTypeVolumeID = this._getPrimarySiblingSiteVolumeID(session.getSiteVolumeID().getVolumeID());
                try {
                    session = this._connection._getSecondarySession(siteTypeVolumeID);
                    if (session == null) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                }
                catch (SQLException e) {
                    session = this._connection.getSessionPool().getPrimarySession();
                }
                this._session = session;
            }
            boolean bl = this._execute(session, false);
            return bl;
        }
        finally {
            this._wasCancelled.set(false);
        }
        if (session.isHintRouted()) {
            this._connection._handleSuccessHintRouted();
        }
        return isQuery;
    }

    private boolean _hasInputLOB(ParseInfo parseInfo) {
        if (this._isDeferredPrepare) {
            for (ServerConverter.ServerInputArg serverInputArg : this._serverInputArgs) {
                if (serverInputArg == null || !serverInputArg.isLOB()) continue;
                return true;
            }
            return false;
        }
        return parseInfo.hasInputLOB();
    }

    private Set<String> _getTableOutputParameters() throws SQLException {
        if (!this._connection.refCursors()) {
            return null;
        }
        HashSet<String> tableOutputParameters = null;
        for (AbstractConverter converter : this._parseInfo.get().getParameterConverters()) {
            if (!(converter instanceof TableConverter) || converter.getParameterMode() != ParameterMode.Out) continue;
            int outputFieldPos = converter.getOutputFieldPos();
            byte[] cursorID = converter.getBytes(this, this._getDataPart(outputFieldPos));
            if (tableOutputParameters == null) {
                tableOutputParameters = new HashSet<String>();
            }
            tableOutputParameters.add(HexUtils.toHexString(cursorID));
        }
        return tableOutputParameters;
    }

    private boolean _handleStreamsForExecute(HDataPart dataPart, Object[] inputArgs) throws SQLException {
        ParseInfo parseInfo = this._parseInfo.get();
        this._putvals = new ArrayList<AbstractPutval>();
        int n = parseInfo.getParameterCount();
        for (int i = 1; i <= n; ++i) {
            AbstractConverter converter = parseInfo.getParameterConverter(i);
            Object inputArg = inputArgs[i - 1];
            if (!converter.isLOB() || !(inputArg instanceof AbstractPutval)) continue;
            this._putvals.add((AbstractPutval)inputArg);
        }
        this._putvals.sort(PUTVAL_COMPARATOR);
        return this._writePutvals(dataPart);
    }

    private boolean _handleStreamsForExecute(HDataPart dataPart, List<ServerConverter.ServerInputArg> serverInputArgs) throws SQLException {
        this._putvals = new ArrayList<AbstractPutval>();
        int n = serverInputArgs.size();
        for (int i = 1; i <= n; ++i) {
            ServerConverter.ServerInputArg serverInputArg = serverInputArgs.get(i - 1);
            if (serverInputArg == null || !serverInputArg.isLOB() || serverInputArg._value == null) continue;
            this._putvals.add((AbstractPutval)serverInputArg._value);
        }
        this._putvals.sort(PUTVAL_COMPARATOR);
        return this._writePutvals(dataPart);
    }

    private boolean _writePutvals(HDataPart dataPart) throws SQLException {
        boolean wasTruncated = false;
        for (AbstractPutval putval : this._putvals) {
            if (putval.isEOF() && (putval = putval.cloneForBatch()).isEOF()) {
                throw SQLExceptionSapDB.newInstance("error.stream.isatend", new String[0]);
            }
            putval.transferData(true, dataPart);
            if (!putval.isEOF()) {
                wasTruncated = true;
            }
            putval.setLocatorIDStale();
        }
        return wasTruncated;
    }

    private HReplyPacket _handleStreamsForPutval(HReplyPacket replyPacket, Session session, boolean ignoreErrors) throws SQLException {
        if (this._putvals == null || this._putvals.isEmpty()) {
            return replyPacket;
        }
        for (HPartInfo partInfo : replyPacket.parts(0)) {
            if (partInfo.getPartKind() != PartKind.RowsAffected) continue;
            this._rowsAffected = partInfo.getRowsAffected();
            this._hasRowCount = true;
            this._hasReturnedRowsAffected = false;
            break;
        }
        int putvalCount = this._putvals.size();
        AbstractPutval lastPutval = this._putvals.get(putvalCount - 1);
        int firstOpenPutval = 0;
        if (!lastPutval.isEOF()) {
            this._getChangedPutvalDescriptors(replyPacket);
        }
        while (!lastPutval.isEOF()) {
            HRequestPacket requestPacket = this._connection.initWriteLOB(session, this._packetSize);
            HDataPart dataPart = requestPacket.addWriteLOBRequestPart();
            int putvalsHandled = 0;
            for (int i = firstOpenPutval; i < putvalCount && dataPart.canAddLOBDescriptor(21); ++i) {
                AbstractPutval putval = this._putvals.get(i);
                if (putval.isEOF() || putval.isLocatorIDStale()) {
                    ++firstOpenPutval;
                    continue;
                }
                putval.putDescriptor(false, dataPart);
                ++putvalsHandled;
                if (this._wasCancelled.get()) {
                    putval.markEOF();
                    ++firstOpenPutval;
                    continue;
                }
                putval.transferData(false, dataPart);
                if (!putval.isEOF()) continue;
                ++firstOpenPutval;
            }
            if (putvalsHandled == 0) {
                return replyPacket;
            }
            dataPart.close(putvalsHandled);
            requestPacket.close();
            this._session = session;
            replyPacket = this._connection.exchange(session, requestPacket, this, ConnectionSapDB.ExchangeFlag.IS_PREPARED_EXECUTE, ignoreErrors ? ConnectionSapDB.ExchangeFlag.IGNORE_ERRORS : ConnectionSapDB.ExchangeFlag.NOP);
        }
        if (this._wasCancelled.get()) {
            throw SQLExceptionSapDB.newInstance("error.statement.cancelled", new String[0]);
        }
        return replyPacket;
    }

    private void _getChangedPutvalDescriptors(HReplyPacket replyPacket) throws SQLException {
        byte[][] descriptors = replyPacket.findLOBLocators(0);
        int descriptorCount = descriptors.length;
        int descriptorIndex = 0;
        for (AbstractPutval putval : this._putvals) {
            if (putval.isEOF()) continue;
            if (descriptorIndex >= descriptorCount) {
                throw SQLExceptionSapDB.newInstance("error.internal.LOBDescriptorMissing", new String[0]);
            }
            putval.setLocatorID(descriptors[descriptorIndex++]);
        }
        if (descriptorIndex < descriptorCount) {
            throw SQLExceptionSapDB.newInstance("error.internal.ToManyLOBDescriptors", new String[0]);
        }
    }

    private void _addPreparedBatch() throws SQLException {
        ++this._batchSize;
        if (this._isDeferredPrepare) {
            if (this._serverBatchItems == null) {
                this._serverBatchItems = new ArrayList<List<ServerConverter.ServerInputArg>>();
            }
            this._serverBatchItems.add(this._serverInputArgs);
        } else if (this._isClientRouting()) {
            List<Object[]> items;
            SiteTypeVolumeID siteTypeVolumeID = this._computeVolumeID();
            if (this._batchVolumeMap == null) {
                this._batchVolumeMap = new HashMap<SiteTypeVolumeID, List<Object[]>>();
            }
            if ((items = this._batchVolumeMap.get(siteTypeVolumeID)) == null) {
                items = new ArrayList<Object[]>();
                this._batchVolumeMap.put(siteTypeVolumeID, items);
            }
            items.add(this._inputArgs);
        } else {
            if (this._batchItems == null) {
                this._batchItems = new ArrayList<Object[]>();
            }
            this._batchItems.add(this._inputArgs);
        }
        if (this._isDeferredPrepare) {
            ArrayList<ServerConverter.ServerInputArg> serverNextRow = new ArrayList<ServerConverter.ServerInputArg>();
            for (ServerConverter.ServerInputArg serverInputArg : this._serverInputArgs) {
                serverNextRow.add(ServerConverter.cloneServerInputArgForBatch(serverInputArg));
            }
            this._serverInputArgs = serverNextRow;
        } else {
            ParseInfo parseInfo = this._parseInfo.get();
            int parameterCount = parseInfo.getParameterCount();
            Object[] nextRow = new Object[parameterCount];
            for (int i = 1; i <= parameterCount; ++i) {
                AbstractConverter converter = parseInfo.getParameterConverter(i);
                nextRow[i - 1] = converter.cloneObjectForBatch(this._inputArgs[i - 1]);
            }
            this._inputArgs = nextRow;
        }
    }

    private void _clearPreparedBatch() {
        if (this._isDeferredPrepare) {
            if (this._serverBatchItems != null) {
                this._serverBatchItems.clear();
            }
        } else {
            if (this._batchItems != null) {
                this._batchItems.clear();
            }
            if (this._batchVolumeMap != null) {
                this._batchVolumeMap.clear();
            }
        }
        this._batchSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] _executePreparedBatch() throws SQLException {
        int[] updateCounts;
        this._assertOpen();
        this._resetForExecute();
        ConnectionSapDB connectionSapDB = this._connection;
        synchronized (connectionSapDB) {
            this._connection._cacheOnExecute();
            if (this._isDeferredPrepare) {
                Session session = this._getSession(false);
                updateCounts = this._executePreparedBatch(session);
            } else if (this._isClientRouting() && this._batchVolumeMap != null && !this._batchVolumeMap.isEmpty()) {
                updateCounts = new int[this._batchSize];
                int itemCount = 0;
                ParseInfo parseInfo = this._parseInfo.get();
                for (Map.Entry<SiteTypeVolumeID, List<Object[]>> entry : this._batchVolumeMap.entrySet()) {
                    Session session;
                    SiteTypeVolumeID siteTypeVolumeID = entry.getKey();
                    List<Object[]> items = entry.getValue();
                    if (items.isEmpty()) continue;
                    if (this._batchItems == null) {
                        this._batchItems = new ArrayList<Object[]>();
                    } else {
                        this._batchItems.clear();
                    }
                    this._batchItems.addAll(items);
                    if (siteTypeVolumeID.isValid()) {
                        session = this._getSession(siteTypeVolumeID);
                        if (parseInfo.getParseID(session) == null) {
                            session = this._reparse(session);
                        }
                    } else {
                        session = this._getSession(false);
                    }
                    this._session = session;
                    int[] subsetUpdateCounts = this._executePreparedBatch(session);
                    System.arraycopy(subsetUpdateCounts, 0, updateCounts, itemCount, subsetUpdateCounts.length);
                    itemCount += subsetUpdateCounts.length;
                }
                this._batchVolumeMap.clear();
            } else {
                Session session = this._isClientRoutingByHashWithoutSplit() || this._isClientRoutingByRangeWithoutSplit() ? this._getSession(this._computeVolumeID()) : this._getSession(false);
                updateCounts = this._executePreparedBatch(session);
            }
            this._batchSize = 0;
        }
        return updateCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int[] _executePreparedBatch(Session session) throws SQLException {
        int[] result;
        block52: {
            int count;
            ParseInfo parseInfo = this._parseInfo.get();
            ParseID parseID = null;
            ArrayList<Object[]> localBatchItems = null;
            ArrayList<List<ServerConverter.ServerInputArg>> localServerBatchItems = null;
            SQLException lastWriteLobSqlExceptionChain = null;
            if (parseInfo != null) {
                parseID = parseInfo.getParseID(session);
                if (parseID == null) {
                    session = this._reparse(session);
                    parseID = parseInfo.getParseID(session);
                }
                if (!this._isDeferredPrepare) {
                    if (parseInfo.isSelect()) {
                        throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchresultset", new Object[0]), new int[0]);
                    }
                    if (parseInfo.getFunctionCode() == FunctionCode.DBProcedureCall || parseInfo.getFunctionCode() == FunctionCode.DBProcedureCallWithResultSet) {
                        for (AbstractConverter converter : parseInfo.getParameterConverters()) {
                            if (!converter.getParameterMode().isOutput()) continue;
                            throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchprocout", new Object[0]), new int[0]);
                        }
                    }
                }
            }
            if (this._isDeferredPrepare) {
                if (this._serverBatchItems == null || this._serverBatchItems.isEmpty()) {
                    return new int[0];
                }
                localServerBatchItems = new ArrayList<List<ServerConverter.ServerInputArg>>(this._serverBatchItems);
                count = localServerBatchItems.size();
                this._serverBatchItems.clear();
            } else {
                if (this._batchItems == null || this._batchItems.isEmpty()) {
                    return new int[0];
                }
                localBatchItems = new ArrayList<Object[]>(this._batchItems);
                count = localBatchItems.size();
                this._batchItems.clear();
            }
            try {
                this._wasCancelled.set(false);
                boolean isFirstPacket = true;
                int inputCursor = 0;
                int executeCount = -1;
                SQLException batchUpdateExceptionChain = null;
                int batchUpdateExceptionIdx = -1;
                result = new int[count];
                boolean truncated = false;
                String commandInfoSource = this._commandInfoSource;
                int commandInfoLine = this._commandInfoLine;
                while (inputCursor < count) {
                    HReplyPacket lastWriteLOBReplyPacket;
                    int[] temp;
                    HReplyPacket replyPacket;
                    int i2;
                    int n;
                    HRequestPacket requestPacket;
                    int[] updateCounts = null;
                    int firstRecordNo = inputCursor;
                    boolean isPrepareAndExecuteRequest = false;
                    if (this._isDeferredPrepare) {
                        if (parseInfo == null) {
                            requestPacket = this._connection.initPrepareAndExecute(session, this._resultSetHoldability, this._queryTimeout, this._sql, commandInfoSource, commandInfoLine, this._packetSize);
                            isPrepareAndExecuteRequest = true;
                        } else {
                            requestPacket = this._connection.initExecute(session, this._resultSetHoldability, this._queryTimeout, parseID, false, commandInfoSource, commandInfoLine, this._packetSize);
                        }
                    } else {
                        requestPacket = this._connection.initExecute(session, this._resultSetHoldability, this._queryTimeout, parseID, false, commandInfoSource, commandInfoLine, this._packetSize);
                    }
                    commandInfoSource = null;
                    commandInfoLine = 0;
                    HDataPart dataPart = requestPacket.addParametersPart();
                    if (isFirstPacket) {
                        requestPacket.addPartAttribute(PartAttribute.FirstPacket);
                        isFirstPacket = false;
                    }
                    int rowcnt = 0;
                    do {
                        boolean looptruncated;
                        Object[] row;
                        if (this._isDeferredPrepare) {
                            row = (Object[])localServerBatchItems.get(inputCursor);
                            if (!dataPart.putServerInputArgs((List<ServerConverter.ServerInputArg>)row)) break;
                            ++rowcnt;
                            if (!this._hasInputLOB(parseInfo)) continue;
                            looptruncated = this._handleStreamsForExecute(dataPart, (List<ServerConverter.ServerInputArg>)row);
                            if (looptruncated) {
                                truncated = true;
                            }
                            if (!truncated || !this._connection.isAutoCommit()) continue;
                            requestPacket.setAutoCommit(false);
                            continue;
                        }
                        row = (Object[])localBatchItems.get(inputCursor);
                        n = parseInfo.getParameterCount();
                        for (i2 = 1; i2 <= n; ++i2) {
                            AbstractConverter converter = parseInfo.getParameterConverter(i2);
                            if (!converter.getParameterMode().isInput() || UNINITIALIZED_PARAMETER_VALUE != row[i2 - 1]) continue;
                            this._makeBatchCountArray(result, new int[0], firstRecordNo, count - firstRecordNo, -3);
                            throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchmissingin", Integer.toString(inputCursor + 1), Integer.toString(i2)), "02000", result);
                        }
                        if (!dataPart.putInputArgs(parseInfo.getParameterConverters(), row)) break;
                        ++rowcnt;
                        if (!parseInfo.hasInputLOB()) continue;
                        looptruncated = this._handleStreamsForExecute(dataPart, row);
                        if (looptruncated) {
                            truncated = true;
                        }
                        if (!truncated || !this._connection.isAutoCommit()) continue;
                        requestPacket.setAutoCommit(false);
                    } while (++inputCursor < count);
                    if (inputCursor == count) {
                        requestPacket.addPartAttribute(PartAttribute.LastPacket);
                    }
                    dataPart.close(inputCursor - firstRecordNo);
                    if (rowcnt <= 0) continue;
                    try {
                        requestPacket.close();
                        this._session = session;
                        replyPacket = this._connection.exchange(session, requestPacket, this, this._hasInputLOB(parseInfo) ? ConnectionSapDB.ExchangeFlag.NOP : ConnectionSapDB.ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK, ConnectionSapDB.ExchangeFlag.IGNORE_ERRORS, ConnectionSapDB.ExchangeFlag.IS_PREPARED_EXECUTE);
                    }
                    catch (InternalReconnectException e) {
                        session = e.getNewSession();
                        if (session == null || !session.isConnected()) {
                            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.objectisclosed", this.toString());
                        }
                        if (this._isDeferredPrepare) {
                            this._serverBatchItems.addAll(localServerBatchItems);
                        } else {
                            this._batchItems.addAll(localBatchItems);
                        }
                        int[] i2 = this._executePreparedBatch(session);
                        this._wasCancelled.set(false);
                        return i2;
                    }
                    catch (InternalFallbackSecondaryException e) {
                        session = this._connection.getSessionPool().getAnchorSession();
                        if (session == null || !session.isConnected()) {
                            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.objectisclosed", this.toString());
                        }
                        if (this._isDeferredPrepare) {
                            this._serverBatchItems.addAll(localServerBatchItems);
                        } else {
                            this._batchItems.addAll(localBatchItems);
                        }
                        int[] i2 = this._executePreparedBatch(session);
                        this._wasCancelled.set(false);
                        return i2;
                    }
                    if (isPrepareAndExecuteRequest) {
                        session = this._handlePrepareReply(this._sql, session, false, null, replyPacket, false);
                        parseInfo = this._parseInfo.get();
                        if (parseInfo != null) {
                            parseID = parseInfo.getParseID(session);
                        }
                    }
                    if ((temp = replyPacket.findBatchUpdateCounts(0)).length > 0) {
                        executeCount = replyPacket.findRowsAffected(0);
                        updateCounts = temp;
                    }
                    SQLException executeSqlExceptionChain = replyPacket.findSQLExceptionChain(this._connection, 0);
                    this._serverKPIs.accumulate(replyPacket.findStatementContextPart(0));
                    if (batchUpdateExceptionChain == null) {
                        if (executeSqlExceptionChain != null && !(executeSqlExceptionChain instanceof SQLWarning)) {
                            int errIdx = -1;
                            if (updateCounts != null) {
                                n = updateCounts.length;
                                for (i2 = 0; i2 < n; ++i2) {
                                    if (updateCounts[i2] >= 0) continue;
                                    errIdx = i2;
                                    break;
                                }
                            }
                            batchUpdateExceptionChain = executeSqlExceptionChain;
                            int n2 = batchUpdateExceptionIdx = errIdx != -1 ? firstRecordNo + errIdx + 1 : -1;
                        }
                        if (isPrepareAndExecuteRequest && parseInfo == null) {
                            this._makeBatchCountArray(result, updateCounts, firstRecordNo, inputCursor - firstRecordNo, -3);
                            throw new BatchUpdateExceptionSapDB(result, batchUpdateExceptionChain, (Integer)batchUpdateExceptionIdx);
                        }
                    }
                    if (parseInfo == null) {
                        throw new AssertionError((Object)"Unexpected null ParseInfo");
                    }
                    if (parseInfo.hasInputLOB() && (lastWriteLOBReplyPacket = this._handleStreamsForPutval(replyPacket, session, true)) != replyPacket) {
                        temp = lastWriteLOBReplyPacket.findBatchUpdateCounts(0);
                        if (temp.length > 0) {
                            executeCount = lastWriteLOBReplyPacket.findRowsAffected(0);
                            updateCounts = temp;
                        }
                        lastWriteLobSqlExceptionChain = lastWriteLOBReplyPacket.findSQLExceptionChain(this._connection, 0);
                        if (batchUpdateExceptionChain == null && lastWriteLobSqlExceptionChain != null && !(lastWriteLobSqlExceptionChain instanceof SQLWarning)) {
                            int errIdx = -1;
                            if (updateCounts != null) {
                                n = updateCounts.length;
                                for (i2 = 0; i2 < n; ++i2) {
                                    if (updateCounts[i2] >= 0) continue;
                                    errIdx = i2;
                                    break;
                                }
                            }
                            batchUpdateExceptionChain = lastWriteLobSqlExceptionChain;
                            batchUpdateExceptionIdx = errIdx != -1 ? firstRecordNo + errIdx + 1 : -1;
                        }
                    }
                    this._makeBatchCountArray(result, updateCounts, firstRecordNo, inputCursor - firstRecordNo, executeSqlExceptionChain != null || lastWriteLobSqlExceptionChain != null ? -3 : -2);
                    this._rowsAffected = executeCount;
                }
                if (truncated && this._connection.isAutoCommit()) {
                    this._connection._commitInternal();
                }
                if (batchUpdateExceptionChain != null) {
                    throw new BatchUpdateExceptionSapDB(result, batchUpdateExceptionChain, (Integer)batchUpdateExceptionIdx);
                }
                break block52;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this._wasCancelled.set(false);
            }
        }
        return result;
    }

    private void _makeBatchCountArray(int[] resultArr, int[] updateCounts, int chunkOffset, int chunkLen, int defaultValue) {
        if (updateCounts == null) {
            for (int i = 0; i < chunkLen; ++i) {
                resultArr[chunkOffset + i] = defaultValue;
            }
        } else {
            for (int i = 0; i < chunkLen; ++i) {
                resultArr[chunkOffset + i] = i < updateCounts.length ? updateCounts[i] : defaultValue;
            }
        }
    }

    private boolean _isClientRouting() {
        ParseInfo parseInfo = this._parseInfo.get();
        return parseInfo != null ? parseInfo._isClientRouting(this._isBatch()) : false;
    }

    private boolean _isClientRoutingByHashWithoutSplit() {
        ParseInfo parseInfo = this._parseInfo.get();
        return parseInfo != null ? parseInfo._isClientRoutingByHashWithoutSplit() : false;
    }

    private boolean _isClientRoutingByRangeWithoutSplit() {
        ParseInfo parseInfo = this._parseInfo.get();
        return parseInfo != null ? parseInfo._isClientRoutingByRangeWithoutSplit() : false;
    }

    private SiteTypeVolumeID _getPrimarySiblingSiteVolumeID(int volumeID) {
        Session anchor = this._connection.getSessionPool().getAnchorSession();
        if (!this._connection.getDistributionMode().isStatementRouting() || anchor == null) {
            return new SiteTypeVolumeID(SiteType.PRIMARY, this._connection.getSessionPool().getPrimarySession().getSiteVolumeID().getVolumeID());
        }
        return new SiteTypeVolumeID(SiteType.PRIMARY, volumeID);
    }

    private SiteTypeVolumeID _computeVolumeID() {
        ParseInfo parseInfo = this._parseInfo.get();
        if (parseInfo != null) {
            return parseInfo.computeSiteTypeVolumeID();
        }
        return new SiteTypeVolumeID(SiteType.NONE, -1);
    }

    public synchronized SiteVolumeID getSiteVolumeID() {
        return this._session.getSiteVolumeID();
    }

    public synchronized Session getSession() {
        return this._session;
    }

    public ParseInfo getParseInfo() {
        return this._parseInfo.get();
    }

    public List<SiteTypeVolumeID> getTableLocations() {
        return this._parseInfo.get().getTableLocations();
    }

    public HashPartitionInfo getHashPartitionInfo() {
        return this._parseInfo.get().getHashPartitionInfo();
    }

    public RangePartitionInfo getRangePartitionInfo() {
        return this._parseInfo.get().getRangePartitionInfo();
    }

    public synchronized Map<SiteTypeVolumeID, List<Object[]>> getBatchVolumeMap() {
        return this._batchVolumeMap != null ? Collections.unmodifiableMap(this._batchVolumeMap) : Collections.emptyMap();
    }

    public int getComputedVolumeID() {
        return this._computedVolumeID.get();
    }

    public synchronized boolean isLightPrepare() {
        return !this._fullCompileOnPrepare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _getAppLobCount() {
        if (this._lockAppLobs == null) {
            return 0;
        }
        Object object = this._lockAppLobs;
        synchronized (object) {
            return this._appLobs != null ? this._appLobs.size() : 0;
        }
    }

    private static class PutvalComparator
    implements Comparator<AbstractPutval> {
        private PutvalComparator() {
        }

        @Override
        public int compare(AbstractPutval p1, AbstractPutval p2) {
            int inputFieldPos1 = p1.getInputFieldPos();
            int inputFieldPos2 = p2.getInputFieldPos();
            return inputFieldPos1 - inputFieldPos2;
        }
    }
}

