/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding.api;

import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.exception.ServiceBindingAccessException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleServiceBindingCache
implements ServiceBindingAccessor {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(SimpleServiceBindingCache.class);
    @Nonnull
    private static final Duration DEFAULT_CACHE_DURATION = Duration.ofMinutes(5L);
    @Nonnull
    private static final Supplier<LocalDateTime> DEFAULT_LOCAL_DATE_TIME_SUPPLIER = LocalDateTime::now;
    @Nonnull
    private final ReadWriteLock accessLock = new ReentrantReadWriteLock();
    @Nonnull
    private final ServiceBindingAccessor delegateAccessor;
    @Nonnull
    private final Duration cacheDuration;
    @Nonnull
    private final Supplier<LocalDateTime> localDateTimeSupplier;
    @Nullable
    private List<ServiceBinding> cachedServiceBindings = null;
    @Nullable
    private LocalDateTime lastCacheRenewal = null;

    public SimpleServiceBindingCache(@Nonnull ServiceBindingAccessor delegateAccessor) {
        this(delegateAccessor, DEFAULT_CACHE_DURATION, DEFAULT_LOCAL_DATE_TIME_SUPPLIER);
    }

    SimpleServiceBindingCache(@Nonnull ServiceBindingAccessor delegateAccessor, @Nonnull Duration cacheDuration, @Nonnull Supplier<LocalDateTime> localDateTimeSupplier) {
        this.delegateAccessor = delegateAccessor;
        this.cacheDuration = cacheDuration;
        this.localDateTimeSupplier = localDateTimeSupplier;
    }

    public SimpleServiceBindingCache(@Nonnull ServiceBindingAccessor delegateAccessor, @Nonnull Duration cacheDuration) {
        this(delegateAccessor, cacheDuration, DEFAULT_LOCAL_DATE_TIME_SUPPLIER);
    }

    @Override
    @Nonnull
    public List<ServiceBinding> getServiceBindings() throws ServiceBindingAccessException {
        LocalDateTime now = this.localDateTimeSupplier.get();
        if (now == null) {
            throw new IllegalStateException(String.format("Unable to determine the current %s.", LocalDateTime.class.getSimpleName()));
        }
        return Optional.ofNullable(this.tryReadCache(now)).orElse(this.readOrUpdateCache(now));
    }

    @Nullable
    private List<ServiceBinding> tryReadCache(@Nonnull Temporal now) {
        this.accessLock.readLock().lock();
        try {
            if (this.isExpired(now)) {
                List<ServiceBinding> list = null;
                return list;
            }
            logger.debug("Serving service bindings from cache.");
            List<ServiceBinding> list = this.cachedServiceBindings;
            return list;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    @Nonnull
    private List<ServiceBinding> readOrUpdateCache(@Nonnull LocalDateTime now) {
        this.accessLock.writeLock().lock();
        try {
            if (!this.isExpired(now)) {
                List<ServiceBinding> list = Objects.requireNonNull(this.cachedServiceBindings, "Cached Service Bindings must not be null.");
                return list;
            }
            logger.debug("Refreshing service bindings cache.");
            this.cachedServiceBindings = this.delegateAccessor.getServiceBindings();
            this.lastCacheRenewal = now;
            List<ServiceBinding> list = this.cachedServiceBindings;
            return list;
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
    }

    private boolean isExpired(@Nonnull Temporal now) {
        if (this.lastCacheRenewal == null || this.cachedServiceBindings == null) {
            return true;
        }
        Duration durationSinceLastCacheRenewal = Duration.between(this.lastCacheRenewal, now);
        return this.cacheDuration.minus(durationSinceLastCacheRenewal).isNegative();
    }

    public void invalidate() {
        logger.debug("Invalidating service binding cache.");
        this.accessLock.writeLock().lock();
        try {
            this.cachedServiceBindings = null;
            this.lastCacheRenewal = null;
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
    }
}

