/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding.api;

import com.sap.cloud.environment.servicebinding.api.TypedMapView;
import com.sap.cloud.environment.servicebinding.api.exception.ValueCastException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TypedListView {
    @Nonnull
    private final List<Object> list;

    private TypedListView(@Nonnull List<Object> list) {
        this.list = list;
    }

    @Nonnull
    static TypedListView fromIterable(@Nonnull Iterable<Object> list) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object item : list) {
            if (item instanceof Map) {
                items.add(TypedMapView.fromRawMap(item));
                continue;
            }
            if (item instanceof List) {
                items.add(TypedListView.fromRawIterable(item));
                continue;
            }
            items.add(item);
        }
        return new TypedListView(items);
    }

    @Nonnull
    static TypedListView fromRawIterable(@Nonnull Object rawIterable) {
        try {
            return TypedListView.fromIterable((Iterable)rawIterable);
        }
        catch (ClassCastException e) {
            throw new ValueCastException(Iterable.class, rawIterable);
        }
    }

    public boolean getBoolean(int index) throws IndexOutOfBoundsException, ValueCastException {
        Object value = this.get(index);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new ValueCastException(Boolean.class, value);
    }

    @Nullable
    public Object get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getSize()) {
            throw new IndexOutOfBoundsException();
        }
        return this.list.get(index);
    }

    public int getSize() {
        return this.list.size();
    }

    public int getInteger(int index) throws IndexOutOfBoundsException, ValueCastException {
        return this.getNumber(index).intValue();
    }

    @Nonnull
    public Number getNumber(int index) throws IndexOutOfBoundsException, ValueCastException {
        Object value = this.get(index);
        if (value instanceof Number) {
            return (Number)value;
        }
        throw new ValueCastException(Number.class, value);
    }

    public double getDouble(int index) throws IndexOutOfBoundsException, ValueCastException {
        return this.getNumber(index).doubleValue();
    }

    @Nonnull
    public String getString(int index) throws IndexOutOfBoundsException, ValueCastException {
        Object value = this.get(index);
        if (value instanceof String) {
            return (String)value;
        }
        throw new ValueCastException(String.class, value);
    }

    @Nonnull
    public TypedMapView getMapView(int index) throws IndexOutOfBoundsException, ValueCastException {
        Object value = this.get(index);
        if (value instanceof TypedMapView) {
            return (TypedMapView)value;
        }
        throw new ValueCastException(TypedMapView.class, value);
    }

    @Nonnull
    public TypedListView getListView(int index) throws IndexOutOfBoundsException, ValueCastException {
        Object value = this.get(index);
        if (value instanceof TypedListView) {
            return (TypedListView)value;
        }
        throw new ValueCastException(TypedListView.class, value);
    }

    @Nonnull
    public <T> List<T> getItems(@Nonnull Class<? extends T> itemType) {
        return this.list.stream().filter(item -> item != null && itemType.isAssignableFrom(item.getClass())).map(item -> item).collect(Collectors.toList());
    }
}

