/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding.api;

import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.TypedListView;
import com.sap.cloud.environment.servicebinding.api.exception.KeyNotFoundException;
import com.sap.cloud.environment.servicebinding.api.exception.ValueCastException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TypedMapView {
    @Nonnull
    private final Map<String, Object> map;

    private TypedMapView(@Nonnull Map<String, Object> map) {
        this.map = map;
    }

    @Nonnull
    public static TypedMapView of(@Nonnull ServiceBinding serviceBinding) {
        TreeMap<String, Object> properties = new TreeMap<String, Object>(String::compareToIgnoreCase);
        for (String key : serviceBinding.getKeys()) {
            if (key == null || key.isEmpty()) continue;
            Object value = serviceBinding.get(key).orElse(null);
            TypedMapView.insertElement(properties, key, value);
        }
        return new TypedMapView(properties);
    }

    @Nonnull
    public static TypedMapView ofCredentials(@Nonnull ServiceBinding serviceBinding) {
        return TypedMapView.fromMap(serviceBinding.getCredentials());
    }

    private static void insertElement(@Nonnull Map<String, Object> properties, @Nonnull String key, @Nullable Object value) {
        if (value instanceof Map) {
            properties.put(key, TypedMapView.fromRawMap(value));
            return;
        }
        if (value instanceof List) {
            properties.put(key, TypedListView.fromRawIterable(value));
            return;
        }
        properties.put(key, value);
    }

    @Nonnull
    static TypedMapView fromRawMap(@Nonnull Object rawMap) {
        try {
            return TypedMapView.fromMap((Map)rawMap);
        }
        catch (ClassCastException e) {
            throw new ValueCastException(Map.class, rawMap);
        }
    }

    @Nonnull
    static TypedMapView fromMap(@Nonnull Map<String, Object> map) {
        TreeMap<String, Object> properties = new TreeMap<String, Object>(String::compareToIgnoreCase);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null) continue;
            TypedMapView.insertElement(properties, key, value);
        }
        return new TypedMapView(properties);
    }

    @Nonnull
    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public boolean getBoolean(@Nonnull String key) throws KeyNotFoundException, ValueCastException {
        Object value = this.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new ValueCastException(Boolean.class, value);
    }

    @Nullable
    public Object get(@Nonnull String key) throws KeyNotFoundException {
        if (!this.containsKey(key)) {
            throw new KeyNotFoundException(this, key);
        }
        return this.map.get(key);
    }

    public boolean containsKey(@Nonnull String key) {
        return this.map.containsKey(key);
    }

    public int getInteger(@Nonnull String key) throws KeyNotFoundException, ValueCastException {
        return this.getNumber(key).intValue();
    }

    @Nonnull
    public Number getNumber(@Nonnull String key) throws KeyNotFoundException, ValueCastException {
        Object value = this.get(key);
        if (value instanceof Number) {
            return (Number)value;
        }
        throw new ValueCastException(Number.class, value);
    }

    public double getDouble(@Nonnull String key) throws KeyNotFoundException, ValueCastException {
        return this.getNumber(key).doubleValue();
    }

    @Nonnull
    public String getString(@Nonnull String key) throws KeyNotFoundException, ValueCastException {
        Object value = this.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        throw new ValueCastException(String.class, value);
    }

    @Nonnull
    public TypedMapView getMapView(@Nonnull String key) throws KeyNotFoundException, ValueCastException {
        Object value = this.get(key);
        if (value instanceof TypedMapView) {
            return (TypedMapView)value;
        }
        throw new ValueCastException(TypedMapView.class, value);
    }

    @Nonnull
    public TypedListView getListView(@Nonnull String key) throws KeyNotFoundException, ValueCastException {
        Object value = this.get(key);
        if (value instanceof TypedListView) {
            return (TypedListView)value;
        }
        throw new ValueCastException(TypedListView.class, value);
    }

    @Nonnull
    public <T> Map<String, T> getEntries(@Nonnull Class<? extends T> entryType) {
        return this.map.entrySet().stream().filter(e -> e.getValue() != null && entryType.isAssignableFrom(e.getValue().getClass())).collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue()));
    }
}

