/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding;

import com.sap.cloud.environment.servicebinding.api.DefaultServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.exception.ServiceBindingAccessException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapVcapServicesServiceBindingAccessor
implements ServiceBindingAccessor {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(SapVcapServicesServiceBindingAccessor.class);
    @Nonnull
    public static final Function<String, String> DEFAULT_ENVIRONMENT_VARIABLE_READER = System::getenv;
    @Nonnull
    private static final String VCAP_SERVICES = "VCAP_SERVICES";
    @Nonnull
    private final Function<String, String> environmentVariableReader;

    public SapVcapServicesServiceBindingAccessor() {
        this(DEFAULT_ENVIRONMENT_VARIABLE_READER);
    }

    public SapVcapServicesServiceBindingAccessor(@Nonnull Function<String, String> environmentVariableReader) {
        this.environmentVariableReader = environmentVariableReader;
    }

    @Nonnull
    public List<ServiceBinding> getServiceBindings() throws ServiceBindingAccessException {
        JSONObject parsedVcapServices;
        logger.debug("Trying to determine service bindings using the '{}' environment variable.", (Object)VCAP_SERVICES);
        String vcapServices = this.environmentVariableReader.apply(VCAP_SERVICES);
        if (vcapServices == null) {
            logger.debug("Environment variable '{}' is not defined.", (Object)VCAP_SERVICES);
            return Collections.emptyList();
        }
        try {
            parsedVcapServices = new JSONObject(vcapServices);
        }
        catch (JSONException e) {
            logger.debug("Environment variable '{}' ('{}') is not a valid JSON.", (Object)VCAP_SERVICES, (Object)vcapServices);
            return Collections.emptyList();
        }
        return parsedVcapServices.keySet().stream().flatMap(serviceName -> this.extractServiceBindings(parsedVcapServices, (String)serviceName).stream()).collect(Collectors.toList());
    }

    @Nonnull
    private List<ServiceBinding> extractServiceBindings(@Nonnull JSONObject vcapServices, @Nonnull String serviceName) {
        JSONArray jsonServiceBindings;
        try {
            jsonServiceBindings = vcapServices.getJSONArray(serviceName);
        }
        catch (JSONException e) {
            logger.debug("Skipping '{}': Unexpected format.", (Object)VCAP_SERVICES);
            return Collections.emptyList();
        }
        ArrayList<ServiceBinding> serviceBindings = new ArrayList<ServiceBinding>(jsonServiceBindings.length());
        for (int i = 0; i < jsonServiceBindings.length(); ++i) {
            JSONObject jsonServiceBinding;
            try {
                jsonServiceBinding = jsonServiceBindings.getJSONObject(i);
            }
            catch (JSONException e) {
                continue;
            }
            serviceBindings.add(this.toServiceBinding(jsonServiceBinding, serviceName));
        }
        logger.debug("Successfully read {} service binding(s) from '{}'.", (Object)serviceBindings.size(), (Object)VCAP_SERVICES);
        return serviceBindings;
    }

    @Nonnull
    private ServiceBinding toServiceBinding(@Nonnull JSONObject jsonServiceBinding, @Nonnull String serviceName) {
        return DefaultServiceBinding.builder().copy(jsonServiceBinding.toMap()).withNameKey("name").withServiceName(serviceName).withServicePlanKey("plan").withTagsKey("tags").withCredentialsKey("credentials").build();
    }
}

