/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.google.common.base.Strings;
import com.sap.cds.CdsCommunicationException;
import com.sap.cds.mtx.impl.Authenticator;
import com.sap.cds.mtx.impl.ModelAndInformation;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractSidecarAccess {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSidecarAccess.class);
    private static final String MTX_SIDECAR_DESTINATION = "com.sap.cds.mtxSidecar";
    private static final String APPLICATION_JSON = "application/json";
    private final String sidecarBaseUrl;
    private final Authenticator authenticator;
    private final AtomicReference<HttpDestination> atomicSidecarHttpDestination = new AtomicReference();

    public AbstractSidecarAccess(String sidecarBaseUrl, Authenticator authenticator) {
        this.sidecarBaseUrl = sidecarBaseUrl;
        this.authenticator = authenticator;
    }

    private HttpDestination getSidecarDestination() throws CdsCommunicationException {
        HttpDestination sidecarHttpDestination = this.atomicSidecarHttpDestination.get();
        if (sidecarHttpDestination == null) {
            try {
                sidecarHttpDestination = DestinationAccessor.getDestination((String)MTX_SIDECAR_DESTINATION).asHttp();
            }
            catch (DestinationAccessException e) {
                try {
                    sidecarHttpDestination = DefaultHttpDestination.builder((String)this.sidecarBaseUrl).name(MTX_SIDECAR_DESTINATION).build();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CdsCommunicationException((Throwable)illegalArgumentException);
                }
            }
            if (!this.atomicSidecarHttpDestination.compareAndSet(null, sidecarHttpDestination)) {
                return this.atomicSidecarHttpDestination.get();
            }
        }
        return sidecarHttpDestination;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModelAndInformation executeRequest(HttpUriRequest request, String eTag) {
        logger.debug("Call sidecar on url {} ", (Object)request.getURI());
        HttpClient client = HttpClientAccessor.getHttpClient((HttpDestinationProperties)this.getSidecarDestination());
        try (CloseableHttpResponse response = (CloseableHttpResponse)client.execute(request);){
            int httpStatusCode = response.getStatusLine().getStatusCode();
            switch (httpStatusCode) {
                case 304: {
                    logger.debug("Received not modified status");
                    ModelAndInformation modelAndInformation = new ModelAndInformation(null, eTag, true);
                    return modelAndInformation;
                }
                case 200: {
                    if (response.containsHeader("ETag")) {
                        eTag = response.getLastHeader("ETag").getValue();
                    }
                    String model = EntityUtils.toString((HttpEntity)response.getEntity());
                    logger.debug("Received a [modified] model from sidecar");
                    ModelAndInformation modelAndInformation = new ModelAndInformation(model, eTag, false);
                    return modelAndInformation;
                }
            }
            String contentAsString = EntityUtils.toString((HttpEntity)response.getEntity());
            String message = MessageFormat.format("Sidecar returned with status {0} and message {1}", httpStatusCode, contentAsString);
            throw new CdsCommunicationException(message, httpStatusCode);
        }
        catch (IOException e) {
            throw new CdsCommunicationException("Communication error with sidecar.", (Throwable)e);
        }
    }

    protected ModelAndInformation callSidecar(HttpUriRequest request, String eTag) {
        try {
            this.authenticator.getAuthorization().ifPresent(auth -> request.setHeader("Authorization", auth));
        }
        catch (IOException e) {
            throw new CdsCommunicationException((Throwable)e);
        }
        request.setHeader("Accept", APPLICATION_JSON);
        if (!Strings.isNullOrEmpty((String)eTag)) {
            request.setHeader("If-None-Match", eTag);
        }
        return this.executeRequest(request, eTag);
    }
}

