/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.sap.cds.CdsCommunicationException;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.AbstractSidecarAccess;
import com.sap.cds.mtx.impl.Authenticator;
import com.sap.cds.mtx.impl.ModelAndInformation;
import com.sap.cds.mtx.impl.SidecarAccess;
import org.apache.http.client.methods.RequestBuilder;

public class SidecarAccessV1
extends AbstractSidecarAccess
implements SidecarAccess {
    private static final String CSN_PATH = "/mtx/v1/metadata/csn/";
    private static final String EDMX_PATH = "/mtx/v1/metadata/edmx/";

    public SidecarAccessV1(String sidecarBaseUrl, Authenticator authenticator) {
        super(sidecarBaseUrl, authenticator);
    }

    @Override
    public ModelAndInformation getCsn(ModelId id, String eTag) throws CdsCommunicationException {
        String url = this.getCsnUrl(id);
        RequestBuilder builder = RequestBuilder.get((String)url);
        return this.callSidecar(builder.build(), eTag);
    }

    @Override
    public ModelAndInformation getEdmx(ModelId id, String eTag) throws CdsCommunicationException {
        String url = this.getEdmxUrl(id);
        RequestBuilder builder = RequestBuilder.get((String)url);
        return this.callSidecar(builder.build(), eTag);
    }

    private String getCsnUrl(ModelId id) {
        return CSN_PATH + id.getTenantId();
    }

    private String getEdmxUrl(ModelId id) {
        UrlBuilder url = new UrlBuilder(EDMX_PATH + id.getTenantId());
        id.getServiceName().ifPresent(s -> url.param("name", (String)s));
        id.getLanguage().ifPresent(l -> url.param("language", (String)l));
        id.getODataVersion().ifPresent(l -> url.param("odataVersion", (String)l));
        return url.build();
    }

    private static class UrlBuilder {
        private StringBuilder url;
        private char c = (char)63;

        public UrlBuilder(String path) {
            this.url = new StringBuilder(path);
        }

        public void param(String name, String value) {
            this.url.append(this.c);
            this.url.append(name);
            this.url.append("=");
            this.url.append(value);
            this.c = (char)38;
        }

        public String build() {
            return this.url.toString();
        }
    }
}

