/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.google.common.base.Objects;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.sap.cds.CdsException;
import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.CacheParams;
import com.sap.cds.mtx.impl.ModelAndInformation;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsModelReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataAccessorImpl<M>
implements MetaDataAccessor<M> {
    private static final long NANOS_TO_SECONDS = 1000000000L;
    private static final Logger logger = LoggerFactory.getLogger(MetaDataAccessorImpl.class);
    private final Cache<CdsModel> modelIdToCdsModel;
    private final Cache<M> modelIdToEdmxModel;

    public MetaDataAccessorImpl(SidecarAccess sidecarAccess, CacheParams cacheParams, EdmxModelCreator<M> strToEdmx, Ticker cacheTicker) {
        if (cacheTicker == null) {
            cacheTicker = Ticker.systemTicker();
        }
        Object executorService = cacheParams.isSynchronousRefresh() ? MoreExecutors.newDirectExecutorService() : Executors.newSingleThreadExecutor();
        this.modelIdToCdsModel = new CdsCache(sidecarAccess, cacheParams, cacheTicker, (ExecutorService)executorService);
        this.modelIdToEdmxModel = new EdmxCache<M>(sidecarAccess, strToEdmx, cacheParams, cacheTicker, (ExecutorService)executorService);
    }

    @Override
    public CdsModel getCdsModel(ModelId key, int maxAgeSeconds) {
        return this.modelIdToCdsModel.getOrLoadIfStale(key, maxAgeSeconds);
    }

    @Override
    public M getEdmx(ModelId key, int maxAgeSeconds) throws CdsException {
        return this.modelIdToEdmxModel.getOrLoadIfStale(key, maxAgeSeconds);
    }

    @Override
    public void evict(String tenantId) {
        this.modelIdToCdsModel.evict(tenantId);
        this.modelIdToEdmxModel.evict(tenantId);
    }

    @Override
    public void refresh(String tenantId, int maxAgeSeconds) {
        this.modelIdToCdsModel.refresh(tenantId, maxAgeSeconds);
        this.modelIdToEdmxModel.refresh(tenantId, maxAgeSeconds);
    }

    private static class CdsCache
    extends Cache<CdsModel> {
        private final SidecarAccess sidecarAccess;

        public CdsCache(SidecarAccess sidecarAccess, CacheParams params, Ticker ticker, ExecutorService executorService) {
            super(params, ticker, executorService);
            this.sidecarAccess = sidecarAccess;
        }

        @Override
        ModelAndInformation access(ModelId key, String eTag) {
            return this.sidecarAccess.getCsn(key, eTag);
        }

        @Override
        CdsModel parse(ModelId key, String csn) {
            return CdsModelReader.read((String)csn, (boolean)true);
        }
    }

    private static class EdmxCache<M>
    extends Cache<M> {
        private final SidecarAccess sidecarAccess;
        private final EdmxModelCreator<M> strToEdmx;

        public EdmxCache(SidecarAccess sidecarAccess, EdmxModelCreator<M> strToEdmx, CacheParams params, Ticker ticker, ExecutorService executorService) {
            super(params, ticker, executorService);
            this.sidecarAccess = sidecarAccess;
            this.strToEdmx = strToEdmx;
        }

        @Override
        ModelAndInformation access(ModelId key, String eTag) {
            return this.sidecarAccess.getEdmx(key, eTag);
        }

        @Override
        M parse(ModelId key, String model) {
            return this.strToEdmx.parse(model, key.getServiceName().orElse(null));
        }
    }

    private static class Entry<V> {
        private final V entry;
        private final String eTag;
        private final AtomicLong refreshed;

        public Entry(V entry, String eTag, long refreshed) {
            this.entry = entry;
            this.eTag = eTag != null ? eTag.trim() : null;
            this.refreshed = new AtomicLong(refreshed);
        }

        public V getEntry() {
            return this.entry;
        }

        public String getETag() {
            return this.eTag;
        }

        public void refresh(long refreshed) {
            this.refreshed.set(refreshed);
        }

        public long refreshed() {
            return this.refreshed.get();
        }
    }

    private static abstract class Cache<V> {
        private final Ticker ticker;
        private final LoadingCache<ModelId, Entry<V>> guavaCache;
        private final String cacheName = this.getClass().getSimpleName();

        protected Cache(CacheParams params, Ticker ticker, final ExecutorService executorService) {
            CacheBuilder builder = CacheBuilder.newBuilder().maximumSize(params.getMaximumSize()).expireAfterAccess(params.getExpirationDuration(), params.getExpirationDurationUnit()).refreshAfterWrite(params.getRefreshDuration(), params.getRefreshDurationUnit());
            if (ticker != null) {
                builder.ticker(ticker);
            }
            this.ticker = ticker;
            this.guavaCache = builder.build(new CacheLoader<ModelId, Entry<V>>(){

                public Entry<V> load(ModelId key) {
                    return this.load(key, null);
                }

                public ListenableFuture<Entry<V>> reload(ModelId key, Entry<V> oldValue) {
                    logger.debug("Reloading '{}' in cache '{}'", (Object)key, (Object)cacheName);
                    ListenableFutureTask readModelTask = ListenableFutureTask.create(() -> {
                        try {
                            return this.load(key, oldValue);
                        }
                        catch (Exception e) {
                            logger.error("Reloading '{}' failed", (Object)key, (Object)e);
                            return oldValue;
                        }
                    });
                    executorService.execute((Runnable)readModelTask);
                    return readModelTask;
                }
            });
        }

        public void evict(String tenantId) {
            logger.debug("Evicting tenant '{}' from cache '{}'", (Object)tenantId, (Object)this.cacheName);
            this.forTenant(tenantId, arg_0 -> this.guavaCache.invalidate(arg_0));
        }

        public void refresh(String tenantId, int maxAgeSeconds) {
            logger.debug("Refreshing tenant '{}' in cache '{}'", (Object)tenantId, (Object)this.cacheName);
            this.forTenant(tenantId, k -> this.getOrLoadIfStale((ModelId)k, maxAgeSeconds));
        }

        private void forTenant(String tenantId, Consumer<ModelId> action) {
            this.guavaCache.asMap().keySet().stream().filter(k -> Objects.equal((Object)tenantId, (Object)k.getTenantId())).forEach(action);
        }

        public Entry<V> getUnchecked(ModelId key) {
            return (Entry)this.guavaCache.getUnchecked((Object)key);
        }

        private void put(ModelId key, Entry<V> entry) {
            this.guavaCache.put((Object)key, entry);
        }

        public V getOrLoadIfStale(ModelId key, int maxAgeSeconds) {
            Entry<V> entry;
            long maxAgeNanos = (long)maxAgeSeconds * 1000000000L;
            try {
                entry = this.getUnchecked(key);
            }
            catch (UncheckedExecutionException e) {
                throw new CdsException((Throwable)e);
            }
            if (this.ticker.read() - entry.refreshed() > maxAgeNanos) {
                Entry<V> loaded = this.load(key, entry);
                if (loaded != entry) {
                    this.put(key, loaded);
                    entry = loaded;
                }
            } else {
                logger.debug("'{}' in cache '{}' is not older than '{}'", new Object[]{key, this.cacheName, maxAgeSeconds});
            }
            return entry.getEntry();
        }

        private Entry<V> load(ModelId key, Entry<V> oldEntry) {
            logger.debug("Loading '{}' in cache '{}'", (Object)key, (Object)this.cacheName);
            String eTag = oldEntry != null ? oldEntry.getETag() : null;
            long beforeAccess = this.ticker.read();
            ModelAndInformation model = this.access(key, eTag);
            if (oldEntry != null && model.isNotModified()) {
                oldEntry.refresh(beforeAccess);
                logger.debug("Refreshed unchanged '{}' in cache '{}'", (Object)key, (Object)this.cacheName);
                return oldEntry;
            }
            return new Entry<V>(this.parse(key, model.getModel()), model.getETag(), beforeAccess);
        }

        abstract ModelAndInformation access(ModelId var1, String var2);

        abstract V parse(ModelId var1, String var2);
    }

    @FunctionalInterface
    public static interface EdmxModelCreator<M> {
        public M parse(String var1, String var2);
    }
}

