/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.AbstractSidecarAccess;
import com.sap.cds.mtx.impl.Authenticator;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import com.sap.cloud.mt.tools.api.ServiceCall;
import com.sap.cloud.mt.tools.exception.InternalException;
import java.util.HashMap;
import java.util.Map;

public class SidecarAccessV2
extends AbstractSidecarAccess
implements SidecarAccess {
    private static final String BASE_PATH = "/mtx/v2/model/";
    private static final String CSN_PATH = "/mtx/v2/model/csn/";
    private static final String EDMX_PATH = "/mtx/v2/model/edmx/";

    public SidecarAccessV2(String sidecarBaseUrl, Authenticator authenticator, ResilienceConfig resilienceConfig) {
        super(sidecarBaseUrl, authenticator, resilienceConfig);
    }

    @Deprecated
    public SidecarAccessV2(String sidecarBaseUrl, Authenticator authenticator) {
        this(sidecarBaseUrl, authenticator, ResilienceConfig.NONE);
    }

    @Override
    protected String getDestinationName() {
        return "com.sap.cds.mtxSidecar";
    }

    @Override
    protected String getCsnPath() {
        return CSN_PATH;
    }

    @Override
    protected ServiceCall createCsnCall(ModelId id, String eTag) throws InternalException {
        return this.csnEndpoint.createServiceCall().http().post().payload(this.getCsnBody(id)).noPathParameter().noQuery().authenticationTokenSupplier(this.getAuthenticationTokenSupplier()).insertHeaderFields(this.getHeaderFields(eTag)).end();
    }

    @Override
    protected String getEdmxPath() {
        return EDMX_PATH;
    }

    @Override
    protected ServiceCall createEdmxCall(ModelId id, String eTag) throws InternalException {
        return this.edmxEndpoint.createServiceCall().http().post().payload(this.getEdmxBody(id)).noPathParameter().noQuery().authenticationTokenSupplier(this.getAuthenticationTokenSupplier()).insertHeaderFields(this.getHeaderFields(eTag)).end();
    }

    protected Map<String, Object> getBody(ModelId id) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenant", id.getTenantId());
        body.put("toggles", id.getFeatures());
        return body;
    }

    protected Map<String, Object> getCsnBody(ModelId id) {
        return this.getBody(id);
    }

    protected Map<String, Object> getEdmxBody(ModelId id) {
        Map<String, Object> body = this.getBody(id);
        id.getServiceName().ifPresent(s -> body.put("service", s));
        id.getLanguage().ifPresent(l -> body.put("locale", l));
        id.getODataVersion().ifPresent(v -> body.put("odataVersion", v));
        return body;
    }
}

