/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.Authenticator;
import com.sap.cds.mtx.impl.ModelAndInformation;
import com.sap.cds.mtx.impl.SidecarAccessV2;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import com.sap.cloud.mt.tools.api.ServiceResponse;
import com.sap.cloud.mt.tools.exception.InternalException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;

public class SidecarAccessV3
extends SidecarAccessV2 {
    private static final HashFunction hasher = Hashing.goodFastHash((int)160);
    protected static final String BASE_PATH = "/-/cds/model-provider/";
    private static final String CSN_PATH = "/-/cds/model-provider/getOdataCsn";
    private static final String EDMX_PATH = "/-/cds/model-provider/getEdmx";
    private static final String MODEL_PROVIDER_DESTINATION = "com.sap.cds.modelProvider";

    public SidecarAccessV3(String sidecarBaseUrl, Authenticator authenticator, ResilienceConfig resilienceConfig) {
        super(sidecarBaseUrl, authenticator, resilienceConfig);
    }

    @Deprecated
    public SidecarAccessV3(String sidecarBaseUrl, Authenticator authenticator) {
        super(sidecarBaseUrl, authenticator, ResilienceConfig.NONE);
    }

    @Override
    protected String getDestinationName() {
        return MODEL_PROVIDER_DESTINATION;
    }

    @Override
    protected Map<String, String> getHeaderFields(String eTag) {
        return Collections.singletonMap("Accept", "application/json");
    }

    @Override
    protected String getCsnPath() {
        return CSN_PATH;
    }

    @Override
    protected ModelAndInformation csnModelInfo(ServiceResponse<String> response, String oldHash) throws InternalException {
        return this.modelInfo(this.getPayload(response), oldHash);
    }

    private String getPayload(ServiceResponse<String> response) throws InternalException {
        return response.getPayload().orElse("");
    }

    @Override
    protected String getEdmxPath() {
        return EDMX_PATH;
    }

    @Override
    protected ModelAndInformation edmxModelInfo(ServiceResponse<String> response, String oldHash) throws InternalException {
        return this.modelInfo(this.getPayload(response), oldHash);
    }

    private ModelAndInformation modelInfo(String value, String oldHash) {
        String newHash = hasher.hashString((CharSequence)value, StandardCharsets.UTF_8).toString();
        if (newHash.equals(oldHash)) {
            return new ModelAndInformation(null, oldHash, true);
        }
        return new ModelAndInformation(value, newHash, false);
    }

    @Override
    protected Map<String, Object> getEdmxBody(ModelId id) {
        Map<String, Object> body = this.getBody(id);
        id.getServiceName().ifPresent(s -> body.put("serviceName", s));
        id.getLanguage().ifPresent(l -> body.put("locale", l));
        id.getODataVersion().ifPresent(v -> body.put("odataFlavor", v));
        return body;
    }
}

