/*
 * ----------------------------------------------------------------
 * © 2019-2021 SAP SE or an SAP affiliate company. All rights reserved.
 * ----------------------------------------------------------------
 *
 */

package com.sap.cds.mtx.impl;

import java.util.Map;

import com.sap.cds.mtx.ModelId;
import com.sap.cloud.mt.tools.api.ResilienceConfig;

/**
 * Class that is responsible for communication with external model provider
 * service
 */

public class ModelProviderAccess extends SidecarAccessV3 {

	private static final String CSN_PATH = BASE_PATH + "getCsn";

	/**
	 * @param sidecarBaseUrl   URL of sidecar application without path specification
	 * @param authenticator    object that is responsible for authentication
	 * @param resilienceConfig Parameters like number of retries, wait between
	 *                         retries, ..
	 */
	public ModelProviderAccess(String sidecarBaseUrl, Authenticator authenticator, ResilienceConfig resilienceConfig) {
		super(sidecarBaseUrl, authenticator, resilienceConfig);
	}

	@Deprecated
	public ModelProviderAccess(String sidecarBaseUrl, Authenticator authenticator) {
		super(sidecarBaseUrl, authenticator, ResilienceConfig.NONE);
	}

	@Override
	protected String getCsnPath() {
		return CSN_PATH;
	}

	@Override
	protected Map<String, Object> getBody(ModelId id) {
		Map<String, Object> body = super.getBody(id);
		body.put("for", "java");
		return body;
	}

	@Override
	protected Map<String, Object> getEdmxBody(ModelId id) {
		Map<String, Object> body = getBody(id);
		id.getServiceName().ifPresent(s -> body.put("service", s));
		id.getLanguage().ifPresent(l -> body.put("locale", l));
		id.getODataVersion().ifPresent(v -> body.put("flavor", v));
		return body;
	}
}
