/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.AbstractSidecarAccess;
import com.sap.cds.mtx.impl.ModelAndInformation;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cloud.mt.tools.api.RequestEnhancer;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import com.sap.cloud.mt.tools.api.ServiceCall;
import com.sap.cloud.mt.tools.api.ServiceResponse;
import com.sap.cloud.mt.tools.exception.InternalException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ModelProviderAccess
extends AbstractSidecarAccess
implements SidecarAccess {
    public static final String MODEL_PROVIDER_DESTINATION = "com.sap.cds.modelProvider";
    protected static final String BASE_PATH = "/-/cds/model-provider/";
    private static final String CSN_PATH = "/-/cds/model-provider/getCsn";
    private static final String EDMX_PATH = "/-/cds/model-provider/getEdmx";

    public ModelProviderAccess(RequestEnhancer requestEnhancer, ResilienceConfig resilienceConfig) {
        super(requestEnhancer, resilienceConfig);
    }

    @Override
    protected String getCsnPath() {
        return CSN_PATH;
    }

    @Override
    protected String getDestinationName() {
        return MODEL_PROVIDER_DESTINATION;
    }

    @Override
    protected Map<String, String> getHeaderFields(String eTag) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        if (Objects.nonNull(eTag)) {
            headers.put("If-None-Match", eTag);
        }
        return headers;
    }

    @Override
    protected ModelAndInformation csnModelInfo(ServiceResponse<String> response, String oldHash) throws InternalException {
        return this.modelInfo(response, oldHash);
    }

    @Override
    protected String getEdmxPath() {
        return EDMX_PATH;
    }

    @Override
    protected ModelAndInformation edmxModelInfo(ServiceResponse<String> response, String oldHash) throws InternalException {
        return this.modelInfo(response, oldHash);
    }

    @Override
    protected ServiceCall createCsnCall(ModelId id, String eTag) throws InternalException {
        return this.csnEndpoint.createServiceCall().http().post().payload(this.getCsnBody(id)).noPathParameter().noQuery().enhancer(this.requestEnhancer).insertHeaderFields(this.getHeaderFields(eTag)).end();
    }

    @Override
    protected ServiceCall createEdmxCall(ModelId id, String eTag) throws InternalException {
        return this.edmxEndpoint.createServiceCall().http().post().payload(this.getEdmxBody(id)).noPathParameter().noQuery().enhancer(this.requestEnhancer).insertHeaderFields(this.getHeaderFields(eTag)).end();
    }

    private ModelAndInformation modelInfo(ServiceResponse<String> response, String oldEtag) throws InternalException {
        if (response.getHttpStatusCode() == 304) {
            return new ModelAndInformation(null, oldEtag, true);
        }
        String eTag = response.getETag().orElse(null);
        return new ModelAndInformation(this.getPayload(response), eTag, false);
    }

    private String getPayload(ServiceResponse<String> response) throws InternalException {
        return response.getPayload().orElse("");
    }

    protected Map<String, Object> getBody(ModelId id) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenant", id.getTenantId());
        body.put("toggles", id.getFeatures());
        body.put("for", "java");
        return body;
    }

    protected Map<String, Object> getEdmxBody(ModelId id) {
        Map<String, Object> body = this.getBody(id);
        id.getServiceName().ifPresent(s -> body.put("service", s));
        id.getLanguage().ifPresent(l -> body.put("locale", l));
        id.getODataVersion().ifPresent(v -> body.put("flavor", v));
        return body;
    }

    protected Map<String, Object> getCsnBody(ModelId id) {
        return this.getBody(id);
    }
}

