/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.google.common.base.Strings;
import com.sap.cds.CdsCommunicationException;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.ModelAndInformation;
import com.sap.cloud.mt.tools.api.RequestEnhancer;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import com.sap.cloud.mt.tools.api.ServiceCall;
import com.sap.cloud.mt.tools.api.ServiceEndpoint;
import com.sap.cloud.mt.tools.api.ServiceResponse;
import com.sap.cloud.mt.tools.exception.InternalException;
import com.sap.cloud.mt.tools.exception.ServiceException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;

public abstract class AbstractSidecarAccess {
    protected static final String APPLICATION_JSON = "application/json";
    protected final ServiceEndpoint csnEndpoint;
    protected final ServiceEndpoint edmxEndpoint;
    protected RequestEnhancer requestEnhancer;

    protected AbstractSidecarAccess(RequestEnhancer requestEnhancer, ResilienceConfig resilienceConfig) {
        Set<Integer> retryCodes = this.getRetryCodes();
        try {
            this.csnEndpoint = ServiceEndpoint.create().destinationName(this.getDestinationName()).path(this.getCsnPath()).returnCodeChecker(this.getCheckFunction()).retry().forReturnCodes(retryCodes).config(resilienceConfig).end();
            this.edmxEndpoint = ServiceEndpoint.create().destinationName(this.getDestinationName()).path(this.getEdmxPath()).returnCodeChecker(this.getCheckFunction()).retry().forReturnCodes(retryCodes).config(resilienceConfig).end();
        }
        catch (InternalException e) {
            throw new CdsCommunicationException((Throwable)e);
        }
        this.requestEnhancer = requestEnhancer;
    }

    private Set<Integer> getRetryCodes() {
        HashSet<Integer> retryCodes = new HashSet<Integer>();
        retryCodes.add(502);
        retryCodes.add(504);
        retryCodes.add(500);
        retryCodes.add(503);
        retryCodes.add(404);
        return retryCodes;
    }

    protected abstract String getDestinationName();

    protected Map<String, String> getHeaderFields(String eTag) {
        HashMap<String, String> headerFields = new HashMap<String, String>();
        if (!Strings.isNullOrEmpty((String)eTag)) {
            headerFields.put("If-None-Match", eTag);
        }
        headerFields.put("Accept", APPLICATION_JSON);
        return headerFields;
    }

    private IntFunction<Exception> getCheckFunction() {
        return c -> {
            if (c != 200 && c != 304 && c != 204) {
                String message = MessageFormat.format("Sidecar returned with status {0}", c);
                return new CdsCommunicationException(message, c);
            }
            return null;
        };
    }

    public ModelAndInformation getCsn(ModelId id, String eTag) throws CdsCommunicationException {
        try {
            ServiceCall call = this.createCsnCall(id, eTag);
            ServiceResponse response = call.execute(String.class);
            return this.csnModelInfo((ServiceResponse<String>)response, eTag);
        }
        catch (InternalException e) {
            throw new CdsCommunicationException((Throwable)e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof CdsCommunicationException) {
                throw (CdsCommunicationException)e.getCause();
            }
            throw new CdsCommunicationException((Throwable)e);
        }
    }

    protected abstract String getCsnPath();

    protected abstract ServiceCall createCsnCall(ModelId var1, String var2) throws InternalException;

    protected ModelAndInformation csnModelInfo(ServiceResponse<String> response, String eTag) throws InternalException {
        return this.modelInfo(response, eTag);
    }

    public ModelAndInformation getEdmx(ModelId id, String eTag) throws CdsCommunicationException {
        try {
            ServiceCall call = this.createEdmxCall(id, eTag);
            ServiceResponse response = call.execute(String.class);
            return this.edmxModelInfo((ServiceResponse<String>)response, eTag);
        }
        catch (InternalException e) {
            throw new CdsCommunicationException((Throwable)e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof CdsCommunicationException) {
                throw (CdsCommunicationException)e.getCause();
            }
            throw new CdsCommunicationException((Throwable)e);
        }
    }

    protected ModelAndInformation edmxModelInfo(ServiceResponse<String> response, String eTag) throws InternalException {
        return this.modelInfo(response, eTag);
    }

    private ModelAndInformation modelInfo(ServiceResponse<String> response, String eTag) throws InternalException {
        if (response.getHttpStatusCode() == 304) {
            return new ModelAndInformation(null, eTag, true);
        }
        String value = response.getPayload().orElse("");
        return new ModelAndInformation(value, response.getETag().orElse(eTag), false);
    }

    protected abstract String getEdmxPath();

    protected abstract ServiceCall createEdmxCall(ModelId var1, String var2) throws InternalException;
}

