/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Ticker;
import com.sap.cds.CdsException;
import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.CacheParams;
import com.sap.cds.mtx.impl.ModelAndInformation;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsModelReader;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataAccessorImpl<M>
implements MetaDataAccessor<M> {
    private static final long NANOS_TO_SECONDS = 1000000000L;
    private static final Logger logger = LoggerFactory.getLogger(MetaDataAccessorImpl.class);
    private final Cache<CdsModel> modelIdToCdsModel;
    private final Cache<M> modelIdToEdmxModel;

    public MetaDataAccessorImpl(MetaDataAccessorConfig config, Ticker cacheTicker) {
        if (cacheTicker == null) {
            cacheTicker = Ticker.systemTicker();
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        SidecarAccess sidecarAccess = config.getSidecarAccess();
        CacheParams cacheParams = config.getCacheParams();
        EdmxModelCreator<?> strToEdmx = config.getStrToEdmx();
        Function<String, CdsModel> strToModel = config.getStrToModel();
        this.modelIdToCdsModel = strToModel == null ? null : new CdsCache(sidecarAccess, strToModel, cacheParams, cacheTicker, executorService);
        this.modelIdToEdmxModel = strToEdmx == null ? null : new EdmxCache(sidecarAccess, strToEdmx, cacheParams, cacheTicker, executorService);
    }

    public MetaDataAccessorImpl(SidecarAccess sidecarAccess, CacheParams cacheParams, EdmxModelCreator<M> strToEdmx, Ticker cacheTicker) {
        this(new MetaDataAccessorConfig.Builder().sidecarAccess(sidecarAccess).cacheParams(cacheParams).strToEdmx(strToEdmx).strToModel(csn -> CdsModelReader.read((CdsModelReader.Config)new CdsModelReader.Config.Builder().setIncludeUIAnnotations(true).build(), (String)csn, (boolean)true)).build(), cacheTicker);
    }

    @Override
    public CdsModel getCdsModel(ModelId key, int maxAgeSeconds) {
        if (this.modelIdToCdsModel == null) {
            throw new CdsException("Cache not configured");
        }
        return this.modelIdToCdsModel.getOrLoadIfStale(key, maxAgeSeconds);
    }

    @Override
    public M getEdmx(ModelId key, int maxAgeSeconds) throws CdsException {
        if (this.modelIdToEdmxModel == null) {
            throw new CdsException("Cache not configured");
        }
        return this.modelIdToEdmxModel.getOrLoadIfStale(key, maxAgeSeconds);
    }

    @Override
    public void evict(String tenantId) {
        if (this.modelIdToCdsModel != null) {
            this.modelIdToCdsModel.evict(tenantId);
        }
        if (this.modelIdToEdmxModel != null) {
            this.modelIdToEdmxModel.evict(tenantId);
        }
    }

    @Override
    public void refresh(String tenantId, int maxAgeSeconds) {
        if (this.modelIdToCdsModel != null) {
            this.modelIdToCdsModel.refresh(tenantId, maxAgeSeconds);
        }
        if (this.modelIdToEdmxModel != null) {
            this.modelIdToEdmxModel.refresh(tenantId, maxAgeSeconds);
        }
    }

    public static class MetaDataAccessorConfig {
        private SidecarAccess sidecarAccess;
        private CacheParams cacheParams;
        private EdmxModelCreator<?> strToEdmx;
        private Function<String, CdsModel> strToModel;

        private MetaDataAccessorConfig() {
        }

        public SidecarAccess getSidecarAccess() {
            return this.sidecarAccess;
        }

        public CacheParams getCacheParams() {
            return this.cacheParams;
        }

        public EdmxModelCreator<?> getStrToEdmx() {
            return this.strToEdmx;
        }

        public Function<String, CdsModel> getStrToModel() {
            return this.strToModel;
        }

        public static class Builder {
            private SidecarAccess sidecarAccess;
            private CacheParams cacheParams;
            private EdmxModelCreator<?> strToEdmx;
            private Function<String, CdsModel> strToModel;

            public Builder sidecarAccess(SidecarAccess sidecarAccess) {
                this.sidecarAccess = sidecarAccess;
                return this;
            }

            public Builder cacheParams(CacheParams cacheParams) {
                this.cacheParams = cacheParams;
                return this;
            }

            public Builder strToEdmx(EdmxModelCreator<?> strToEdmx) {
                this.strToEdmx = strToEdmx;
                return this;
            }

            public Builder strToModel(Function<String, CdsModel> strToModel) {
                this.strToModel = strToModel;
                return this;
            }

            public MetaDataAccessorConfig build() {
                MetaDataAccessorConfig config = new MetaDataAccessorConfig();
                config.sidecarAccess = this.sidecarAccess;
                config.cacheParams = this.cacheParams;
                config.strToEdmx = this.strToEdmx;
                config.strToModel = this.strToModel;
                return config;
            }
        }
    }

    @FunctionalInterface
    public static interface EdmxModelCreator<M> {
        public M parse(String var1, String var2);
    }

    private static abstract class Cache<V> {
        private final Ticker ticker;
        private final LoadingCache<ModelId, Entry<V>> cache;
        private final String cacheName = this.getClass().getSimpleName();

        protected Cache(CacheParams params, Ticker ticker, ExecutorService executorService) {
            this.ticker = ticker;
            this.cache = Caffeine.newBuilder().maximumSize(params.getMaximumSize()).expireAfterAccess(params.getExpirationDuration(), params.getExpirationDurationUnit()).refreshAfterWrite(params.getRefreshDuration(), params.getRefreshDurationUnit()).executor((Executor)executorService).ticker(ticker).evictionListener((k, v, c) -> {
                if (c.wasEvicted()) {
                    logger.debug("Evicted '{}' in cache '{}' with cause '{}'", new Object[]{k, this.cacheName, c});
                }
            }).build(new CacheLoader<ModelId, Entry<V>>(){

                public Entry<V> load(ModelId key) {
                    return this.load(key, null);
                }

                public Entry<V> reload(ModelId key, Entry<V> oldValue) {
                    logger.debug("Reloading '{}' in cache '{}'", (Object)key, (Object)cacheName);
                    try {
                        return this.load(key, oldValue);
                    }
                    catch (Exception e) {
                        logger.error("Reloading '{}' failed", (Object)key, (Object)e);
                        return oldValue;
                    }
                }
            });
        }

        public void evict(String tenantId) {
            logger.debug("Evicting tenant '{}' from cache '{}'", (Object)tenantId, (Object)this.cacheName);
            this.forTenant(tenantId, arg_0 -> this.cache.invalidate(arg_0));
        }

        public void refresh(String tenantId, int maxAgeSeconds) {
            logger.debug("Refreshing tenant '{}' in cache '{}'", (Object)tenantId, (Object)this.cacheName);
            this.forTenant(tenantId, k -> this.getOrLoadIfStale((ModelId)k, maxAgeSeconds));
        }

        private void forTenant(String tenantId, Consumer<ModelId> action) {
            this.cache.asMap().keySet().stream().filter(k -> Objects.equals(tenantId, k.getTenantId())).forEach(action);
        }

        public V getOrLoadIfStale(ModelId key, int maxAgeSeconds) {
            Entry<V> entry;
            long maxAgeNanos = (long)maxAgeSeconds * 1000000000L;
            try {
                entry = (Entry<V>)this.cache.get((Object)key);
            }
            catch (RuntimeException e) {
                throw new CdsException((Throwable)e);
            }
            if (this.ticker.read() - entry.refreshed() > maxAgeNanos) {
                Entry<V> loaded = this.load(key, entry);
                if (loaded != entry) {
                    this.cache.put((Object)key, loaded);
                    entry = loaded;
                }
            } else {
                logger.debug("'{}' in cache '{}' is not older than '{}'", new Object[]{key, this.cacheName, maxAgeSeconds});
            }
            return entry.getEntry();
        }

        private Entry<V> load(ModelId key, Entry<V> oldEntry) {
            logger.debug("Loading '{}' in cache '{}'", (Object)key, (Object)this.cacheName);
            String eTag = oldEntry != null ? oldEntry.getETag() : null;
            long beforeAccess = this.ticker.read();
            ModelAndInformation model = this.access(key, eTag);
            if (oldEntry != null && model.isNotModified()) {
                oldEntry.refresh(beforeAccess);
                logger.debug("Refreshed unchanged '{}' in cache '{}'", (Object)key, (Object)this.cacheName);
                return oldEntry;
            }
            return new Entry<V>(this.parse(key, model.getModel()), model.getETag(), beforeAccess);
        }

        abstract ModelAndInformation access(ModelId var1, String var2);

        abstract V parse(ModelId var1, String var2);
    }

    private static class CdsCache
    extends Cache<CdsModel> {
        private final SidecarAccess sidecarAccess;
        private final Function<String, CdsModel> strToModel;

        public CdsCache(SidecarAccess sidecarAccess, Function<String, CdsModel> strToModel, CacheParams params, Ticker ticker, ExecutorService executorService) {
            super(params, ticker, executorService);
            this.sidecarAccess = sidecarAccess;
            this.strToModel = strToModel;
        }

        @Override
        ModelAndInformation access(ModelId key, String eTag) {
            return this.sidecarAccess.getCsn(key, eTag);
        }

        @Override
        CdsModel parse(ModelId key, String csn) {
            return this.strToModel.apply(csn);
        }
    }

    private static class EdmxCache<M>
    extends Cache<M> {
        private final SidecarAccess sidecarAccess;
        private final EdmxModelCreator<M> strToEdmx;

        public EdmxCache(SidecarAccess sidecarAccess, EdmxModelCreator<M> strToEdmx, CacheParams params, Ticker ticker, ExecutorService executorService) {
            super(params, ticker, executorService);
            this.sidecarAccess = sidecarAccess;
            this.strToEdmx = strToEdmx;
        }

        @Override
        ModelAndInformation access(ModelId key, String eTag) {
            return this.sidecarAccess.getEdmx(key, eTag);
        }

        @Override
        M parse(ModelId key, String model) {
            return this.strToEdmx.parse(model, key.getServiceName().orElse(null));
        }
    }

    private static class Entry<V> {
        private final V entry;
        private final String eTag;
        private final AtomicLong refreshed;

        public Entry(V entry, String eTag, long refreshed) {
            this.entry = entry;
            this.eTag = eTag != null ? eTag.trim() : null;
            this.refreshed = new AtomicLong(refreshed);
        }

        public V getEntry() {
            return this.entry;
        }

        public String getETag() {
            return this.eTag;
        }

        public void refresh(long refreshed) {
            this.refreshed.set(refreshed);
        }

        public long refreshed() {
            return this.refreshed.get();
        }
    }
}

