/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mt;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.CdsException;
import com.sap.cds.mtx.CdsDataStoreConnectorCreator;
import com.sap.cds.mtx.impl.CacheParams;
import com.sap.cds.reflect.CdsModel;
import java.util.function.BiPredicate;
import java.util.function.Function;

public class CdsDataStoreLookup {
    private final BiPredicate<String, CdsModel> isModelOutDated;
    private final LoadingCache<String, CdsDataStoreConnector> tenantToConnector;

    public CdsDataStoreLookup(CdsDataStoreConnectorCreator cdsDataStoreConnectorCreator, BiPredicate<String, CdsModel> isModelOutDated, CacheParams cacheParams, Ticker cacheTicker) {
        this.isModelOutDated = isModelOutDated;
        this.tenantToConnector = CdsDataStoreLookup.buildCache(cacheParams, cacheTicker, cdsDataStoreConnectorCreator::create);
    }

    public CdsDataStoreConnector getCdsDataStoreConnector(String tenantId) throws CdsException {
        try {
            return (CdsDataStoreConnector)this.tenantToConnector.getUnchecked((Object)tenantId);
        }
        catch (UncheckedExecutionException e) {
            throw new CdsException((Throwable)e);
        }
    }

    public void evictIfOutDated(String tenantId) {
        CdsModel cdsModel;
        CdsDataStoreConnector connector = this.getCdsDataStoreConnector(tenantId);
        if (connector != null && this.isModelOutDated.test(tenantId, cdsModel = connector.reflect())) {
            this.tenantToConnector.invalidate((Object)tenantId);
        }
    }

    private static LoadingCache<String, CdsDataStoreConnector> buildCache(CacheParams params, Ticker cacheTicker, final Function<String, CdsDataStoreConnector> loader) {
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize(params.getMaximumSize()).expireAfterAccess(params.getExpirationDuration(), params.getExpirationDurationUnit());
        if (cacheTicker != null) {
            builder.ticker(cacheTicker);
        }
        return builder.build((CacheLoader)new CacheLoader<String, CdsDataStoreConnector>(){

            public CdsDataStoreConnector load(String key) {
                return (CdsDataStoreConnector)loader.apply(key);
            }
        });
    }
}

