/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.AbstractSidecarAccess;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cloud.mt.tools.api.QueryParameter;
import com.sap.cloud.mt.tools.api.RequestEnhancer;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import com.sap.cloud.mt.tools.api.ServiceCall;
import com.sap.cloud.mt.tools.exception.InternalException;
import java.util.ArrayList;
import java.util.List;

public class SidecarAccessV1
extends AbstractSidecarAccess
implements SidecarAccess {
    public static final String MTX_SIDECAR_DESTINATION = "com.sap.cds.mtxSidecar";
    private static final String CSN_PATH = "/mtx/v1/metadata/csn/";
    private static final String EDMX_PATH = "/mtx/v1/metadata/edmx/";

    public SidecarAccessV1(RequestEnhancer requestEnhancer, ResilienceConfig resilienceConfig) {
        super(requestEnhancer, resilienceConfig);
    }

    @Override
    protected String getDestinationName() {
        return MTX_SIDECAR_DESTINATION;
    }

    @Override
    protected ServiceCall createCsnCall(ModelId id, String eTag) throws InternalException {
        return this.csnEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(id.getTenantId()).noQuery().enhancer(this.requestEnhancer).insertHeaderFields(this.getHeaderFields(eTag)).end();
    }

    @Override
    protected ServiceCall createEdmxCall(ModelId id, String eTag) throws InternalException {
        return this.edmxEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(id.getTenantId()).query(this.getQuery(id)).enhancer(this.requestEnhancer).insertHeaderFields(this.getHeaderFields(eTag)).end();
    }

    private List<QueryParameter> getQuery(ModelId id) {
        ArrayList<QueryParameter> queryParameters = new ArrayList<QueryParameter>();
        id.getServiceName().ifPresent(s -> queryParameters.add(new QueryParameter("name", s)));
        id.getLanguage().ifPresent(l -> queryParameters.add(new QueryParameter("language", l)));
        id.getODataVersion().ifPresent(v -> queryParameters.add(new QueryParameter("odataVersion", v)));
        return queryParameters;
    }

    @Override
    protected String getCsnPath() {
        return CSN_PATH;
    }

    @Override
    protected String getEdmxPath() {
        return EDMX_PATH;
    }

    @Override
    protected String getI18nPath() {
        return null;
    }

    @Override
    protected ServiceCall createI18nCall(ModelId id, String eTag) throws InternalException {
        return null;
    }
}

