/*
 * ----------------------------------------------------------------
 * © 2019-2021 SAP SE or an SAP affiliate company. All rights reserved.
 * ----------------------------------------------------------------
 *
 */

package com.sap.cds.mt;

import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.CdsException;
import com.sap.cds.mt.proxy.ProxyCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

@Deprecated
public class RoutingDataStoreConnectorCreator {
	private static final Logger logger = LoggerFactory.getLogger(RoutingDataStoreConnectorCreator.class);
	private final Supplier<String> tenantIdProvider;
	private final Supplier<CdsDataStoreConnector> dataStoreConnectorCreator;
	private final Handler invocationHandler;
	private final ConcurrentMap<String, CdsDataStoreConnector> factories = new ConcurrentHashMap<>();

	public RoutingDataStoreConnectorCreator(Supplier<String> tenantIdProvider,
			Supplier<CdsDataStoreConnector> dataStoreConnectorCreator) {
		this.tenantIdProvider = tenantIdProvider;
		this.dataStoreConnectorCreator = dataStoreConnectorCreator;
		this.invocationHandler = new Handler();
	}

	public CdsDataStoreConnector create() {
		return ProxyCreator.create(CdsDataStoreConnector.class, invocationHandler);
	}

	private class Handler implements InvocationHandler {

		private static final String NO_TENANT = "n/a";

		@Override
		public Object invoke(Object proxy, Method method, Object[] args) {
			logger.debug("invoking: " + method.getName());
			try {
				String tenantId = tenantIdProvider.get();
				if (tenantId == null) {
					tenantId = NO_TENANT;
				}
				CdsDataStoreConnector dataStoreConnector = factories.get(tenantId);
				if (dataStoreConnector == null) {
					logger.debug("creating new data store connector for tenant " + tenantId);
					dataStoreConnector = dataStoreConnectorCreator.get();
					CdsDataStoreConnector alreadyExisting = factories.putIfAbsent(tenantId, dataStoreConnector);
					if (alreadyExisting != null) {
						dataStoreConnector = alreadyExisting;
					}
				} else {
					logger.debug("obtained existing data store connector for tenant " + tenantId);
				}
				return method.invoke(dataStoreConnector, args);
			} catch (InvocationTargetException ex) { // NOSONAR
				throw new CdsException("exception during method invocation", ex.getCause());
			} catch (IllegalAccessException ex) {
				throw new CdsException("exception during method invocation", ex);
			}
		}
	}

	public void invalidate() {
		factories.remove(tenantIdProvider.get());
	}

	public void invalidateAll() {
		factories.clear();
	}

}
