/*
 * ----------------------------------------------------------------
 * © 2019-2021 SAP SE or an SAP affiliate company. All rights reserved.
 * ----------------------------------------------------------------
 *
 */

package com.sap.cds.mtx.impl;

/**
 * Csn or edmx model returned from sidecar with eTag and "not modified"-flag
 */
public class ModelAndInformation {
	private final String model;
	private final String eTag;
	private final boolean notModified;

	/**
	 * @param model       csn or edmx model as string
	 * @param eTag        ETag
	 * @param notModified true if model wasn't modified
	 */
	public ModelAndInformation(String model, String eTag, boolean notModified) {
		this.model = model;
		this.eTag = eTag != null ? eTag.trim() : null;
		this.notModified = notModified;
	}

	public String getModel() {
		return model;
	}

	public String getETag() {
		return eTag;
	}

	public boolean isNotModified() {
		return notModified;
	}
}
