/*
 * ----------------------------------------------------------------
 * © 2019-2021 SAP SE or an SAP affiliate company. All rights reserved.
 * ----------------------------------------------------------------
 *
 */

package com.sap.cds.mtx.impl;

/**
 * Response as string returned from sidecar with eTag and "not modified"-flag
 */
public class SidecarResponse {
	private final String payload;
	private final String eTag;
	private final boolean notModified;

	/**
	 * @param payload    response payload as string
	 * @param eTag        ETag
	 * @param notModified true if model wasn't modified
	 */
	public SidecarResponse(String payload, String eTag, boolean notModified) {
		this.payload = payload;
		this.eTag = eTag != null ? eTag.trim() : null;
		this.notModified = notModified;
	}

	public String getPayload() {
		return payload;
	}

	public String getETag() {
		return eTag;
	}

	public boolean isNotModified() {
		return notModified;
	}
}
