/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx;

import com.google.common.base.MoreObjects;
import com.sap.cds.CdsException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ModelId {
    private final String tenantId;
    private final String serviceName;
    private final String language;
    private final String odataVersion;
    private final String version;
    private final Set<String> features;

    private ModelId(String tenantId, String serviceName, String language, String version, String odataVersion, Set<String> features) throws CdsException {
        this.tenantId = tenantId;
        this.serviceName = serviceName;
        this.language = language;
        this.odataVersion = odataVersion;
        this.version = version;
        this.features = new HashSet<String>(features);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Optional<String> getServiceName() {
        return Optional.ofNullable(this.serviceName);
    }

    public Optional<String> getLanguage() {
        return Optional.ofNullable(this.language);
    }

    public String getVersion() {
        return this.version;
    }

    public Optional<String> getODataVersion() {
        return Optional.ofNullable(this.odataVersion);
    }

    public Set<String> getFeatures() {
        return this.features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelId)) {
            return false;
        }
        ModelId key = (ModelId)o;
        return Objects.equals(this.tenantId, key.tenantId) && this.version.equals(key.version) && this.features.equals(key.features) && Objects.equals(this.serviceName, key.serviceName) && Objects.equals(this.language, key.language) && Objects.equals(this.odataVersion, key.odataVersion);
    }

    public int hashCode() {
        return Objects.hash(this.tenantId, this.serviceName, this.language, this.odataVersion, this.version, this.features);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("tenantId", (Object)this.tenantId).add("serviceName", (Object)this.serviceName).add("language", (Object)this.language).add("odataVersion", (Object)this.odataVersion).add("version", (Object)this.version).add("features", this.features).toString();
    }

    public static Builder create(String tenant) {
        return new Builder(tenant);
    }

    public static class Builder {
        private final String tenant;
        private String service = null;
        private String language = null;
        private String version = "";
        private String odataVersion = null;
        private Set<String> features = Collections.emptySet();

        public Builder(String tenant) {
            this.tenant = tenant;
        }

        public Builder service(String service) {
            this.service = service;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder odataVersion(String odataVersion) {
            this.odataVersion = odataVersion;
            return this;
        }

        public Builder odata(String service, String language, String odataVersion) {
            this.service = service;
            this.language = language;
            this.odataVersion = odataVersion;
            return this;
        }

        public Builder version(String version) {
            this.notNull("Version", version);
            this.version = version;
            return this;
        }

        public Builder features(Set<String> features) {
            this.notNull("Features", features);
            this.features = features;
            return this;
        }

        public Builder features(String ... features) {
            this.notNull("Features", features);
            return this.features(Arrays.stream(features).collect(Collectors.toSet()));
        }

        public Builder allFeatures() {
            return this.features("*");
        }

        public ModelId build() {
            return new ModelId(this.tenant, this.service, this.language, this.version, this.odataVersion, this.features);
        }

        private void notNull(String string, Object value) {
            if (value == null) {
                throw new CdsException(string + " must not be null");
            }
        }
    }
}

