/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.JDBCDataStoreConnector;
import com.sap.cds.impl.SystemPropertyDataStoreConfiguration;
import com.sap.cds.mtx.CdsDataStoreConnectorCreator;
import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.transaction.TransactionManager;
import java.util.function.Function;
import javax.sql.DataSource;

public class CdsDataStoreConnectorCreatorImpl
implements CdsDataStoreConnectorCreator {
    private final MetaDataAccessor<?> metaDataAccessor;
    private final Function<String, DataSource> dataSourceForTenant;
    private final TransactionManager cdsTransactionManager;
    private final DataStoreConfiguration config;

    public CdsDataStoreConnectorCreatorImpl(MetaDataAccessor<?> metaDataAccessor, Function<String, DataSource> dataSourceForTenant, TransactionManager cdsTransactionManager, DataStoreConfiguration config) {
        this.metaDataAccessor = metaDataAccessor;
        this.dataSourceForTenant = dataSourceForTenant;
        this.cdsTransactionManager = cdsTransactionManager;
        this.config = config;
    }

    public CdsDataStoreConnectorCreatorImpl(MetaDataAccessor<?> metaDataAccessor, Function<String, DataSource> dataSourceForTenant, TransactionManager cdsTransactionManager) {
        this(metaDataAccessor, dataSourceForTenant, cdsTransactionManager, (DataStoreConfiguration)new SystemPropertyDataStoreConfiguration());
    }

    @Override
    public CdsDataStoreConnector create(String tenantId) {
        return JDBCDataStoreConnector.create((CdsModel)this.metaDataAccessor.getCdsModel(tenantId), (TransactionManager)this.cdsTransactionManager).datasource(this.dataSourceForTenant.apply(tenantId)).config(this.config).build();
    }
}

