/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.sql.DataSource;

public class AtomikosDataSourceLookup extends DataSourceLookup {
    private static Logger logger = LoggerFactory.getLogger(AtomikosDataSourceLookup.class);
    private final EnvironmentAccess environment;
    private final DataPoolSettings poolSettings;


    public AtomikosDataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, EnvironmentAccess environment,
                                    DataPoolSettings poolSettings, boolean oneDataSourcePerDb) {
        super(instanceLifecycleManager, oneDataSourcePerDb);
        this.environment = environment;
        this.poolSettings = poolSettings;
    }

    @Override
    public DataSource create(DataSourceInfo info) throws InternalError {
        DataSourceCreator dataSourceCreator = null;
        logger.debug("Atomikos data source pool taken");
        dataSourceCreator = new DataSourceCreatorAtomikos(poolSettings);
        return dataSourceCreator.create(info, environment);
    }

    @Override
    public void closeDataSource(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        logger.debug("Close Atomikos data source pool");
        com.atomikos.jdbc.AtomikosDataSourceBean atomikosDataSource = (com.atomikos.jdbc.AtomikosDataSourceBean) dataSource;
        atomikosDataSource.close();
    }
}

