/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/

package com.sap.cloud.mt.runtime;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.function.BiFunction;


public class ConnectionProviderFunction implements BiFunction<String, Boolean, ConnectionProvider> {
    private static final ConnectionProvider HANA_CONNECTION_PROVIDER = new HanaConnectionProvider();
    private static final ConnectionProvider GENERIC_CONNECTION_PROVIDER = new GenericConnectionProvider();
    private static final Logger logger = LoggerFactory.getLogger(ConnectionProviderFunction.class);
    private static final String USE_GENERIC_CONNECTION_PROVIDER = "Use generic connection provider";

    public ConnectionProvider apply(String driver, Boolean onDataSourcePerDb) {
        if (onDataSourcePerDb == null) {
            onDataSourcePerDb = false;
        }
        switch (driver) {
            case "com.sap.db.jdbc.Driver":
                if (onDataSourcePerDb) {
                    logger.debug("Use HANA connection provider");
                    return HANA_CONNECTION_PROVIDER;
                } else {
                    logger.debug(USE_GENERIC_CONNECTION_PROVIDER);
                    return GENERIC_CONNECTION_PROVIDER;
                }
            default:
                logger.debug(USE_GENERIC_CONNECTION_PROVIDER);
                return GENERIC_CONNECTION_PROVIDER;
        }
    }
}
